<?php
#
# SMS Autoregistration
# By Rexy

define('CONF_FILE', '/usr/local/etc/alcasar.conf');

// Read CONF_FILE
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);

// Check if the SMS service is enable
if ($conf['SMS'] !== 'on') {
	header('Location: /');
	exit();
}
$page = "sms_registration";
$organisme   = $conf['ORGANISM'];
$current_num = $conf['SMS_NUM'];


// Choice of language
$Language = 'en';
if(isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'fr') {	// French
	$l_title		= "Page d'auto enregistrement";
	$l_num_exist	= "Compte actif";
	$l_num_flood	= "Numéro bloqué: nombre d'essai dépassé.";
	$l_num_num		= "Numéro de GSM / identifiant de compte";
	$l_num_raison	= "État de votre numéro de GSM / compte";
	$l_num_expiration	= "Expiration";
	$l_tuto_1		= "Bienvenue sur la page d'auto enregistrement.";
	$l_tuto_2		= "Ce portail peut créer un compte dont l'identifiant sera votre numéro de GSM. Pour cela, envoyez le mot de passe de votre choix par SMS au numéro suivant : <b>$current_num</b>";
	$l_tuto_3		= "Votre SMS ne doit contenir qu'un seul mot.";
	$l_tuto_4		= "Votre inscription sera activée lorsque vous retrouverez votre numéro de GSM dans le tableau ci-dessous.";
	$l_tuto_5		= "Le champ de recherche ci-dessous vous permet de retrouver votre numéro suivant les 5 derniers chiffres.";	
	$l_tab_first	= "premier";
	$l_tab_last		= "dernier";
	$l_tab_next		= "suivant";
	$l_tab_prev		= "précédent";
	$l_tab_search	= "Recherche :";
	$l_tab_pmenu	= "Affiche la page _PAGE_ sur _PAGES_";
	$l_tab_info		= "Montrer _MENU_ résultats par page";
	$l_tab_infoempty	= "Aucun résultat";
	$l_autorefresh		= "Rafraichissement : 10 sec";
} else if ($Language === 'es') {	// Spanish
	$l_title		= "Auto-Registro";
	$l_num_exist	= "Cuenta existente";
	$l_num_flood	= "Número de teléfono bloqueado: se superó el número de intentos.";
	$l_num_num		= "Número GSM / identificador de cuenta";
	$l_num_raison	= "Estado de su número GSM / cuenta";
	$l_num_expiration	= "Vencimiento";
	$l_tuto_1		= "Bienvenido a la página de auto-registro";
	$l_tuto_2		= "Este portal puede crear una cuenta cuyo identificador será su número de teléfono móvil. Para ello, envíe la contraseña que elija por SMS al siguiente número: <b>$current_num</b> ";
	$l_tuto_3		= "Simplemente envíe 1 palabra en su SMS.";
	$l_tuto_4		= "Su registro se activará cuando encuentre su número GSM en la siguiente tabla.";
	$l_tuto_5		= "Puede buscar su número de teléfono de acuerdo con los últimos 5 dígitos de su número de teléfono.";
	$l_tab_first	= "primero";
	$l_tab_last		= "último";
	$l_tab_next		= "siguiente";
	$l_tab_prev		= "anterior";
	$l_tab_search	= "Buscar :";
	$l_tab_pmenu	= "Mostrando _PAGE_ a _PAGE_ de _PAGE_ entradas :";
	$l_tab_info		= "Mostrar _MENU_ entradas";
	$l_tab_infoempty	= "No se encontraron registros coincidencias";
	$l_autorefresh		= "Actualizar: 10 seg";
} else if ($Language === 'de') {	// German
	$l_title		= "Seite zur Selbstregistrierung";
	$l_num_exist	= "Aktives Konto";
	$l_num_flood	= "Blockierte Nummer: Anzahl der Versuche überschritten.";
	$l_num_num		= "GSM-Nummer / Konto-Kennung";
	$l_num_raison	= "Status Ihrer Handynummer / Ihres Kontos";
	$l_num_expiration	= "Ablauf";
	$l_tuto_1		= "Willkommen auf der Seite für die Selbstregistrierung.";
	$l_tuto_2		= "Dieses Portal kann ein Konto erstellen, dessen Kennung Ihre Mobiltelefonnummer ist. Senden Sie dazu das Passwort Ihrer Wahl per SMS an die folgende Nummer: <b>$current_num</b> ";
	$l_tuto_3		= "Ihre Textnachricht darf nur ein Wort enthalten.";
	$l_tuto_4		= "Ihre Registrierung wird aktiviert, wenn Sie Ihre Handynummer in der Tabelle unten finden.";
	$l_tuto_5		= "Mit dem Suchfeld unten können Sie Ihre Nummer nach den letzten 5 Ziffern suchen.";
	$l_tab_first	= "erste";
	$l_tab_last		= "aktuellste";
	$l_tab_next		= "unter";
	$l_tab_prev		= "vorherige";
	$l_tab_search	= "Forschung :";
	$l_tab_pmenu	= "Zeigt die Seite _PAGE_ auf _PAGES_ an";
	$l_tab_info		= "_MENU_ Ergebnisse pro Seite anzeigen";
	$l_tab_infoempty	= "Keine Ergebnisse";
	$l_autorefresh		= "Kühlung: 10 sec";
} else {			// English
	$l_title		= "Autoregistration";
	$l_num_exist		= "Account enabled";
	$l_num_flood		= "Phone number banned: Number of trial exceeded.";
	$l_num_num		= "Mobile phone number / account identifier";
	$l_num_raison		= "Status of your phone number / account";
	$l_num_expiration	= "Expiration";
	$l_tuto_1		= "Welcome to the auto-enrollment page";
	$l_tuto_2		= "This portal can create an account whose identifier will be your mobile phone number. To do so, send the password of your choice by SMS to the following number: <b>$current_num</b>";
	$l_tuto_3		= "Just send 1 word in your SMS.";
	$l_tuto_4		= "Your registration will be activated when you'll find your phone number in the following table.";
	$l_tuto_5		= "You can search your phone number according to the 5 last digits in your phone number.";
	$l_tab_first		= "first";
	$l_tab_last		= "last";
	$l_tab_next		= "next";
	$l_tab_prev		= "previous";
	$l_tab_search		= "Search :";
	$l_tab_pmenu		= "Showing _PAGE_ to _PAGE_ of _PAGE_ entries :";
	$l_tab_info		= "Show _MENU_ entries";
	$l_tab_infoempty	= "No matching records found";
	$l_autorefresh		= "Refresh: 10 sec";
}

// Get SMS from database
require('/etc/freeradius-web/config.php');
$img_rep         = '/images/';
$img_sms         = 'sms.png';

$con = mysqli_connect($config['sql_server'], $config['sql_username'], $config['sql_password'], 'gammu');

if (mysqli_connect_errno()) {
	exit('Failed to connect to ' . $config['sql_type']/* . ': ' . mysqli_connect_error()*/);
}

$result = mysqli_query($con, 'SELECT * FROM `SMS_ban_perm` ORDER BY date_add DESC;');

$smsBanPerms = [];
while ($row = mysqli_fetch_array($result)) {
	$smsBanPerms[] = (object) [
		'numberHidden' => substr($row['SenderNumber'], 0, 3) . '****' . substr($row['SenderNumber'], -5),
		'expiration'   => $row['Expiration'],
		'perm'         => $row['Perm']
	];
}
mysqli_close($con);

?>
<!DOCTYPE html>
<html><!-- written by Rexy -->
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>ALCASAR - <?= $l_title ?></title>
	<link rel="stylesheet" type="text/css" href="/css/bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="/css/index.css">
	<link rel="stylesheet" type="text/css" href="/css/jquery.dataTables.css">
	<link rel="icon" href="/images/favicon-48.ico" type="image/ico">
	<script src="/js/jquery.min.js"></script>
	<script src="/js/jquery.dataTables.js"></script>
	<script>
	function timedRefresh(timeoutPeriod) {
		var interval = setInterval(refreshPage, timeoutPeriod);
	}

	function refreshPage() {
		if ($('input[name=autoRefreshCheckboxes]').is(':checked')) {
			location.reload(true);
		}
	}

	$(document).ready( function () {
		$('#table_id').DataTable({
			"order": [[ 2, "desc" ]],		
			"language": {
				"paginate": {
					"sFirst":    "<?= $l_tab_first ?>",
					"sLast":     "<?= $l_tab_last ?>",
					"sPrevious": "<?= $l_tab_prev ?>",
					"sNext":     "<?= $l_tab_next ?>"
				},
				"lengthMenu":  "<?= $l_tab_info ?>",
				"zeroRecords": "<?= $l_tab_infoempty ?>",
				"info":        "<?= $l_tab_pmenu ?>",
				"infoEmpty":   "<?= $l_tab_infoempty ?>",
				"sSearch":     "<?= $l_tab_search ?>"
				}
		});
	});
	</script>
</head>
<body onload="timedRefresh(10000);">
	<div class="col-12 col-lg-10 offset-lg-1">
		<?php require_once(__DIR__.'/header.php'); ?>
		<!-- Main content box -->
		<div class="row">
			<div id="contenu_acces" class="col-12 offset-lg-1 col-lg-10">
				<h3><?= $l_tuto_2 ?></h3>
				<div class="menu-container container col-12 col-md-7">
					<div class="box_menu_right box_menu">
						<span><?= $l_tuto_3 ?></span>
						<div class="menu-image">						
							<img class="img-fluid" src="<?= $img_rep.$img_sms ?>">
						</div>
					</div>
				</div>
			</div>
		</div>
	<p>
		<div class="row">
			<div id="contenu_acces" class="col-12 offset-xl-1 col-xl-10">
				<h4><?= $l_tuto_4 ?></h4>
				<h4><?= $l_tuto_5 ?></h4>
				<label><input type="checkbox" checked="checked" name="autoRefreshCheckboxes"><?= $l_autorefresh ?></label>
				<table id="table_id" class="display">
				<thead>
					<tr>
						<th><b><?= $l_num_num ?></b></th>
						<th><b><?= $l_num_raison ?></b></th>
						<th><b><?= $l_num_expiration ?></b></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($smsBanPerms as $smsBanPerm): ?>
						<tr>
							<td><?= $smsBanPerm->numberHidden ?></td>
							<?php if ($smsBanPerm->perm == '0'): ?>
							<td><?= $l_num_exist ?></td>
							<?php elseif ($smsBanPerm->perm == '1'): ?>
							<td><?= $l_num_flood ?></td>
							<?php endif ?>
							<td><?= $smsBanPerm->expiration ?></td>
						</tr>
					<?php endforeach; ?>
				</tbody>
				</table>
			</div>
		</div>
	</div>
</body>
</html>
