<?php
# $Id: password.php 3145 2023-11-12 15:45:31Z rexy $
#
# change user password on ALCASAR
# by ANGEL95 & REXY

/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');

/****************************************************************
*			FILE reading test			*
*****************************************************************/
$conf_files = array(CONF_FILE);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Fichier $file non présent");
	}
	if (!is_readable($file)) {
		exit("Vous n'avez pas les droits de lecture sur le fichier $file");
	}
}

/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);

if ($conf['HTTPS_LOGIN'] === 'on') {
// Redirect to HTTPS
if ((!isset($_SERVER['HTTPS'])) || (empty($_SERVER['HTTPS'])) || ($_SERVER['HTTPS'] === 'off')) {
	header('Location: https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
	exit(); }
}

require('/etc/freeradius-web/config.php');

$page = "password";
$current_page = htmlspecialchars($_SERVER['PHP_SELF']);
$homepage = (((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')) ? 'https' : 'http').'://'.$conf['HOSTNAME'].'.'.$conf['DOMAIN'];

// Choice of language
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'es') {		// Spanish
	$l_title			= "Gestione su contraseña";
	$l_form_l1			= "Usuario *";
	$l_form_l2			= "Contraseña anterior *";
	$l_form_l3			= "Nueva contraseña *";
	$l_form_l4			= "Nueva contraseña (verificación) *";
	$l_eval_pass			= "Evaluación :";
	$l_passwordmeter		= "Powered by 'Shibbo Password Analyser'";
	$l_mandatory			= "* Campos requeridos";
	$l_form_button_valid		= "Modificar";
	$l_form_button_retour		= "Cancelar";
	$l_form_result1			= "Su contraseña ha sido actualizada exitosamente";
	$l_form_result2			= "Error al intentar cambiar la contraseña";	
} else if ($Language === 'pt') {	// Portuguese
	$l_title			= "Alteração de senha do usuário";
	$l_form_l1			= "Usuário *";
	$l_form_l2			= "Senha antiga *";
	$l_form_l3			= "Nova senha *";
	$l_form_l4			= "Nova senha (confirmação) *";
	$l_eval_pass			= "Resultado:";
	$l_passwordmeter		= "Powered by 'Shibbo Password Analyser'";
	$l_mandatory			= "* Campos obrigatórios";
	$l_form_button_valid		= "Modificar";
	$l_form_button_retour		= "Cancelar";
	$l_form_result1			= "Sua senha foi alterada com sucesso";
	$l_form_result2			= "Erro ao tentar alterar a senha";
} else if ($Language === 'de') {	// German
	$l_title			= "Password ändern";
	$l_form_l1			= "Benutzername *";
	$l_form_l2			= "Altes Passwort *";
	$l_form_l3			= "Neues Passwort *";
	$l_form_l4			= "Neues Passwort bestätigen *";
	$l_eval_pass			= "Wert :";
	$l_passwordmeter		= "Powered by 'Shibbo Password Analyser'";
	$l_mandatory			= "* Benötigte Felder";
	$l_form_button_valid		= "Bestätigen";
	$l_form_button_retour		= "Abbrechen";
	$l_form_result1			= "Ihr Passwort wurde erfolgreich geändert.";
	$l_form_result2			= "Fehler beim Ändern des Passworts";
} else if ($Language === 'nl') {	// Dutch
	$l_title			= "User password change";
	$l_form_l1			= "User *";
	$l_form_l2			= "Old password *";
	$l_form_l3			= "New password *";
	$l_form_l4			= "New password (confirmation) *";
	$l_eval_pass			= "Score :";
	$l_passwordmeter		= "Powered by 'Shibbo Password Analyser'";
	$l_mandatory			= "* Verplichte velden";
	$l_form_button_valid		= "Modify";
	$l_form_button_retour		= "Cancel";
	$l_form_result1			= "Your password has been successfuly changed";
	$l_form_result2			= "Error when trying to change password";
} else if ($Language === 'zh') {	// Chinese
	$l_title			= "修改用户密码";
	$l_form_l1			= "用户 *";
	$l_form_l2			= "旧密码 *";
	$l_form_l3			= "新密码 *";
	$l_form_l4			= "新密码(确认) *";
	$l_eval_pass			= "得分";
	$l_passwordmeter		= "技术支持 'Shibbo Password Analyser'";
	$l_mandatory			= "* 必须填写";
	$l_form_button_valid		= "修改";
	$l_form_button_retour		= "取消";
	$l_form_result1			= "您的密码已成功修改";
	$l_form_result2			= "修改密码出错";
} else if ($Language === 'ar') {	// Arabic
	$l_title			= "تغيير كلمة المرور للمستخدم";
	$l_form_l1			= "المستعمل *";
	$l_form_l2			= "كلمه السر القديمة *";
	$l_form_l3			= "كلمة السر الجديدة *";
	$l_form_l4			= "كلمة السر الجديدة (أكد) *";
	$l_eval_pass			= ": أحرز هدفا";
	$l_passwordmeter		= "مشغل بواسطة 'Shibbo Password Analyser'";
	$l_mandatory			= "* الحقول المطلوبة";
	$l_form_button_valid		= "تغيير";
	$l_form_button_retour		= "إلغاء";
	$l_form_result1			= "تم تغيير الرقم السري بنجاح";
	$l_form_result2			= "خطأ عند محاولة تغيير كلمة المرور";
} else if ($Language === 'fr') {	// French
	$l_title			= "Changement de mot de passe";
	$l_form_l1			= "Utilisateur : *";
	$l_form_l2			= "Ancien mot de passe : *";
	$l_form_l3			= "Nouveau mot de passe : *";
	$l_form_l4			= "Nouveau mot de passe (confirmation) : *";
	$l_eval_pass			= "Score :";
	$l_passwordmeter		= "Propulsé par 'Shibbo Password Analyser'";
	$l_mandatory			= "* champs requis";
	$l_form_button_valid		= "Modifier";
	$l_form_button_retour		= "Annuler";
	$l_form_result1			= "Votre mot de passe a été modifié avec succès";
	$l_form_result2			= "Erreur de changement de mot de passe";
} else {				// English
	$l_title			= "User password change";
	$l_form_l1			= "User*";
	$l_form_l2			= "Old password *";
	$l_form_l3			= "New password *";
	$l_form_l4			= "New password (confirmation) *";
	$l_eval_pass			= "Score:";
	$l_passwordmeter		= "Powered by 'Shibbo Password Analyser'";
	$l_mandatory			= "* fields required";
	$l_form_button_valid		= "Modify";
	$l_form_button_retour		= "Cancel";
	$l_form_result1			= "Your password has been successfuly changed";
	$l_form_result2			= "Error when trying to change password";
}

if (isset($action)) {
	if ($action === 'checkpass') {
		if (!is_file("acc/manager/lib/sql/drivers/$config[sql_type]/functions.php")) {
			exit('<b>Could not include SQL library</b>');
		}
		require_once("acc/manager/lib/sql/drivers/$config[sql_type]/functions.php");
		$link = @da_sql_pconnect($config);
		if ($link) {
			$sql = "SELECT attribute,value FROM $config[sql_check_table] WHERE username = '$login' AND attribute = '$config[sql_password_attribute]';";
			$res = @da_sql_query($link,$config, $sql);
			if ($res) {
				$row = @da_sql_fetch_array($res, $config);
				if (!is_file("acc/manager/lib/crypt/$config[general_encryption_method].php")) {
					exit('<b>Could not open encryption library file</b>');
				}
				include("acc/manager/lib/crypt/$config[general_encryption_method].php");
				$enc_passwd = $row['value'];
				$passwd     = da_encrypt($passwd,$enc_passwd);
				$newpasswd  = da_encrypt($newpasswd,$enc_passwd);
				$newpasswd2 = da_encrypt($newpasswd2,$enc_passwd);
				if (($passwd === $enc_passwd) && ($newpasswd === $newpasswd2)) {
					$sql = "UPDATE $config[sql_check_table] SET value='$newpasswd' WHERE username = '$login' AND attribute = '$config[sql_password_attribute]';";
					$res2 = @da_sql_query($link, $config, $sql);
					$changePasswordMessage = '<font color=blue><b>'.$l_form_result1.'</b></font>';
				} else {
					$changePasswordMessage = '<font color=red><b>'.$l_form_result2.'</b></font>';
				}
			}
		}
	}
}

// Cleaning the cache
header('Expires: Tue, 01 Jan 2000 00:00:00 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>ALCASAR - <?= $l_title ?></title>
	<link rel="stylesheet" type="text/css" href="/css/pwdmeter.css"> 
	<link rel="stylesheet" type="text/css" href="/css/bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="/css/pass.css">
	<link rel="icon" href="/images/favicon-48.ico" type="image/ico">
	<script type="text/javascript" src="js/jquery.min.js"></script>
	<script type="text/javascript" src="js/bootstrap.min.js"></script>
	<script src="/js/pwdmeter.js"></script>
</head>
<script>
	jQuery(document).ready(function($){
		$("#contenu_acces #input_value").focus(function(){
			$("#status").fadeOut(1000);
		});
	});
</script>
<body>
	<div class="col-12 col-lg-10 offset-lg-1">

		<?php require_once(__DIR__.'/header.php'); ?>
		
		<!-- Main content box -->
		<div class="row">
			<form name="master" id="contenu_acces" action="<?= $current_page ?>" method="post" class="col-12 offset-lg-1 col-lg-10">
				<input class="row" type="hidden" name="action" value="checkpass">

				<div class="row input_row">
					<div class="label_name col-3 col-lg-4"><?= $l_form_l1 ?></div>
					<div class="col-6 col-lg-4">
						<input type="text" name="login" class="form-control" id="input_value" value="" label="test">
					</div>
				</div>

				<div class="row input_row">
					<div class="label_name col-3 col-lg-4"><?= $l_form_l2 ?></div>
					<div class="col-6 col-lg-4">
						<input type="password" class="form-control" id="input_value" name="passwd" value="">
					</div>
				</div>

				<div class="row input_row">
					<div class="label_name col-3 col-lg-4"><?= $l_form_l3 ?></div>
					<div class="col-6 col-lg-4">
						<input class="form-control" id="input_value" type="password" name="newpasswd" value="" autocomplete="off" onkeyup="chkPass(this.value);" />
					</div>
					<div class="col-3 col-lg-4">	
						<input type="text" id="passwordTxt" name="passwordTxt" autocomplete="off" onkeyup="chkPass(this.value);" class="hide" />
					</div>
				</div>
		
				<div class="row input_row">
					
					<div class="label_name col-3 col-lg-4"><?= $l_eval_pass ?></div>
					<div class="col-6 col-lg-4">
						<div class="progress bg-secondary">
  							<div id ="pwprogress" class="progress-bar" role="progressbar" style="width: 0%;">0%</div>
						</div>
						<div class="row">
							<div id="lien_pass" class="col-12"><?= $l_passwordmeter ?></div>
						</div>
					</div>
				</div>

				<div class="row input_row">
					<div class="label_name col-3 col-lg-4"><?= $l_form_l4 ?></div>
					<div class="col-6 col-lg-4">
						<input type="password" class="form-control" id="input_value" name="newpasswd2" value="">
					</div>
				</div>
				<div id="status">
					<?=$l_mandatory?>
				</div>
				<div class="row input_row">
					<div class="col-5 offset-sm-1 col-md-4 offset-md-2">
						<input id="buttons" class="btn btn-default" value="<?= $l_form_button_retour ?>" onclick="window.location.href = '<?= $homepage ?>';">
					</div>
					<div class="col-5 col-md-4">
						<button type="submit" class="btn btn-primary" id="buttons"><?= $l_form_button_valid ?></button>
					</div>
				</div>
			</form>
			</div>
<!--		
			<div class="row">
				<div id="boite_logo" class="img_banner col-xs-12 hidden-sm hidden-md hidden-lg">
					<img class="img-fluid image" src="images/organisme.png">
				</div>
			</div>-->
		</div>
		<div id="info_pass">
			<table id="tablePwdStatus" cellpadding="5" cellspacing="1" border="0">
				<tr>
					<th colspan="2">Additions</th>
					<th class="txtCenter">Type</th>
					<th class="txtCenter">Rate</th>
					<th class="txtCenter">Count</th>
					<th class="txtCenter">Bonus</th>
				</tr>
				<tr>
					<td width="1%"><div id="div_nLength" class="fail">&nbsp;</div></td>
					<td width="94%">Number of Characters</td>
					<td width="1%" class="txtCenter">Flat</td>
					<td width="1%" class="txtCenter italic">+(n*4)</td>
					<td width="1%"><div id="nLength" class="box">&nbsp;</div></td>
					<td width="1%"><div id="nLengthBonus" class="boxPlus">&nbsp;</div></td>
				</tr>
				<tr>
					<td><div id="div_nAlphaUC" class="fail">&nbsp;</div></td>
					<td>Uppercase Letters</td>
					<td class="txtCenter">Cond/Incr</td>
					<td nowrap="nowrap" class="txtCenter italic">+((len-n)*2)</td>
					<td><div id="nAlphaUC" class="box">&nbsp;</div></td>
					<td><div id="nAlphaUCBonus" class="boxPlus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nAlphaLC" class="fail">&nbsp;</div></td>
					<td>Lowercase Letters</td>
					<td class="txtCenter">Cond/Incr</td>
					<td class="txtCenter italic">+((len-n)*2)</td>
					<td><div id="nAlphaLC" class="box">&nbsp;</div></td>
					<td><div id="nAlphaLCBonus" class="boxPlus">&nbsp;</div></td>
				</tr>
				<tr>
					<td><div id="div_nNumber" class="fail">&nbsp;</div></td>
					<td>Numbers</td>
					<td class="txtCenter">Cond</td>
					<td class="txtCenter italic">+(n*4)</td>
					<td><div id="nNumber" class="box">&nbsp;</div></td>
					<td><div id="nNumberBonus" class="boxPlus">&nbsp;</div></td>
				</tr>
				<tr>
					<td><div id="div_nSymbol" class="fail">&nbsp;</div></td>
					<td>Symbols</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">+(n*6)</td>
					<td><div id="nSymbol" class="box">&nbsp;</div></td>
					<td><div id="nSymbolBonus" class="boxPlus">&nbsp;</div></td>
				</tr>
				<tr>
					<td><div id="div_nMidChar" class="fail">&nbsp;</div></td>
					<td>Middle Numbers or Symbols</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">+(n*2)</td>
					<td><div id="nMidChar" class="box">&nbsp;</div></td>
					<td><div id="nMidCharBonus" class="boxPlus">&nbsp;</div></td>
				</tr>
				<tr>
					<td><div id="div_nRequirements" class="fail">&nbsp;</div></td>
					<td>Requirements</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">+(n*2)</td>
					<td><div id="nRequirements" class="box">&nbsp;</div></td>
					<td><div id="nRequirementsBonus" class="boxPlus">&nbsp;</div></td>
				</tr>
				<tr>
					<th colspan="6">Deductions</th>
				</tr>
				<tr>
					<td width="1%"><div id="div_nAlphasOnly" class="pass">&nbsp;</div></td>
					<td width="94%">Letters Only</td>
					<td width="1%" class="txtCenter">Flat</td>
					<td width="1%" class="txtCenter italic">-n</td>
					<td width="1%"><div id="nAlphasOnly" class="box">&nbsp;</div></td>
					<td width="1%"><div id="nAlphasOnlyBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nNumbersOnly" class="pass">&nbsp;</div></td>
					<td>Numbers Only</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">-n</td>
					<td><div id="nNumbersOnly" class="box">&nbsp;</div></td>
					<td><div id="nNumbersOnlyBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nRepChar" class="pass">&nbsp;</div></td>
					<td>Repeat Characters (Case Insensitive)</td>
					<td class="txtCenter">Comp</td>
					<td nowrap="nowrap" class="txtCenter italic"> - </td>
					<td><div id="nRepChar" class="box">&nbsp;</div></td>
					<td><div id="nRepCharBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nConsecAlphaUC" class="pass">&nbsp;</div></td>
					<td>Consecutive Uppercase Letters</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">-(n*2)</td>
					<td><div id="nConsecAlphaUC" class="box">&nbsp;</div></td>
					<td><div id="nConsecAlphaUCBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nConsecAlphaLC" class="pass">&nbsp;</div></td>
					<td>Consecutive Lowercase Letters</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">-(n*2)</td>
					<td><div id="nConsecAlphaLC" class="box">&nbsp;</div></td>
					<td><div id="nConsecAlphaLCBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nConsecNumber" class="pass">&nbsp;</div></td>
					<td>Consecutive Numbers</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">-(n*2)</td>
					<td><div id="nConsecNumber" class="box">&nbsp;</div></td>
					<td><div id="nConsecNumberBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nSeqAlpha" class="pass">&nbsp;</div></td>
					<td>Sequential Letters (3+)</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">-(n*3)</td>
					<td><div id="nSeqAlpha" class="box">&nbsp;</div></td>
					<td><div id="nSeqAlphaBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nSeqNumber" class="pass">&nbsp;</div></td>
					<td>Sequential Numbers (3+)</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">-(n*3)</td>
					<td><div id="nSeqNumber" class="box">&nbsp;</div></td>
					<td><div id="nSeqNumberBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<td><div id="div_nSeqSymbol" class="pass">&nbsp;</div></td>
					<td>Sequential Symbols (3+)</td>
					<td class="txtCenter">Flat</td>
					<td class="txtCenter italic">-(n*3)</td>
					<td><div id="nSeqSymbol" class="box">&nbsp;</div></td>
					<td><div id="nSeqSymbolBonus" class="boxMinus">&nbsp;</div></td>
				</tr>	
				<tr>
					<th colspan="6">Legend</th>
				</tr>
				<tr>
					<td colspan="6">
						<ul id="listLegend">
							<li><div class="exceed imgLegend">&nbsp;</div><span class="bold">Exceptional:</span> Exceeds minimum standards. Additional bonuses are applied.</li>
							<li><div class="pass imgLegend">&nbsp;</div><span class="bold">Sufficient:</span> Meets minimum standards. Additional bonuses are applied.</li>
							<li><div class="warn imgLegend">&nbsp;</div><span class="bold">Warning:</span> Advisory against employing bad practices. Overall score is reduced.</li>
							<li><div class="fail imgLegend">&nbsp;</div><span class="bold">Failure:</span> Does not meet the minimum standards. Overall score is reduced.</li>
						</ul>
					</td>
				</tr>
			</table>
			<table id="tablePwdNotes" cellpadding="5" cellspacing="1" border="0">
				<tr>
					<th>Quick Footnotes</th>
				</tr>
				<tr>
					<td>
						&bull; <strong>Flat:</strong> Rates that add/remove in non-changing increments.<br>
						&bull; <strong>Incr:</strong> Rates that add/remove in adjusting increments.<br>
						&bull; <strong>Cond:</strong> Rates that add/remove depending on additional factors.<br>
						&bull; <strong>Comp:</strong> Rates that are too complex to summarize. See source code for details.<br>
						&bull; <strong>n:</strong> Refers to the total number of occurrences.<br>
						&bull; <strong>len:</strong> Refers to the total password length.<br>
						&bull; Additional bonus scores are given for increased character variety.<br>
						&bull; Final score is a cumulative result of all bonuses minus deductions.<br>
						&bull; Final score is capped with a minimum of 0 and a maximum of 100.<br>
						&bull; Score and Complexity ratings are not conditional on meeting minimum requirements.<br>
					</td>
				</tr>
			</table>
		</div>
	</div>
</body>
</html>
