<?php
# $Id: intercept.php 3228 2024-10-22 11:59:33Z rexy $
#
# intercept.php for ALCASAR captive portal
# by Rexy & steweb57
# UI & css style by Stéphane ERARD & Alexandre VEZIN
# Help for language translation by B. AUBARD (thanks)

# Redirects from CoovaChilli (chilli daemon) :
# Response to login:
  # success :	if login successful
  # failed :	if login failed
  # logoff :	if logout successful
  # already :	if tried to login while already logged in
  # notyet :	if not logged in yet
  # Default :	it was not a form request -> client go to login form

/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');
define('DOMAIN_ALLOWED_LIST', '/usr/local/etc/alcasar-uamdomain');

/****************************************************************
*			FILE reading test			*
*****************************************************************/
$conf_files = array(CONF_FILE, DOMAIN_ALLOWED_LIST);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Fichier $file non présent");
	}
	if (!is_readable($file)) {
		exit("Vous n'avez pas les droits de lecture sur le fichier $file");
	}
}
/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);

$organisme = $conf["ORGANISM"];
$service_SMS_status = ($conf['SMS'] === 'on');
$service_Email_status = ($conf['MAIL'] === 'on');
$service_wifi4eu_status = ($conf['WIFI4EU'] === 'on');
$service_wifi4eu_code = $conf['WIFI4EU_CODE'];
$service_wifi4eu_server = 'https://collection.wifi4eu.ec.europa.eu/wifi4eu.min.js';

// Shared secret used to encrypt password with coova.
$uamsecret = "";

// URL loaded after success authenticates (let blank for browser defaults)
$adminurl = "";

// Our own path
$loginpath = htmlspecialchars($_SERVER['PHP_SELF']);
$useHTTPS = ((isset($_SERVER['HTTPS'])) && (!empty($_SERVER['HTTPS'])) && ($_SERVER['HTTPS'] !== 'off'));
$alcasarpath = (($useHTTPS) ? 'https' : 'http' ).'://'.$conf['HOSTNAME'].'.'.$conf['DOMAIN'];
$statuspath = (($conf['HTTPS_CHILLI'] === 'on') ? 'https' : 'http' ).'://'.$conf['HOSTNAME'].'.'.$conf['DOMAIN'].'/status.php';

# Redirection if HTTPS needed and not used
if (($conf['HTTPS_LOGIN'] === 'on') && (!$useHTTPS)) {
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: https://'.$conf['HOSTNAME'].'.'.$conf['DOMAIN'].'/intercept.php');
	exit();
}

// Choice of language
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'es') {		// Spanish
	$l_ChilliError			= "La autenticación debe ser un éxito a través del servicio de portal cautivo.";
	$l_login			= "Autenticación exitosa.<HR>Cerrar ésta ventana interrumpe la sesión.";
	$l_logout			= "Finalice la conexión";
	$l_loginfailed			= "Error de autenticación";
	$l_loggingin			= "Identificación en el portal cautivo";
	$l_loggedcont			= "Control de Acceso";
	$l_loggedout			= "Su sesión se cierra";
	$l_user				= "Usuario";
	$l_password			= "Contraseña";
	$l_mandatory			= "* Campos requeridos";
	$l_wait				= "Por favor, espere un momento ...";
	$l_onlinetime			= "Tiempo de conexión:";
	$l_remainingtime		= "Desconexión en:";
	$l_boutonO			= "Autenticación";
	$l_boutonF			= "Cerrar";
	$l_loggedin_stringl1		= "Información del Sistema de Seguridad";
	$l_loggedin_stringl2		= "El portal fue creado para garantizar la trazabilidad, la rendición de cuentas y el no repudio de las conexiones.";
	$l_loggedin_stringl3		= "Su actividad en la red es registrada, de conformidad con criterios de privacidad.";
	$l_loggedin_stringl4		= "Los datos registrados pueden ser solicitados y suministrados a una autoridad judicial en el curso de una investigación.";
	$l_loggedin_stringl5		= "Estos datos se eliminan automáticamente después de un año.";
	$l_loggedin_stringl6		= "Click <a href=\"$alcasarpath\">aquí</a> para cambiar su contraseña o para instalar el certificado de seguridad en su navegador";
	$l_loggedout_string		= "Desconectado del portal cautivo!";
	$l_reply_0			= "Nombre de usuario o contraseña incorrectos";
	$l_reply_1			= "Su cuota diaria ha sido alcanzada (duración o volumen)";
	$l_reply_2			= "Su cuota mensual ha sido alcanzada (duración o volumen)";
	$l_reply_3			= "Intenta conectarse fuera de su intervalo de tiempo permitido";
	$l_reply_4			= "su cuenta expiró";
	$l_reply_5			= "Ha alcanzado el número máximo de inicios de sesión simultáneos";
	$l_reply_6			= "Se ha alcanzado su tiempo de conexión autorizado";
	$l_online_time			= "Tiempo en linea";
	$l_remaining_time		= "Tiempo restante";
	$l_uam_domain			= "Sitios de libre acceso : ";
	$l_sms_registration		= "Registro por SMS";
	$l_email_registration		= "Registro por E-mail";
} else if ($Language === 'pt') {	// Portuguese
	$l_ChilliError			= "A autenticação precisa ser bem sucedida através do portal.";
	$l_login			= "Sucesso na autenticação.<HR>Matenha esse pop-up apenas minimizado para não interromper a conexão";
	$l_logout			= "Encerrar conexão";
	$l_loginfailed			= "Falha na autenticação";
	$l_loggingin			= "Identificação do portal cativo";
	$l_loggedcont			= "Controle de acesso";
	$l_loggedout			= "Sua sessão foi fechada";
	$l_user				= "Usuário";
	$l_password			= "Senha";
	$l_mandatory			= "* Campos obrigatórios";
	$l_wait				= "Por favor, aguarde um momento ...";
	$l_onlinetime			= "Tempo de conexão:";
	$l_remainingtime		= "Desconectado em:";
	$l_boutonO			= "Autenticação";
	$l_boutonF			= "Fechar";
	$l_loggedin_stringl1		= "Sistema de Informação e segurança";
	$l_loggedin_stringl2		= "Este controle foi criado para garantir acesso seguro.";
	$l_loggedin_stringl3		= "A autenticação será criptografada em 256 bits, impedindo captura por escâner de rede.";
	$l_loggedin_stringl4		= "Sua atividade na Internet será resguardada de acordo com os regulamentos da lei.";
	$l_loggedin_stringl5		= "Mantenha o popup da conexão minimizado para não interromper a cessão.";
	$l_loggedin_stringl6		= "Clique <a href=\"$alcasarpath\">aqui</a> para alterar sua senha, instalar certificado ou sair do portal.";
	$l_loggedout_string		= "desconexão do portal cativo";
	$l_reply_0			= "Nome de usuário ou senha incorretos";
	$l_reply_1			= "Sua cota diária foi alcançada (duração ou volume)";
	$l_reply_2			= "Sua cota mensal foi atingida (duração ou volume)";
	$l_reply_3			= "Você tenta conectar-se fora do seu período de tempo permitido";
	$l_reply_4			= "Sua conta expirou";
	$l_reply_5			= "Você atingiu o número máximo de logins simultâneos";
	$l_reply_6			= "Seu tempo de conexão autorizada finalizou";
	$l_online_time			= "Tempo Online";
	$l_remaining_time		= "Tempo restante";
	$l_uam_domain			= "Sítios de acesso livre : ";
	$l_sms_registration		= "Registo por SMS";
	$l_email_registration		= "Registro por E-mail";
} else if ($Language === 'zh') {	// Chinese
	$l_ChilliError			= "验证必须通过强制门户服务";
	$l_login			= "验证成功<HR>关闭此窗口中断连接";
	$l_logout			= "关闭连接";
	$l_loginfailed			= "验证失败";
	$l_loggingin			= "强制门户身份识别";
	$l_loggedcont			= "访问控制";
	$l_loggedout			= "您的连接已关闭";
	$l_user				= "用户名";
	$l_password			= "密码";
	$l_mandatory			= "* 必须填写";
	$l_wait				= "请等待 ...";
	$l_onlinetime			= "连接时间";
	$l_remainingtime		= "断开连接于";
	$l_boutonO			= "验证";
	$l_boutonF			= "关闭";
	$l_loggedin_stringl1		= "信息系统安全";
	$l_loggedin_stringl2		= "这种控制实施以法定保证可追溯性，可归罪性和连接的不否认性.";
	$l_loggedin_stringl3		= "您的网络活动是私密登记的.";
	$l_loggedin_stringl4		= "记录的数据能被司法机关在调查中操作使用.";
	$l_loggedin_stringl5		= "这些数据将在一年后自动删除.";
	$l_loggedin_stringl6		= "点击 <a href=\"$alcasarpath\"> 这里 </a> 修改密码或安装浏览器安全证书";
	$l_loggedout_string		= "强制网络门户连接已断开";
	$l_reply_0			= "用户名或密码无效";
	$l_reply_1			= "您的每日配额已达到（持续时间或数量) ";
	$l_reply_2			= "已达到每月配额（持续时间或数量）";
	$l_reply_3			= "您尝试在授权时间以外连接";
	$l_reply_4			= "您的账号已过期";
	$l_reply_5			= "您已经达到同时连接的最大数量";
	$l_reply_6			= "已经到达您的允许连接时间";
	$l_online_time			= "在线时间";
	$l_remaining_time		= "剩余时间";
	$l_uam_domain			= " : ";
	$l_sms_registration		= "SMSで登録する";
	$l_email_registration		= "メールでの登録";
} else if ($Language === 'ar') {	// Arabic
	$l_ChilliError			= "يجب نجاح المصادقة على البوابة الأسيرة";
	$l_login			= "إغلاق هذه النافذة يقطع دورة عملك";
	$l_logout			= "إغلاق الدورة";
	$l_loginfailed			= "فشل المصادقة";
	$l_loggingin			= "التعريف على البوابة الأسيرة";
	$l_loggedcont			= "مراقبة الدخول";
	$l_loggedout			= "دورتكَ مغلقة";
	$l_user				= "التعريف";
	$l_password			= "كلمة السر";
	$l_mandatory			="* الحقول المطلوبة";
	$l_wait				= "...إنتظر بعض اللحظات";
	$l_onlinetime			= ":مدة الإتصال";
	$l_remainingtime		= ":انقطاع الإتصال في";
	$l_boutonO			= "مصادقة";
	$l_boutonF			= "أغلق";
	$l_loggedin_stringl1		= "سلامة نظم المعلومات";
	$l_loggedin_stringl2		= "وُضعت هذه المراقبة للضمان القانوني لتتبع ومساءلة وعدم تنصل الإتصالات";
	$l_loggedin_stringl3		= "نشاطك على الشبكة مسجل وفقاً لاحترام الحريات الشخصية";
	$l_loggedin_stringl4		= "لا يمكن استغلال البيانات المسجلة إلاّ من قِبل سلطات التحقيق القضائ";
	$l_loggedin_stringl5		= "سيتم حدف هذه البيانات تلقائياً بعد سنة من الْيَوْمَ";
	$l_loggedin_stringl6		= "لتغيير كلمة السر أو شهادة الأمان <a href=\"$alcasarpath\">هنا</a> اضغط ";
	$l_loggedout_string		= "تَمّ قطع الإتصال بالبوابة الأسيرة";
	$l_reply_0			= "اسم المستخدم أو كلمة المرور غير صالحة";
	$l_reply_1			= "تم الوصول إلى حصتك اليومية (المدة أو الحجم)";
	$l_reply_2			= "تم الوصول إلى حصتك الشهرية (المدة أو الحجم)";
	$l_reply_3			= "محاولة اتصال خارج فترتك المأذونة";
	$l_reply_4			= "انتهت مدة صلاحية حسابك";
	$l_reply_5			= "لقد استكملت العدد الأقصى للإتصالات المتزامنة";
	$l_reply_6			= "استكملت مذة الإتصال المسموحة";
	$l_online_time			= "مذة الإتصال";
	$l_remaining_time		= "الوقت المتبق";
	$l_uam_domain			= "مواقع الوصول المجاني";
	$l_sms_registration		= "التسجيل عن طريق الرسائل القصيرة";
	$l_email_registration		= "التسجيل عن طريق البريد الإلكتروني";
} else if ($Language === 'de') {	// German
	$l_ChilliError			= "Sie wurden erfolgreich durch das Portal authentifiziert.";
	$l_login			= "Erfolgreiche Authentifizierung.<HR>Schlißen dieses fensters unterbricht die Sitzung";
	$l_logout			= "Beenden der Verbindung";
	$l_loginfailed			= "Authentifizierungsfehler";
	$l_loggingin			= "Authentifizierung auf dem Portal";
	$l_loggedcont			= "Zugangskontrolle";
	$l_loggedout			= "Ihre Sitzung wurde geschlossen";
	$l_user				= "Benutzer";
	$l_password			= "Passwort";
	$l_mandatory			= "* Benötigte Felder";
	$l_wait				= "Bitte warten Sie einen Moment ...";
	$l_onlinetime			= "Online-Zeit:";
	$l_remainingtime		= "Abmelden:";
	$l_boutonO			= "Authentifizierung";
	$l_boutonF			= "Schließen";
	$l_loggedin_stringl1		= "Information System Security";
	$l_loggedin_stringl2		= "Dieses Portal wurde eingerichtet, um ordnungsgemäß die Rückverfolgbarkeit, die Zurechenbarkeit und die Nicht-Abstreitbarkeit der Verbindungen zu sichern.";
	$l_loggedin_stringl3		= "Ihre Tätigkeiten im Netzwerk werden im Hinblick auf den Schutz Ihrer Privatsphäre gespeichert.";
	$l_loggedin_stringl4		= "Die gespeicherten Daten können von einer Justizbehörde im Falle einer Untersuchung genutzt werden.";
	$l_loggedin_stringl5		= "Diese Daten werden nach einem Jahr automatisch gelöscht.";
	$l_loggedin_stringl6		= "Klicken Sie <a href=\"$alcasarpath\">hier</a> um Ihr Password zu ändern oder das Sicherheitszertifikat für Ihren Browser herunterzuladen";
	$l_loggedout_string		= "Sie wurden vom Portal getrennt!";
	$l_reply_0			= "Falscher Benutzername oder falsches Passwort";
	$l_reply_1			= "Ihr Tageskontingent wurde erreicht (Dauer oder Volumen)";
	$l_reply_2			= "Ihr monatliches Kontingent wurde erreicht (Dauer oder Volumen)";
	$l_reply_3			= "Sie haben versucht sich außerhalb der erlaubten Zeiten zu verbinden";
	$l_reply_4			= "Ihr Account ist abgelaufen";
	$l_reply_5			= "Sie haben die maximale Anzahl an simultanen Verbindungen erreicht";
	$l_reply_6			= "Ihre maximale Verbindungszeit wurde erreicht";
	$l_online_time			= "Online-Zeit";
	$l_remaining_time		= "Verbleibende Zeit";
	$l_uam_domain			= "Offen zugängliche Seiten : ";
	$l_sms_registration		= "Per SMS anmelden";
	$l_email_registration		= "Per E-Mail anmelden";
} else if ($Language === 'nl') {	// Dutch
	$l_ChilliError			= "De authenticatie moet een succes worden via de captive portal dienst.";
	$l_login			= "Succesvolle authenticatie.<HR>Dit venster te sluiten onderbreekt uw sessie.";
	$l_logout			= "Slotkoers verbinding";
	$l_loginfailed			= "Authenticatie mislukt";
	$l_loggingin			= "Identificatie van de captive-portaal";
	$l_loggedcont			= "toegangscontrole";
	$l_loggedout			= "Uw sessie is gesloten";
	$l_user				= "Gebruiker";
	$l_password			= "Wachtwoord";
	$l_mandatory			= "* Verplichte velden";
	$l_wait				= "Wacht een moment ...";
	$l_onlinetime			= "Sluit tijd:";
	$l_remainingtime		= "Verbreking in:";
	$l_boutonO			= "Authenticatie";
	$l_boutonF			= "Sluiten";
	$l_loggedin_stringl1		= "Information System Security";
	$l_loggedin_stringl2		= "Het portaal werd opgericht verordeningen om de traceerbaarheid, verantwoordelijkheid en onloochenbaarheid van de verbindingen.";
	$l_loggedin_stringl3		= "Uw activiteit op het netwerk is geregistreerd in overeenstemming met de persoonlijke levenssfeer.";
	$l_loggedin_stringl4		= "De geregistreerde gegevens kunnen worden kunnen worden bediend door een rechterlijke instantie in de loop van een onderzoek.";
	$l_loggedin_stringl5		= "Deze gegevens worden automatisch verwijderd na een jaar.";
	$l_loggedin_stringl6		= "Click <a href=\"$alcasarpath\">here</a> to change your password or to integrate the security certificate in your browser";
	$l_loggedout_string		= "Logout gemaakt intern portaal!";
	$l_reply_0			= "Ongeldige gebruikersnaam of wachtwoord";
	$l_reply_1 			= "Uw dagelijkse quotum is bereikt (duur of volume)";
	$l_reply_2			= "Je maandelijkse quotum is bereikt (duur of volume)";
	$l_reply_3			= "You try to connect outside of your allowed timespan";
	$l_reply_4			= "your account expired";
	$l_reply_5			= "You have reached the maximum number of simultaneous logins";
	$l_reply_6			= "Your authorized connexion time has been reached";
	$l_online_time			= "Online tijd";
	$l_remaining_time		= "Reterende tijd";
	$l_uam_domain			= "Sites met open toegang : ";
	$l_sms_registration		= "Registreren per SMS";
	$l_email_registration		= "Registreer per E-mail";
} else if ($Language === 'fr') {	// French
	$l_ChilliError			= "L'authentification doit être réussie sur le portail captif.";
	$l_login			= "Authentification réussie.<HR>La fermeture de cette fenêtre interrompt votre session.";
	$l_logout			= "Fermeture de la session";
	$l_loginfailed			= "Echec d'authentification";
	$l_loggingin			= "Identification sur le portail captif";
	$l_loggedcont			= "Contrôle d'accès";
	$l_loggedout			= "Votre session est fermée";
	$l_user				= "Identifiant";
	$l_password			= "Mot de passe";
	$l_mandatory			= "* champs requis";
	$l_wait				= "Patientez un instant ...";
	$l_onlinetime			= "Temps de connexion:";
	$l_remainingtime		= "Deconnexion dans :";
	$l_boutonO			= "Authentification";
	$l_boutonF			= "Fermer";
	$l_loggedin_stringl1		= "Sécurité des Systèmes d'Information";
	$l_loggedin_stringl2		= "Ce contrôle a été mis en place pour assurer réglementairement la traçabilité, l'imputabilité et la non-répudiation des connexions.";
	$l_loggedin_stringl3		= "Votre activité sur le réseau est enregistrée conformément au respect de la vie privée.";
	$l_loggedin_stringl4		= "Les données enregistrées ne pourront être exploitées que par une autorité judiciaire dans le cadre d'une enquête.";
	$l_loggedin_stringl5		= "Ces données seront automatiquement supprimées au bout d'un an.";
	$l_loggedin_stringl6		= "Cliquez <a href=\"$alcasarpath\">ici</a> pour changer votre mot de passe ou pour intégrer le certificat de sécurité à votre navigateur";
	$l_loggedout_string		= "Déconnexion du portail captif effectuée !";
	$l_reply_0			= "Nom d'utilisateur ou mot de passe incorrect";
	$l_reply_1			= "Votre quota journalier a été atteint (durée ou volume)";
	$l_reply_2			= "Votre quota mensuel a été atteint (durée ou volume)";
	$l_reply_3			= "Vous tentez de vous connecter en dehors de votre période autorisée";
	$l_reply_4			= "Votre compte a expiré";
	$l_reply_5			= "Vous avez atteint le nombre maximum de connexions simultanées";
	$l_reply_6			= "Votre durée de connexion autorisée a été atteinte";
	$l_online_time			= "Temps de connexion";
	$l_remaining_time		= "Temps restant";
	$l_uam_domain			= "Sites en accès libre : ";
	$l_sms_registration		= "S'inscrire par SMS";
	$l_email_registration		= "S'incrire par E-mail";
} else {				// English
	$l_ChilliError			= "The authentication must be successful through the captive portal service.";
	$l_login			= "Successful authentication.<HR>Closing this window interrupts your session";
	$l_logout			= "Closing connection";
	$l_loginfailed			= "Authentication Failed";
	$l_loggingin			= "Identification on the captive portal";
	$l_loggedcont			= "Access Control";
	$l_loggedout			= "Your session is closed";
	$l_user				= "User";
	$l_password			= "Password";
	$l_mandatory			= "* field required";
	$l_wait				= "Please wait a moment ...";
	$l_onlinetime			= "Connect time:";
	$l_remainingtime		= "Disconnection in:";
	$l_boutonO			= "Authentication";
	$l_boutonF			= "Close";
	$l_loggedin_stringl1		= "Information System Security";
	$l_loggedin_stringl2		= "That control was set up regulations to ensure traceability, accountability and non-repudiation of connections.";
	$l_loggedin_stringl3		= "Your activity on the network is registered in accordance with privacy.";
	$l_loggedin_stringl4		= "The recorded data can be able to be operated by a judicial authority in the course of an investigation.";
	$l_loggedin_stringl5		= "These data will be automatically deleted after one year.";
	$l_loggedin_stringl6		= "Click <a href=\"$alcasarpath\">here</a> to change your password or to integrate the security certificate in your browser";
	$l_loggedout_string		= "Disconnection of the captive portal made";
	$l_reply_0			= "Incorrect username or password";
	$l_reply_1			= "Your daily quota has been reached (duration or volume)";
	$l_reply_2			= "Your monthly quota has been reached (duration or volume)";
	$l_reply_3			= "You try to connect outside of your allowed timespan";
	$l_reply_4			= "your account expired";
	$l_reply_5			= "You have reached the maximum number of simultaneous logins";
	$l_reply_6			= "Your authorized connexion time has been reached";
	$l_online_time			= "Online time";
	$l_remaining_time		= "Remaining time";
	$l_uam_domain			= "Open access websites : ";
	$l_sms_registration		= "Register by SMS";
	$l_email_registration		= "Register by E-mail";
}

# Read form parameters which we care about
# avoid the "user as a MAC address" attempts
if ((isset($_POST['username'])) && (preg_match('/^([0-9A-F]{2}-){5}[0-9A-F]{2}$/', $_POST['username']) !== 1))
	$username	= htmlspecialchars(trim($_POST['username'])); else $username = '';
if (isset($_POST['password']))	$password	= $_POST['password']; else $password = '';
if (isset($_POST['challenge']))	$challenge	= htmlspecialchars($_POST['challenge']); else $challenge = '';
if (isset($_POST['button']))	$button		= htmlspecialchars($_POST['button']); else $button = '';
// if (isset($_POST['logout']))	$logout		= htmlspecialchars($_POST['logout']); else $logout = '';
// if (isset($_POST['prelogin']))	$prelogin	= htmlspecialchars($_POST['prelogin']); else $prelogin = '';
// if (isset($_POST['res']))	$res		= htmlspecialchars($_POST['res']); else $res = '';
// if (isset($_POST['uamip']))	$uamip		= htmlspecialchars($_POST['uamip']); else $uamip = '';
// if (isset($_POST['uamport']))	$uamport	= htmlspecialchars($_POST['uamport']); else $uamport = '';
if (isset($_POST['userurl']))	$userurl	= htmlspecialchars($_POST['userurl']); else $userurl = '';
// if (isset($_POST['timeleft']))	$timeleft	= htmlspecialchars($_POST['timeleft']); else $timeleft = '';
// if (isset($_POST['redirurl']))	$redirurl	= htmlspecialchars($_POST['redirurl']); else $redirurl = '';

# Read query parameters which we care about
if (isset($_GET['res']))	$res		= htmlspecialchars($_GET['res']); else $res = '';
// if (isset($_GET['reason']))	$reason		= htmlspecialchars($_GET['reason']); else $reason = '';
if (isset($_GET['challenge']))	$challenge	= htmlspecialchars($_GET['challenge']);
// if (isset($_GET['uamip']))	$uamip		= htmlspecialchars($_GET['uamip']);
// if (isset($_GET['uamport']))	$uamport	= htmlspecialchars($_GET['uamport']);
if (isset($_GET['timeleft']))	$timeleft	= htmlspecialchars($_GET['timeleft']); else $timeleft = '';
if (isset($_GET['reply']))	$reply		= htmlspecialchars(trim($_GET['reply'])); else $reply = '';
if (isset($_GET['redirurl']))	$redirurl	= htmlspecialchars($_GET['redirurl']); else $redirurl = '';
if (isset($_GET['userurl']))	$userurl	= htmlspecialchars($_GET['userurl']);

// TODO: clean unused query params

$uamip = $conf['HOSTNAME'].'.'.$conf['DOMAIN'];
if (($conf['HTTPS_CHILLI'] === 'on') && $useHTTPS) {
	$uamproto = 'https';
	$uamport  = 3991;
} else {
	$uamproto = 'http';
	$uamport  = 3990;
}

# translation of radius replies
if (!empty($reply)) {
	switch ($reply) {
		case 'Username not found'				: $reply = $l_reply_0; break;
		case 'Login failed'					: $reply = $l_reply_0; break;
		case 'Your maximum daily usage time has been reached'	: $reply = $l_reply_1; break;
		case 'Your maximum monthly usage time has been reached'	: $reply = $l_reply_2; break;
		case 'You are out your allowed time period'		: $reply = $l_reply_3; break;
		case 'Your expiration date has been reached'	: $reply = $l_reply_4; break;
		case 'You are already logged in - access denied'	: $reply = $l_reply_5; break;
		case 'Your usage time has been reached'	: 			$reply = $l_reply_6; break;
	}
}

// If attempt to login
if ($button === $l_boutonO) {
	//correction password length in coova-chilli
	//thanks to http://www.stochasticgeometry.ie/2009/09/09/maximum-password-length-in-coova-chilli/
	$hexchal = pack('H*', $challenge);
	$newchal = pack('H*', hash('sha256',$hexchal . $uamsecret));
	// If challenge isn't long enough, repeat it until it is
	while (strlen($newchal) < strlen($password)) {
		$newchal .= $newchal;
	}
	$newpwd   = pack('a*', $password);
	// Encode plain text password with challenge
	$pappassword = implode('', unpack('H*', ($newpwd ^ $newchal)));
	header("Location: $uamproto://$uamip:$uamport/logon?username=$username&password=$pappassword&userurl=$userurl");
	exit();
}

switch($res) {
	case 'success':	$result = 1; break; // If login successful
	case 'failed':	$result = 2; break; // If login failed
	case 'logoff':	$result = 3; break; // If logout successful
	case 'already':	$result = 4; break; // If tried to login while already logged in
	case 'notyet':	$result = 5; break; // If not logged in yet
	default:	$result = 0; // Default: It was not a form request -> client go to login form
}

//check if we need to warn user about the imputability logs.
if ($result === 1) {
	if ((is_file('./acc/manager/lib/sql/drivers/mysql/functions.php')) && (is_file('/etc/freeradius-web/config.php'))) {
		include_once('/etc/freeradius-web/config.php');
		include_once('./acc/manager/lib/sql/drivers/mysql/functions.php');
		$link = @da_sql_pconnect($config);
		if ($link) {
			$user_uid = da_sql_escape_string($link, $_GET['uid']);
			$sql = "SELECT value FROM radreply WHERE username='$user_uid' AND attribute='Alcasar-Imputability-Warning'";
			$res = @da_sql_query($link, $config, $sql);
			if ($res) {
				$row = @da_sql_fetch_array($res, $config);
				if ($row && $row['value'] === '1') {
					$sql = "DELETE FROM radreply WHERE username='$user_uid' AND attribute='Alcasar-Imputability-Warning'";
					@da_sql_query($link, $config, $sql);
					header('Location: '.(($conf['HTTPS_LOGIN'] === 'on') ? 'https' : 'http').'://'.$conf['HOSTNAME'].'.'.$conf['DOMAIN'].'/index.php?warn=1&url='.urlencode($_GET['userurl']));   //we present to user information about imputability logs 
					exit();
				}
			}
		}
	}
}

// By default, redirect to prelogin in order to generate a challenge
if ($result === 0) {
	header("Location: $uamproto://$uamip:$uamport/prelogin");
	exit();
}

//////////////////////////////////////////////
///////////// TEST VARIABLES /////////////////
//////////////////////////////////////////////////////////////////
//$result = 5;     // = 1/2/3/4/5
//$reply is a displayed sentence
//$reply = 'dsfsdfsdfdsf';    //  = ''/'Incorrect user/password'
//$service_SMS_status = true;    // = true/false
//$service_Email_status = true;    // = true/false
//$service_wifi4eu_status = true;    // = true/false
// test of domain Allowed
//////////////////////////////////////////////////////////////////

// Cleaning the cache
header('Expires: Tue, 01 Jan 2000 00:00:00 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title><?= $l_loggingin ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="stylesheet" href="/css/bootstrap.min.css" type="text/css">
	<link rel="stylesheet" href="/css/intercept.css" type="text/css">
	<link rel="icon" href="/images/favicon-48.ico" type="image/ico">
<? if ($service_wifi4eu_status): ?>
	<script type="text/javascript">
		var wifi4euTimerStart = Date.now();
		var wifi4euNetworkIdentifier = '<?= $service_wifi4eu_code ?>';
		var wifi4euLanguage = '<?= $Language ?>';
		//var selftestModus = true;
	</script>
	<script type="text/javascript" src="<?= $service_wifi4eu_server ?>"></script>
<? endif; ?>
	<script type="text/javascript">
	function doOnLoad(result, userurl, redirurl, adminurl, timeleft) {
		if ((result === 1) || (result === 4)) {	// success or already
			var url;
			if (adminurl !== '') {
				url = adminurl;
			} else if (redirurl !== '') {
				url = redirurl;
			} else if (userurl !== '') {
				url = userurl;
			}
			if (typeof url !== 'undefined') {
				var win = window.open('<?= $statuspath ?>', '_blank');
				if ((win === null) || (typeof win === 'undefined')) { // Pop-up blocked
					window.location = '<?= $statuspath ?>';
				} else {
					window.location = url;
				}
			} else {
				window.location = '<?= $statuspath ?>';
			}
		}
		if ((result === 2) || (result === 3) || result === 5) { // failed or logoff or notyet
			document.form1.username.focus();
		}
	}
	</script>
	<script type="text/javascript" src="js/bootstrap.min.js"></script>
	<script type="text/javascript" src="/js/jquery.min.js"></script>
	<script>jQuery(document).ready(function($){$("input").focus(function(){$("#status").fadeOut(1000);});});</script>
</head>
<body onLoad="javascript:doOnLoad(<?= $result ?>,'<?= $userurl ?>','<?= $redirurl ?>','<?= $adminurl ?>','<?= $timeleft ?>')">
	<div class="col-12">	
	<?php if ($result === 2 || $result === 3 || $result === 5): // failed or logoff or notyet ?>
		<div class ="row">
			<div class="col-12 col-md-10 offset-sm-1">
				<div class="row banner">
					<div class="col-8 offset-xs-2 col-md-12 offset-sm-0">
				<?php if ($service_wifi4eu_status): ?>
					<img id="wifi4eubanner">
				<?php else: ?>
					<h1 class="organisme"><?= $organisme ?></h1>
				<?php endif; ?>
					</div>
				</div>
				<div class="row">
					<form name="form1" class="form-horizontal col-12 col-sm-12 col-md-10 offset-md-1 background-form" method="post" action="<?= $loginpath ?>">
						<div class="row">
							<div class="col-12 col-sm-12 col-md-6 offset-md-3">
								<h2 class="titre-controle-acces"><?= $l_loggedcont ?></h2>
							</div>
							<div class="d-none d-md-block col-md-3">
							<?php
							// Read the "Domain allowed" file
							$tab = file(DOMAIN_ALLOWED_LIST);
							if ($tab) { // the file isn't empty
								echo '<div id="authorized_domain">'.$l_uam_domain.'</div>';
								echo '<ul>';
								foreach ($tab as $line) {
									if (!empty(trim($line))) { // the line isn't empty
										if (strpos ($line, '#')) { // the domain should be displayed
											$domain_allowed = explode('#', $line);
											$domain = explode('"', $domain_allowed[0]);
											$domain[1] = ltrim($domain[1], '.'); // remove every '.' from the beginning of domain
											echo '<li><a href="http://'.trim($domain[1]).'">'.trim($domain_allowed[1]).'</a></li>';
										}
									}
								}
								echo '</ul>';
							}
							?>
							</div>
						</div>
						<div>
						<?php if ($result === 2): // failed ?>
							<h3 class="titre-erreur"><?= $l_loginfailed ?>
							<?php if ($reply): // traitement du reply ... ?>
								: <?= $reply ?>
							<?php endif; ?>
							</h3>
						<?php endif;
						if ($userurl === 'http://logout/') $userurl = 'http://www.google.com'; // Avoid cyclic logout
						?>
						</div>
						<div class="row inputs">
							<div class="d-none d-md-block col-md-2">
								 <img id="logo-organ" class="img-fluid" src="/images/organisme.png">
							</div>
							<div class="col-12 col-md-8">
								<input type="hidden" name="challenge" value="<?= $challenge ?>">
								<input type="hidden" name="userurl" value="<?= $userurl ?>">
								<div class="form-group row">
									<div class="col-2 col-md-3 control-label">
										<p class="boite-info-text"><?= $l_user ?> *</p>
									</div>
									<div class="col-8 col-md-8" id="input_username">
										<input type="text" class="form-control boite-info-text" name="username" placeholder="<?= $l_user ?>">
									</div>
								</div>
								<div class="form-group row">
									<div class="col-2 col-md-3 control-label">
										<p class="boite-info-text"><?= $l_password ?> *</p>
									</div>
									<div class="col-8 col-md-8" id="input_password">
										<input type="password" class="form-control boite-info-text" name="password" placeholder="<?= $l_password ?>">
									</div>
								</div>
								<div id="status"><?=$l_mandatory?></div>
							</div>
							<div class="d-none d-md-block col-md-2">
							</div>
						</div>
						<div class="row row_button">
							<div class="col-12 text-center">
								<input value="<?= $l_boutonO ?>" class="btn btn-primary button" type="submit" name="button">
								<?php if ($service_SMS_status): ?>
									<a href="sms_registration.php" class="btn btn-primary button"><?= $l_sms_registration ?></a>
								<?php endif; ?>
								<?php if ($service_Email_status): ?>
									<a href="email_registration_front.php" class="btn btn-primary button"><?= $l_email_registration ?></a>
								<?php endif; ?>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
			<div class="row boite-info-spacing">
				<div class="col-12 col-md-10 offset-sm-1 col-lg-8 offset-md-2 boite-info-spacing">
					<table id="boite-info" cellSpacing="0" cellPadding="0">
						<tr class="boite-info-titre">
							<td align="center"><font color="red"><b><?= $l_loggedin_stringl1 ?></b></font></td>
						</tr>
						<tr class="boite-info-text">
							<td align="left">
								<ul>
									<li><?= $l_loggedin_stringl2 ?></li>
									<li><?= $l_loggedin_stringl4 ?></li>
									<li><?= $l_loggedin_stringl3 ?></li>
									<li><?= $l_loggedin_stringl5 ?></li>
									<li><?= $l_loggedin_stringl6 ?></li>
								</ul>
							</td>
						</tr>
					</table>
				</div>
				<div class="d-none d-sm-none d-md-block col-md-2">
					<img id="logo-alcasar" class="img-fluid" src="/images/logo-alcasar.png">
				</div>
			</div>
			<div class="row">
				<div class="col-6 col-md-12 d-md-none d-sm-none d-lg-none">
						<img id="logo-alcasar" class="img-fluid img-xs-bottom" src="/images/logo-alcasar.png">
					</div>
				<div class="col-6 d-sm-none d-md-none d-lg-none">
					<img id="logo-organ" class="img-fluid img-xs-bottom" src="/images/organisme.png">
				</div>
			</div>
		<div class="row" style="text-align: center">
			<div class="col-8 offset-xs-2 col-md-6 offset-sm-3 d-md-none d-sm-none d-lg-none">
			<?php
			// Read the "Domain allowed" file
			$tab = file(DOMAIN_ALLOWED_LIST);
			if ($tab) { // the file isn't empty
				echo '<div id="authorized_domain">'.$l_uam_domain.'</div>';
				echo '<ul>';
				foreach ($tab as $line) {
					if (!empty(trim($line))) { // the line isn't empty
						if (strpos ($line, '#')) { // the domain should be displayed
							$domain_allowed = explode('#', $line);
							$domain = explode('"', $domain_allowed[0]);
							$domain[1] = ltrim($domain[1], '.'); // remove every '.' from the beginning of domain
							echo '<li><a href="http://'.trim($domain[1]).'">'.trim($domain_allowed[1]).'</a></li>';
						}
					}
				}
				echo '</ul>';
			}
			?>
			</div>
		</div>
	</div>
	<?php endif; ?>
</body>
</html>
