<?php

/********************************************************************
*																	*
*			ALCASAR EMAIL INSCRIPTION								*
*																	*
*	By K@M3L & T3RRY @ La Plateforme_								*
*	By Rexy															*
*	Partie front de la page d'inscription des utilisateurs			*
*	elle envoi les infos à traiter à la page de traitement			*
*	via AJAX (email_registration_back)								*
*																	*
/********************************************************************/

/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');

$page = "email_registration";
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'es') {	// Spanish
	$l_title = "Inscripción por e-mail";
	$l_Email = "dirección de e-mail : *";
	$l_mandatory = "* Campos requeridos";
	$l_inscription = "Inscripción";
	$l_mail_success = "Se ha enviado una contraseña a su dirección de correo electrónico.\\nVRevise su correo no deseado o spam, si no ve este correo en su bandeja de entrada.";
	$l_mail_error = "Se ha producido un error. Por favor, renueve su registro o póngase en contacto con su administrador.";
} else if ($Language === 'pt') {	// Portuguese
	$l_title = "inscrição de e-mail";
	$l_Email = "endereço de e-mail : *";
	$l_mandatory = "* Campos obrigatórios";
	$l_inscription = "Inscrição";
	$l_mail_success = "Foi enviada uma senha para o seu endereço electrónico.\\nVerifique o seu spam ou lixo electrónico, se não vir este e-mail na sua caixa de entrada.";
	$l_mail_error = "Ocorreu um erro. Por favor, renove o seu registo ou contacte o seu administrador.";
} else if ($Language === 'de') {	// German
	$l_title = "E-Mail-Anschrift";
	$l_Email = "e-mail adress : *";
	$l_mandatory = "* Erforderliche Felder";
	$l_inscription = "Aufschrift";
	$l_mail_success = "Ein Passwort wurde an Ihre E-Mail-Adresse gesendet.\\nPrüfen Sie Ihre Spam- oder Junk-Mail, wenn Sie diese E-Mail nicht in Ihrem Posteingang finden.";
	$l_mail_error = "Es ist ein Fehler aufgetreten. Bitte erneuern Sie Ihre Registrierung oder kontaktieren Sie Ihren Administrator.";
} else if ($Language === 'nl') {	// Dutch
	$l_title = "e-mail inscriptie";
	$l_Email = "e-mailadres : *";
	$l_mandatory = "* Verplichte velden";
	$l_inscription = "Opschrift";
	$l_mail_success = "Er is een wachtwoord naar uw e-mail adres gestuurd.\\nControleer uw spam of junk mail, als u deze e-mail niet in uw inbox ziet.";
	$l_mail_error = "Er is een fout opgetreden. Vernieuw uw registratie of neem contact op met uw beheerder.";
} else if ($Language === 'zh') {	// Chinese
	$l_title = "电子邮件题词";
	$l_Email = "电子邮件地址 : *";
	$l_mandatory = "* 必须填写";
	$l_inscription = "铭文";
	$l_mail_success = "一个密码已经发送到你的邮箱。\\n如果你在收件箱中没有看到这封邮件，请检查你的垃圾邮件或垃圾邮件。";
	$l_mail_error = "发生了一个错误。请更新您的注册或联系您的管理员。";
} else if ($Language === 'ar') {	// Arabic
	$l_title = "تسجيل البريد الإلكتروني";
	$l_Email = "عنوان البريد الالكترونى : *";
	$l_mandatory = "* الحقول المطلوبة";
	$l_inscription = "التسجيل";
	$l_mail_success = "تم إرسال كلمة المرور إلى عنوان البريد الإلكتروني الخاص بك.\\nتحقق من البريد العشوائي أو البريد غير الهام ، إذا كنت لا ترى هذا البريد الإلكتروني في صندوق الوارد الخاص بك.";
	$l_mail_error = "الرجاء تجديد التسجيل الخاص بك أو الاتصال بالمسؤول.";
} else if ($Language === 'fr') {
	$l_title = "Inscription par e-mail";
	$l_Email = "Adresse e-mail : *";
	$l_mandatory = "* Champs requis";
	$l_inscription = "Inscription";
	$l_mail_success = "Un mot de passe vient d'être envoyé à votre adresse e-mail.\\nVérifier vos spams ou courriers indésirables, si vous ne voyez pas cet e-mail dans votre boîte de réception.";
	$l_mail_error = "Une erreur s'est produite. Veuillez renouveler votre inscription ou contacter votre administrateur.";
} else { // english
	$l_title = "e-mail inscription";
	$l_Email = "e-mail address : *";
	$l_mandatory = "* Required fields";
	$l_inscription = "Inscription";
	$l_mail_success = "A password has been sent to your e-mail address.\\nCheck your spam or junk mail, if you don't see this e-mail in your inbox.";
	$l_mail_error = "An error has occurred. Please renew your registration or contact your administrator.";
}

/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);
$whiteDomain	= $conf['MAIL_WHITEDOMAIN'];
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>ALCASAR - <?=$l_title?></title>
	<link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="css/pass.css">
	<link rel="icon" href="images/favicon-48.ico" type="image/ico">
	<script type="text/javascript" src="js/jquery.min.js"></script>
	<script type="text/javascript" src="js/bootstrap.min.js"></script>
</head>
<body>
	<div class="col-12 col-lg-10 offset-lg-1">
		<?php require_once(__DIR__.'/header.php'); ?>
		<section id="inscription" class="row">
			<form name="master" id="contenu_acces" onsubmit="return false;" class="col-12 offset-lg-1 col-lg-10">
				<div class="row input_row">
					<div class="label_name col-3 col-lg-4"><?=$l_Email?></div>
					<div class="col-6 col-lg-4">
					<input type="email" placeholder="@*.<?=$whiteDomain?>" id="email" name="email" required class="form-control"/>
					</div>
					<small id="output_email" class="row"></small>
				</div>
				<div id="status">
					<?=$l_mandatory?>
				</div>
				<div class="row input_row">
					<div class="col-5 offset-xs-1 col-md-4 offset-md-2">
						<input id="buttons" class="btn btn-default" value="Annuler" onclick="window.location.href = 'index.php';">
					</div>
				<div class="col-5 col-md-4">
						<button type="submit" class="btn btn-primary btn-lg" id="buttons" ><?=$l_inscription?></button>
					</div>
				</div>
			</form>
		</section>
		<script>
			jQuery(document).ready(function($){
				$("#contenu_acces input").focus(function(){
					$("#status").fadeOut(800);
				});
				$("#contenu_acces").submit(function(){
					var status = $("#status");
					var Fmail = $("#email").val();
					$.ajax({
						type: "post",
						url:  "email_registration_back.php",
						data: {
							'Fmail' : Fmail,
						},
						beforeSend: function(){
							$("#status").attr("value", "Traitement en cours...");
						},
						success: function(data){
							if (data.match("success")) {
								status.html(data).fadeIn(400);
								alert("<?=$l_mail_success?>");
								document.location.href="index.php";
							} else {
							console.log(data);
								alert("<?=$l_mail_error?>");
								status.css("color", "red").html(data).fadeIn(400);
							}
						}
					});
				});
			});
		</script>
		<script>
		document.getElementById('email').addEventListener('input', function(e) {
			const email = e.target.value;
			const domain = email.split('@')[1];
			if (domain.endsWith('.<?= $whiteDomain ?>') || domain === '<?= $whiteDomain ?>') {
				e.target.style.borderColor = 'green';
			} else {
				e.target.style.borderColor = 'red';
			}
		});
		</script>
	</div>
</body>
</html>
