<?php 

/************************************************************************
*						ALCASAR INSCRIPTION								*
*																		*
*	By K@M3L & T3RRY LaPlateforme
*	By Rexy																*
*																		*
*	Partie back de la page d'inscription des utilisateurs				*
*	Récupère les infos de "email_registration_front.php					*
*	- Lit le fichier de configuration /usr/local/etc/alcasar.conf		*
*	- Verifie si le login est déjà présent dans la table "radcheck"		*
*	- Vérifie si l'@ mail est présent dans la table "userinfo"			*
*	- Vérifie que le domaine du mail est bien WLD (optionnel)			*
*	- Crée l'utilisateur avec un mot de passe aléatoire					*
*	- Envoi l'email à l'utilisaeur et à l'admin avec date et IP			*
*																		*
*************************************************************************/

/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');
/****************************************************************
*			Conf files reading test			*
*****************************************************************/
$conf_files = array(CONF_FILE);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Fichier $file non présent");
	}
	if (!is_readable($file)) {
		exit("Vous n'avez pas les droits de lecture sur le fichier $file");
	}
}
/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);
$whiteDomain	= explode(" ", strtolower(trim($conf['MAIL_WHITEDOMAIN'])));
$adminMail		= $conf['MAIL_ADMIN'];
$typeMail		= $conf['MAIL_TYPE'];
$fromMail		= $conf['MAIL_ADDR'];
$organism		= $conf['ORGANISM'];

/****************************************
*			Choice of language			*
*****************************************/
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'fr') {
	$l_invalid_Email = "L'adresse e-mail est invalide";
	$l_domain = "Le domaine";
	$l_not_authorized = "n'est pas autorisé";
	$l_Email_already_used = "Cette adresse e-mail est déjà utilisée.";
	$l_subject = "Activation de votre compte ALCASAR";
	$l_hello = "Bonjour";
	$l_automatic_mail = "Ceci est un e-mail automatique provenant du portail ALCASAR : $organism";
	$l_login = "Voici vos indentifiants de connexion :";
	$l_password = "Mot de passe";
	$l_mail_success = "Un mot de passe vient d'être envoyé à votre adresse e-mail.";
	$l_mail_error = "Erreur lors de l'envoi du mail. Renouvelez votre inscription ou contactez votre administrateur.";
} else if ($Language === 'es') {
	$l_invalid_Email = "Dirección de correo electrónico no válida";
	$l_domain = "El dominio";
	$l_not_authorized = "no está autorizado";
	$l_Email_already_used = "Esta dirección de correo electrónico ya está utilizada.";
	$l_subject = "Activación de su cuenta ALCASAR";
	$l_hello = "Hola";
	$l_automatic_mail = "Este es un correo electrónico automático del portal ALCASAR : $organism";
	$l_login = "Estas son sus credenciales de acceso:";
	$l_password = "Contraseña";
	$l_mail_success = "Se ha enviado una contraseña a su dirección de correo electrónico.";
	$l_mail_error = "Error al enviar el correo electrónico. Renueve su registro o póngase en contacto con su administrador.";
} else {
	$l_invalid_Email = "Invalid Email address";
	$l_domain = "The domain";
	$l_not_authorized = "is not authorized";
	$l_Email_already_used = "This Email address is already used.";
	$l_subject = "Activation of your ALCASAR account";
	$l_hello = "Hello";
	$l_automatic_mail = "This is an automatic e-mail from ALCASAR portal : $organism";
	$l_login = "Here are your login credentials :";
	$l_password = "Password";
	$l_mail_success = "A password has been sent to your e-mail address";
	$l_mail_error = "Error while sending the email. Renew your registration or contact your administrator.";
}

if(!isset($create)) $create=0;
if(!isset($show)) $show=0;
if(!isset($login)) $login = '';
if(!isset($cn)) $cn = '';
if(!isset($mail)) $mail = '';
if(!isset($langue_imp)) $langue_imp = '';
if(!isset($selected)) $selected = array();
if(!isset($selected['='])) $selected['='] = '';

require('/etc/freeradius-web/config.php');
require('acc/manager/lib/attrshow.php');
require('acc/manager/lib/defaults.php');

if (false && /* Hide operator column */ $config['general_lib_type'] == 'sql' && $config['sql_use_operators'] == 'true') {
	$colspan = 2;
	$show_ops = 1;
	require('acc/manager/lib/operators.php');
} else {
	$show_ops = 0;
	$colspan = 1;
}

if (is_file("acc/manager/lib/sql/drivers/$config[sql_type]/functions.php"))
	require("acc/manager/lib/sql/drivers/$config[sql_type]/functions.php");
else{
	echo "<b>Could not include SQL library</b><br />\n";
	exit();
}

require('acc/manager/lib/functions.php');
if ($config['sql_use_operators'] == 'true'){
	include_once("acc/manager/lib/operators.php");
	$text = ',op';
	$passwd_op = ",':='";
}

$da_abort=0;
$op_val2 = '';

function GenPassword($nb_car="8")
{
// Random password
	$password = "";
	$chaine  = "aAzZeErRtTyYuUIopP152346897mMLkK";
	$chaine .= "jJhHgGfFdDsSqQwWxXcCvVbBnN152346897";
	while($nb_car != 0) {
		//$i = rand(0,71);
		// Bug corrigé
		$i = rand(0,66);
		$password .= $chaine[$i];
		$nb_car--;
	}
	return $password;
}

if(isset($_POST['Fmail'])){
	extract($_POST,EXTR_SKIP);
	$Fmail = htmlentities(strtolower(trim($Fmail)));
	if(!filter_var($Fmail, FILTER_VALIDATE_EMAIL)){  
		echo "<b>$l_invalid_Email</b><br />\n";
		exit();
	}
	
	// Retrieve the domainName of the new user
	list($user, $domain) = explode('@', $Fmail);

	// Extract main domain  (allows sub_domains)
	$domainParts = explode('.', $domain);
	if (count($domainParts) >= 2) {
		$mainDomain = implode('.', array_slice($domainParts, -2));
	} else {
		$mainDomain = $domain; // Cas où le domaine n'a pas de sous-domaine (ex: exemple.com)
	}

	// check if the domainName is in the whitelist
	if (!empty($whiteDomain)){
		if (!in_array($mainDomain, $whiteDomain)){
			echo "$l_domain $domain $l_not_authorized";
			exit();
		}
	}
	$login  = $Fmail;
	
	// check if the new user already exist
	$link = @da_sql_pconnect($config);
	if ($link) {
		$sql = "SELECT id FROM $config[sql_check_table] WHERE username = '$login';";
		$res = @da_sql_query($link,$config, $sql);
	}
	$login_check = da_sql_num_rows($res,$config);
	da_sql_close($link,$config);
	
	// check if the new user is already in the profile of an existing user 
	$link = @da_sql_pconnect($config);
	if ($link) {
		$sql = "SELECT id FROM $config[sql_user_info_table] WHERE mail = '$Fmail';";
		$res = @da_sql_query($link,$config, $sql);
	}
	$email_check = da_sql_num_rows($res,$config);
	da_sql_close($link,$config);
	if($login_check > 0) { // user already exist
		echo "<b>$l_Email_already_used</b><br />\n";
	} else if($email_check > 0) { // email already used
		echo "<b>$l_Email_already_used</b><br />\n";
	} else {
		$password = GenPassword();
		
		// if we want to enrich the new user profile
/*		$Fcn = "$prenom".".$nom";
		$Fou = "";
		$Fhomephone = "";
		$Ftelephonenumber = "";
		$Fmobile = "";
*/
		$link = da_sql_pconnect($config);
		if ($link){
			mysqli_set_charset($link,"utf8");
			if (is_file("acc/manager/lib/crypt/$config[general_encryption_method].php")){
				include_once("acc/manager/lib/crypt/$config[general_encryption_method].php");

				$passwd = da_encrypt($password);
				$passwd = da_sql_escape_string($link, $passwd);
				$res = da_sql_query($link,$config,
				"INSERT INTO $config[sql_check_table] (attribute,value,username $text)
				VALUES ('$config[sql_password_attribute]','$passwd','$login' $passwd_op);");
				if (!$res || !da_sql_affected_rows($link,$res,$config)){
					echo "<b>Erreur lors de la création de l'utilisateur $login: " . da_sql_error($link,$config) . "</b><br />\n";
					$da_abort=1;
				}

				if ($config['sql_use_user_info_table'] == 'true' && !$da_abort){
					$res = da_sql_query($link,$config,
					"SELECT username FROM $config[sql_user_info_table] WHERE
					username = '$login';");
					if ($res){
						if (!da_sql_num_rows($res,$config)){
							$Fcn = (isset($Fcn)) ? da_sql_escape_string($link, $Fcn) : '';
							$Fmail = (isset($Fmail)) ? da_sql_escape_string($link, $Fmail) : '';
							$Fou = (isset($Fou)) ? da_sql_escape_string($link, $Fou) : '';
							$Fhomephone = (isset($Fhomephone)) ? da_sql_escape_string($link, $Fhomephone) : '';
							$Ftelephonenumber = (isset($Ftelephonenumber)) ? da_sql_escape_string($link, $Ftelephonenumber) : '';
							$Fmobile = (isset($Fmobile)) ? da_sql_escape_string($link, $Fmobile) : '';
							$res = da_sql_query($link,$config,
							"INSERT INTO $config[sql_user_info_table]
							(username,name,mail,department,homephone,workphone,mobile) VALUES
							('$login','$Fcn','$Fmail','$Fou','$Fhomephone','$Ftelephonenumber','$Fmobile');");
							if (!$res || !da_sql_affected_rows($link,$res,$config))
								// Erreur sql à supprimer : l'info ne devrait pas être communiquer au client.
								echo "<b>Une erreur s'est produite lors de la création du compte : " . da_sql_error($link,$config) . "</b><br />\n";
						}
						else
							echo "<b>User already exist</b><br />\n";
					}
					else
						echo "<b>Une erreur s'est produite lors de la création du compte : " . da_sql_error($link,$config) . "</b><br />\n";
				}
				// if the new user must be in a group
				if (isset($Fgroup) && $Fgroup != ''){
					$Fgroup = da_sql_escape_string($link, $Fgroup);
					$res = da_sql_query($link,$config,
					"SELECT username FROM $config[sql_usergroup_table]
					WHERE username = '$login' AND groupname = '$Fgroup';");
					if ($res){
						if (!da_sql_num_rows($res,$config)){
							$res = da_sql_query($link,$config,
							"INSERT INTO $config[sql_usergroup_table]
							(username,groupname) VALUES ('$login','$Fgroup');");
							if (!$res || !da_sql_affected_rows($link,$res,$config))
								echo "<b>Impossible d'ajouter l'utilisateur dans le groupe $Fgroup.</b><br />\n";
						}
						else
							echo "<b>L'utilisateur est déjà présent dans le groupe $Fgroup</b><br />\n";
					}
					else
						echo "<b>Impossible d'ajouter l'utilisateur dans le groupe $Fgroup: " . da_sql_error($link,$config) . "</b><br />\n";
				}
				// Creation of the email with the new user login & passwd
				$ip = $_SERVER['REMOTE_ADDR'];
				$time = date_create('now')->format('d-m-Y H:i:s');
				$domain = $conf["DOMAIN"];
				$hostname  = $conf["HOSTNAME"];
				$to = $Fmail;
				if ($typeMail == "3") { // using an existing @mail
					$from = $fromMail; }
				else {
					$from = "administrator";
				}
				$subject = $l_subject;
				$message = "<!DOCTYPE html>
<html>
	<head>
		<meta charset=\"utf-8\">
	</head>
		<body>
			$l_hello,<br/>
			<p>$l_automatic_mail<br/>
			<h3>$l_login</h3>
			<pre>
				Login : $login
				$l_password : $password
			</pre>
		</body>
</html>";
				$header = "From: $from\n";
				$header .= "MIME-Version: 1.0\n";
				$header .= "Content-type: text/html; charset=utf-8\n";
				if(mail($to, $subject, $message, $header)){
					echo "<center>success : <b>$l_mail_success</b><br>";
					if (!empty($adminMail)){ // Creation of the email for the administrator (if enabled)
						$to = $adminMail;
						$subject = "New registration on ALCASAR";
						$message = "<!DOCTYPE html>
<html>
	<head>
		<meta charset=\"utf-8\">
	</head>
	<body>
		Hello,<br>
		<p>$l_automatic_mail<br>
		<h3>A new registration on ALCASAR '$organism' has been made :</h3>
		<pre>
			@IP   : $ip
			Hour  : $time
			Login : $login
			Email : $Fmail
		</pre>
	</body>
</html>";
						mail($to, $subject, $message, $header);
					}
				} else {
					// On smtp error, we remove the new user
					$link = da_sql_pconnect($config);
					$res2 = da_sql_query($link,$config,
						"DELETE FROM $config[sql_user_info_table] WHERE username = '$login';");
					$res3 = da_sql_query($link,$config,
						"DELETE FROM $config[sql_check_table] WHERE username = '$login';");
					echo "<b>$l_mail_error</b><br />\n";
				}
			}
			else // Could not open encryption library file
				echo "<b>Error during the account creation process</b><br />\n";
		}
		else // Could not connect to SQL database
			echo "<b>Error during the account creation process</b><br />\n";
		da_sql_close($link,$config);
	}
}
?>
