<?php
# Welcome page (sysinfo)
# by Rexy
// request database
function request ($texte) {
		$strResult = 0;
		// Déclaration des paramètres de connexion
		$host = "localhost";
		$DB_USER = "radius";
		$DB_RADIUS = "radius";
		$radiuspwd = "";
		// Connexion au serveur
		$mysqli = new mysqli($host, $DB_USER, $radiuspwd, $DB_RADIUS);
		if ($texte == 'user') {$query = "SELECT UserName FROM userinfo";}
		else { $query = "SELECT GroupName FROM radusergroup GROUP BY GroupName";}
		$result = $mysqli->query($query);
		// Recuperation des resultats
		$strResult = $result->num_rows;
		// Deconnexion de la base de donnees
		$mysqli->close();
		return $strResult;
 }
// router test
function routerTest($host,$nic) {
	$out = exec("(sudo LANG=C LC_ALL=C arping -I$nic -c1 $host|grep response|cut -d' ' -f2)");
	return ($out == "1") ? true : false;
}

// Internet test
function internetTest() {
	$host  = 'www.google.com';
	$host2 = 'www.alcasar.net';
	$port = 80;

	$sock = @fsockopen($host, $port, $errno, $errstr, 2);
	if ($sock) {
		fclose($sock);
		return true;
	}

	$sock = @fsockopen($host2, $port, $errno, $errstr, 2);
	if ($sock) {
		fclose($sock);
		return true;
	}

	return false;
}

// searchString = search for a string in a file
function searchString($file, $search_regex){
	$pointeur = fopen($file,"r");
	$result = false;
	if ($pointeur)
		{
		while (!feof($pointeur))
			{
				$ligne = fgets($pointeur);
				if (preg_match($search_regex, $ligne, $r))
				{
				$result = true;
				break;
				}
			}
		}
	fclose($pointeur);
	return $result;
}

$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue	  = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
	}
if ($Language === 'fr') {
	$locale_time = "fr_FR";
	$l_title = "Bienvenue dans l'ACC (ALCASAR Control Center)";
	$l_internet_link = "Accès Internet";
	$l_lan = "LAN";
	$l_router = "Routeur";
	$l_DNS = "DNS";
	$l_enable = "Activé";
	$l_disable = "Désactivé";
	$l_version = "Version instalée";
	$l_available = "Version disponible";
	$l_users = "Nombre d'utilisateurs / connectés";
	$l_groups = "Nombre de groupes";
	$l_system_date = "Date du système";
}
else if ($Language === 'es') {
	$locale_time = "es_ES";
	$l_title = "Bienvenido al ACC (Centro de Control de ALCASAR)";
	$l_internet_link = "Acceso a Internet";
	$l_enable = "Activo";
	$l_lan = "LAN";
	$l_router = "Rúter";
	$l_DNS = "DNS";
	$l_disable = "Desactivado";
	$l_version = "Versión instalada";
	$l_available = "Versión disponible";
	$l_users = "Número de usuarios / conectados";
	$l_groups = "Número de grupos";
	$l_system_date = "Fecha del sistema";
}
else {
	$locale_time = "en_EN";
	$l_title = "Welcome in ACC (ALCASAR Control Center)";
	$l_internet_link = "Internet access";
	$l_lan = "LAN";
	$l_router = "Router";
	$l_DNS = "DNS";
	$l_enable = "Enabled";
	$l_disable = "Disabled";
	$l_version = "Installed version";
	$l_available = "Available version";
	$l_users = "Number of users / connected";
	$l_groups = "Number of groups";
	$l_system_date = "System date";
}
?>
<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" href="/css/acc.css">
</head>
<body>	
	<div class="panel">
		<div class="panel-header"><?= $l_title ?></div>
		<div class ="panel-row">
			<div class="panel-cell">
<?
// Read CONF_FILE
define ('CONF_FILE', '/usr/local/etc/alcasar.conf');
	$file_conf = fopen(CONF_FILE, 'r');
	if (!$file_conf) {
		exit('Error opening the file '.CONF_FILE);}
	while (!feof($file_conf)) {
		$buffer = fgets($file_conf, 4096);
		if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
			$tmp = explode('=', $buffer, 2);
			$conf[trim($tmp[0])] = trim($tmp[1]);
		}
	}
	fclose($file_conf);
// Get current version
$INSTALLEDVERSION = $conf['VERSION'];
setlocale (LC_TIME, $locale_time);
$date = new DateTime();
$date_formatter = new IntlDateFormatter(
    $Langue[0],
    IntlDateFormatter::FULL,
    IntlDateFormatter::FULL,
    date_default_timezone_get(),
    IntlDateFormatter::GREGORIAN
);
$nb_users = request ('user');
$nb_groups  = request ('group');
$nb_online_users = exec ("sudo /usr/sbin/chilli_query list | cut -d\" \" -f5 | grep \"1\" | wc -l");

// Internet LAN Status (Is connected and has a @IP)
$tmp = file_get_contents("/sys/class/net/".$conf['EXTIF']."/carrier");
if(strcmp($tmp,"1")==1){
	$lan_status =  $l_lan." "." <img src='/images/state_ok.gif'> ";	
} else{
	$lan_status =  $l_lan." "." <img src='/images/state_error.gif'> ";
}

// Router(s) status
$mask = strrchr($conf['PUBLIC_IP'],"/");
if(routerTest($conf['GW'],$conf['EXTIF']) && ($conf['GW'].$mask != $conf['PUBLIC_IP'])){ //test only if ALCASAR is not directly connected to Internet
	$router_status =  $l_router." "." <img src='/images/state_ok.gif'> ";	
} else{
	$router_status =  $l_router." "." <img src='/images/state_error.gif'> ";
}
if($conf['MULTIWAN'] == 'on'){
	exec("grep \"^WAN\" " . CONF_FILE . " | wc -l", $nb_gw);
	for ($i = 1; $i <= $nb_gw[0]; $i++){
		$gw="WAN".$i; $tmp=explode(',', $conf[$gw], 2);
		$gw_ip=trim(str_replace('"', '', $tmp[0]));
		$nro_router = $i + 1;
		if(routerTest($gw_ip,$conf['EXTIF'])){
			$router_status = $router_status." $l_router"."$nro_router"." <img src='/images/state_ok.gif'> ";
		} else{	
			$router_status = $router_status." $l_router"."$nro_router"." <img src='/images/state_error.gif'> ";
		}
	}
}
// Internet status
if ((searchString("/var/www/html/index.php","/network_pb = false/")) && (internetTest())) {
	$internet_status =  $l_DNS." "." <img src='/images/state_ok.gif'> ";
	$version = dns_get_record("version.alcasar.net",DNS_TXT);
	if (!empty($version)) {
		$AVAILABLEDVERSION = $version[0]['txt'];
	} else {
		$AVAILABLEDVERSION = "-";
	}
} else {
	$internet_status =  $l_DNS." "." <img src='/images/state_error.gif'> ";
	$AVAILABLEDVERSION = "-";
}

echo $l_internet_link." : ".$lan_status.$router_status.$internet_status."<br>\n";
echo $l_version." : ".$INSTALLEDVERSION."<br>\n";
echo $l_available." : ".$AVAILABLEDVERSION."<br>\n";
echo "</div><div class=\"panel-cell\">";
echo $l_users." : ".$nb_users." / ".$nb_online_users."<br>\n";
echo $l_groups." : ".$nb_groups."<br>\n";
echo $l_system_date." : ".$date_formatter->format($date)."<br>\n";
?>
			</div>
		</div>
	</div>
	<div class="panel">
		<iframe class="panel-iframe" src="phpsysinfo/">
		</iframe>
	</div>
</body>
</html>
