<?php
# $Id: menu.php 3294 2025-07-20 22:26:38Z rexy $
// written by Rexy & Tom HOUDAYER

/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');
define('ACC_ACCESS_LOG', '/var/Save/security/acc_access.log');

/****************************************************************
*			FILE reading test			*
*****************************************************************/
$conf_files = array(CONF_FILE, ACC_ACCESS_LOG);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Requested file $file isn't present");
	}
	if (!is_readable($file)) {
		exit("Can't read the file $file");
	}
}

/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);

// Retrieve the user's profil
$user_htdigest = $_SERVER['REMOTE_USER'];
exec('sudo alcasar-profil.sh --list | cut -d":" -f2', $output);
$admin_members   = explode(' ', ltrim($output[0], " \t"));
$backup_members  = explode(' ', ltrim($output[1], " \t"));
$manager_members = explode(' ', ltrim($output[2], " \t"));

if (in_array($user_htdigest, $admin_members)) {
	$right = 0; // admin
} else if (in_array($user_htdigest, $backup_members)) {
	$right = 1; // backup
} else if (in_array($user_htdigest, $manager_members)) {
	$right = 2; // manager
} else {
	exit();     // Unknown account
}

$installed_version = $conf['VERSION'];

// Choice of language
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'fr') {	// French
	$l_home			= "ACCUEIL";
	$l_system		= "SYSTÈME";
	$l_auth			= "AUTHENTIFICATION";
	$l_filter		= "FILTRAGE";
	$l_statistics		= "STATISTIQUES";
	$l_backup		= "SAUVEGARDES";
	$l_activity		= "Activité";
	$l_blacklist		= "Liste noire";
	$l_whitelist		= "Liste blanche";
	$l_network		= "Réseau";
	$l_ldap			= "LDAP/A.D.";
	$l_federation	= "Fédération";
	$l_access_nb		= "accès à l'ACC";
	$l_create_user		= "Créer des utilisateurs";
	$l_edit_user		= "Gérer les utilisateurs";
	$l_create_group		= "Créer un groupe";
	$l_edit_group		= "Gérer les groupes";
	$l_import_empty		= "Importer / Vider";
	$l_protocols		= "Protocoles";
	$l_stat_user_day	= "Par connexion";
	$l_stat_con		= "Journal global";
	$l_stat_daily		= "Usage quotidien";
	$l_stat_global_network	= "Trafic global";
	$l_stat_detail_network	= "Trafic détaillé";
	$l_security		= "Sécurité";
	$l_menu			= "Menu";
	$l_sms			= "Inscription par SMS";
	$l_mail			= "Inscription par E-mail";
	$l_backup_archive	= "Archives";
	$l_accountability_logs		= "Journaux d'imputabilité";
	$l_since		= "depuis le";
	$l_doc_language = "fr";
} else if ($Language === 'es') {	// Spanish
	$l_home			= "INICIO";
	$l_system		= "SISTEMA";
	$l_auth			= "GESTIONAR";
	$l_filter		= "FILTRADO";
	$l_statistics		= "ESTADISTICAS";
	$l_backup		= "BACKUPS";
	$l_activity		= "Actividad";
	$l_blacklist		= "Lista Negra";
	$l_whitelist		= "Lista Blanca";
	$l_network		= "Red";
	$l_ldap			= "LDAP/A.D.";
	$l_federation	= "federación";
	$l_access_nb		= "accesos a la ACC";
	$l_create_user		= "Crear usuarios";
	$l_edit_user		= "Administrar usuarios";
	$l_create_group		= "Crear un grupo";
	$l_edit_group		= "Administrar grupos";
	$l_import_empty		= "Importar / Purgar";
	$l_protocols		= "Protocolos";
	$l_stat_user_day	= "Por conexión";
	$l_stat_con		= "Registros globales";
	$l_stat_daily		= "Uso diario";
	$l_stat_global_network	= "Tráfico global";
	$l_stat_detail_network	= "Tráfico detallado";
	$l_security		= "Seguridad";
	$l_menu			= "Principal";
	$l_sms			= "Registro por sms";
	$l_mail			= "Registro por E-mail";
	$l_backup_archive	= "Archivos";
	$l_accountability_logs		= "registros de responsabilidad";
	$l_since		= "desde";
	$l_doc_language = "en";
} else {			// English
	$Language		= 'en';
	$l_home			= "HOME";
	$l_system		= "SYSTEM";
	$l_auth			= "AUTHENTICATION";
	$l_filter		= "FILTERING";
	$l_statistics		= "STATISTICS";
	$l_backup		= "BACKUPS";
	$l_activity		= "Activity";
	$l_blacklist		= "Blacklist";
	$l_whitelist		= "Whitelist";
	$l_network		= "Network";
	$l_ldap			= "LDAP/A.D.";
	$l_federation		= "Federation";
	$l_access_nb		= "accesses to ACC";
	$l_create_user		= "Create users";
	$l_edit_user		= "Manage users";
	$l_create_group		= "Create a group";
	$l_edit_group		= "Manage groups";
	$l_import_empty		= "Import / Empty";
	$l_protocols		= "Protocols";
	$l_stat_user_day	= "By connection";
	$l_stat_con		= "Global accounting";
	$l_stat_daily		= "Daily use";
	$l_stat_global_network	= "Global traffic";
	$l_stat_detail_network	= "Detailed traffic";
	$l_security		= "Security";
	$l_menu			= "Main";
	$l_sms			= "SMS registration";
	$l_mail			= "E-mail registration";
	$l_backup_archive	= "Archives";
	$l_accountability_logs		= "accountability logs";
	$l_since		= "since";
	$l_doc_language = "en";
}

// Get access log count
$tab = file(ACC_ACCESS_LOG);
$accAccessCounter = count($tab);
$field = explode('|', $tab[0]);
$accAccessFirstDate = explode(' ', $field[0])[0];
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title>Menu - ALCASAR</title>
	<link rel="stylesheet" type="text/css" href="/css/acc.css">
	<link rel="stylesheet" type="text/css" href="/css/menu.css">
	<script src="/js/jquery.min.js"></script>
	<script>
		$(document).ready(function () {
			$('.menu a[href="#"]').click(function (event) {
				event.preventDefault();
				if ($(this).parent().hasClass('active')) {
					$(this).parent().removeClass('active');
				} else {
					$('.menu li.active').removeClass('active');
					$(this).parent().addClass('active');
				}
			});
		});
	</script>
</head>
<body>
	<div class="panel">
		<div class="panel-header">
			<?= $l_menu ?>
		</div>
		<div class="panel-row">
			<div class="menu">
				<ul>
					<li><div class="caret"></div><a href="welcome.php" target="REXY2"><?= $l_home ?></a></li>
					<?php if ($right === 0):			// admin ?>
						<li>
							<div class="caret"></div><a href="#"><?= $l_system ?></a>
							<ul>
								<li><div class="caret"></div><a href="admin/network.php" target="REXY2"><?= $l_network ?></a></li>
								<li><div class="caret"></div><a href="admin/services.php" target="REXY2">Services</a></li>
								<li><div class="caret"></div><a href="admin/ldap.php" target="REXY2"><?= $l_ldap ?></a></li>
								<li><div class="caret"></div><a href="admin/federation.php" target="REXY2"><?= $l_federation ?></a></li>
							</ul>
						</li>
					<?php endif; ?>
					<?php if ($right === 0 || $right === 2):	// admin, manager ?>
						<li>
							<div class="caret"></div><a href="#"><?= $l_auth ?></a>
							<ul>
								<li><div class="caret"></div><a href="manager/htdocs/activity.php" target="REXY2"><?= $l_activity ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/user_new.php" target="REXY2"><?= $l_create_user ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/find.php" target="REXY2"><?= $l_edit_user ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/group_new.php" target="REXY2"><?= $l_create_group ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/show_groups.php" target="REXY2"><?= $l_edit_group ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/import_user.php" target="REXY2"><?= $l_import_empty ?></a></li>
								<li><div class="caret"></div><a href="manager/auth_exceptions.php" target="REXY2">Exceptions</a></li>
								<li><div class="caret"></div><a href="manager/htdocs/user_by_sms.php" target="REXY2"><?= $l_sms ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/user_by_email.php" target="REXY2"><?= $l_mail ?></a></li>
							</ul>
						</li>
					<?php endif; ?>
					<?php if ($right === 0):			// admin ?>
						<li>
							<div class="caret"></div><a href="#"><?= $l_filter ?></a>
							<ul>
								<li><div class="caret"></div><a href="admin/bl_filter.php" target="REXY2"><?= $l_blacklist ?></a></li>
								<li><div class="caret"></div><a href="admin/wl_filter.php" target="REXY2"><?= $l_whitelist ?></a></li>
								<li><div class="caret"></div><a href="admin/protocols_filter.php" target="REXY2"><?= $l_protocols ?></a></li>
							</ul>
						</li>
					<?php endif; ?>
					<?php if ($right === 0):			// admin ?>
						<li>
							<div class="caret"></div><a href="#"><?= $l_statistics ?></a>
							<ul>
								<li><div class="caret"></div><a href="manager/htdocs/user_stats.php" target="REXY2"><?= $l_stat_user_day ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/accounting.php" target="REXY2"><?= $l_stat_con ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/stats.php" target="REXY2"><?= $l_stat_daily ?></a></li>
								<li><div class="caret"></div><a href="manager/vnstat.php" target="REXY2"><?= $l_stat_global_network ?></a></li>
								<li><div class="caret"></div><a href="manager/nfsen.php" target="REXY2"><?= $l_stat_detail_network ?></a></li>
								<li><div class="caret"></div><a href="manager/htdocs/security.php" target="REXY2"><?= $l_security ?></a></li>
							</ul>
						</li>
					<?php endif; ?>
					<?php if ($right === 0 || $right === 1):	// admin, backup ?>
						<li>
							<div class="caret"></div><a href="#"><?= $l_backup ?></a>
							<ul>
								<li><div class="caret"></div><a href="backup/sauvegarde.php" target="REXY2"><?= $l_backup_archive ?></a></li>
								<li><div class="caret"></div><a href="backup/log_generation.php" target="REXY2"><?= $l_accountability_logs ?></a></li>
							</ul>
						</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>
	<br>
	<div class="panel">
		<div class="panel-header">
			Documents
		</div>
		<div class="panel-row">
			<div class="menu">
				<ul>
					<li><div class="caret"></div><a href="<?= "alcasar-$installed_version-presentation-$l_doc_language.pdf" ?>" target="_blank">Presentation</a></li>
					<li><div class="caret"></div><a href="<?= "alcasar-$installed_version-installation-$l_doc_language.pdf" ?>" target="_blank">Installation</a></li>
					<li><div class="caret"></div><a href="<?= "alcasar-$installed_version-exploitation-$l_doc_language.pdf" ?>" target="_blank">Exploitation</a></li>
					<li><div class="caret"></div><a href="<?= "alcasar-$installed_version-technique.pdf" ?>" target="_blank">Technique</a></li>
				</ul>
			</div>
		</div>
	</div>
	<br>
	<div class="panel">
		<div class="panel-header">
			<?= $conf['ORGANISM'] ?>
		</div>
		<div class="panel-row" style="text-align: center;">
		<a href="admin_log.php" target="REXY2"><?= $accAccessCounter.' '.$l_access_nb ?></a><br>
			<?= $l_since ?> <?= $accAccessFirstDate ?>
		</div>
	</div>
</body>
</html>
