<?php
/**
 * config file for nfsen-ng.
 *
 * remarks:
 * * database name = datasource class name (case-sensitive)
 * * log priority should be one of the predefined core constants prefixed with LOG_
 */

$nfsen_config = [
    'general' => [
        'ports' => [
            443, 80, 22, 53,
        ],
        'sources' => [
            'alcasar_netflow',
        ],
        'filters' => [
            'proto udp',
            'proto tcp',
        ],
        'db' => 'RRD',
        'processor' => 'NfDump',
    ],
    'frontend' => [
        'reload_interval' => 300,
        'defaults' => [
            'view' => 'graphs', // graphs, flows, statistics
            'graphs' => [
                'display' => 'sources', // sources, protocols, ports
                'datatype' => 'flows', // flows, packets, traffic
                'protocols' => ['any'], // any, tcp, udp, icmp, others (multiple possible if display=protocols)
            ],
            'flows' => [
                'limit' => 50,
            ],
            'statistics' => [
                'order_by' => 'bytes',
            ],
        ],
    ],
    'nfdump' => [
        'binary' => '/usr/bin/nfdump',
        'profiles-data' => '/var/log/nfsen/profiles-data',
        'profile' => 'live',
        'max-processes' => 1, // maximum number of concurrently running nfdump processes
    ],
    'db' => [
        'Akumuli' => [
            // 'host' => 'localhost',
            // 'port' => 8282,
        ],
        'RRD' => [],
    ],
    'log' => [
        'priority' => \LOG_WARNING, // LOG_DEBUG is very talkative!
    ],
];
