<?php
# $Id: user_stats.php 2856 2020-07-21 22:11:44Z rexy $

require('/etc/freeradius-web/config.php');
require('../lib/functions.php');
require('../lib/sql/nas_list.php');
require_once('../lib/xlat.php');
?>
<!DOCTYPE html>
<html>
<head>
<?php
# Choice of language
$Language = 'en';
if(isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])){
	$Langue		= explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language	= strtolower(substr(chop($Langue[0]),0,2)); }
if($Language == 'fr'){
	$l_title		= "Statistiques de connexion des utilisateurs";
	$l_start_date		= "Dates de début";
	$l_end_date		= "Dates de fin";
	$l_number_result	= "Nb. résultat / page";
	$l_order_by		= "Trié par";
	$l_sorted_order		= "Classé par ordre";
	$l_all			= "Tous";
	$l_con_number		= "Nombre de connexions";
	$l_con_length		= "Durée de connexions";
	$l_ascending		= "Croissant";
	$l_descending		= "Décroissant";
	$l_server		= "Sur le serveur";
	$l_user			= "Filtrer pour un utilisateur (laissez vide pour tous)";
	$l_show			= "Montrer";
	$l_from			= "Du";
	$l_to			= "au";
	$l_server		= "Serveur";
	$l_login		= "Identifiant";
	$l_user_edit		= "Éditer l'utilisateur";
} else if($Language == 'es') {
    $l_title		= "Estadísticas de conexiones de los Usuarios";
	$l_start_date		= "Desde fecha";
	$l_end_date		= "Hasta fecha";
	$l_number_result	= "Nro de resultados / páginas";
	$l_order_by		= "Ordenados por";
	$l_sorted_order		= "Ordenar resultados";
	$l_all			= "Todos";
	$l_con_number		= "Números de conexiones";
	$l_con_length		= "Duración de la conexión";
	$l_ascending		= "Ascendente";
	$l_descending		= "Descendente";
	$l_server		= "En el servidor";
	$l_user			= "Filtrar por usuario (en blanco para todos los usuarios)";
	$l_show			= "Mostrar";
	$l_from			= "Desde";
	$l_to			= "hasta";
	$l_server		= "Servidor";
	$l_login		= "Usuario";
	$l_user_edit		= "Modificar usuario";
} else {
	$l_title		= "Statistics of users connexions";
	$l_start_date		= "Start date";
	$l_end_date		= "End date";
	$l_number_result	= "Nb results / page";
	$l_order_by		= "Sorted by";
	$l_sorted_order		= "Sorted order";
	$l_all			= "All";
	$l_con_number		= "Connections number";
	$l_con_length		= "Connection length";
	$l_ascending		= "Ascending";
	$l_descending		= "Descending";
	$l_server		= "On server";
	$l_user			= "Filter for a user (let empty for all)";
	$l_show			= "Show";
	$l_from			= "From";
	$l_to			= "to";
	$l_server		= "Server";
	$l_login		= "Login";
	$l_user_edit		= "Edit user";
}
if (is_file("../lib/sql/drivers/$config[sql_type]/functions.php"))
	include_once("../lib/sql/drivers/$config[sql_type]/functions.php");
else{
	echo <<<EOM
<title>$l_title</title>
<meta http-equiv="Content-Type" content="text/html; charset=$config[general_charset]">
<link rel="stylesheet" href="/css/acc.css">
</head>
<body>
<center><b>Could not include SQL library functions. Aborting</b></center>
</body>
</html>
EOM;
	exit();
}
if (!isset($start) && !isset($stop)){
	$now = time();
	$stop = date($config['sql_date_format'],$now);
	$now -= 604800;
	$start = date($config['sql_date_format'],$now);
}
$start = da_sql_escape_string($link,$start);
$stop = da_sql_escape_string($link,$stop);
?>
<title><?= $l_title ?></title>
<link rel="stylesheet" href="/css/acc.css" type="text/css">
</head>
<body>
<div class="panel">
	<div class="panel-header"><?= $l_title ?></div>
	<div class="panel-row">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
<?php
if(isset($pagesize))
{	
	echo <<<EOM
<tr align="center"><td colspan="9">
$l_from $start $l_to $stop
</td></tr>
<tr>
<th>#</th><th>$l_login</th><th>Date</th><th>$l_server</th><th>$l_con_number</th><th>$l_con_length</th><th>Upload</th><th>Download</th>
</tr>
EOM;
	$pagesize = ($pagesize) ? $pagesize : 10;
	$selected[5] = "";
	$selected[10] = "";
	$selected[15] = "";
	$selected[20] = "";
	$selected[40] = "";
	$selected[80] = "";
	$selected['all'] = "";
	$selected['num'] = "";
	$selected['time'] = "";
	$selected['asc'] = "";
	$selected['desc'] = "";
	if (!is_numeric($pagesize) && $pagesize != 'all')
		$pagezise = 10;
	if ($pagesize > 100)
		$pagesize = 100;
	$limit = ($pagesize == 'all') ? '100' : "$pagesize";
	$selected[$pagesize] = 'selected';
	$order = ($order) ? $order : $config['general_accounting_info_order'];
	if ($order != 'desc' && $order != 'asc')
		$order = 'desc';
	if ($sortby != '')
		$order_attr = ($sortby == 'num') ? 'connnum' : 'conntotduration';
	else
		$order_attr = 'connnum';
	if ($server != '' && $server != 'all'){
		$server = da_sql_escape_string($link,$server);
		$server_str = "AND nasipaddress = '$server'";
	}
	else
	{
		$server_str = "";
	}
	$login_str = ($login) ? "AND username = '$login' " : '';
	$selected[$order] = 'selected';
	$selected[$sortby] = 'selected';
	$sql_extra_query = '';
	if (isset($config['sql_accounting_extra_query'])){
		$sql_extra_query = xlat($config['sql_accounting_extra_query'],$login,$config);
		$sql_extra_query = da_sql_escape_string($link,$sql_extra_query);
	}
	unset($da_name_cache);
	if (isset($_SESSION['da_name_cache']))
		$da_name_cache = $_SESSION['da_name_cache'];
	$link = @da_sql_pconnect($config);
	if ($link){
		$num = 0;
		$search = @da_sql_query($link,$config,
		"SELECT " . da_sql_limit($limit,0,$config) . " * FROM $config[sql_total_accounting_table]
		WHERE acctdate >= '$start' AND acctdate <= '$stop' $server_str $login_str $sql_extra_query " . da_sql_limit($limit,1,$config)
		. " ORDER BY $order_attr $order " . da_sql_limit($limit,2,$config) . " ;");
		if ($search){
			while( $row = @da_sql_fetch_array($search,$config) ){
				$num++;
				$acct_login = $row['username'];
				if ($acct_login == '')
				$acct_login = '-';
				else{
					$Acct_login = urlencode($acct_login);
					$acct_login = "<a href=\"user_admin.php?login=$Acct_login\" title=\"$l_user_edit $acct_login\">$acct_login</a>";
				}
				$acct_time = $row['conntotduration'];
				$acct_time = time2str($acct_time);
				$acct_conn_num = $row['connnum'];
				$acct_date = $row['acctdate'];
				$acct_upload = $row['inputoctets'];
				$acct_download = $row['outputoctets'];
				$acct_upload = bytes2str($acct_upload);
				$acct_download = bytes2str($acct_download);
				if (!isset($acct_server)){
					$acct_server = @gethostbyaddr($row['nasipaddress']);
					if (!isset($da_name_cache) && $config['general_use_session'] == 'yes'){
						$da_name_cache[$row['nasipaddress']] = $acct_server;
						session_register('da_name_cache');
					}
				else
					$da_name_cache[$row['nasipaddress']] = $acct_server;
				}
				if ($acct_server == '')
				$acct_server = '-';
				echo <<<EOM
			<tr align=center bgcolor="white">
				<td>$num</td>
				<td>$acct_login</td>
				<td>$acct_date</td>
				<td>$acct_server</td>
				<td>$acct_conn_num</td>
				<td>$acct_time</td>
				<td>$acct_upload</td>
				<td>$acct_download</td>
			</tr>
EOM;
			}
		}
	}
	echo <<<EOM
</table>
<hr>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
EOM;
}
else
{
	//create dummy selected
	if(!isset($selected))	
	{
		$selected = array();
		$selected[5] = "";
		$selected[10] = "";
		$selected[15] = "";
		$selected[20] = "";
		$selected[40] = "";
		$selected[80] = "";
		$selected['all'] = "";
		$selected['num'] = "";
		$selected['time'] = "";
		$selected['asc'] = "";
		$selected['desc'] = "";
	}


}
echo <<<EOM
<tr><td align="left">
<form action="user_stats.php" method="post" name="master">
		<table border="0">
		<tr valign="bottom" align="center">
		<td><small><b>$l_start_date</b></small></td><td><small><b>$l_end_date</b></small></td><td><small><b>$l_number_result</b></small></td><td><small><b>$l_order_by</b></small></td><td><small><b>$l_sorted_order</b></small></td></tr>
	<tr valign="middle"><td>
<input type="hidden" name="show" value="0">
<input type="text" name="start" size="11" value="$start"></td>
<td><input type="text" name="stop" size="11" value="$stop"></td>
<td><select name="pagesize">
<option $selected[5] value="5" >5
<option $selected[10] value="10">10
<option $selected[15] value="15">15
<option $selected[20] value="20">20
<option $selected[40] value="40">40
<option $selected[80] value="80">80
<option $selected[all] value="all">$l_all
</select>
</td>
<td>
<select name="sortby">
<option $selected[num] value="num">$l_con_number
<option $selected[time] value="time">$l_con_length
</select>
</td>
<td><select name="order">
<option $selected[asc] value="asc">$l_ascending
<option $selected[desc] value="desc">$l_descending
</select>
</td>
EOM;
?>
	<td><input type="submit" class=button value="<?php echo "$l_show";?>"></td>
</tr>
<tr align="center">
<td><small><b><?php echo "$l_server";?></b></small></td>
<td><small><b><?php echo "$l_user";?></b></small></td>
</tr>
<tr><td>
<select name="server">
<?php
foreach ($nas_list as $nas){
	$name = $nas['name'];
	if ($nas['ip'] == '')
		continue;
	$servers[$name] = $nas['ip'];
}
ksort($servers);
foreach ($servers as $name => $ip){
	if (isset($server) && ($server == $ip))
		echo "<option selected value=\"$ip\">$name\n";
	else
		echo "<option value=\"$ip\">$name\n";
}
if (isset($server) && ($server == '' || $server == 'all'))
	echo "<option selected value=\"all\">tous\n";
else
	echo "<option value=\"all\">tous\n";
?>
</select>
</td>
<td><input type="text" name="login" size="11" value="<?php if(!isset($login)){echo "";}else{ echo $login;} ?>"></td>
</tr>
</table>
</form>
</td></tr></table>
	</div>
</div>
</body>
</html>
