<?php
# $Id: mail.php 2853 2020-07-19 21:50:07Z joss_p $

/* written by Joss_p & Rexy */
/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');
/****************************************************************
*			Conf files reading test			*
*****************************************************************/
$conf_files = array(CONF_FILE);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Fichier $file non présent");
	}
	if (!is_readable($file)) {
		exit("Vous n'avez pas les droits de lecture sur le fichier $file");
	}
}
/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);
/****************************************
*			Choice of language			*
*****************************************/
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue	  = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'fr') {
	$l_mail_title			= "Inscription par e-mail";
	$l_mail_registration	= "Activer l'inscription par e-mail :";
	$l_mail_choice			= "Quel type de service e-mail utiliser ?";
	$l_use_internal_server	= "Utiliser le serveur de messagerie interne";
	$l_use_external_server	= "Relayer vers un serveur de messagerie externe";
	$l_use_email_address	= "Utiliser une adresse e-mail déjà fonctionnelle";
	$l_email_address		= "Adresse e-mail utilisée pour l'envoi de mail";
	$l_email_password		= "Mot de passe (ou 'mot de passe d'application' dans le cas de gmail)";
	$l_email_password_confirm	= "Confirmez le mot de passe";
	$l_mail_service			= "Choisissez le service de messagerie";
	$l_mail_smtp_ip			= "Adresse IP ou nom du serveur SMTP";
	$l_mail_smtp_port		= "Port d'écoute du serveur SMTP";
	$l_admin_log			= "Avertissement de l'administrateur";
	$l_mail_admin			= "Adresse e-mail de l'administrateur";
	$l_whitelist_domain		= "Nom de domaine autorisé (les sous-domaines seront automatiquement autorisés)";
	$l_mail_YES				= "OUI";
	$l_mail_NO				= "NON";
	$l_mail_submit			= "Enregistrer";
} else if($Language == 'es') {
	$l_mail_title			= "Registro por e-mail";
	$l_mail_registration	= "Activar el registro por correo electrónico :";
	$l_mail_choice			= "Qué tipo de servicio de correo utiliza?";
	$l_use_internal_server	= "Utilizar el servidor de correo interno";
	$l_use_external_server	= "Retransmisión a un servidor de correo externo";
	$l_use_email_address	= "Utilizar una dirección de correo electrónico";
	$l_email_address		= "Dirección de correo electrónico utilizada para el envío de correo";
	$l_email_password		= "Contraseña (o 'contraseña de la aplicación' en el caso de gmail)";
	$l_email_password_confirm	= "Confirmar contraseña";
	$l_mail_service			= "Elija el servicio de correo";
	$l_mail_smtp_ip			= "Dirección IP o nombre del servidor de correo";
	$l_mail_smtp_port		= "Puerto de escucha del servidor de correo";
	$l_admin_log			= "Advertencia del administrador";
	$l_mail_admin			= "Dirección de correo electrónico del administrador";
	$l_whitelist_domain		= "Nombre de dominio autorizado (los subdominios se autorizarán automáticamente)";
	$l_mail_YES				= "SI";
	$l_mail_NO				= "NO";
	$l_mail_submit			= "SI";
} else {
	$l_mail_title			= "Registration by e-mail";
	$l_mail_registration	= "Enable registration by e-mail :";
	$l_mail_choice			= "What type of e-mail service use ?";
	$l_use_internal_server	= "Use the internal mail server";
	$l_use_external_server	= "Relay to an external mail server";
	$l_use_email_address	= "Use an email address";
	$l_email_address		= "Email address used for sending mail";
	$l_email_password		= "Password (or 'application password' in the case of gmail)";
	$l_email_password_confirm	= "Confirm password";
	$l_mail_service			= "Choose the mail service";
	$l_mail_smtp_ip			= "IP address or name of mail server";
	$l_mail_smtp_port		= "Listen port of mail server";
	$l_admin_log			= "Administrator's warning";
	$l_mail_admin			= "Administrator Email address";
	$l_whitelist_domain		= "Authorized domain name (subdomains will be automatically authorized)";
	$l_mail_YES				= "YES";
	$l_mail_NO				= "NO";
	$l_mail_submit			= "Save";
}

// Mail configuration params
$mail_status        	= $conf['MAIL'];
$mail_type				= $conf['MAIL_TYPE'];
$mail_smtp_ip			= $conf['MAIL_SMTP_IP'];
$mail_smtp_port			= $conf['MAIL_SMTP_PORT'];
$mail_address			= $conf['MAIL_ADDR'];
$mail_mdp			 	= "";
$mail_mdp2				= "";
$mail_admin				= $conf['MAIL_ADMIN'];
$mail_whitelist			= $conf['MAIL_WHITEDOMAIN'];

if(isset($_POST['submit'])){
	if($_POST['mail_enable'] === 'on')
	{
		$mail_type = $_POST['mail_type'];
		$mail_whitelist = $_POST['mail_whitelist'];
		$admin_enable = $_POST['admin_enable'];
		if(isset($_POST['mail_address']))	{ $mail_address = $_POST['mail_address']; }
		if(isset($_POST['mail_server']))	{ $mail_server = $_POST['mail_server']; }
		if(isset($_POST['mail_smtp_ip']))	{ $mail_smtp_ip = $_POST['mail_smtp_ip']; }
		if(isset($_POST['mail_smtp_port']))	{ $mail_smtp_port = $_POST['mail_smtp_port']; }
		if(isset($_POST['mail_mdp']))		{ $mail_mdp = $_POST['mail_mdp']; }
		if(isset($_POST['mail_mdp2']))		{ $mail_mdp2 = $_POST['mail_mdp2']; }
		if ($admin_enable == "1") { $mail_admin = $_POST['mail_admin']; }
		switch ($mail_type) {
			case '1': // Act as a SMTP server
				$mail_smtp_port = 587;
				if ($admin_enable == "1"){
					exec("sudo /usr/local/bin/alcasar-mail-install.sh -1 -a $mail_admin -w $mail_whitelist");
				}
				else {
					exec("sudo /usr/local/bin/alcasar-mail-install.sh -1 -w $mail_whitelist");
				}
				break;
			case '2': // Relay to an external SMTP server
				if ($admin_enable == "1"){
					exec("sudo /usr/local/bin/alcasar-mail-install.sh -2 -s $mail_smtp_ip -p $mail_smtp_port -a $mail_admin -w $mail_whitelist");
				}
				else {
					exec("sudo /usr/local/bin/alcasar-mail-install.sh -2 -s $mail_smtp_ip -p $mail_smtp_port -w $mail_whitelist");
				}
				break;
			case '3': // Use an user Email address
				if(($mail_mdp != '') && ($mail_mdp==$mail_mdp2)) {
					switch ($mail_server) {
						case '1':
							$mail_smtp_ip	= "smtp.orange.fr";
							$mail_smtp_port		= 465;
						break;
						case '2':
							$mail_smtp_ip	= "smtp.office365.com";
							$mail_smtp_port		= 587;
						break;
						case '3':
							$mail_smtp_ip	= "smtp.sfr.fr";
							$mail_smtp_port		= 465;
						break;
						case '4':
							$mail_smtp_ip	= "smtp.free.fr";
							$mail_smtp_port		= 465;	
						break;
						case '5':
							$mail_smtp_ip	= "smtp.gmail.com";
							$mail_smtp_port		= 587;
						break;
						case '6':
							$mail_smtp_ip	= "smtp.laposte.net";
							$mail_smtp_port		= 465;
						break;
						case '7':
							$mail_smtp_ip	= "smtp.bbox.fr";
							$mail_smtp_port		= 465;
						break;
						default:
							echo "Erreur dans la saisie !";
						break;
					}
					if ($admin_enable == "1"){
						exec("sudo /usr/local/bin/alcasar-mail-install.sh -3 -s $mail_smtp_ip -p $mail_smtp_port -m $mail_address -o $mail_mdp -a $mail_admin -w $mail_whitelist");
					}
					else {
						exec("sudo /usr/local/bin/alcasar-mail-install.sh -3 -s $mail_smtp_ip -p $mail_smtp_port -m $mail_address -o $mail_mdp -w $mail_whitelist");
					}
				}
				else { // no password or password are not same
					header("Refresh:0");
				}
				break;
			default:
				echo "Erreur dans la saisie !";
				break;
		}
	}
	else { // switch email registation off
		exec("sudo /usr/local/bin/alcasar-mail-install.sh -0");
	}
	header("Refresh:0");
	exit;
}

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title><?= $l_mail_title ?></title>
	<link type="text/css" href="/css/acc.css" rel="stylesheet">
	<script>
	function onMailStatusChange() {
		var listToDisables1 = ['mail_type','admin_enable','mail_admin','mail_whitelist'];
		var listToDisables2 = ['mail_type','admin_enable','mail_admin','mail_whitelist','mail_server','mail_smtp_ip','mail_smtp_port'];
		var listToDisables3 = ['mail_type','admin_enable','mail_admin','mail_whitelist','mail_server','mail_smtp_ip','mail_smtp_port','mail_address','mail_mdp','mail_mdp2'];
		var formSubmit = document.querySelector('form input[type="submit"]');
		var isChecked = false;
		for (var i=0; i<listToDisables3.length; i++) {
			document.getElementById(listToDisables3[i]).style.backgroundColor = '#c0c0c0';
			document.getElementById(listToDisables3[i]).disabled = true;
		}
		if (document.getElementById('mail_enable').value === 'on') {
			document.getElementById('mail_type').style.backgroundColor = null;
			document.getElementById('mail_type').disabled = false;
			if (document.getElementById('mail_type').value === '1') {
				for (var i=0; i<listToDisables1.length; i++) {
				document.getElementById(listToDisables1[i]).style.backgroundColor = null;
				document.getElementById(listToDisables1[i]).disabled = false;
				}
				if (document.getElementById('admin_enable').value === '0') {
				document.getElementById('mail_admin').style.backgroundColor = '#c0c0c0';
				document.getElementById('mail_admin').disabled = true;
				}
			}
			else if (document.getElementById('mail_type').value === '2') {
				for (var i=0; i<listToDisables2.length; i++) {
				document.getElementById(listToDisables2[i]).style.backgroundColor = null;
				document.getElementById(listToDisables2[i]).disabled = false;
				}
				if (document.getElementById('admin_enable').value === '0') {
				document.getElementById('mail_admin').style.backgroundColor = '#c0c0c0';
				document.getElementById('mail_admin').disabled = true;
				}
				if (document.getElementById('mail_server').value != '9') {
				document.getElementById('mail_smtp_ip').style.backgroundColor = '#c0c0c0';
				document.getElementById('mail_smtp_ip').disabled = true;
				document.getElementById('mail_smtp_port').style.backgroundColor = '#c0c0c0';
				document.getElementById('mail_smtp_port').disabled = true;
				}
			}
			else if (document.getElementById('mail_type').value === '3') {
				for (var i=0; i<listToDisables3.length; i++) {
				document.getElementById(listToDisables3[i]).style.backgroundColor = null;
				document.getElementById(listToDisables3[i]).disabled = false;
				}
				if (document.getElementById('admin_enable').value === '0') {
				document.getElementById('mail_admin').style.backgroundColor = '#c0c0c0';
				document.getElementById('mail_admin').disabled = true;
				}
				if (document.getElementById('mail_server').value != '9') {
				document.getElementById('mail_smtp_ip').style.backgroundColor = '#c0c0c0';
				document.getElementById('mail_smtp_ip').disabled = true;
				document.getElementById('mail_smtp_port').style.backgroundColor = '#c0c0c0';
				document.getElementById('mail_smtp_port').disabled = true;
				}
			}
			formSubmit.style.display = null;
		}
	}
	</script>
</head>
<body onLoad="onMailStatusChange();">
<div id="ldoverlay" class="overlay">
	<div class="lds-spinner" id="spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
</div>
	<div class="panel">
		<div class="panel-header"><?= $l_mail_title ?></div>
		<div class="panel-body">
			<form id="form-config_mail" name="config_mail" method="POST" action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" enctype="multipart/form-data">
				<fieldset>
					<legend>
						<br>
						<div style="text-align: center">
						</div>
					</legend>
					<dl>
						<dt>
							<label for="mail_enable"><?= $l_mail_registration ?></label>
						</dt>
						<dd>
							<select id="mail_enable" name="mail_enable" onchange="onMailStatusChange();">
								<option value="on"<?= ($mail_status == 'on') ? ' selected="selected"' : '' ?>><?= $l_mail_YES ?></option>
								<option value="off"<?= ($mail_status == 'off') ? ' selected="selected"' : '' ?>><?= $l_mail_NO ?></option>
							</select>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_type"><?= $l_mail_choice ?></label><br>
						</dt>
						<dd>
							<select id="mail_type" name="mail_type" onchange="onMailStatusChange();">
								<option value="1"<?= ($mail_type == '1') ? ' selected="selected"' : '' ?> disabled><?= $l_use_internal_server ?></option>
								<option value="2"<?= ($mail_type == '2') ? ' selected="selected"' : '' ?> disabled><?= $l_use_external_server ?></option>
								<option value="3"<?= ($mail_type == '3') ? ' selected="selected"' : '' ?>><?= $l_use_email_address ?></option>
							</select>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_address"><?= $l_email_address ?></label><br>
						</dt>
						<dd>
							<input type="text" id="mail_address" size="40" name="mail_address" value="<?= $mail_address ?>" oninput="onMailStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_mdp"><?= $l_email_password ?></label><br>
						</dt>
						<dd>
							<input type="password" id="mail_mdp" size="40" name="mail_mdp" value="<?= $mail_mdp ?>" oninput="onMailStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_mdp2"><?= $l_email_password_confirm ?></label><br>
						</dt>
						<dd>
							<input type="password" id="mail_mdp2" size="40" name="mail_mdp2" value="<?= $mail_mdp2 ?>" oninput="onMailStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_server"><?= $l_mail_service ?></label><br>
						</dt>
						<dd>
							<select id="mail_server" name="mail_server" onchange="onMailStatusChange();">
								<option value="1"<?= ($mail_smtp_ip == 'smtp.orange.fr') ? ' selected="selected"' : '' ?>>Orange</option>
								<option value="2"<?= ($mail_smtp_ip == 'smtp.office365.com') ? ' selected="selected"' : '' ?>>Office365</option>
								<option value="3"<?= ($mail_smtp_ip == 'smtp.sfr.fr') ? ' selected="selected"' : '' ?>>SFR</option>
								<option value="4"<?= ($mail_smtp_ip == 'smtp.free.fr') ? ' selected="selected"' : '' ?>>Free</option>
								<option value="5"<?= ($mail_smtp_ip == 'smtp.gmail.com') ? ' selected="selected"' : '' ?>>Gmail</option>
								<option value="6"<?= ($mail_smtp_ip == 'smtp.laposte.net') ? ' selected="selected"' : '' ?>>Laposte</option>
								<option value="7"<?= ($mail_smtp_ip == 'smtp.bbox.fr') ? ' selected="selected"' : '' ?>>Bouygues</option>
								<option value="8">Personnalisé</option>
							</select>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_smtp_ip"><?= $l_mail_smtp_ip ?></label><br>
						</dt>
						<dd>
							<input type="text" id="mail_smtp_ip" size="40" name="mail_smtp_ip" value="<?= $mail_smtp_ip ?>" oninput="onMailStatusChange();">
						</dd>
						<dt>
							<label for="mail_smtp_port"><?= $l_mail_smtp_port ?></label><br>
						</dt>
						<dd>
							<input type="text" id="mail_smtp_port" size="5" name="mail_smtp_port" value="<?= $mail_smtp_port ?>" oninput="onMailStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="admin_enable"><?= $l_admin_log ?></label>
						</dt>
						<dd>
							<select id="admin_enable" name="admin_enable" onchange="onMailStatusChange();">
								<option value="1"<?= ($mail_admin != '')  ? ' selected="selected"' : '' ?>><?= $l_mail_YES ?></option>
								<option value="0"<?= ($mail_admin == '') ? ' selected="selected"' : '' ?>><?= $l_mail_NO ?></option>
							</select>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_admin"><?= $l_mail_admin ?></label><br>
						</dt>
						<dd>
							<input type="text" id="mail_admin" size="40" name="mail_admin" value="<?= $mail_admin ?>" oninput="onMailStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="mail_whitelist"><?= $l_whitelist_domain ?></label><br>
						</dt>
						<dd>
							<input type="text" id="mail_whitelist" size="40" name="mail_whitelist" value="<?= $mail_whitelist ?>" oninput="onMailStatusChange();">
						</dd>
					</dl>
					<p>
						<input id="submit" onClick="document.getElementById('ldoverlay').style.display='block';" type="submit" value="<?= $l_mail_submit ?>" name="submit">
					</p>
				</fieldset>
			</form>
		</div>
	</div>
</body>
</html>
