<?php
/**
 * Print tickets of new users
 *
 * @author    Tom Houdayer
 * @copyright Copyright (C) ALCASAR (http://www.alcasar.net)
 * @license   GPL-3.0
 * @version   $Id: ticket_voucher.php 2700 2019-02-05 10:34:12Z tom.houdayer $
 */

require_once __DIR__ . '/../lib/alcasar/TicketsGenerator.php';
$langue_imp = ((isset($_POST['langue_imp'])) ? $_POST['langue_imp'] : 'en');
require_once __DIR__ . '/../lib/langues_imp.php';
require_once __DIR__ . '/../lib/langues.php';
require_once '/etc/freeradius-web/config.php';
require_once __DIR__ . '/../lib/sql/drivers/'.$config['sql_type'].'/functions.php';;
require_once __DIR__ . '/../lib/attrshow.php';
require_once __DIR__ . '/../lib/defaults.php';
require_once __DIR__ . '/../lib/functions.php';
if ($config['sql_use_operators'] === 'true') {
	require_once __DIR__ . '/../lib/operators.php';
	$text      = ',op';
	$passwd_op = ",':='";
}

// Get datas from form
if ((!isset($_POST['nbtickets'])) || (!is_numeric($_POST['nbtickets']))){
	header('Location: user_new.php');
	exit();
}
$nbTickets = (int)$_POST['nbtickets'];

// Get user attributes
$userAttr = [];
foreach (['Max-All-Session', 'Session-Timeout', 'Max-Daily-Session', 'Expiration'] as $attrName) {
	if (isset($_POST[$attrName]) && !empty($_POST[$attrName])) {
		$userAttr[$attrName] = $_POST[$attrName];
	}
}

if (count($userAttr) < 4) {
	// Get group attributes
	$link = da_sql_pconnect($config);
	if ($link) {
		if (isset($_POST['Fgroup']) && !empty($_POST['Fgroup'])) {
			$default_group = 'ldap';
			$group_uid = da_sql_escape_string($link, $_POST['Fgroup']);
			$sql = "SELECT attribute, value FROM (( SELECT attribute, value FROM radgroupcheck WHERE groupname = '$group_uid' AND (attribute IN ('Max-All-Session', 'Max-Daily-Session', 'Expiration'))) UNION ( SELECT attribute, value FROM radgroupcheck WHERE groupname = '$default_group' AND (attribute IN ('Max-All-Session', 'Max-Daily-Session', 'Expiration'))) UNION ( SELECT attribute, value FROM radgroupreply WHERE groupname = '$group_uid' AND (attribute IN ('Session-Timeout'))) UNION ( SELECT attribute, value FROM radgroupreply WHERE groupname = '$default_group' AND (attribute IN ('Session-Timeout')))) attrs GROUP BY attribute;";
		} else {
			$default_group = 'ldap';
			$sql = "SELECT attribute, value FROM (( SELECT attribute, value FROM radgroupcheck WHERE groupname = '$default_group' AND (attribute IN ('Max-All-Session', 'Max-Daily-Session', 'Expiration'))) UNION ( SELECT attribute, value FROM radgroupreply WHERE groupname = '$default_group' AND (attribute IN ('Session-Timeout')))) attrs GROUP BY attribute;";
		}
		$res = da_sql_query($link, $config, $sql);
		if ($res) {
			while ($row = da_sql_fetch_array($res, $config)) {
				if (!isset($userAttr[$row['attribute']])) {
					$userAttr[$row['attribute']] = $row['value'];
				}
			}
		}
	}
}

// Format user attributes
$userAttr['Session-Timeout']   = ((isset($userAttr['Session-Timeout']))   ? formatTime($userAttr['Session-Timeout'])   : $l_unlimited);
$userAttr['Max-All-Session']   = ((isset($userAttr['Max-All-Session']))   ? formatTime($userAttr['Max-All-Session'])   : $l_unlimited);
$userAttr['Max-Daily-Session'] = ((isset($userAttr['Max-Daily-Session'])) ? formatTime($userAttr['Max-Daily-Session']) : $l_unlimited);
$userAttr['Expiration'] = ((isset($userAttr['Expiration'])) ? date('d - m - Y', strtotime($userAttr['Expiration'])) : $l_without);

// Generate tickets
$ticketsGenerator = new TicketsGenerator(['language' => $langue_imp]);

ob_start();
$nbFailUsers = 0;
for ($i = 0; $i < $nbTickets; $i++) {
	// Generate username and password
	$login  = generateRandomString(8);
	$passwd = generateRandomString(12);
	$password = $passwd;
	
	// Check user exist
	require '../lib/'.$config['general_lib_type'].'/user_info.php';
	if ($user_exists === 'yes') {
		$nbFailUsers++;
		continue;
	}

	// Create user in database
	require '../lib/'.$config['general_lib_type'].'/create_user.php';

	// Add user ticket
	$ticketsGenerator->addTicket([
		'username'        => $login,
		'password'        => $password,
		'maxAllSession'   => $userAttr['Max-All-Session'],
		'sessionTimeout'  => $userAttr['Session-Timeout'],
		'maxDailySession' => $userAttr['Max-Daily-Session'],
		'expiration'      => $userAttr['Expiration']
	]);
}
$content_generation = ob_get_clean();

// Generate the PDF
$ret = $ticketsGenerator->output();

if (!$ret) {
	echo $content_generation;
	echo 'Error during tickets report generation';
}


/**
 * Format time in seconds to days/hours/minutes/secondes.
 *
 * @param int $time Time in seconds.
 *
 * @return string Formated time.
 */
function formatTime($time)
{
	$days     = floor($time / 86400); $rest = $time % 86400;
	$hours    = floor($rest /  3600); $rest = $rest %  3600;
	$minutes  = floor($rest /    60);
	$secondes = $rest % 60;

	$result = '';
	if ($days     != 0) $result .= $days.' J ';
	if ($hours    != 0) $result .= $hours.' H ';
	if ($minutes  != 0) $result .= $minutes.' m ';
	if ($secondes != 0) $result .= $secondes.' s ';

	return $result;
}

/**
 * Generate a random string.
 *
 * @param int $length Length of the string.
 *
 * @return string Random string.
 */
function generateRandomString($length = 8)
{
	$string  = '';
	$chars   = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$randoms = openssl_random_pseudo_bytes($length);
	for ($i = 0; $i < $length; $i++) {
		$string .= $chars[ord($randoms[$i]) % 62];
	}
	return $string;
}
