<?php
# $Id: security.php 3324 2026-02-01 22:38:07Z rexy $

$language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
    $langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
    $language = strtolower(substr(chop($langue[0]), 0, 2));
}
if ($language === 'fr') {
    $l_title = 'Sécurité';
    $l_spoofing = "Adresse(s) MAC usurpée(s) (Watchdog)";
    $l_fail2ban = "Adresse(s) IP bloquée(s) (Fail2Ban)";
    $l_ban_date = "Date de bloquage";
    $l_unban_date = "Date de débloquage";
    $l_ipAddress="Adresse IP";
    $l_user = "L'utilisateur";
    $l_empty="Vide";
    $l_rule="Règle";
} else if ($language === 'es') {
    $l_title = 'Seguridad';
    $l_spoofing = "Direcciones MAC usurpadas (Watchdog)";
    $l_fail2ban = "Dirección(es) IP bloqueada(s) (Fail2Ban)";
    $l_ban_date = "Fecha de bloqueo"; 
    $l_unban_date = "Fecha de desembolso";
    $l_ipAddress="Dirección ip";
    $l_user = "El usuario";
    $l_empty="Vacío";
    $l_rule="Regla";
} else {
    $l_title = 'Security';
    $l_spoofing = "MAC address spoofed (Watchdog)";
    $l_fail2ban = "IP address blocked (Fail2Ban)";
    $l_ban_date = "Lock date";
    $l_unban_date = "Unlock date";
    $l_ipAddress="IP address";
    $l_user = "User";
    $l_empty="Empty";
    $l_rule="Rule";
}
$tab = (isset($_GET['tab'])) ? intval($_GET['tab']) : 1;
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta charset="UTF-8">
		<title><?= $l_title ?></title>
		<link rel="stylesheet" href="/css/acc.css">
		<link rel="stylesheet" href="/css/bootstrap.min.css">
		<script src="/js/jquery.min.js"></script>
		<script src="/js/bootstrap.min.js"></script>
	</head>
	<body>
		<div class="panel">
			<div class="panel-header"><?= $l_title ?></div>
			<div class="panel-row">
				<div class="btn-group btn-group-justified" role="group" aria-label="Justified button group"> 
					<a href="security.php?tab=1" class="btn btn-default<?= (($tab === 1) ? ' active' : '') ?>" role="button"><?= $l_spoofing ?></a>
					<a href="security.php?tab=2" class="btn btn-default<?= (($tab === 3) ? ' active' : '') ?>" role="button"><?= $l_fail2ban ?></a>
				</div>
<?php
if ($tab === 1) {
	$spoofs = [];
	$regex = '/^\[(?P<date>[0-9\/\-: ]+)\] : alcasar-watchdog : (?P<ip>(?:(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])) is usurped \((?P<mac>(?:[0-9A-Fa-f]{2}[:-]){5}[0-9A-Fa-f]{2})\)\. Alcasar disconnect the user \((?P<user>.+)\)\.$/';
	$file = fopen('/var/Save/security/watchdog.log', 'r');
	if ($file) {
		while (!feof($file)) {
			$line = fgets($file);

			if (preg_match($regex, $line, $matches)) {
				if (preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}-[0-9]{2}:[0-9]{2}:[0-9]{2}/', $matches['date'], $matches_date)) {
					$matches['date'] = DateTime::createFromFormat('d/m/Y-H:i:s', $matches['date'])->format('Y-m-d H:i:s');
				}
				$spoofs[] = (object) [
					'date' => $matches['date'],
					'ip'   => $matches['ip'],
					'mac'  => $matches['mac'],
					'user' => $matches['user']
				];
			}
		}
		fclose($file);
	}
	$spoofs = array_reverse($spoofs);
?>
			<h3><?= $l_spoofing ?></h3>
			<div class="container">
				<table class="table table-striped table-hover" border="1">
				<tr>
					<th>
						Date
					</th>
					<th>
						<?= $l_ipAddress ?>	
					</th>
					<th>
						MAC
					</th>
					<th>
						<?= $l_user ?>
					</th>
				</tr>
				<tbody>
					<?php if (!empty($spoofs)): ?>
					<?php foreach ($spoofs as $spoof): ?>
					<tr><td><?= $spoof->date ?></td><td><?= $spoof->ip ?></td><td><?= $spoof->mac ?></td><td><?= $spoof->user ?></td></tr>
					<?php endforeach; ?>
					<?php else: ?>
					<tr><td colspan="4" style="text-align: center;"><?= $l_empty ?></td></tr>
					<?php endif; ?>
				</tbody>
				</table>
			</div>
<?php
} else if ($tab === 2) {
	$bans = [];
	$regex = '/^(?P<date>[0-9]{4}-[0-9]{2}-[0-9]{2}[ \t]+[0-9]{2}:[0-9]{2}:[0-9]{2}),[0-9]{3}[ \t]+fail2ban\.actions[ \t]+\[[0-9]+\]:[ \t]+NOTICE[ \t]+\[(?P<rule>[a-zA-Z0-9_-]+)\][ \t]+(?P<type>Ban|Unban)[ \t]+(?P<ip>[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3})/';
	$file = fopen('/var/log/fail2ban.log', 'r');
	if ($file) {
		while (!feof($file)) {
			$line = fgets($file);
			if (preg_match($regex, $line, $matches)) {
				if ($matches['type'] === 'Ban') {
					$bans[] = (object) [
						'date_ban'   => $matches['date'],
						'date_unban' => null,
						'rule'       => $matches['rule'],
						'ip'         => $matches['ip']
					];
				} else if ($matches['type'] === 'Unban') {
					foreach (array_reverse($bans) as $ban) {
						if (($ban->ip === $matches['ip']) && ($ban->rule === $matches['rule']) && ($ban->date_unban === null)) {
							$ban->date_unban = $matches['date'];
							break;
						}
					}
				}
			}
		}
		fclose($file);
	}
	$bans = array_reverse($bans);
?>
	<h3><?= $l_fail2ban ?></h3>
	<div class="container" border="1">
		<table  class="table table-striped table-hover" border="1">
				<tr >
					<th>
						<?= $l_ban_date ?>
					</th>
					<th>
						<?= $l_unban_date ?>
					</th>
					<th>
						<?= $l_rule ?>
					</th>
					<th>
						<?= $l_ipAddress ?>
					</th>
				</tr>
				<?php if (!empty($bans)): ?>
					<?php foreach ($bans as $ban): ?>
						<tr>
							<td>
								<?= $ban->date_ban ?>
							</td>
							<td>
								<?= $ban->date_unban ?>
							</td>
							<td>
								<?= $ban->rule ?>
							</td>
							<td>
								<?= $ban->ip ?>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php else: ?>
					<tr><td colspan="4" style="text-align: center;"><?= $l_empty ?></td></tr>
				<?php endif; ?>
		</table>
	</div>
<?php
} else {
	echo 'Unknown tab';
}
?>
	</div>
</div>
</body>
</html>
