<?php
/**
 * Print credentials of imported users
 *
 * @author    Tom Houdayer
 * @copyright Copyright (C) ALCASAR (http://www.alcasar.net)
 * @license   GPL-3.0
 * @version   $Id: import_file.php 2168 2017-04-18 17:39:54Z tom.houdayer $
 */

if ((!isset($_GET['file'])) || (empty($_GET['file']))) {
	exit();
}

$filename = $_GET['file'];
$format   = ((isset($_GET['format'])) ? $_GET['format'] : 'txt');

if (($format !== 'txt') && ($format !== 'pdf')) {
	exit();
}

$filePath = '/tmp/'.$filename.'.pwd';
if ((!is_file($filePath)) || (!is_readable($filePath))) {
	exit('FILE_NOT_FOUND');
}

if ($format === 'txt') {
	header('Content-Type: application/x-download');
	header('Content-Length: '.filesize($filePath));
	header('Content-Disposition: attachment; filename="'.$filename.'.txt"');
	header('Content-Type: application/force-download; filename="'.$filename.'.txt"');
	header('Cache-Control: private, max-age=0, must-revalidate');
	header('Pragma: public');
	ini_set('zlib.output_compression', '0');
	readfile($filePath);
} else if ($format === 'pdf') {
	// Convert to PDF
	$html  = '<!doctype html><html><head><meta charset="utf-8"></head><body><pre>';
	$html .= file_get_contents($filePath);
	$html .= '</pre></body></html>';
	file_put_contents("$filePath.pdf.html", $html);

	$command = 'wkhtmltopdf' . ' --quiet --disable-smart-shrinking --footer-font-size 8 --footer-left "ALCASAR" --footer-center "[page] / [toPage]" --footer-right "' . date('Y-m-d H:i:s') . '" ' . escapeshellarg("$filePath.pdf.html") . ' ' . escapeshellarg("$filePath.pdf");
	$output;
	$exitCode;
	exec($command, $output, $exitCode);

	header('Content-Type: application/pdf');
	header('Content-Length: '.filesize("$filePath.pdf"));
	header('Content-Disposition: attachment; filename="'.$filename.'.pdf"');
	header('Cache-Control: private, max-age=0, must-revalidate');
	header('Pragma: public');
	readfile("$filePath.pdf");

	unlink("$filePath.pdf");
	unlink("$filePath.pdf.html");
}
