<?php
/********************
* READ CONF FILES   *
*********************/
define("CONF_FILE", "/usr/local/etc/alcasar.conf");
define("ETHERS_INFO_FILE", "/usr/local/etc/alcasar-ethers-info");
$conf_files=array(CONF_FILE,ETHERS_INFO_FILE);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Requested file ".$file." isn't present");
	}
	if (!is_readable($file)) {
		exit("Can't read the file ".$file);
	}
}

$alcasar_conf_file = '/usr/local/etc/alcasar.conf';
$file_conf = fopen($alcasar_conf_file, 'r');
if (!$file_conf) {
	exit('Error opening the file '.$alcasar_conf_file);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);

$csrf_key = "";
$csrf_token = hash('sha256', $_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_USER_AGENT'].$_SERVER['REQUEST_URI'].$csrf_key);
$tmp = explode("/",$conf["PRIVATE_IP"]);
$private_ip=$tmp[0];
$intif = $conf["INTIF"];
if ($conf['MULTIWAN'] !== 'off') {
	exec ('sudo /usr/local/bin/alcasar-list-ip_gw.sh', $list_ip_gw); 
}
require('/etc/freeradius-web/config.php');
# Choice of language
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'fr') {
	$l_activity = "Activité sur le réseau de consultation";
	$l_ip_adr = "Adresse IP";
	$l_mac_adr = "Adresse MAC";
	$l_unknown = "manufacturer unknown";
	$l_user = "Usager";
	$l_mac_allowed = "@MAC autorisée";
	$l_mac_temporarily_allowed = "@MAC autorisée temporairement";
	$l_action = "Action";
	$l_dissociate = "Dissocier @IP";
	$l_disconnect = "Déconnecter";
	$l_stop_capture_disconnect = "Arrêter la capture et déconnecter";
	$l_refresh = "Recharger cette page";
	$l_edit_user = "Editer l'utilisateur";
	$l_connect = "Autoriser temporairement";
	$l_captureon = "Autoriser et capturer";
	$l_captureoff = "Arrêter la capture";
	$l_captureonly_on = "Capturer";
	$l_gw = "Routeur";
} else if ($Language === 'es') {
	$l_activity = "Actividad en la LAN";
	$l_ip_adr = "Dirección IP";
	$l_mac_adr = "Dirección MAC";
	$l_unknown = "fabricante desconocido";
	$l_user = "Usuario";
	$l_mac_allowed = "@MAC autorizada";
	$l_mac_temporarily_allowed = "@MAC temporalmente autorizada";
	$l_action = "Acción";
	$l_dissociate = "Liberar @IP";
	$l_disconnect = "Desconectar";
	$l_stop_capture_disconnect = "Deje de capturar y desconecte";
	$l_refresh = "Recargar esta página";
	$l_edit_user = "usuario de edición"; 
	$l_connect = "Permitir temporalmente";
	$l_captureon = "Autorizar y capturar";
	$l_captureoff = "Detener la captura";
	$l_captureonly_on = "Captura";
	$l_gw = "Router";
} else {
	$l_activity = "Activity on the consultation LAN";
	$l_ip_adr = "IP Address";
	$l_mac_adr = "MAC Address";
	$l_unknown = "fabricant inconnu";
	$l_user = "User";
	$l_mac_allowed = "@MAC allowed";
	$l_mac_temporarily_allowed = "@MAC temporarily allowed";
	$l_action = "Action";
	$l_dissociate = "Dissociate @IP";
	$l_disconnect = "Disconnect";
	$l_stop_capture_disconnect = "Stop capture and disconnect";
	$l_refresh = "Reload this page";
	$l_edit_user = "Edit user";
	$l_connect = "Temporarily authorize";
	$l_captureon = "Authorize and capture";
	$l_captureoff = "Stop capture";
	$l_captureonly_on = "Capture";
	$l_gw = "Router";
}
function taille_fichier($fichier)
{
	$taille_fichier = filesize($fichier);
	if ($taille_fichier >= 1073741824){
		$taille_fichier = round($taille_fichier / 1073741824 * 100) / 100 . " Go";}
	elseif ($taille_fichier >= 1048576){
		$taille_fichier = round($taille_fichier / 1048576 * 100) / 100 . " Mo";}
	elseif ($taille_fichier >= 1024){
		$taille_fichier = round($taille_fichier / 1024 * 100) / 100 . " Ko";}
	else {$taille_fichier = $taille_fichier . " o";}
	return $taille_fichier;
}

if (isset($_POST['action'])){
	$mac= trim($_POST['mac_addr']);
	if ((filter_var($mac, FILTER_VALIDATE_MAC) !== false) && (trim($_POST['post_csrf_token']) == $csrf_token)){
		switch ($_POST['action']){
			case "$l_disconnect" :
				exec("sudo /usr/sbin/chilli_query logout ".$mac);
			break;
			case "$l_stop_capture_disconnect" :
				exec('sudo /usr/local/bin/alcasar-iot_capture.sh -k '.$mac.' &>/dev/null &');
				exec("sudo /usr/sbin/chilli_query logout ".$mac);
			break;
			case "$l_dissociate" :
				exec("sudo /usr/sbin/chilli_query dhcp-release ".$mac);
			break;
			case "$l_connect" :
				exec("sudo /usr/sbin/chilli_query authorize mac ".$mac);
			break;
			case "$l_captureon" :
				exec('sudo /usr/local/bin/alcasar-iot_capture.sh -l '.$mac.' &>/dev/null &');
				exec("sudo /usr/sbin/chilli_query authorize mac ".$mac);
			break;
			case "$l_captureonly_on" :
				exec('sudo /usr/local/bin/alcasar-iot_capture.sh -l '.$mac.' &>/dev/null &');
			break;	
			case "$l_captureoff" :
				exec('sudo /usr/local/bin/alcasar-iot_capture.sh -k '.$mac.' &>/dev/null &');
			break;
		}
	}
	unset($_POST['mac_addr']);
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><!-- written by Rexy -->
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?= $config['general_charset'] ?>">
	<title>Activity</title>
	<link rel="stylesheet" type="text/css" href="/css/acc.css">
	<link rel="stylesheet" href="/css/jquery.dataTables.css">
	<script src="/js/jquery-3.6.min.js"></script>
	<script src="/js/jquery.dataTables.js"></script>
	<script src="/js/jquery.dataTables.ip-address.js"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#datatable_display').DataTable();
		});
		$.extend(true, $.fn.dataTable.defaults, {
			language: {url: '/js/jquery.dataTables.<?= $Language ?>.json'},
			columns: [{ type: 'html-num' }, { type: 'ip-address' }, null, null, null],
		});
	</script>
</head>
<body>
<div id="ldoverlay" class="overlay">
	<div class="lds-spinner" id="spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
</div>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
<tr><th><?= $l_activity ?></th></tr>
<tr bgcolor="#FFCC66"><td><img src="/images/pix.gif" width="1" height="2"></td></tr>
</table>
<table width="100%" border=1 cellspacing=0 cellpadding=1>
	<tr><td valign="middle" align="center"><a href="#" onclick="location.reload();"><?= $l_refresh ?></a><br>
	<table border=1  id="datatable_display" class="display" width="80%" cellpadding=2 cellspacing=0>
		<thead>
		<tr bgcolor="#686464">
			<th>#</th>
			<th><?= $l_ip_adr ?></th>
			<th><?= $l_mac_adr ?></th>
			<th><?= $l_user ?></th>
			<th><?= $l_action ?></th>
			<?php
			if ($conf['MULTIWAN'] !== 'off') {
				echo "<th>$l_gw</th>";
			}
		echo "</tr>";
		echo "</thead>";
		$IoT_capture = $conf["IOT_CAPTURE"];
		$output = array(); $detail = array(); $nb_ligne = 0;
		exec("sudo /sbin/ip link show ".escapeshellarg($intif), $output); // retrieve ALCASAR @MAC
		$detail = explode (" " , $output[1]);
		$intif_mac_addr=strtoupper(str_replace(":","-",$detail[5]));
		unset ($output);unset ($detail);
		exec ('sudo /usr/sbin/chilli_query list|sort -k5 -r', $output); 
		echo "<tbody>";
		foreach ($output as $ligne){
			$detail = explode (" ", $ligne);
			$nb_ligne ++;
			echo "<tr valign=\"middle\">";
			echo "<td>".$nb_ligne."</td>";
			echo "<td>".$detail[1]."</td>"; // @IP
			echo "<td>$detail[0]"; // @MAC
			if(file_exists('/usr/share/nmap/nmap-mac-prefixes')){ // retrieve @MAC manufacturer
				$oui_id = substr(str_replace("-","",$detail[0]),0,6);
				exec ("grep ^$oui_id /usr/share/nmap/nmap-mac-prefixes | cut -d' ' -f2-", $mac_manufacturer);
				if(! empty($mac_manufacturer[0])) echo " <font size=\"1\">($mac_manufacturer[0])</font>";
					else echo " <font size=\"1\">($l_unknown)</font>";
				unset($mac_manufacturer);
			}
			exec ("grep $detail[0] /usr/local/etc/alcasar-ethers-info |cut -d' ' -f3", $mac_in_ether_file); // retrieve @MAC info
			if (!empty($mac_in_ether_file[0])){
				$mac_info= ltrim($mac_in_ether_file[0],'#');
				if (!empty($mac_info)) echo " - <b>" . ltrim($mac_in_ether_file[0],'#') . "</b>";
			}
			echo "</td><td>";
			if ($detail[4] == "1"){ // is user authenticated ?
				$login = $detail[5];
				unset ($found_users); unset ($cn);
				$search = $login; $search_IN = 'username'; // search user in database
				if (is_file("../lib/sql/find.php"))
				include("../lib/sql/find.php");
				if (isset ($found_users)){ // is user in database ? 
					if (is_file("../lib/sql/user_info.php")) // retrieve user info (especialy $cn)
						include("../lib/sql/user_info.php");
				}
				if (! isset ($cn)){ $cn='-';}
				if ($detail[5] == $detail[0]){ // is user an @MAC ?
					if (isset ($found_users)){ // is @MAC allowed ?
						echo "<a href=\"/acc/manager/htdocs/user_admin.php?login=$detail[5]\" title=\"$l_edit_user\">$l_mac_allowed";if ($cn != '-'){ echo " ($cn)";};echo "</a>";
						echo "</td>";
						echo "<td>&nbsp;</td>"; // no 'disconnect' button for allowed @MAC
					}
					else {
						echo "<b>$l_mac_temporarily_allowed</b>";
						echo "</td><td>";
						echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"POST\">";
						echo "<input type=\"hidden\" name=\"mac_addr\" value=\"$detail[0]\">";
						echo "<input type=\"hidden\" name=\"post_csrf_token\" value=\"$csrf_token\">";
						if($IoT_capture == "on"){
							if(exec('sudo /usr/local/bin/alcasar-iot_capture.sh -i '.$detail[0]) == "CaptureON"){
								echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_stop_capture_disconnect\">";
								echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_captureoff\">";
							}
 							else {
								echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_disconnect\">";
								echo "<br><input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_captureonly_on\">";
								$file = '/var/Save/iot_captures/'.$detail[0].'.pcap';
								if (file_exists($file))	{
									echo "<br><center><a href=\"/save/iot_captures/$detail[0].pcap\">$detail[0].pcap</a> (";echo taille_fichier("/var/Save/iot_captures/".$detail[0].".pcap");echo ")</center>";
								}
							}	
						}
						else echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_disconnect\">";
						echo "</form></td>";
					}
				}
				else { // The user is a humanoide ;-)
					if ($cn != '-') { echo "<a href=\"/acc/manager/htdocs/user_admin.php?login=$detail[5]\" title=\"$l_edit_user $detail[5]\">$detail[5] ($cn)</a>";}
					else { echo "<a href=\"/acc/manager/htdocs/user_admin.php?login=$detail[5]\" title=\"$l_edit_user $detail[5]\">$detail[5]</a>";}
					echo "<td>";
					echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"POST\">";
					echo "<input type=\"hidden\" name=\"mac_addr\" value=\"$detail[0]\">";
					echo "<input type=\"hidden\" name=\"post_csrf_token\" value=\"$csrf_token\">";
					echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_disconnect\">";
					echo "</form></td>";
				}
			}
			// equipment without authenticated user
			else if (($detail[0] == $intif_mac_addr) || ($detail[1] == $private_ip)){ 
				echo "ALCASAR system";
				echo "<td>";
				echo "&nbsp;";
				echo "</td>";
			}	
			else {  
				echo "&nbsp;";
				echo "<td>";		
				echo "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"POST\">";
				# Dissociate user (... or other) who is not connected yet
				echo "<input type=\"hidden\" name=\"mac_addr\" value=\"$detail[0]\">";
				echo "<input type=\"hidden\" name=\"post_csrf_token\" value=\"$csrf_token\">";
				exec ("grep $detail[0] /usr/local/etc/alcasar-ethers-info", $mac_in_ether_file);
				if (empty($mac_in_ether_file[1])){
					echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_dissociate\">"; // Dissociate only MAC not in ether file (dhcp)
				}
				echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_connect\">"; // Enable temporarily @MAC access
				if($IoT_capture == "on"){
					if(exec('sudo /usr/local/bin/alcasar-iot_capture.sh -i '.$detail[0]) == "CaptureON"){
						echo "<br><input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_captureoff\">";
					}
					else {
						echo "<br><input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_captureon\">";
						echo "<input type=\"submit\" onClick=\"document.getElementById('ldoverlay').style.display='block';\" name=\"action\" value=\"$l_captureonly_on\">";
						$file = '/var/Save/iot_captures/'.$detail[0].'.pcap';
						if (file_exists($file)) {
							echo "<br><center><a href=\"/save/iot_captures/$detail[0].pcap\">$detail[0].pcap</a> (";echo taille_fichier("/var/Save/iot_captures/".$detail[0].".pcap");echo ")</center>";
						}
					}
				}
				echo "</form></td>";
			}
			if ($conf['MULTIWAN'] !== 'off') {
				if ($detail[4] == "1"){ // authenticated user
					foreach ($list_ip_gw as $ligne2){
						$detail2 = explode (" ", $ligne2);
						if ($detail2[0] == $detail[1]){
							echo "<td>$detail2[1]</td>";
							reset ($list_ip_gw);
							break;
						}
					}
				}
			else echo "<td>&nbsp;</td>"; 
			}
			unset ($mac_in_ether_file);
			echo "</tr>";
		}
		echo "</tbody>";
		?>
	</table>
	</td></tr>
</table>
</html>
