<?php
# $Id: admin_log.php 3264 2025-04-05 14:29:06Z rexy $

$Language = 'en';
if(isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2)); 
}
if ($Language === 'fr') {
	$l_title	= "Connexion à l'ALCASAR Control Center (ACC)";
	$l_user		= "Utilisateur";
	$l_ip_address	= "Adresse IP";
	$l_date         = "Date";
	$l_agent        = "Agent web";
} else if ($Language === 'es') {
	$l_title	= "Conexiones a ALCASAR, Centro de Control (ACC)";
	$l_user		= "Usuario";
	$l_ip_address	= "Dirección IP";
	$l_date         = "Fecha";
	$l_agent        = "Agente web";
} else {
	$l_title	= "Connection to ALCASAR Control Center (ACC)";
	$l_user		= "User";
	$l_ip_address	= "IP address";
	$l_date         = "Date";
	$l_agent        = "Web user agent";
}
// Read access log
$accessLogs = [];
$accessLogFilename = '/var/Save/security/acc_access.log';
$filePtn = fopen($accessLogFilename, 'r');
if ($filePtn !== false){
	while (!feof($filePtn)) {
		$ligne = fgets($filePtn);
		if (empty($ligne)) {
			continue;
		}
		$infos = explode('|', $ligne);
		$accessLogs[] = (object) [
			'date'     	=> trim($infos[0]),
			'username' 	=> trim($infos[1]),
			'ip'       	=> trim($infos[2]),
			'user_agent'	=> trim($infos[3])
		];
	}
	fclose($filePtn);
}
$accessLogs = array_reverse($accessLogs);

// Remove access before startTime
if (isset($_GET['startTime'])) {
	$startTime = intval($_GET['startTime']);
	foreach ($accessLogs as $key => $access) {
		$timestamp = date_timestamp_get(date_create_from_format('d/m/Y H:i:s', $access->date));
		if ($timestamp < $startTime) {
			$accessLogs = array_slice($accessLogs, 0, $key);
			break;
		}
	}
}

?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>Admin Logs</title>
	<link rel="stylesheet" href="/css/acc.css" type="text/css">
	<link rel="stylesheet" href="/css/jquery.dataTables.css">
	<script src="/js/jquery-3.6.min.js"></script>
	<script src="/js/jquery.dataTables.js"></script>
	<script src="/js/jquery.dataTables.ip-address.js"></script>
	<script type="text/javascript">
		$(document).ready(function() {
		$('#datatable_display').DataTable();
		});
		$.extend(true, $.fn.dataTable.defaults, {
        	language: {url: '/js/jquery.dataTables.<?= $Language ?>.json'},
			columns: [{ type: 'date' }, null, { type: 'ip-address' }, null],
		});
	</script>
</head>
<body>
<div class="panel">
	<div class="panel-header"><?= $l_title ?></div>
	<div class="panel-row">
		<table border=0 width=100% cellpadding=12 cellspacing=0 bgcolor="#ffffd0" valign=top>
		<tr><td>
			<TABLE id="datatable_display" class="display" width="100%" border=1 cellspacing=0 cellpadding=0>
			<thead><tr bgcolor=”#686464”>
				<th><?=$l_date?></th>
				<th><?=$l_user?></th>
				<th><?=$l_ip_address?></th>
				<th><?=$l_agent?></th>
			</tr></thead>
			<tbody>
			<?php if (empty($accessLogs)): ?>
			<tr>
				<td colspan="4"><center>Empty</center></td>
			</tr>
			<?php else: ?>
			<?php foreach ($accessLogs as $access): ?>
			<tr>
				<td><?= $access->date ?></td>
				<td><?= $access->username ?></td>
				<td><?= $access->ip ?></td>
				<td><?= $access->user_agent ?></td>
			</tr>
			<?php endforeach; ?>
			<?php endif; ?>
			</tbody>
			</table>
		</table>
	</div>
</div>
</body>
</html>
