<!DOCTYPE HTML>
<html><!-- Written by Rexy -->
<head>
	<meta charset="UTF-8">
	<title>Logo Customizing</title>
	<link rel="stylesheet" href="/css/acc.css" type="text/css">
</head>
<body>
<div id="ldoverlay" class="overlay">
	<div class="lds-spinner" id="spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
</div>
<?php
# Configuration
$max_file_size = 100000; // 100 Ko
$allowed_types = ['image/png'];
$upload_dir = $_SERVER['DOCUMENT_ROOT']."/images/";
$target_file = $upload_dir . 'organisme.png';

# Choice of language
$language = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? 'en', 0, 2);
$messages = [
	'fr' => [
		'l_title' => "Personnalisation du logo",
		'l_current_logo' => "Logo actuel",
		'l_logo_select' => "Sélectionnez un nouveau logo (fichier au format 'PNG' de taille inférieure à 100Ko) :",
		'l_error_type' => "Le fichier doit être une image PNG valide.",
		'l_error_size' => "Le fichier dépasse la taille maximale autorisée (100 Ko).",
		'l_error_upload' => "Une erreur est survenue lors du téléchargement.",
		'l_success' => "Votre logo a été mis à jour.",
		'l_logo_refresh' => "Rafraîchissez la page de votre navigateur pour voir le résultat (CTRL+F5).",
		'l_send' => "Envoyer"
	],
	'es' => [
		'l_title' => "Personalización del logo",
		'l_current_logo' => "Logo actual",
		'l_logo_select' => "Seleccione un nuevo logotipo (archivo en formato «PNG» con un tamaño inferior a 100 KB) :",
		'l_error_type' => "El archivo debe ser una imagen PNG válida.",
		'l_error_size' => "El archivo supera el tamaño máximo permitido (100 KB).",
		'l_error_upload' => "Se ha producido un error durante la descarga.",
		'l_success' => "Se ha actualizado su logotipo.",
		'l_logo_refresh' => "Actualice la página de su navegador para ver el resultado (CTRL+F5).",
		'l_send' => "Enviar"
	],
	'en' => [
		'l_title' => "Customizing the logo",
		'l_current_logo' => "Current logo",
		'l_logo_select' => "Select a new logo (file in ‘PNG’ format, less than 100 KB in size) :",
		'l_error_type' => "The file must be a valid PNG image.",
		'l_error_size' => "The file exceeds the maximum allowed size (100 KB).",
		'l_error_upload' => "An error occurred during the download.",
		'l_success' => "Your logo has been updated.",
		'l_logo_refresh' => "Refresh your browser page to see the result (CTRL+F5).",
		'l_send' => "Send"
	]
];
$lang = $messages[$language] ?? $messages['en'];

# Logo download management
if(isset($_FILES['logo'])) {
	$result = null;
	$file = $_FILES['logo'];
	$finfo = finfo_open(FILEINFO_MIME_TYPE);
	$mime = finfo_file($finfo, $file['tmp_name']);
	finfo_close($finfo);
	// Download error
	if ($file['error'] !== UPLOAD_ERR_OK) {
		$result = $lang['l_error_upload']; }
	// MIME type check
	elseif (!in_array($file['type'], $allowed_types)) {
		$result = $lang['l_error_type']; }
	elseif (!in_array($mime, $allowed_types)) {
		$result = $lang['l_error_type']; }
	// Size check
	elseif ($file['size'] > $max_file_size) {
		$result = $lang['l_error_size']; }
	// PNG consistent check
	elseif (!getimagesize($file['tmp_name'])) {
		$result = $lang['l_error_type']; }
	// ok : move it
	elseif (!move_uploaded_file($file['tmp_name'], $target_file)) {
		$result = $lang['l_error_upload']; }
	else {
		$result = $lang['l_success'];}
}
?>
<div class="panel">
	<div class="panel-header"><?= $lang['l_title'] ?></div>
	<div class="panel-row">
	<table width="100%" border=0 cellspacing=0 cellpadding=1>
		<tr><td>
		<table width="100%" border=0 cellspacing=0 cellpadding=2>
			<tr><td valign="middle" align="left">
			<center><H3><?= $lang['l_current_logo'] ?><img src="/images/organisme.png" width="90"></H3></center><BR>
<?= $lang['l_logo_select'] ?>
			<form action="logo.php" method="POST" ENCTYPE="multipart/form-data">
				<input type="file" name="logo">
				<input type="hidden" name="MAX_FILE_SIZE" value="<?= $max_file_size ?>">
				<input type="submit" onClick="document.getElementById('ldoverlay').style.display='block';" value="<?= $lang['l_send'] ?>">
			</form>
<?php
if (isset($result)){
	echo "<H3>".$result."</H3>";
	echo "<H3>".$lang['l_logo_refresh']."</H3>";
	}
?>
			</td></tr>
		</table>
		</td></tr>
	</table>
	</div>
</div>
</body>
</html>
