#!/bin/bash

# alcasar-wifi4eu.sh
# by Rexy
# This script is distributed under the Gnu General Public License (GPL)

# active ou désactive l'affichage du logo WIFI4EU (+ intégration de leur échantillon de code)
# enable or disable the display of WIFI4EU logo (+ integration of their snippet)

SED="/bin/sed -i"
CONF_FILE="/usr/local/etc/alcasar.conf"
TRUST_SITES_FILE='/usr/local/etc/alcasar-uamdomain'
TRUST_DOMAIN='collection.wifi4eu.ec.europa.eu' # the web site where the snippet connects to
HOSTNAME=$(grep ^HOSTNAME= $CONF_FILE | cut -d'=' -f2)
DOMAIN=$(grep ^DOMAIN= $CONF_FILE | cut -d'=' -f2)

usage="Usage: alcasar-wifi4eu.sh {--on | -on} | {--off | -off}"
nb_args=$#
args=$1
if [ $nb_args -eq 0 ]
then
	echo "$usage"
	exit 1
fi

case $args in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	--off | -off)
		$SED "s?^WIFI4EU=.*?WIFI4EU=off?" $CONF_FILE
		$SED "/$TRUST_DOMAIN/d" $TRUST_SITES_FILE
		/usr/local/bin/alcasar-file-clean.sh # Clean & sort conf files.
		/usr/bin/systemctl restart chilli
		;;
	--on | -on)
		$SED "s?^WIFI4EU=.*?WIFI4EU=on?" $CONF_FILE
		echo "uamdomain=\"$TRUST_DOMAIN\"" >> $TRUST_SITES_FILE
		/usr/local/bin/alcasar-file-clean.sh # Clean & sort conf files.
		/usr/bin/systemctl restart chilli
		;;
	*)
		echo "Argument inconnu : $1"
		echo "$usage"
		exit 1
		;;
esac
