#!/bin/bash
# $Id: alcasar-watchdog-hl/sh 2113 2017-01-08 22:43:26Z richard $

# alcasar-watchdog-hl.sh
# by 3abtux
# This script is distributed under the Gnu General Public License (GPL)
# - Ce script déconnecte les équipements réseau qui sont identifiés en 0.0.0.0 (lancé optionnellement par cron dans /etc/cron.d/alcasar-watchdog)
# - This script disconnects the network equipments which are identified in 0.0.0.0 (optionally run by cron in /etc/cron.d/alcasar-watchdog)

OLDIFS=$IFS
IFS=$'\n'

usage="Usage: alcasar-watchdog-hl.sh "
case $1 in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	*)
		# searching for 0.0.0.0 IP
		for system in `/usr/sbin/chilli_query list |grep  "0\.0\.0\.0 dnat"`
		do
			active_mac=`echo $system | cut -d" " -f1`
			echo "$(date "+[%x-%X] : ")alcasar-watchdog-hl : $active_mac has 0.0.0.0 IP address. Alcasar release the equipment." >> /var/Save/security/watchdog-hl.log
			/usr/sbin/chilli_query dhcp-release $active_mac
		done
		;;
esac	
IFS=$OLDIFS
