#!/bin/bash
# $Id: alcasar-uninstall.sh 3294 2025-07-20 22:26:38Z rexy $

# alcasar-uninstall.sh
# by Franck BOUIJOUX, Pascal LEVANT and Richard REY
# This script is distributed under the Gnu General Public License (GPL)

# Désinstallation ou mise à jour d'ALCASAR
# Uninstall or update ALCASAR

SED="/bin/sed -i"

[ -z $DEBUG_ALCASAR ] && DEBUG_ALCASAR='off'

init ()
{
	echo -en "(2) : "
	rm -f /root/ALCASAR* && echo -n "1, " # The files in /usr/local/ will be removed at the end (still usefull here)
	[ -e /etc/grub.d/default-40_custom ] && mv /etc/grub.d/default-40_custom /etc/grub.d/40_custom && echo -n "2"
}

ACC ()
{
	echo -en "(13) : "
	[ -d /var/www/html ] && rm -rf /var/www/html && echo -n "1, "
	[ -d /etc/freeradius-web ] && rm -rf /etc/freeradius-web && echo -n "2, "
	[ -e /etc/php.ini.default ] && mv -f /etc/php.ini.default /etc/php.ini && echo -n "4, "
	[ -d /usr/local/etc/digest ] && rm -rf /usr/local/etc/digest && echo -n "5, "
	[ -e /etc/httpd/conf/httpd.conf.default ] && mv /etc/httpd/conf/httpd.conf.default /etc/httpd/conf/httpd.conf && echo -n "6, "
	[ -e /etc/httpd/conf/modules.d/00_base.conf.default ] && mv /etc/httpd/conf/modules.d/00_base.conf.default /etc/httpd/conf/modules.d/00_base.conf && echo -n "7, "
	[ -e /etc/httpd/conf/conf.d/ssl.conf.default ] && mv /etc/httpd/conf/conf.d/ssl.conf.default /etc/httpd/conf/conf.d/ssl.conf && echo -n "8, "
	[ -e /etc/httpd/conf/vhosts.d/00_default_ssl_vhost.conf.default ] && mv /etc/httpd/conf/vhosts.d/00_default_ssl_vhost.conf.default /etc/httpd/conf/vhosts.d/00_default_ssl_vhost.conf && echo -n "9, "
	[ -e /etc/httpd/conf/conf.d/multilang-errordoc.conf.default ] && mv /etc/httpd/conf/conf.d/multilang-errordoc.conf.default /etc/httpd/conf/conf.d/multilang-errordoc.conf && echo -n "10, "
	[ -e /usr/share/httpd/error/include/top.html.default ] && mv /usr/share/httpd/error/include/top.html.default /usr/share/httpd/error/include/top.html && echo -n "11, "
	[ -e /usr/share/httpd/error/include/bottom.html.default ] && mv /usr/share/httpd/error/include/bottom.html.default /usr/share/httpd/error/include/top.html && echo -n "12, "
	[ -e /etc/httpd/conf/webapps.d/alcasar.conf ] && rm -f /etc/httpd/conf/webapps.d/alcasar.conf && echo -n "13"
}

CA ()
{
	echo -en "(5) : "
	[ -e /etc/pki/CA/alcasar-ca.crt ] && rm -f /etc/pki/CA/alcasar-ca.crt && echo -n "1, "
	[ -e /etc/pki/CA/private/alcasar-ca.key ] && rm -f /etc/pki/CA/private/alcasar-ca.key && echo -n "2, "
	[ -e /etc/pki/tls/certs/alcasar.crt ] && rm -f /etc/pki/tls/certs/alcasar.crt && echo -n "3, "
	[ -e /etc/pki/tls/private/alcasar.key ] && rm -f /etc/pki/tls/private/alcasar.key && echo -n "4, "
	[ -e /etc/pki/tls/private/alcasar.pem ] && rm -f /etc/pki/tls/private/alcasar.pem && echo -n "5"
}

time_server ()
{
	echo -en "(1) : "
	[ -e /etc/ntp.conf.default ] && mv /etc/ntp.conf.default /etc/ntp.conf && echo -n "1"
}

init_db ()
{
	echo -en "(3) : "
	[ -e /etc/my.cnf.default ] && mv -f /etc/my.cnf.default /etc/my.cnf && echo -n "1, "
	[ -e /etc/my.cnf.d/server.cnf.default ] && mv /etc/my.cnf.d/server.cnf.default /etc/my.cnf.d/server.cnf && echo -n "2, "
	if [ -e /etc/systemd/system/mysqld.service ]
	then
		rm /etc/systemd/system/mysqld.service
		echo -n "3"
	fi
	if [ -e /etc/systemd/system/mariadb.service ]
	then
		rm /etc/systemd/system/mariadb.service
		echo -n "3"
	fi
	/usr/bin/systemctl daemon-reload
	rm -rf /var/lib/mysql
}

freeradius ()
{
	echo -en "(22) : "
	[ -e /etc/raddb/empty-radiusd-db.sql ] && rm /etc/raddb/empty-radiusd-db.sql && echo -n "1, "
	[ -e /etc/raddb/radiusd.conf.default ] && mv /etc/raddb/radiusd.conf.default /etc/raddb/radiusd.conf && echo -n "2, "
	[ -e /etc/raddb/dictionary.default ] && mv /etc/raddb/dictionary.default /etc/raddb/dictionary && echo -n "3, "
	[ -e /etc/raddb/dictionary.alcasar ] && rm /etc/raddb/dictionary.alcasar && echo -n "4, "
	[ -e /etc/raddb/dictionary.coovachilli ] && rm /etc/raddb/dictionary.coovachilli && echo -n "5, "
	[ -e /etc/raddb/clients.conf.default ] && mv /etc/raddb/clients.conf.default /etc/raddb/clients.conf && echo -n "6, "
	[ -e /etc/raddb/sites-enabled/alcasar ] && rm /etc/raddb/sites-enabled/alcasar && echo -n "7, "
	[ -e /etc/raddb/sites-available/alcasar ] && rm /etc/raddb/sites-available/alcasar && echo -n "8, "
	[ -e /etc/raddb/sites-available/alcasar-with-ldap ] && rm /etc/raddb/sites-available/alcasar-with-ldap && echo -n "9, "
	[ -e /etc/raddb/mods-available/ldap-alcasar ] && rm /etc/raddb/mods-available/ldap-alcasar && echo -n "10, "
    i=10
	for mods in sql sqlcounter attr_filter expiration logintime pap expr always
	do
		i=`expr $i + 1`
        [ -e /etc/raddb/mods-enabled/$mods ] && rm /etc/raddb/mods-enabled/$mods && echo -n "$i, "
	done
	[ -e /etc/raddb/mods-available/sql.default ] && mv /etc/raddb/mods-available/sql.default /etc/raddb/mods-available/sql && echo -n "19, "
	[ -e /etc/raddb/mods-config/sql/main/mysql/queries.conf.default ] && mv /etc/raddb/mods-config/sql/main/mysql/queries.conf.default /etc/raddb/mods-config/sql/main/mysql/queries.conf && echo -n "20, "
	[ -e /etc/raddb/mods-available/sqlcounter.default ] && mv /etc/raddb/mods-available/sqlcounter.default /etc/raddb/mods-available/sqlcounter && echo -n "21, "
	if [ -e /etc/systemd/system/radiusd.service ]; then
		rm -f /etc/systemd/system/radiusd.service
		echo -n "22"
	fi
}

chilli ()
{
	echo -en "(4) : "
	[ -e /etc/init.d/chilli.default ] && mv /etc/init.d/chilli.default /etc/init.d/chilli && echo -n "1, "
	[ -e /usr/libexec/chilli ] && rm /usr/libexec/chilli && echo -n "2, "
	[ -e /etc/chilli.conf.default ] && mv /etc/chilli.conf.default /etc/chilli.conf && echo -n "3, "
	[ -e /etc/systemd/system/chilli.service ] && rm /etc/systemd/system/chilli.service && echo -n "4"
}

e2guardian ()
{
	echo -en "(7) : "
	[ -d /var/e2guardian ] && rm -rf /var/e2guardian
	[ -d /var/dansguardian ] && rm -rf /var/dansguardian
	if [ -e /etc/systemd/system/e2guardian.service ]; then
		rm -f /etc/systemd/system/e2guardian.service
		echo -n "1, "
	fi
	[ -e /etc/e2guardian/e2guardian.conf.default ] && mv /etc/e2guardian/e2guardian.conf.default /etc/e2guardian/e2guardian.conf && echo -n "2, "
	[ -e /usr/share/e2guardian/languages/french/alcasar-e2g.html ] && rm /usr/share/e2guardian/languages/french/alcasar-e2g.html && echo -n "3, "
	[ -e /usr/share/e2guardian/languages/ukenglish/alcasar-e2g.html ] && rm /usr/share/e2guardian/languages/ukenglish/alcasar-e2g.html && echo -n "4, "
	[ -e /etc/e2guardian/e2guardianf1.conf.default ] && mv /etc/e2guardian/e2guardianf1.conf.default /etc/e2guardian/e2guardianf1.conf && echo -n "5, "
	[ -d /etc/e2guardian/lists/group1 ] && rm -rf /etc/e2guardian/lists/group1 && echo -n "6, "
	[ -e /etc/e2guardian/e2guardianf2.conf ] && rm -f /etc/e2guardian/e2guardianf2.conf && echo -n "7"
}

antivirus ()
{
	echo -en "(4) : "
	if [ -e /etc/systemd/system/clamav-daemon.service ]; then
		rm -f /etc/systemd/system/clamav-daemon.service
		echo -n "1, "
	fi
	if [ -e /etc/systemd/system/clamav-daemon.socket ]; then
		rm -f /etc/systemd/system/clamav-daemon.socket
		echo -n "2, "
	fi
	[ -e /etc/clamd.conf.default ] && mv /etc/clamd.conf.default /etc/clamd.conf && echo -n "3, "
	[ -e /etc/freshclam.conf.default ] && mv /etc/freshclam.conf.default /etc/freshclam.conf && echo -n "4"
}

ulogd ()
{
	echo -en "(6) : "
	i=0
	for log_type in traceability ssh ext-access
	do
		i=`expr $i + 1`
		[ -e /etc/ulogd-$log_type.conf ] && rm -f /etc/ulogd-$log_type.conf && echo -n "$i, "
		i=`expr $i + 1`
		[ -e /etc/systemd/system/ulogd-$log_type.service ] && rm -f /etc/systemd/system/ulogd-$log_type.service && echo -n "$i, "
	done
}

nfsen ()
{
	# we don't remove user "nfcapd" & nfcapd folders in order to keep data when updating
	echo -en "(2) : "
	[ -e /etc/systemd/system/nfcapd.service ] && rm -f /etc/systemd/system/nfcapd.service && echo -n "1, "
	[ -e /etc/systemd/system/nfsen-ng.service ] && rm -f /etc/systemd/system/nfsen-ng.service && echo -n "2"
}

vnstat ()
{
	echo -en "(2) : "
	[ -e /etc/vnstat.conf.default ] && mv /etc/vnstat.conf.default /etc/vnstat.conf && echo -n "1, "
	if [ -e /etc/systemd/system/vnstat.service ]; then
		rm -f /etc/systemd/system/vnstat.service
		echo -n "2"
	fi
}

unbound ()
{
	echo -en "(9) : "
	[ -e /etc/unbound/unbound.conf.default ] && mv /etc/unbound/unbound.conf.default /etc/unbound/unbound.conf && echo -n "1, "
	[ -e /etc/unbound/unbound-blacklist.conf ] && rm -f /etc/unbound/unbound-blacklist.conf && echo -n "2, "
	[ -e /etc/unbound/unbound-whitelist.conf ] && rm -f /etc/unbound/unbound-whitelist.conf && echo -n "3, "
	[ -e /etc/unbound/unbound-blackhole.conf ] && rm -f /etc/unbound/unbound-blackhole.conf && echo -n "4, "
	[ -e /etc/unbound/conf.d ] && rm -rf /etc/unbound/conf.d && echo -n "5, "
	i=6
	for list in blacklist blackhole whitelist
	do
		if [ -e /etc/systemd/system/unbound-$list.service ]
		then
			rm -f /etc/systemd/system/unbound-$list.service
			echo -n "$i, "
		fi
		i=`expr $i + 1`
	done
	if [ -e /etc/systemd/system/unbound.service ]; then
		rm -f /etc/systemd/system/unbound.service
		echo -n "9"
	fi
}

dhcpd ()
{
	echo -en "(1) : "
	[ -e /etc/dhcpd.conf.default ] && mv /etc/dhcpd.conf.default /etc/dhcpd.conf && echo -n "1"
}

cron ()
{
# /etc/cron.d/alcasar-daemon-watchdog is removed at the beginning of this script
echo -en "(12) : "
	i=1
	for cron in `ls /etc/cron.d/alcasar-* 2>/dev/null`
	do
		rm $cron && echo -n "$i, "
		i=`expr $i + 1`
	done
	[ -e /etc/crontab.default ] && mv /etc/crontab.default /etc/crontab && echo -n "11, "
	[ -e /etc/anacrontab.default ] && mv /etc/anacrontab.default /etc/anacrontab && echo -n "12"
}

fail2ban ()
{
	echo -en "(10) : "
	[ -e /etc/fail2ban/jail.conf.default ] && mv /etc/fail2ban/jail.conf.default /etc/fail2ban/jail.conf && echo -n "1, "
	[ -e /etc/fail2ban/action.d/iptables-allports.conf.default ] && mv /etc/fail2ban/action.d/iptables-allports.conf.default /etc/fail2ban/action.d/iptables-allports.conf # only for ALCASAR version <= V3.5.1
	i=1
	for filter in `ls /etc/fail2ban/filter.d/alcasar_* 2>/dev/null`
	do
		i=`expr $i + 1`
		rm $filter && echo -n "$i, "
	done
	for jail in `ls /etc/fail2ban/jail.d/*alcasar_* 2>/dev/null`
	do
		i=`expr $i + 1`
		rm $jail && echo -n "$i, "
	done
	if [ -e /etc/systemd/system/fail2ban.service ]; then
		rm -f /etc/systemd/system/fail2ban.service
		echo -n "10"
	fi
}

gammu_smsd ()
{
	echo -en "(4) : "
	[ -e /etc/gammu_smsd_conf ] && rm -f /etc/gammu_smsd_conf && echo -n "1, "
	[ -e /etc/systemd/system/gammu-smsd.service ] && rm -f /etc/systemd/system/gammu-smsd.service && echo -n "2, "
	[ -e /var/log/gammu-smsd ] && rm -rf /var/log/gammu-smsd && echo -n "3, "
	userdel -r gammu_smsd 2>/dev/null && echo -n "4"
	#[ -e /lib/udev/rules.d/66-huawei.rules ] && rm -f /lib/udev/rules.d/66-huawei.rules && echo -n "4"
}

msec ()
{
	echo -en "(2) : "
	if [ -e /etc/security/msec/security.conf ]; then
		[ -e /etc/security/msec/security.conf.default ] && mv /etc/security/msec/security.conf.default /etc/security/msec/security.conf && echo -n "1, "
		[ -e /etc/security/msec/perm.local ] && rm -f /etc/security/msec/perm.local && echo -n "2"
	else
		echo -n "uninstalled"
	fi
}

letsencrypt ()
{
	echo -en "(3) : "
	[ -e /usr/local/etc/letsencrypt ] && rm -rf /usr/local/etc/letsencrypt && echo -n "1, "
	[ -e /opt/acme.sh/acme.sh ] && /opt/acme.sh/acme.sh --uninstall --nocron 1>/dev/null && echo -n "2, "
	[ -e /opt/acme.sh ] && rm -rf /opt/acme.sh && echo -n "3"
}

mail_service()
{
	echo -en "(3) : "
	[ -e /etc/php.d/05_mail.ini.default ] && mv /etc/php.d/05_mail.ini.default /etc/php.d/05_mail.ini && echo -n "1"
	[ -e /etc/postfix/main.cf.orig ] && mv /etc/postfix/main.cf.orig /etc/postfix/main.cf && echo -n "2"
	[ -e /etc/postfix/aliases.default ] && mv /etc/postfix/aliases.default /etc/postfix/aliases && newaliases && echo -n "3"
}

post_install ()
{
echo -en "(7) : "
	[ -e /etc/mageia-release.default ] && mv -f /etc/mageia-release.default /etc/mageia-release && echo -n "1, "
	[ -e /etc/ssh/alcasar-banner-ssh ] && rm -f /etc/ssh/alcasar-banner-ssh && echo -n "2, "
	[ -e /etc/ssh/sshd_config.default ] && mv -f /etc/ssh/sshd_config.default /etc/ssh/sshd_config && echo -n "3, "
	[ -e /etc/bashrc.default ] && mv -f /etc/bashrc.default /etc/bashrc && echo -n "4, "
	[ -e /etc/sudoers.default ] && mv -f /etc/sudoers.default /etc/sudoers && echo -n "5, "
	[ -e /etc/security/limits.conf.default ] && mv -f /etc/security/limits.conf.default /etc/security/limits.conf && echo -n "6, "
	[ -e /etc/default/grub.default ] && mv -f /etc/default/grub.default /etc/default/grub && echo -n "7"
}

usage="Usage: alcasar-uninstall.sh {-update or --update} | {-full or --full}"

nb_args=$#
args=$1
if [ $nb_args -eq 0 ]; then
	nb_args=1
	args="-h"
fi
case $args in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	--update | -update)
		mode="update"
		;;
	--full | -full)
		mode="full"
		;;
	*)
		echo "Argument inconnu :$1";
		echo "$usage"
		exit 1
		;;
esac
clear
if [ $mode == "full" ]; then
	echo "----------------------------------------------------------------------------"
	echo "**                     Uninstall/Désinstallation d'ALCASAR		**"
	echo "----------------------------------------------------------------------------"
	services="vnstat clamav-daemon clamav-freshclam ntpd httpd radiusd mariadb unbound unbound-blacklist unbound-whitelist unbound-blackhole nfcapd nfsen-ng fail2ban iptables ulogd-ext-access ulogd-ssh ulogd-traceability e2guardian sshd chilli"
	/usr/local/bin/alcasar-logout.sh all # logout everybody
else
	echo "--------------------------------------------------------------------------"
	echo "**                     update/mise à jour d'ALCASAR			**"
	echo "--------------------------------------------------------------------------"
	# unbound, iptables & sshd should stay on to allow remote update
	services="vnstat clamav-daemon clamav-freshclam ntpd httpd radiusd mariadb unbound-blacklist unbound-whitelist unbound-blackhole nfcapd nfsen-ng fail2ban ulogd-ext-access ulogd-ssh ulogd-traceability e2guardian chilli"
	/usr/local/bin/alcasar-bypass.sh -on # to allow remote update + users stay connected during the update
fi

echo "Stopping services : "
# remove daemon watchdog in order to not restart alcasar daemons during the uninstall process
[ -e /etc/cron.d/alcasar-daemon-watchdog ] && rm -f /etc/cron.d/alcasar-daemon-watchdog
/usr/local/bin/alcasar-sms.sh --stop
for i in $services
do
	service_exist=`systemctl list-unit-files | grep ^$i.service | wc -l`
	if [ $service_exist -eq 1 ]; then
		/usr/bin/systemctl disable $i.service
		/usr/bin/systemctl stop $i.service 1>/dev/null
		sleep 1
	else
		echo "The service $i.service doesn't exist !"
	fi
done
echo "Check the service clearing"
for i in $services
do
	if [ `systemctl is-active $i.service` == "active" ]; then
		echo "The service '$i' need to be killed"
		/usr/bin/systemctl stop $i.service
		killall $i
	fi
done

[ $mode == "update" ] && /usr/bin/systemctl reload sshd # reload sshd in case of remote update

echo "Reset ALCASAR main functions : "
for func in init ACC CA time_server init_db freeradius chilli e2guardian antivirus ulogd nfsen vnstat unbound dhcpd cron fail2ban gammu_smsd msec letsencrypt mail_service post_install
do
	echo -en "\n- $func "
	$func
	if [ $DEBUG_ALCASAR == "on" ]; then
		echo -n " *** 'debug' : end removing function '$func' *** "
		read a
	fi
done
if [ $mode == "full" ]; then
	echo -en "\n- network(11) : "
	hostnamectl set-hostname localhost.lan
	chmod a-x /etc/sysconfig/network-scripts/default-*
	i=0
	for nic in `ls /etc/sysconfig/network-scripts/default-*|cut -d'-' -f4`
	do
		i=`expr $i + 1`
		/sbin/ifdown $nic
		[ -e /etc/sysconfig/network-scripts/default-ifcfg-$nic ] && mv -f /etc/sysconfig/network-scripts/default-ifcfg-$nic /etc/sysconfig/network-scripts/ifcfg-$nic && echo -n "$i ($nic), "
	done
	[ -e /etc/sysconfig/network.default ] && mv -f /etc/sysconfig/network.default /etc/sysconfig/network && echo -n "3, "
	[ -e /etc/hosts.default ] && mv -f /etc/hosts.default /etc/hosts && echo -n "4, "
	[ -e /etc/hosts.allow.default ] && mv -f /etc/hosts.allow.default /etc/hosts.allow && echo -n "5, "
	[ -e /etc/hosts.deny.default ] && mv -f /etc/hosts.deny.default /etc/hosts.deny && echo -n "6, "
	[ -e /etc/resolv.conf.default ] && mv -f /etc/resolv.conf.default /etc/resolv.conf && echo -n "7, "
	[ -e /etc/modprobe.preload.default ] && mv -f /etc/modprobe.preload.default /etc/modprobe.preload && echo -n "8, "
	if [ -e /etc/systemd/system/alcasar-network.service ]; then
		rm -f /etc/systemd/system/alcasar-network.service
		echo -n "9, "
	fi
	if [ -e /etc/systemd/system/iptables.service ]; then
		rm -f /etc/systemd/system/iptables.service
		echo -n "10, "
	fi
	[ -e /usr/libexec/iptables.init.default ] && mv -f /usr/libexec/iptables.init.default /usr/libexec/iptables.init && echo -n "11"
	/usr/bin/systemctl restart network
	sleep 1
fi

# Reset "skip.list" (we keep "kernel" in order not to download kernel we don't want to have)
echo "/^kernel/" > /etc/urpmi/skip.list
if [ `grep -E '^exclude=' /etc/dnf/dnf.conf |wc -l` -eq "1" ]; then
	$SED "s?^exclude=.*?exclude=kernel\*?g" /etc/dnf/dnf.conf
else
	echo "exclude=kernel*" >> /etc/dnf/dnf.conf
fi
# Cleaning (remove all "old" alcasar scripts)
echo -en "\n- End of cleaning ...\n"
for rm_fic in /usr/local/bin /usr/local/etc /usr/local/sbin
do
	rm -rf $rm_fic/alcasar*
done
/usr/bin/update-grub2

if [ $mode == "full" ]; then
	echo -n "Waiting for Network to be up again : "
	i=0
	while [ $i -lt 10 ] # We wait 10 seconds max
	do
		echo -n "."
		DNS1=`grep ^nameserver /etc/resolv.conf|awk -F" " '{print $2}'|head -n 1`
		if [ "$DNS1" != "" ] && [ "$DNS1" != "127.0.0.1" ]; then
			i=9
			echo -n "ok"
		fi
		i=`expr $i + 1`
		sleep 1
	done
fi
echo
