#!/bin/bash

# alcasar-rpm.sh
# by 3abtux and Rexy
# This script is distributed under the Gnu General Public License (GPL)

# script de mise en place des dépots RPM + installation des RPM complémentaires
# configure the RPM repository + complementary RPM installation

Lang=`echo $LANG|cut -c 1-2`
SED="/bin/sed -i"
VERSION="9"
ARCH="x86_64"
# The kernel version we compile netflow for
KERNEL="kernel-server-6.6.88-3.mga9"
# ****** Alcasar need RPMS - paquetages nécessaires au fonctionnement d'Alcasar ******
# "fonts-dejavu-common" & "fonts-ttf-dejavu" : fonts needed by wkhtmltopdf
# "lsscsi" & nvme-cli" & "php-dom" : need by phpsysinfo
# "php-rrd" : need by nfsen-ng
# "socat" : avoid a warning when run the install script of letsencrypt ("acme.sh")
# "sudo" : need after a reinstallation (to be investigated)
# "postfix" + "cyrus-sasl" + "lib64sasl2-plug-plain" : email registration method
# "nmap" : "/usr/share/nmap/nmap-mac-prefixes" is used to display MAC manufacturers in ACC

PACKAGES="vim-enhanced freeradius freeradius-mysql freeradius-ldap apache apache-mod_ssl apache-mod_php php-gd php-ldap php-mysqli php-mbstring php-sockets php-curl php-pdo_sqlite php-dom php-filter php-intl php-rrd php-fileinfo php-cli unbound e2guardian postfix mariadb ntpsec bind-utils openssh-server rng-utils rsync fail2ban gnupg2 ulogd ipset usb_modeswitch vnstat dos2unix p7zip msec kernel-userspace-headers kernel-firmware kernel-firmware-nonfree dhcp-server tcpdump fonts-dejavu-common fonts-ttf-dejavu lsscsi nvme-cli sudo socat postfix cyrus-sasl lib64sasl2-plug-plain iftop"

rpm_repository_sync ()
{
	cat <<EOF > /etc/urpmi/urpmi.cfg
{
downloader: wget
}
EOF
	echo ${!MIRRORLIST}
	urpmi.addmedia core --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/core/release
	urpmi.addmedia core-updates --update --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/core/updates
	urpmi.addmedia nonfree --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/nonfree/release
	urpmi.addmedia nonfree-updates --update --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/nonfree/updates
}

rpm_error ()
{
	# restore previous rpm conf file & removed RPMs
	[ -e /etc/urpmi/urpmi.cfg.old ] && mv /etc/urpmi/urpmi.cfg.old /etc/urpmi/urpmi.cfg
	urpmi --no-verify-rpm --auto rpms/$ARCH/wkhtmltopdf*.rpm
	echo
	if [ $Lang == "fr" ]
	then
		echo "Relancez l'installation ultérieurement."
		echo "Si vous rencontrez à nouveau ce problème, modifier les variables MIRRORLIST[1&2] du fichier 'scripts/alcasar-rpm.sh'"
	else
		echo "Try an other install later."
		echo "If this problem occurs again, change the MIRRORLIST[1&2] variables in the file 'scripts/alcasar-rpm.sh'"
	fi
}

# We prefer wget than curl
wget_exist=`rpm -qa|grep wget|wc -l`
if [ "$wget_exist" -eq "0" ]
then
	urpmi --no-verify-rpm --auto rpms/$ARCH/wget*.rpm && rm -f rpms/$ARCH/wget*.rpm
else
	rm -f rpms/$ARCH/wget*.rpm
fi
# Set the RPM repository (if not already set)
cp /etc/urpmi/urpmi.cfg /etc/urpmi/urpmi.cfg.old
ACTIVE_REPO=`cat /etc/urpmi/urpmi.cfg|grep "mageia.org"|wc -l`
MIRROR_NBR=3
#                       For French
MIRRORLIST1="http://ftp.free.fr/mirrors/mageia.org/distrib/$VERSION/$ARCH"
#                       For Europeans
MIRRORLIST2="https://www.mirrorservice.org/pub/mageia/distrib/$VERSION/$ARCH"
#                       For everybody
MIRRORLIST3="https://mirrors.mageia.org/api/mageia.$VERSION.$ARCH.list"
try_nb="0"; nb_repository="0"
while [ "$nb_repository" != "4" ]
do
	try_nb=`expr $try_nb + 1`
	MIRRORLIST="MIRRORLIST$try_nb"
	rpm_repository_sync
	nb_repository=`cat /etc/urpmi/urpmi.cfg|grep mirrorlist|wc -l`
	if [ "$nb_repository" != "4" ]
	then
		if [ $Lang == "fr" ]
		then
			echo "Une erreur a été détectée lors de la synchronisation avec le dépot N°$try_nb."
		else
			echo "An error occurs when synchronising the repositories N°$try_nb"
		fi
		if [ $(expr $try_nb) -eq $MIRROR_NBR ]
		then
			rpm_error
			exit 1
		fi
		if [ $Lang == "fr" ]
		then
			echo "Voulez-vous tenter une synchronisation avec un autre dépôt ? (O/n)"
		else
			echo "Do you want to try a synchronisation with an other repository? (Y/n)"
		fi
		response=0
		PTN='^[oOnNyY]?$'
		until [[ "$response" =~ $PTN ]]
		do
			read response
		done
		if [ "$response" = "n" ] || [ "$response" = "N" ]
		then
			[ -e /etc/urpmi/urpmi.cfg.old ] && mv /etc/urpmi/urpmi.cfg.old /etc/urpmi/urpmi.cfg # restore previous rpm conf file
			exit 1
		fi
	fi
done

# Clean the RPM cache
urpmi --clean

# At this time, we only skip Kernel update
echo "/^kernel/" > /etc/urpmi/skip.list
if [ `grep -E '^exclude=' /etc/dnf/dnf.conf |wc -l` -eq "1" ]; then
	$SED "s?^exclude=.*?exclude=kernel\*?g" /etc/dnf/dnf.conf
else
	echo "exclude=kernel*" >> /etc/dnf/dnf.conf
fi

# download the kernel used by ALCASAR
if [ $Lang == "fr" ]
then
	echo "Récupération du noyau Linux exploité par ALCASAR. Veuillez patienter ..."
else
	echo "Download the Linux kernel used by ALCASAR. Please wait ..."
fi
urpmi --auto --quiet $KERNEL

# download updated RPM in cache
if [ $Lang == "fr" ]
then
	echo "Récupération des paquetages de mise à jour. Veuillez patienter ..."
	echo "Il est temps d'aller prendre un café (ou une bonne bière) ;-)"
else
	echo "Updated RPM download. Please wait ..."
	echo "You should now take a coffe (or a good beer) ;-)"
fi
urpmi --auto --auto-update --quiet --test --retry 2
if [ "$?" != "0" ]
then
	echo
	if [ $Lang == "fr" ]
	then
		echo "Une erreur a été détectée lors de la récupération des paquetages."
	else
		echo "An error occurs when downloading RPMS"
	fi
	rpm_error
	exit 1
fi

# update with cached RPM
urpmi --auto --auto-update
if [ "$?" != "0" ]
then
	echo
	if [ $Lang == "fr" ]
	then
		echo "Une erreur a été détectée lors de la mise à jour des paquetages."
	else
		echo "An error occurs when updating packages"
	fi
	rpm_error
	exit 1
fi

# Download of ALCASAR specifics RPM in cache (and test)
if [ $Lang == "fr" ]
then
	echo "Récupération des paquetages complémentaires. Veuillez patienter ..."
else
	echo "Download of complementary packages. Please wait ..."
fi
urpmi --auto --no-recommends $PACKAGES --quiet --test --retry 2
if [ "$?" != "0" ]
then
	echo
	if [ $Lang == "fr" ]
	then
		echo "Une erreur a été détectée lors de la récupération des paquetages complémentaires."
	else
		echo "An error occurs when downloading complementary packages"
	fi
	rpm_error
	exit 1
fi

# update with cached RPM
urpmi --auto --no-recommends $PACKAGES
if [ "$?" != "0" ]
then
	echo
	if [ $Lang == "fr" ]
	then
		echo "Une erreur a été détectée lors de l'installation des paquetages complémentaires."
	else
		echo "An error occurs when installing complementary packages"
	fi
	rpm_error
	exit 1
fi

# Keep only the kernel version we compil netflow with, and remove all others
kernelVersion=$(rpm -qa | grep -e ^kernel-server -e ^kernel-desktop)
for i in $kernelVersion
do
	if [ $i != $KERNEL ];then
		urpme --auto $i
	fi
done

# delete unused or not usefull RPMs
if [ $Lang == "fr" ]
then
	echo "Cleaning the system : "
else
	echo "Nettoyage du système : "
fi
unused_rpm="shorewall mandi plymouth squid polkit pm-utils dnsmasq clamav clamd clamav-db tracker lighttpd php-fpm"
/usr/sbin/urpme --auto -a $unused_rpm
for distrib in mga7 mga8
do
	for rpm in `rpm -qa|grep $distrib`; do urpme --auto $rpm; done
done
/usr/sbin/urpme --auto --auto-orphans

# Save chilli launch script (erase with new rpm one)
[ -e /etc/chilli.conf ] && cp /etc/chilli.conf /tmp/
# Install home made RPMs
for pkg in `ls rpms/$ARCH/*.rpm|grep -v wget`
do
    urpmi --no-verify --auto $pkg
done
# restore chilli launch script
[ -e /tmp/chilli.conf ] && mv /tmp/chilli.conf /etc/

# Clean the RPM cache
urpmi --clean
# the ipt-netflow RPM add the kernel module ipt_NETFLOW (the modules dependance tree need to be updated). "2>/dev/null" in order not to display a error (the running kernel is not the ALCASAR one during the installation process)
/sbin/depmod -a 2>/dev/null
# test if all needed rpms are correctly installed
count_pkg=0; nb_pkg=0;
for pkg in $PACKAGES
do
	nb_pkg=`expr $nb_pkg + 1`
	if rpm -q --quiet $pkg ; then
		count_pkg=`expr $count_pkg + 1`
	else
		echo "error installing $pkg"
	fi
done
if [ $count_pkg -ne $nb_pkg ]
then
	exit 1
fi

# test if all custom rpms are correctly installed
count_pkg=0; nb_pkg=0;
for pkg in `ls rpms/$ARCH/|sed 's/.x86_64.rpm//'`
do
	nb_pkg=`expr $nb_pkg + 1`
	if rpm -q --quiet $pkg ; then
		count_pkg=`expr $count_pkg + 1`
	else
		echo "error installing $pkg"
	fi
done
if [ $count_pkg -ne $nb_pkg ]
then
	exit 1
fi

# .rpmnew handling (unused with ALCASAR)
[ -e /etc/shadow.rpmnew ] && rm -f /etc/shadow.rpmnew
[ -e /etc/sysconfig/system.rpmnew ] && rm -f /etc/sysconfig/system.rpmnew
[ -e /etc/rpm/macros.rpmnew ] && rm -f /etc/rpm/macros.rpmnew
[ -e /etc/fstab.rpmnew ] && rm -f /etc/fstab.rpmnew
[ -e /etc/shells.rpmnew ] && rm -f /etc/shells.rpmnew
[ -e /etc/hosts.rpmnew ] && rm -f /etc/hosts.rpmnew
[ -e /etc/systemd/journald.conf.rpmnew ] && rm -f /etc/systemd/journald.conf.rpmnew
[ -e /etc/raddb/certs/dh.rpmnew ] && rm -f /etc/raddb/certs/dh.rpmnew

# .rpmnew handling (used with ALCASAR)
[ -e /etc/php.ini.rpmnew ] && mv -f /etc/php.ini.rpmnew /etc/php.ini.default
[ -e /etc/e2guardian/e2guardian.conf.rpmnew ] && mv -f /etc/e2guardian/e2guardian.conf.rpmnew /etc/e2guardian/e2guardian.conf.default
[ -e /etc/e2guardian/e2guardianf1.conf.rpmnew ] && mv -f /etc/e2guardian/e2guardianf1.conf.rpmnew /etc/e2guardian/e2guardianf1.conf.default
[ -e /etc/e2guardian/lists/urlregexplist.rpmnew ] && mv -f /etc/e2guardian/lists/urlregexplist.rpmnew /etc/e2guardian/lists/urlregexplist.default
[ -e /etc/e2guardian/lists/bannedregexpurllist.rpmnew ] && mv -f /etc/e2guardian/lists/bannedregexpurllist.rpmnew /etc/e2guardian/lists/bannedregexpurllist.default
[ -e /etc/vnstat.conf.rpmnew ] && mv -f /etc/vnstat.conf.rpmnew /etc/vnstat.conf.default
[ -e /etc/fail2ban/jail.conf.rpmnew ] && mv -f /etc/fail2ban/jail.conf.rpmnew /etc/fail2ban/jail.conf.default
[ -e /etc/ssh/sshd_config.rpmnew ] && mv -f /etc/ssh/sshd_config.rpmnew /etc/ssh/sshd_config.default

exit 0
