#!/bin/bash
# $Id: alcasar-profil.sh 2606 2018-08-20 00:11:49Z tom.houdayer $

# alcasar-profil.sh
# by Richard REY
# This script is distributed under the Gnu General Public License (GPL)

# Gestion des comptes liés aux profiles
# Manage the profil logins

DIR_BIN="/usr/local/bin" # scripts directory
ADM_PROFIL="admin"
PROFILS="backup manager"
ALL_PROFILS=`echo $ADM_PROFIL $PROFILS`
DIR_KEY="/usr/local/etc/digest"
SED="/bin/sed -i"
Lang=`echo $LANG|cut -c 1-2`
REALM="ALCASAR Control Center (ACC)"

# génère le htdigest
function htdigest () {
	passwdfile="$1"
	username="$2"

	[ -f "$passwdfile" ] || touch "$passwdfile"

	grep -q "${username}:${REALM}:" "$passwdfile" && existing_user=1 || existing_user=0

	if [ $existing_user -eq 1 ]; then
		echo "Changing password for user $username in realm $REALM"
	else
		echo "Adding user $username in realm $REALM"
	fi

	equal=0
	while [ $equal -eq 0 ]; do
		echo -n "New password: "
		read -s pass_1
		echo
		echo -n "Confirm the new password: "
		read -s pass_2
		echo

		if [ -n "$pass_1" ] && [ "$pass_1" != "$pass_2" ]; then
			echo -e "\nThe passwords don't match.\n"
		else
			equal=1
		fi
	done

	digest="${username}:${REALM}:"
	digest+=$(echo -n "${username}:${REALM}:${pass_1}" | md5sum | cut -d" " -f1)

	if [ $existing_user -eq 0 ]; then
		echo "$digest" >> "$passwdfile"
	else 
		sed -i "s/${username}:${REALM}:.*/${digest}/" "$passwdfile"
	fi
}

# liste les comptes de chaque profile
function list () {
	for i in $ALL_PROFILS
	do
		if [ $Lang == "fr" ]
			then
			echo -n "Comptes liés au profil '$i' : "

		else
			echo -n "accounts linked with profile '$i' : "
		fi
		account_list=`cat $DIR_KEY/key_only_$i | cut -d':' -f1|sort`
		for account in $account_list
		do
			echo -n "$account "
		done
	echo
	done
}
# ajoute les comptes du profil "admin" aux autres profils
# crée le fichier de clés contenant tous les compte (pour l'accès au centre de gestion)
function concat () {
	> $DIR_KEY/key_all
	for i in $PROFILS
	do
		cp -f $DIR_KEY/key_only_$ADM_PROFIL $DIR_KEY/key_$i
		cat $DIR_KEY/key_only_$i >> $DIR_KEY/key_$i
		cat $DIR_KEY/key_only_$i >> $DIR_KEY/key_all
	done
	cp -f $DIR_KEY/key_only_$ADM_PROFIL $DIR_KEY/key_$ADM_PROFIL
	cat $DIR_KEY/key_only_$ADM_PROFIL >> $DIR_KEY/key_all
	chown -R root:apache $DIR_KEY
	chmod 640 $DIR_KEY/key_*
}

usage="Usage: alcasar-profil.sh [-l|--list] [-a|--add [profil]] [-d|--del] [-p|--pass]"
nb_args=$#
arg1=$1
arg2=$2

# on met en place la structure minimale
if [ ! -e $DIR_KEY/key_$ADM_PROFIL ]
then
	touch $DIR_KEY/key_$ADM_PROFIL
fi
cp -f $DIR_KEY/key_$ADM_PROFIL $DIR_KEY/key_only_$ADM_PROFIL
for i in $PROFILS
do
	if [ ! -e $DIR_KEY/key_only_$i ]
	then
		touch $DIR_KEY/key_only_$i
	fi
done
concat
if [ $nb_args -eq 0 ]
then
	echo $usage
	exit 0
fi
case $arg1 in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	--add|-a)
		if [ $nb_args -eq 1 ]
		then
			# ajout d'un compte
			list
			if [ $Lang == "fr" ]
			then
				echo -n "Choisissez un profil ($ALL_PROFILS) : "
			else
				echo -n "Select a profile ($ALL_PROFILS) : "
			fi
			profil=''
			while [ -z "$profil" ]; do
				read profil
			done
		else
			profil="$2"
		fi

		if ! echo $ALL_PROFILS | grep -qw $profil
		then
			if [ $Lang == "fr" ]
			then
				echo "Le profil indiqué n'existe pas"
			else
				echo "The given profile doesn't exist"
			fi
			exit 1
		fi

		if [ $Lang == "fr" ]
		then
			echo -n "Entrez le nom du compte à créer (profil '$profil') : "
		else
			echo "Enter the name of the account to create (profile '$profil') : "
		fi
		account=''
		while [ -z "$account" ]; do
			read account
		done
		# TODO : add check
		# on teste s'il n'existe pas déjà
		for i in $ALL_PROFILS
		do
			tmp_account=`cat $DIR_KEY/key_only_$i | cut -d':' -f1`
			for j in $tmp_account
				do
				if [ "$j" = "$account" ]
					then if [ $Lang == "fr" ]
						then
							echo "Ce compte existe déjà"
						else
							echo "This account already exists"
						fi
					exit 1
				fi
				done
		done
		htdigest $DIR_KEY/key_only_$profil "$account"
		concat
		list
		;;
	--del|-d)
		# suppression d'un compte
		list
		if [ $Lang == "fr" ]
		then
			echo -n "entrez le nom du compte à supprimer : "
		else
			echo -n "enter the name of the account to remove : "
		fi
		account=''
		while [ -z "$account" ]; do
			read account
		done
		for i in $ALL_PROFILS; do
			$SED "/^$account:/d" $DIR_KEY/key_only_$i
		done
		concat
		list
		;;
	--pass|-p)
		# changement du mot de passe d'un compte
		list
		if [ $Lang == "fr" ]
		then
			echo "Changement de mot de passe"
			echo -n "Entrez le nom du compte : "
		else
			echo "Password change"
			echo -n "Enter the name of the account : "
		fi
		read account
		for i in $ALL_PROFILS
		do
			tmp_account=`cat $DIR_KEY/key_only_$i | cut -d':' -f1`
			for j in $tmp_account
				do
				if [ "$j" = "$account" ]
				then
					htdigest $DIR_KEY/key_only_$i "$account"
				fi
				done
		done
		concat
		;;
	--list|-l)
		# liste des comptes par profil
		list
		;;
	*)
		if [ $Lang == "fr" ]
		then
			echo "Argument inconnu :$1";
		else
			echo "Unknown argument : $i";
		fi
		echo "$usage"
		exit 1
		;;
esac
