#!/bin/bash

# alcasar-network.sh
# by Pierre RIVAULT and Rexy
# This script is distributed under the Gnu General Public License (GPL)

# Met à jour la configuration réseau conformément au fichier de configuration (alcasar.conf)
# update network configuration according to alcasar.conf

CONF_FILE="/usr/local/etc/alcasar.conf"
TMP_ip_gw_save="/tmp/ipset_ip_gw_save"
DOMAIN=`grep ^DOMAIN= $CONF_FILE|cut -d"=" -f2`
EXTIF=`grep ^EXTIF= $CONF_FILE|cut -d"=" -f2`
PUBLIC_IP=`grep ^PUBLIC_IP= $CONF_FILE|cut -d"=" -f2`
if [ $PUBLIC_IP != "dhcp" ]; then
	GW1=`grep ^GW= $CONF_FILE|cut -d"=" -f2`
	MTU=`grep ^PUBLIC_MTU= $CONF_FILE|cut -d"=" -f2`
	MULTIWAN=`grep ^MULTIWAN= $CONF_FILE|cut -d"=" -f2`
	MULTIWAN=${MULTIWAN:=off}
	NET="`ipcalc -n $PUBLIC_IP | cut -d"=" -f2`/`ipcalc -p $PUBLIC_IP | cut -d"=" -f2`"
	IP=`echo $PUBLIC_IP | cut -d"/" -f1`
	PRIVATE_IP_MASK=`grep ^PRIVATE_IP $CONF_FILE | cut -d"=" -f2`
	PRIVATE_IP=`echo $PRIVATE_IP_MASK | cut -d"/" -f1`
	PRIVATE_NETMASK=`echo $PRIVATE_IP_MASK | cut -d"/" -f2`
	PRIVATE_PREFIX=`/bin/ipcalc -p $PRIVATE_IP $PRIVATE_NETMASK |cut -d"=" -f2`	# prefixe du réseau (ex. 24)
	PRIVATE_NETWORK=`/bin/ipcalc -n $PRIVATE_IP $PRIVATE_NETMASK| cut -d"=" -f2`	# @ réseau de consultation (ex.: 192.168.182.0)
	PRIVATE_NETWORK_MASK=$PRIVATE_NETWORK/$PRIVATE_PREFIX				# @ + masque du réseau de consult (192.168.182.0/24)
	nb_gw=`grep ^WAN $CONF_FILE | wc -l`
fi
routecmd="ip route replace default scope global"

if [ $(whoami) != "root" ]; then
	echo "You must be root to run this!" ; echo ; exit 1
fi

if [ $# -eq 0 ]; then
	args="--apply"
else
	args=$1
fi

case $args in
	--save)	# save all the IP before changing the configuration
		rm -f $TMP_ip_gw_save
		gw_list="gw0"	# ipset name list for load_balancing
		for ((i=1 ; i<=$nb_gw ; i++)); do
			gw_list="${gw_list} gw$i"
		done
		# Saving all of the already connected IP in order to put them back in the load balancing after
		for i in $gw_list;do
			ipset list $i 1>/dev/null 2>&1
			if [ $? -eq 0 ]
			then
				# the cut -d":" -f5 deletes all the lines with a :, i.e all the lines except the members
				ipset list $i | grep -v ":" >> $TMP_ip_gw_save
			fi
		done
	exit 0
	;;
	--apply)
		[ -e /etc/sysconfig/network-scripts/ifcfg-$EXTIF ] && ifdown $EXTIF
		# set the new configuration for EXTIF
		if [ $PUBLIC_IP == "dhcp" ]; then
			cat <<EOF > /etc/sysconfig/network-scripts/ifcfg-$EXTIF
DEVICE=$EXTIF
BOOTPROTO=dhcp
DNS1=127.0.0.1
PEERDNS=no
RESOLV_MODS=yes
ONBOOT=yes
NOZEROCONF=yes
METRIC=10
MII_NOT_SUPPORTED=yes
IPV6INIT=no
IPV6TO4INIT=no
ACCOUNTING=no
USERCTL=no
MTU=$MTU
EOF
			ifup $EXTIF
		else
			cat <<EOF > /etc/sysconfig/network-scripts/ifcfg-$EXTIF
DEVICE=$EXTIF
BOOTPROTO=static
IPADDR=$IP
NETMASK=`ipcalc -m $PUBLIC_IP | cut -d= -f2`
NETWORK=`ipcalc -n $PUBLIC_IP | cut -d= -f2`
GATEWAY=$GW1
DNS1=127.0.0.1
RESOLV_MODS=yes
ONBOOT=yes
METRIC=10
MII_NOT_SUPPORTED=yes
IPV6INIT=no
IPV6TO4INIT=no
ACCOUNTING=no
USERCTL=no
MTU=$MTU
NOZEROCONF=yes
EOF
			ifup $EXTIF
			ip route flush ${NET}	# Remove the previous route for the network of EXTIF
			ip route delete default scope global	# Remove the previous default route
			ip route add ${NET} dev ${EXTIF} src ${IP}	 # Set the new route for EXTIF network
			ip route add ${NET} dev ${EXTIF} src ${IP} table 200	# Set the new default route. If no multiwan, these lines are equivalent to `ip route add default via ${GW1}`
			ip route add default via ${GW1} table 200
			routecmd="${routecmd} nexthop via ${GW1} dev ${EXTIF}"
			ip rule flush	# Remove the previous routing rules
			ip rule add from all lookup main pref 32766	# Set back the main rules
			ip rule add from all lookup default pref 32767	# Set back the default rules
			ip rule add from ${PRIVATE_NETWORK_MASK} fwmark 200 lookup 200	# Add the rule for the first gateway
			if [ "$MULTIWAN" == "on" ] || [ "$MULTIWAN" == "On" ]; then
				nb_gw_supp=`grep ^WAN $CONF_FILE|wc -l`
				for ((i=0 ; $i < $nb_gw_supp ; i++)); do
					table=$(($i + 201))	# This number is used to mark the paquets in order to route them to the choosen GW 
					GW=`grep ^WAN$(($i + 1))= $CONF_FILE|awk -F'"' '{ print $2 }' | awk -F, '{print $1}'`
					ip route add ${NET} dev ${EXTIF} src ${IP} table $table	# Add the others route in their respective tables
					ip route add default via ${GW} table $table
					ip rule add from ${PRIVATE_NETWORK_MASK} fwmark $table lookup $table	# Add the rule for each rule depending of the mark set by the firewall
					routecmd="${routecmd} nexthop via ${GW} dev ${EXTIF}"	# add the added gateway into the default gateway
				done
			fi
			${routecmd}	# define the default gateway for outgoing traffic
			ip route flush cache
		fi
		/usr/local/bin/alcasar-iptables.sh
		# write resolv.conf
		cat <<EOF > /etc/resolv.conf
# Basic resolv.conf : ALCASAR ask its local DNS servers (unbound)
search $DOMAIN
nameserver 127.0.0.1
EOF
		exit 0
		;;
	*)
		exit 1
		;;
esac
