#!/bin/sh
#
# $Id: alcasar-macup.sh 3269 2025-04-21 21:57:13Z rexy $
#
# alcasar-macup.sh
#
# This script is distributed under the Gnu General Public License (GPL)

PASSWD_FILE="/root/ALCASAR-passwords.txt"

if [ -z "$CALLING_STATION_ID" ]; then
	exit 1
fi

dbRootPass=$(grep ^db_root= $PASSWD_FILE | cut -d'=' -f2-)

chilli_query_res=$(chilli_query list mac $CALLING_STATION_ID)
[ -z "$chilli_query_res" ] && exit

is_connected=$(echo "$chilli_query_res" | awk '{ print $5 }')
current_mac=$CALLING_STATION_ID

if [ $is_connected == '0' ]; then
	db_query="SELECT username, IFNULL((UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(acctstoptime)), 0) AS timeout, acctterminatecause FROM radacct WHERE callingstationid='$current_mac' ORDER BY acctstarttime DESC LIMIT 1;"
	db_res=$(mariadb -u root -p"$dbRootPass" -D radius -e "$db_query" -Bs)

	if [ -n "$db_res" ]; then
		username=$(echo "$db_res"           | cut -f1)
		timeout=$(echo "$db_res"            | cut -f2)
		acctterminatecause=$(echo "$db_res" | cut -f3)

		if [ "$acctterminatecause" != "User-Request" ]; then
			db_query_additionalGroups=''
			[ -n "$FILTER_ID" ] && db_query_additionalGroups="( SELECT attribute, value FROM radgroupreply WHERE groupname = '$FILTER_ID' AND (attribute='Alcasar-Reconnect-Timeout') ) UNION "
			db_query="SELECT attribute, value FROM ( \
				( SELECT attribute, value FROM radreply      WHERE username  = '$USER_NAME' AND (attribute='Alcasar-Reconnect-Timeout') ) UNION \
				( SELECT attribute, value FROM radgroupreply gr LEFT JOIN radusergroup ug ON gr.groupname = ug.groupname WHERE username = '$USER_NAME' AND (attribute='Alcasar-Reconnect-Timeout') ORDER BY ug.priority ) UNION \
				$db_query_additionalGroups \
				( SELECT attribute, value FROM radgroupreply WHERE groupname = 'default'    AND (attribute='Alcasar-Reconnect-Timeout') ) \
			) attrs GROUP BY attribute;"
			db_res=$(mariadb -u root -p"$dbRootPass" -D radius -e "$db_query" -Bs)

			reconnectTimeout=$(echo "$db_res" | awk '$1 == "Alcasar-Reconnect-Timeout" { print $2 }')

			if [ -n "$reconnectTimeout" ] && [ $timeout -le $reconnectTimeout ]; then
				for i in {1..10}; do
					sleep 1
					chilli_query authorize mac $current_mac username "$username"
					chilli_query_res=$(chilli_query list mac $current_mac)
					isPassing=$(echo "$chilli_query_res"    | awk '{ print $3 }')
					is_connected=$(echo "$chilli_query_res" | awk '{ print $5 }')
					if [ "$is_connected" == '1' ] && [ "$isPassing" == 'pass' ]; then
						logger -t alcasar-macup "The MAC address \"$current_mac\" is reconnected with user \"$username\"."
						break
					fi
				done
			fi
		fi
	fi
fi
