#!/bin/bash
# $Id: alcasar-iptables-bypass.sh 3190 2024-04-07 22:35:03Z rexy $

# alcasar-iptables-bypass.sh
# by Rexy - 3abtux
# This script is distributed under the Gnu General Public License (GPL)

# Applique les regles du parefeu en mode ByPass
# Set the firewall rules in 'ByPass' mode

CONF_FILE="/usr/local/etc/alcasar.conf"
private_ip_mask=`grep ^PRIVATE_IP= $CONF_FILE|cut -d"=" -f2`
private_ip_mask=${private_ip_mask:=192.168.182.1/24}
private_network=`/bin/ipcalc -n $private_ip_mask|cut -d"=" -f2`		# LAN IP address (ie.: 192.168.182.0)
private_prefix=`/bin/ipcalc -p $private_ip_mask|cut -d"=" -f2`		# LAN prefix (ie. 24)
IPTABLES="/sbin/iptables"
EXTIF=`grep ^EXTIF= $CONF_FILE|cut -d"=" -f2`				# EXTernal InterFace
INTIF=`grep ^INTIF= $CONF_FILE|cut -d"=" -f2`				# INTernal InterFace
TUNIF="tun0"								# listen device for chilli daemon
PRIVATE_NETWORK_MASK=$private_network/$private_prefix			# Lan IP address + prefix (192.168.182.0/24)
PRIVATE_IP=`echo $private_ip_mask | cut -d"/" -f1`			# ALCASAR LAN IP address
public_ip_mask=`grep ^PUBLIC_IP= $CONF_FILE|cut -d"=" -f2`		# ALCASAR WAN IP address
if [[ "$public_ip_mask" == "dhcp" ]]
then
	PTN="\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\/([012]?[0-9]|3[0-2])\b"
	public_ip_mask=`ip addr show $EXTIF | grep -o -E $PTN`
fi
PUBLIC_IP=`echo $public_ip_mask | cut -d"/" -f1`
SSH_LAN=`grep ^SSH_LAN= $CONF_FILE|cut -d"=" -f2`			# SSH LAN port
SSH_LAN=${SSH_LAN:=0}
SSH_WAN=`grep ^SSH_WAN= $CONF_FILE|cut -d"=" -f2`		# SSH WAN port
SSH_WAN=${SSH_WAN:=0}
SSH_WAN_ADMIN_FROM=`grep ^SSH_ADMIN_FROM= $CONF_FILE|cut -d"=" -f2|cut -d"/" -f2`
SSH_WAN_ADMIN_FROM=${SSH_WAN_ADMIN_FROM:="0.0.0.0"}
SSH_WAN_ADMIN_FROM=$([ "$SSH_WAN_ADMIN_FROM" == "0.0.0.0" ] && echo "0.0.0.0/0" || echo "$SSH_WAN_ADMIN_FROM" )
SSH_LAN_ADMIN_FROM=`grep ^SSH_ADMIN_FROM= $CONF_FILE|cut -d"=" -f2|cut -d"/" -f1`
SSH_LAN_ADMIN_FROM=${SSH_LAN_ADMIN_FROM:="0.0.0.0"}
SSH_LAN_ADMIN_FROM=$([ "$SSH_LAN_ADMIN_FROM" == "0.0.0.0" ] && echo "$PRIVATE_NETWORK_MASK" || echo "$SSH_LAN_ADMIN_FROM" )
interlan=`grep ^INTERLAN= $CONF_FILE|cut -d"=" -f2`
interlan=${interlan:=off}

# On vide (flush) toutes les règles existantes
# Flush all existing rules
$IPTABLES -F
$IPTABLES -t nat -F
$IPTABLES -F INPUT
$IPTABLES -F FORWARD
$IPTABLES -F OUTPUT

# On indique les politiques par défaut
# Default policies
$IPTABLES -P INPUT DROP
$IPTABLES -P FORWARD DROP
$IPTABLES -P OUTPUT ACCEPT
$IPTABLES -t nat -P PREROUTING ACCEPT
$IPTABLES -t nat -P POSTROUTING ACCEPT
$IPTABLES -t nat -P OUTPUT ACCEPT

# On efface toutes les chaînes qui ne sont pas par défaut dans les tables filter et nat
# Flush non default rules on filter and nat tables
$IPTABLES -X
$IPTABLES -t nat -X

# On autorise tout sur loopback
# accept all on loopback
$IPTABLES -A OUTPUT -o lo -j ACCEPT
$IPTABLES -A INPUT -i lo -j ACCEPT

#############################
#         INPUT             #
#############################
# SSHD rules if activate
if [ $SSH_LAN -gt 0 ]
	then
	$IPTABLES -A INPUT -i $INTIF -s $SSH_LAN_ADMIN_FROM -d $PRIVATE_IP -p tcp --dport $SSH_LAN -m conntrack --ctstate NEW -j NFLOG --nflog-group 2 --nflog-prefix "RULE ssh-from-LAN -- ACCEPT"
	$IPTABLES -A INPUT -i $INTIF -s $SSH_LAN_ADMIN_FROM -d $PRIVATE_IP -p tcp --dport $SSH_LAN -j ACCEPT
fi
if [ $SSH_WAN -gt 0 ]
	then
	$IPTABLES -A INPUT -i $EXTIF -s $SSH_WAN_ADMIN_FROM -d $PUBLIC_IP -p tcp --dport $SSH_WAN -m conntrack --ctstate NEW --syn -j NFLOG --nflog-group 2 --nflog-prefix "RULE ssh-from-WAN -- ACCEPT"
	$IPTABLES -A INPUT -i $EXTIF -s $SSH_WAN_ADMIN_FROM -d $PUBLIC_IP -p tcp --dport $SSH_WAN -j ACCEPT
fi

# Insertion de règles locales
# Here, we add local rules (i.e. VPN from Internet)
if [ -f /usr/local/etc/alcasar-iptables-local.sh ]; then
	. /usr/local/etc/alcasar-iptables-local.sh
fi

# on autorise les requêtes dhcp
# accept dhcp
$IPTABLES -A INPUT -i $INTIF -p udp -m udp --sport bootpc --dport bootps -j ACCEPT

# On drop le broadcast et le multicast sur les interfaces (sans Log)
# Drop broadcast & multicast
$IPTABLES -A INPUT -m addrtype --dst-type BROADCAST,MULTICAST -j DROP

# On autorise l'accès aux services internes
# Allow Internal access
$IPTABLES -A INPUT -i $INTIF -s $PRIVATE_NETWORK_MASK -d $PRIVATE_IP -p udp --dport domain -j ACCEPT	# DNS
$IPTABLES -A INPUT -i $INTIF -s $PRIVATE_NETWORK_MASK -d $PRIVATE_IP -p tcp --dport domain -j ACCEPT	# DNS
$IPTABLES -A INPUT -i $INTIF -s $PRIVATE_NETWORK_MASK -d $PRIVATE_IP -p icmp --icmp-type 8 -j ACCEPT	# Réponse ping # ping responce
$IPTABLES -A INPUT -i $INTIF -s $PRIVATE_NETWORK_MASK -d $PRIVATE_IP -p icmp --icmp-type 0 -j ACCEPT	# Requête  ping # ping request
$IPTABLES -A INPUT -i $INTIF -s $PRIVATE_NETWORK_MASK -d $PRIVATE_IP -p tcp --dport https -j ACCEPT	# ACC
$IPTABLES -A INPUT -i $INTIF -s $PRIVATE_NETWORK_MASK -d $PRIVATE_IP -p tcp --dport http -j ACCEPT	# ACC
$IPTABLES -A INPUT -i $INTIF -s $PRIVATE_NETWORK_MASK -d $PRIVATE_IP -p udp --dport ntp -j ACCEPT	# Serveur local de temps # local time server

# On autorise le retour des connexions entrante déjà acceptées
$IPTABLES -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT

# On interdit et on log le reste sur les 2 interfaces d'accès
$IPTABLES -A INPUT -i $INTIF -j NFLOG --nflog-group 1 --nflog-prefix "RULE rej-int -- REJECT "
$IPTABLES -A INPUT -i $EXTIF -j NFLOG --nflog-group 1 --nflog-prefix "RULE rej-ext -- REJECT "
$IPTABLES -A INPUT -p tcp -j REJECT --reject-with tcp-reset
$IPTABLES -A INPUT -p udp -j REJECT --reject-with icmp-port-unreachable

#############################
#        FORWARD            #
#############################
# On autorise les retours de connexions légitimes par FORWARD
# Conntrack on forward
$IPTABLES -A FORWARD -m state --state RELATED,ESTABLISHED -j ACCEPT

# On autorise (ou pas) les utilisateurs à accéder au réseau situé entre ALCASAR et le routeur Internet
# Users are allowed (or not allowed) to access the network between ALCASAR and the Internet router
if [ "$interlan" != "on" ]
then
	$IPTABLES -A FORWARD -i $TUNIF -d $public_ip_mask -j DROP
fi

# Insertion de règles de blocage
# Here, we add block rules
if [ -s /usr/local/etc/alcasar-ip-blocked ]; then
	while read ip_line
	do
		ip_on=`echo $ip_line|cut -b1`
		if [ $ip_on != "#" ]
		then	
			ip_blocked=`echo $ip_line|cut -d" " -f1`
			$IPTABLES -A FORWARD -d $ip_blocked -j NFLOG --nflog-group 1 --nflog-prefix "RULE IP-blocked -- REJECT "
			$IPTABLES -A FORWARD -d $ip_blocked -j REJECT
		fi
	done < /usr/local/etc/alcasar-ip-blocked
fi

# On autorise les demandes de connexions sortantes
$IPTABLES -A FORWARD -i $INTIF -m state --state NEW -j NFLOG --nflog-group 1 --nflog-prefix "RULE Transfert -- ACCEPT "
$IPTABLES -A FORWARD -i $INTIF -m state --state NEW -j ACCEPT

#############################
#       POSTROUTING         #
#############################
# On active le masquage d'adresse par translation (NAT)
$IPTABLES -A POSTROUTING -t nat -o $EXTIF -j MASQUERADE

# on ne sauvegarde pas les règles. En cas de reboot, on repasse ainsi automatiquement en mode normal (bypass -off)
# Fin du script des regles du parefeu
