#!/bin/bash

# alcasar-iot_capture.sh
# by Guillaume Gellusseau, Dorian Lemoine & REXY
# This script is distributed under the Gnu General Public License (GPL)

# Ce script lance une capture de flux réseau en fonction d'une adresse IP source ($1) 
# This script performs a network flow capture based on source ip address ($1) 

CONF_FILE="/usr/local/etc/alcasar.conf"
INTIF=`grep ^INTIF= $CONF_FILE|cut -d"=" -f2`
PRIVATE_IP=$(grep ^PRIVATE_IP= $CONF_FILE | cut -d'=' -f2 | cut -d'/' -f1)

function info
{
	_PID=$(ps -ef | grep tcpdump | grep $1 | awk {'print $2'})
	if [[ -n $_PID ]]
	then
		echo "CaptureON"
	else
		echo "CaptureOFF"
	fi 
}

function kill
{
	_PID=$(ps -ef | grep tcpdump | grep $1 | awk {'print $2'})
	sudo kill -2 $_PID
}

function launch
{
# capture only one @MAC, on $INTIF, max filesize=10M, without flows to PRIVATE_IP except DNS
	sudo tcpdump "ether host $1 and (host not $PRIVATE_IP or port 53)" -i $INTIF -n -C 10 -W 1 -w /var/Save/iot_captures/$1.pcap
}

function flush
{
	sudo rm /var/Save/iot_captures/$1.pcap -f
}


while getopts "l k i f" option; do

	case "${option}" in

		l)
			launch $2
			;;
		k)
			kill $2
			;;
		i)
			info $2
			;;
		f)
			flush $2
			;;
	esac
done

#End
