#!/bin/bash
# $Id: alcasar-https.sh 3294 2025-07-20 22:26:38Z rexy $

# alcasar-https.sh
# by Rexy
# This script is distributed under the Gnu General Public License (GPL)

# active ou désactive le chiffrement sur les flux d'authentification
# enable or disable encryption on authentication flows

SED="/bin/sed -i"
CONF_FILE="/usr/local/etc/alcasar.conf"
CHILLI_CONF_FILE="/etc/chilli.conf"
HTTPD_CONF_FILE="/etc/httpd/conf/sites.d/alcasar.conf"
HTTPD_80_CONF_FILE="/etc/httpd/conf/sites.d/00_default_vhosts.conf"
HOSTNAME=$(grep ^HOSTNAME= $CONF_FILE | cut -d'=' -f2)
DOMAIN=$(grep ^DOMAIN= $CONF_FILE | cut -d'=' -f2)

usage="Usage: alcasar-https.sh {--on | -on} | {--off | -off}"
nb_args=$#
args=$1
if [ $nb_args -eq 0 ]
then
	echo "$usage"
	exit 1
fi

case $args in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	--off | -off)	# Chilli : disable HTTPS (it will listen only on 3990 port) + Apache : remove "requireSSL" & redirection directive
		$SED "s?^HTTPS_LOGIN=.*?HTTPS_LOGIN=off?" $CONF_FILE
		$SED "s?^HTTPS_CHILLI=.*?HTTPS_CHILLI=off?" $CONF_FILE
		$SED "s?^uamserver.*?uamserver\thttp://$HOSTNAME.$DOMAIN/intercept.php?" $CHILLI_CONF_FILE
		$SED "s?^redirssl.*?#&?" $CHILLI_CONF_FILE
		$SED "s?^uamuissl.*?#&?" $CHILLI_CONF_FILE
		/usr/bin/systemctl restart chilli
		$SED "/<Directory \/var\/www\/html>/{n;/SSLRequireSSL/{d;};}" $HTTPD_CONF_FILE
		$SED "/redirect/d" $HTTPD_80_CONF_FILE
		/usr/bin/systemctl restart httpd
		;;
	--on | -on)	# Chilli : enable HTTPS (it will listen on ports 3990 (http) and 3991 (https) + apache : add "requireSSL" & redirection directive
		$SED "s?^HTTPS_LOGIN=.*?HTTPS_LOGIN=on?" $CONF_FILE
		$SED "s?^HTTPS_CHILLI=.*?HTTPS_CHILLI=on?" $CONF_FILE
		$SED "s?^uamserver.*?uamserver\thttps://$HOSTNAME.$DOMAIN/intercept.php?" $CHILLI_CONF_FILE
		$SED "s?^#redirssl.*?redirssl?" $CHILLI_CONF_FILE
		$SED "s?^#uamuissl.*?uamuissl?" $CHILLI_CONF_FILE
		/usr/bin/systemctl restart chilli
		$SED "/<Directory \/var\/www\/html>/{n;/SSLRequireSSL/{d;};}" $HTTPD_CONF_FILE # remove if already exist
		$SED "/<Directory \/var\/www\/html>/a\        SSLRequireSSL" $HTTPD_CONF_FILE
		$SED "/redirect/d" $HTTPD_80_CONF_FILE # remove if already exist
		$SED "/<\/VirtualHost>/i\    redirect permanent \/ https:\/\/$HOSTNAME.$DOMAIN" $HTTPD_80_CONF_FILE
		/usr/bin/systemctl restart httpd
		;;
	*)
		echo "Argument inconnu : $1"
		echo "$usage"
		exit 1
		;;
esac
