#!/bin/bash
# $Id: alcasar-daemon.sh 3269 2025-04-21 21:57:13Z rexy $

# alcasar-daemon.sh
# by Franck BOUIJOUX & Rexy
# This script is distributed under the Gnu General Public License (GPL)
# Watchdog of Services
# With the option "-after-update" checks if services or system need to be restarted after a RPM update
# See /etc/cron.d/alcasar-daemon-watchdog for config the time

conf_file="/usr/local/etc/alcasar.conf"
SMS=`grep ^SMS= $conf_file|cut -d"=" -f2`				# SMS active (on/off)
SMS=${SMS:=off}
LDAP=`grep ^LDAP= $conf_file|cut -d"=" -f2`				# ldap active (on/off)
LDAP=${LDAP:=off}
INTIF=`grep ^INTIF= $conf_file|cut -d"=" -f2`				# INTIF name
EXTIF=`grep ^EXTIF= $conf_file|cut -d"=" -f2`				# EXTIF name
SERVICES="mariadb httpd ntpd unbound unbound-blacklist unbound-whitelist unbound-blackhole radiusd nfcapd nfsen-ng e2guardian ulogd-ssh ulogd-traceability ulogd-ext-access chilli fail2ban sshd vnstat gammu-smsd"
nb_available_srv=`echo $SERVICES|wc -w`

function ServiceTest () {
	service=$1
	if [ $(/usr/bin/systemctl is-active $service) != "active" ]; then
		logger -t alcasar-daemon -i "$service is inactive. Activation attempt"
		echo "the $service service is disabled! trying to start it..."
		if [ $service == 'gammu-smsd' ]; then
			/usr/local/bin/alcasar-sms.sh --start
		fi
		if [ $service == 'sshd' ]; then
			[ -s /etc/ssh/ssh_host_rsa_key ] || rm -f /etc/ssh/ssh_host_* # sometimes sshd doesn't initialise its keys
		fi	
		/usr/bin/systemctl start $service.service
	else
		nb_srv=$((nb_srv+1))
	fi
}

usage="Usage: alcasar-daemon.sh {-after-update}"
case $1 in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	-after-update)
		# TODO : check precisely which processes should be restarted (reboot the system or restart alcasar processes)
		# extract processes name : for i in `dnf needs-restarting|cut -d " " -f3|sort -u|tr -d ":"|rev|cut -d"/" -f1|rev`;do;echo $i;done
		# system_processes=`dnf needs-restarting|grep -E 'dbus|python|systemd|agetty'|wc -l` # processes to be restarted after glibc update 
		nb_processes=`dnf needs-restarting|wc -l`
		if [ $nb_processes -ne 0 ]; then
			reboot
		fi
		;;
	*)
		for NIC in $EXTIF $INTIF
		do
			if [ `/usr/sbin/ip a show $NIC|grep DOWN|wc -l` -eq "1" ]; then
				echo "The network interface card '$NIC' is down! Try to enable it"
				/usr/sbin/ifup $NIC
			fi
		done
		
		nb_srv=0
		for service in $SERVICES; do
			if [ $service == 'gammu-smsd' ]; then
				if [ $SMS != "ON" ] && [ $SMS != "on" ] && [ $SMS != "On" ]; then
					nb_available_srv=$((nb_available_srv-1))
					continue
				fi
			fi
			ServiceTest $service
		done
		
		if [ $nb_available_srv -ne $nb_srv ]; then
			echo "Restart this script to know if all is ok"
		else
			echo "$nb_srv services needed by ALCASAR are started."
		fi
		
		if [ `cat /proc/modules|grep -c ^ipt_NETFLOW` == 0 ]; then
			logger -t alcasar-daemon -i "ipt_netflow is inactive."
			echo "The Log system is disabled! try to know why (modprobe ipt_NETFLOW)"
		else
			echo "The Log system is active"
		fi
		if [ ! -e /etc/raddb/mods-enabled/ldap ]; then
			if [ $LDAP == "ON" ] || [ $LDAP == "on" ] || [ $LDAP == "On" ]; then
				echo "Enabling LDAP..."
				/usr/local/bin/alcasar-ldap.sh -on
			fi
		fi
	;;
esac
