#!/bin/sh
#
# $Id: alcasar-conup.sh 3269 2025-04-21 21:57:13Z rexy $
#
# alcasar-conup.sh
# by Rexy & Pierre RIVAULT
# This script is distributed under the Gnu General Public License (GPL)

# This script is started by coova after each successfull login
# Ce script est démarré par coova à chaque connexion d'usager (authentification réussi)

CONF_FILE="/usr/local/etc/alcasar.conf"
PASSWD_FILE="/root/ALCASAR-passwords.txt"
DB_USER=`cat $PASSWD_FILE|grep ^db_user=|cut -d'=' -f2`
DB_PASSWORD=`cat $PASSWD_FILE|grep ^db_password=|cut -d'=' -f2`

if [ -z $FRAMED_IP_ADDRESS ]; then
	exit 1
fi

# Retrieve 3 alcasar special radius attributes (search order : default group, then user's group, then user)
db_query="SELECT attribute, value FROM ( \
 	( SELECT attribute, value FROM radreply WHERE username = '$USER_NAME' AND (attribute IN ('Alcasar-Filter', 'Alcasar-Protocols-Filter', 'Alcasar-Status-Page-Must-Stay-Open')) ) UNION \
	( SELECT attribute, value FROM radgroupreply gr LEFT JOIN radusergroup ug ON gr.groupname = ug.groupname WHERE username = '$USER_NAME' AND (attribute IN ('Alcasar-Filter', 'Alcasar-Protocols-Filter', 'Alcasar-Status-Page-Must-Stay-Open')) ORDER BY ug.priority ) UNION \
	( SELECT attribute, value FROM radgroupreply WHERE groupname = 'default' AND (attribute IN ('Alcasar-Filter', 'Alcasar-Protocols-Filter', 'Alcasar-Status-Page-Must-Stay-Open')) ) \
) attrs GROUP BY attribute;"
db_res=$(mariadb -u$DB_USER -p$DB_PASSWORD -D radius -e "$db_query" -Ns)

filter=$(echo "$db_res"             | awk '$1 == "Alcasar-Filter"                     { print $2 }')
filterProto=$(echo "$db_res"        | awk '$1 == "Alcasar-Protocols-Filter"           { print $2 }')
statusPageRequired=$(echo "$db_res" | awk '$1 == "Alcasar-Status-Page-Must-Stay-Open" { print $2 }')


# Add user to his IPSET
if [ "$filter" == '4' ]; then	# AV_WL
	set_filter="av_wl"
elif [ "$filter" == '3' ]; then	# AV_BL
	set_filter="av_bl"
elif [ "$filter" == '2' ]; then	# AV
	set_filter="av"
else				# NOT_FILTERED
	set_filter="not_filtered"
fi

if [ "$filterProto" == '4' ]; then	# PROFILE 3 (Custom)
	set_filterProto="proto_3";
elif [ "$filterProto" == '3' ]; then	# PROFILE 2 (WEB + Mail + Remote access)
	set_filterProto="proto_2";
elif [ "$filterProto" == '2' ]; then	# PROFILE 1 (WEB)
	set_filterProto="proto_1";
else					# PROFILE 0 (Not filtered)
	set_filterProto="proto_0";
fi

# Add user to his IPSET
ipset add $set_filter      $FRAMED_IP_ADDRESS
ipset add $set_filterProto $FRAMED_IP_ADDRESS

# If status page isn't required :
#	-add user_IP with flag PERM in /tmp/current_users.txt (watchdog remove these @IP at midnight)
#	if the user has the "Expiration" attribute, add its @MAC as an authenticated user (with the same user's attributes)
if [ "$statusPageRequired" == '2' ]; then	# Status page is not required
	current_users_file="/tmp/current_users.txt"
	if [ ! -e $current_users_file ]; then
		touch $current_users_file && chown root:apache $current_users_file && chmod 660 $current_users_file
    fi
	echo "$FRAMED_IP_ADDRESS:PERM" >> $current_users_file
fi

# set the user_ip to an gw_ipset for load-balancing
gw_min="gw0"
weight=`grep ^PUBLIC_WEIGHT= $CONF_FILE | cut -d"=" -f2`
already=`ipset list $gw_min | grep Number\ of\ entries: | cut -d":" -f2`
#The *1000 is here to avoid working on floats in bash
gw_min_value=$((1000 * $already / $weight))

nb_gw=`grep ^WAN $CONF_FILE | wc -l`
for (( i = 1 ; i <= $nb_gw ; i++ ));do
	gw="gw${i}"
	weight=`grep ^WAN$i= $CONF_FILE | awk -F'"' '{ print $2 }' | awk -F ',' '{ print $2 }'`
	already=`ipset list $gw | grep Number\ of\ entries: | cut -d":" -f2`
	value=$((1000 * $already / $weight))
	if [ $value -lt $gw_min_value ]
	then
		gw_min_value=$value
		gw_min=$gw
	fi
done
ipset add $gw_min $FRAMED_IP_ADDRESS

#############################
## Debug : show all the coova parse variables (+ ALCASAR-Filter + ALCASAR-Protocols-Filter + Alcasar-Status-Page-Must-Stay-Open).
## see "/src/chilli.c" for the complete list of parse variables
#debug_file="/tmp/debug-conup.txt"
#echo "-----------------------------------------------" >> $debug_file
#echo `date` >> $debug_file
#for i in DEV NET MASK ADDR USER_NAME NAS_IP_ADDRESS SERVICE_TYPE FRAMED_IP_ADDRESS FILTER_ID STATE CLASS CUI SESSION_TIMEOUT IDLE_TIMEOUT CALLING_STATION_ID CALLED_STATION_ID NAS_ID NAS_PORT_TYPE ACCT_SESSION_ID ACCT_INTERIM_INTERVAL WISPR_LOCATION_ID WISPR_LOCATION_NAME WISPR_BANDWIDTH_MAX_UP WISPR_BANDWIDTH_MAX_DOWN COOVACHILLI_MAX_INPUT_OCTETS COOVACHILLI_MAX_OUTPUT_OCTETS COOVACHILLI_MAX_TOTAL_OCTETS INPUT_OCTETS OUTPUT_OCTETS INPUT_PACKETS OUTPUT_PACKETS SESSION_TIME IDLE_TIME LOCATION OLD_LOCATION TERMINATE_CAUSE
#do
#	echo -n "$i=" >> $debug_file
#	if [[ -v $i ]];
#	then
#		echo -n "${!i}; " >> $debug_file
#	else
#		echo -n "not defined; " >> $debug_file
#	fi
#done
#echo >> $debug_file
#echo "ALCASAR-Filter : $set_filter" >> $debug_file
#echo "ALCASAR-Protocols-Filter : $set_filterProto" >> $debug_file
#echo "Alcasar-Status-Page-Must-Stay-Open : $statusPageRequired" >> $debug_file
## END DEBUG
#################################
