#!/bin/bash
# $Id: alcasar-conf.sh 3312 2026-01-07 13:52:38Z rexy $

# alcasar-conf.sh
# by REXY
# This script is distributed under the Gnu General Public License (GPL)

# Ce script permet la mise à jour d'un ALCASAR
#	- (alcasar-conf.sh -create) : création de l'archive des fichiers de configuration (/var/tmp/alcasar-conf.tar.gz)
#	- (alcasar-conf.sh -load) : chargement de l'archive des fichiers de configuration. Le cas échéant, c'est ici qu'on met à jour les fichiers entre versions
#	- (alcasar-conf.sh -apply) : application des directives du fichier de conf central "/usr/local/etc/alcasar.conf". Peut aussi être exploité à chaud après avoir changé des valeurs du fichier de conf.
# This script allows ALCASAR update
#	- (alcasar-conf.sh -create) : create the configuration files backup (/var/tmp/alcasar-conf.tar.gz)
#	- (alcasar-conf.sh -load) : load the backup of configuration files. If needed, it's here we update files between versions
#	- (alcasar-conf.sh -apply) : apply ALCASAR central configuration file "/usr/local/etc/alcasar.conf". Can be use after changes of conf file values.

DIR_UPDATE="/var/tmp/conf"				# répertoire de stockage des fichier de conf pour une mise à jour
DIR_WEB="/var/www/html"					# répertoire du centre de gestion
DIR_BIN="/usr/local/bin"				# scripts directory
DIR_ETC="/usr/local/etc"				# conf directory
DIR_E2G="/etc/e2guardian/lists"			# Toulouse BL directory
DIR_BLACKLIST="$DIR_E2G/blacklists"		# Toulouse BL directory
CONF_FILE="$DIR_ETC/alcasar.conf"		# main alcasar conf file
PASSWD_FILE="/root/ALCASAR-passwords.txt"
DB_USER=$(grep '^db_user=' $PASSWD_FILE | cut -d'=' -f 2-)
DB_PASS=$(grep '^db_password=' $PASSWD_FILE | cut -d'=' -f 2-)
EXTIF=`grep ^EXTIF= $CONF_FILE|cut -d"=" -f2`		# EXTernal InterFace
INTIF=`grep ^INTIF= $CONF_FILE|cut -d"=" -f2`		# INTernal InterFace
MTU=`grep ^PUBLIC_MTU= $CONF_FILE|cut -d"=" -f2`
DHCP_mode=`grep ^DHCP= $CONF_FILE|cut -d"=" -f2`
INT_DNS_mode=`grep ^INT_DNS_ACTIVE= $CONF_FILE|cut -d"=" -f2`
HOSTNAME=`grep ^HOSTNAME= $CONF_FILE|cut -d"=" -f2`
DOMAIN=`grep ^DOMAIN= $CONF_FILE|cut -d"=" -f2`
DOMAIN=${DOMAIN:=lan}
DNS1=`grep ^DNS1= $CONF_FILE | cut -d'=' -f2` 		# To configure WL domain names
HTTPS_LOGIN=`grep ^HTTPS_LOGIN= $CONF_FILE | cut -d'=' -f2`
SED="/bin/sed -i"

private_network_calc ()
{
	PRIVATE_PREFIX=`/bin/ipcalc -p $PRIVATE_IP $PRIVATE_NETMASK |cut -d"=" -f2`				# prefixe du réseau (ex. 24)
	PRIVATE_NETWORK=`/bin/ipcalc -n $PRIVATE_IP $PRIVATE_NETMASK| cut -d"=" -f2`			# @ réseau de consultation (ex.: 192.168.182.0)
	PRIVATE_NETWORK_MASK=$PRIVATE_NETWORK/$PRIVATE_PREFIX									# @ + masque du réseau de consult (192.168.182.0/24)
	classe=$((PRIVATE_PREFIX/8)); classe_sup=`expr $classe + 1`;							# classes de réseau (ex.: 2=classe B, 3=classe C)
	PRIVATE_NETWORK_SHORT=`echo $PRIVATE_NETWORK | cut -d"." -f1-$classe`.					# @ compatible hosts.allow et hosts.deny (ex.: 192.168.182.)
	PRIVATE_BROADCAST=`/bin/ipcalc -b $PRIVATE_NETWORK_MASK | cut -d"=" -f2`				# private network broadcast (ie.: 192.168.182.255)
	private_broadcast_ending=`echo $PRIVATE_BROADCAST | cut -d"." -f$classe_sup`			# last octet of LAN broadcast
	private_ip_ending=`echo $PRIVATE_IP | cut -d"." -f4`									# last octet of LAN address
	PRIVATE_SECOND_IP=`echo $PRIVATE_IP | cut -d"." -f1-3`"."`expr $private_ip_ending + 1`	# second network address (ex.: 192.168.182.2)
	PRIVATE_LAST_IP=`echo $PRIVATE_BROADCAST | cut -d"." -f1-3`"."`expr $private_broadcast_ending - 1`	# last network address (ex.: 192.168.182.254)
	PRIVATE_MAC=`/sbin/ip link show $INTIF | grep ether | cut -d" " -f6| sed 's/:/-/g'| awk '{print toupper($0)}'`	# MAC address of INTIF
}

usage="Usage: alcasar-conf.sh {--create or -create} | {--load or -load} | {--apply or -apply}"
nb_args=$#
args=$1
if [ $nb_args -eq 0 ]
then
	nb_args=1
	args="-h"
fi
case $args in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
###################################################
##           Create an archive conf file         ##
###################################################
--create|-create)
		[ -d $DIR_UPDATE ] && rm -rf $DIR_UPDATE
		mkdir $DIR_UPDATE
# backup the users database  (test to delete in future version)
		$DIR_BIN/alcasar-mariadb.sh --dump
		cp /var/Save/base/"$(ls -1t /var/Save/base|head -1)" $DIR_UPDATE
# backup organism logo
		cp -f $DIR_WEB/images/organisme.png $DIR_UPDATE
# backup E2D BL/WL custom files
		mkdir $DIR_UPDATE/custom_bl
		for i in urlregexplist exceptionsitelist bannedurllist exceptionsiteiplist
		do
			cp $DIR_E2G/group1/$i $DIR_UPDATE/custom_bl/
		done
		cp -rf $DIR_BLACKLIST/ossi-* $DIR_UPDATE/custom_bl/ 2>/dev/null
# backup conf files (main conf file, filtering, digest, etc.)
		mkdir $DIR_UPDATE/etc/
		cp -rf $DIR_ETC/* $DIR_UPDATE/etc/
		cp -f /etc/hosts $DIR_UPDATE/etc/
# backup of the security certificates (server & CA)
		cp -f /etc/pki/tls/certs/alcasar.crt* $DIR_UPDATE
		cp -f /etc/pki/tls/private/alcasar.key* $DIR_UPDATE
		[ -e /etc/pki/tls/private/alcasar.pem ] && cp -f /etc/pki/tls/private/alcasar.pem $DIR_UPDATE # since V3.3
		cp -f /etc/pki/CA/alcasar-ca.crt $DIR_UPDATE
		cp -f /etc/pki/CA/private/alcasar-ca.key $DIR_UPDATE
		if [ -e /etc/pki/tls/certs/server-chain.pem ]; then
			cp -f /etc/pki/tls/certs/server-chain.pem $DIR_UPDATE # autosigned and official if exist
		else
			cp -f /etc/pki/tls/certs/alcasar.crt $DIR_UPDATE/server-chain.pem
		fi
# backup gammu conf file (if necessary)
		SMS=`grep ^SMS= $CONF_FILE|cut -d"=" -f2`
		if [ "$SMS" == "on" ]
			then
			cp -f /etc/gammurc $DIR_UPDATE
			cp -f /etc/gammu_smsd_conf $DIR_UPDATE
		fi
# archive file creation
		cd /var/tmp || { echo "Unable to find /var/tmp directory"; }
		tar -cf alcasar-conf.tar conf/
		gzip -f alcasar-conf.tar
		cp alcasar-conf.tar.gz /var/www/html/acc/backup/alcasar-conf.tar.gz
		chown apache:apache /var/www/html/acc/backup/alcasar-conf.tar.gz
		echo "Conf file (alcasar-conf.tar.gz) is in '/var/tmp/' and in '/var/www/html/acc/backup/'"
		rm -rf $DIR_UPDATE
		;;

###################################################
##           Load an archive conf file           ##
###################################################
	--load|-load)
		if [ ! -f /var/tmp/alcasar-conf.tar.gz ]; then
			echo "Conf file not found (/var/tmp/alcasar-conf.tar.gz) !"
			return 1
		fi
		CURRENT_DIR=`pwd`  # install folder
		cd /var/tmp
		tar -xf alcasar-conf.tar.gz
# update alcasar.conf parameters
		PREVIOUS_VERSION=`grep ^VERSION= $DIR_UPDATE/etc/alcasar.conf|cut -d"=" -f2`
		MAJ_PREVIOUS_VERSION=`echo $PREVIOUS_VERSION|cut -d"." -f1`
		MIN_PREVIOUS_VERSION=`echo $PREVIOUS_VERSION|cut -d"." -f2`
		UPD_PREVIOUS_VERSION=`echo $PREVIOUS_VERSION|cut -d"." -f3|cut -c1`
		for line in `cat $DIR_UPDATE/etc/alcasar.conf | grep "=" | grep -Ev "^#| |VERSION|INSTALL_DATE|PUBLIC|GW|EXTIF|INTIF"`
		do
			key=`echo $line | cut -d"=" -f1`
			key=$key=
			value=`echo $line|cut -d"=" -f2-`
			if [ "$value" != "" ]
				then
				sed -i "s?^$key.*?$key$value?g" /usr/local/etc/alcasar.conf
			fi
		done
# lighttpd need a .pem certificate (aggregation with private key & server crt)
		[ ! -f $DIR_UPDATE/alcasar.pem ] && (cat $DIR_UPDATE/alcasar.key; echo; cat $DIR_UPDATE/alcasar.crt) > $DIR_UPDATE/alcasar.pem
# Retrieve organism logo
		[ -e $DIR_UPDATE/organisme.png ] && cp -f $DIR_UPDATE/organisme.png $DIR_WEB/images/
		chown apache:apache $DIR_WEB/images/organisme.png $DIR_WEB/intercept.php
# Retrieve the security certificates (CA and server)
		cp -f $DIR_UPDATE/alcasar-ca.crt /etc/pki/CA/
		cp -f $DIR_UPDATE/alcasar-ca.key /etc/pki/CA/private/
		cp -f $DIR_UPDATE/alcasar.crt /etc/pki/tls/certs/
		cp -f $DIR_UPDATE/alcasar.key /etc/pki/tls/private/
		cp -f $DIR_UPDATE/alcasar.pem /etc/pki/tls/private/
		[ -e $DIR_UPDATE/server-chain.pem ] && cp -f $DIR_UPDATE/server-chain.pem /etc/pki/tls/certs/
		chmod 755 /etc/pki/
		chown root:apache /etc/pki/CA; chmod 750 /etc/pki/CA
		chown root:apache /etc/pki/CA/alcasar-ca.crt; chmod 640 /etc/pki/CA/alcasar-ca.crt
		chown root:root /etc/pki/CA/private; chmod 700 /etc/pki/CA/private
		chmod 600 /etc/pki/CA/private/*
		chown -R root:apache /etc/pki/tls/private; chmod 750 /etc/pki/tls/private
		chmod 640 /etc/pki/tls/private/*
		chmod 644 /etc/pki/tls/certs/*
# Import of the users database
		$DIR_BIN/alcasar-mariadb.sh --import "$(ls $DIR_UPDATE/alcasar-users-database*)"
# Retrieve local parameters
		[ -d $DIR_UPDATE/etc/digest ] && cp -rf $DIR_UPDATE/etc/digest $DIR_ETC/  # ACC accounts
		[ -e $DIR_UPDATE/etc/alcasar-iptables-local.sh ] && cp -f $DIR_UPDATE/etc/alcasar-iptables-local.sh $DIR_ETC/   # local FW rules
		[ -e $DIR_UPDATE/etc/alcasar-iptables-local-mac-filtered ] && cp -f $DIR_UPDATE/etc/alcasar-iptables-local-mac-filtered $DIR_ETC/   # blocked MAC addresses
		[ -e $DIR_UPDATE/etc/alcasar-custom-allowed-ports ] && cp -f $DIR_UPDATE/etc/alcasar-custom-allowed-ports $DIR_ETC/ # protocols filtering for users (profil 3 : customized with ACC)
		[ -e $DIR_UPDATE/etc/alcasar-uamdomain ] && cp -f $DIR_UPDATE/etc/alcasar-uamdomain $DIR_ETC/ # exception domain names
		[ -e $DIR_UPDATE/etc/alcasar-uamallowed ] && cp -f $DIR_UPDATE/etc/alcasar-uamallowed $DIR_ETC/ # exception IP_addresses or network_IP_addresses
		[ -e $DIR_UPDATE/etc/alcasar-ethers ] && cp -f $DIR_UPDATE/etc/alcasar-ethers $DIR_ETC/ # DHCP static hosts
		[ -e $DIR_UPDATE/etc/alcasar-ethers-info ] && cp -f $DIR_UPDATE/etc/alcasar-ethers-info $DIR_ETC/ # DHCP static hosts information
		[ -e $DIR_UPDATE/etc/hosts ] && cp -f $DIR_UPDATE/etc/hosts /etc/  # local host name resolution
		[ -e $DIR_UPDATE/etc/alcasar-letsencrypt ] && cp -f $DIR_UPDATE/etc/alcasar-letsencrypt $DIR_ETC/ # Letsencrypt local conf
		[ -d $DIR_UPDATE/etc/letsencrypt ] && cp -rf $DIR_UPDATE/etc/letsencrypt $DIR_ETC/  # Letsencrypt local conf files
		[ -e $DIR_UPDATE/gammurc ] && cp -f $DIR_UPDATE/gammurc /etc/ # Gammu conf file
		[ -e $DIR_UPDATE/gammu_smsd_conf ] && cp -f $DIR_UPDATE/gammu_smsd_conf /etc/ # Gammu_smsd conf file
# Retrieve BL/WL custom files
		for i in urlregexplist exceptionsitelist bannedurllist exceptionsiteiplist
		do
			[ -e $DIR_UPDATE/custom_bl/$i ] && cp -f $DIR_UPDATE/custom_bl/$i $DIR_E2G/group1/
		done
		cp -rf $DIR_UPDATE/custom_bl/ossi-* $DIR_BLACKLIST/ 2>/dev/null
		chown -R e2guardian:apache $DIR_E2G
		chmod -R g+rw $DIR_E2G
# Adapt DNS/URL filtering
		PARENT_SCRIPT=`basename $0`
		export PARENT_SCRIPT
		$DIR_BIN/alcasar-bl.sh -cat_choice
		$DIR_BIN/alcasar-bl.sh -reload
# admin profile update (admin + manager + backup)
		$DIR_BIN/alcasar-profil.sh --list
# Apply changes between versions
## V3.5 --> V3.6
		## remove dnsmasq service
		[ -e /etc/dnsmasq-whitelist.conf ] && rm -f /etc/dnsmasq*
		[ -e /etc/systemd/system/dnsmasq-whitelist.service ] && rm -f /etc/systemd/system/dnsmasq* && urpme dnsmasq
## V3.6 --> V3.7
		## if domain name is .localdomain, change it with .lan (see RFC 6762) and adapt certificates.
		DOMAIN=`grep ^DOMAIN= $CONF_FILE|cut -d"=" -f2`
		if [[ $DOMAIN == "localdomain" ]] then
			$SED "s/^DOMAIN=.*/DOMAIN=lan/g" $CONF_FILE
			$SED "s/^LDAP_BASE=.*/LDAP_BASE=cn=Users;dc=serverad;dc=lan/g" $CONF_FILE
			$DIR_BIN/alcasar-CA.sh
			chown root:apache /etc/pki/CA; chmod 750 /etc/pki/CA
			chown root:apache /etc/pki/CA/alcasar-ca.crt; chmod 640 /etc/pki/CA/alcasar-ca.crt
			chown root:root /etc/pki/CA/private; chmod 700 /etc/pki/CA/private
			chmod 600 /etc/pki/CA/private/*
			chown -R root:apache /etc/pki/tls/private; chmod 750 /etc/pki/tls/private
			chmod 640 /etc/pki/tls/private/*
			chmod 644 /etc/pki/tls/certs/*
		fi
		## alcasar-services become alcasar-custom-allowed-ports
		[ -e $DIR_ETC/alcasar-services ] && mv $DIR_ETC/alcasar-services $DIR_ETC/alcasar-custom-allowed-ports
## V3.7 --> V3.8
		## Add Federation entries in conf file
		if [ `grep -E '^REPLICATION=' $CONF_FILE |wc -l` -eq "0" ]; then echo "REPLICATION=off" >> $CONF_FILE; fi
		if [ `grep -E '^REPLICATION_TO=' $CONF_FILE |wc -l` -eq "0" ]; then echo "REPLICATION_TO=off" >> $CONF_FILE; fi
# Remove the update folder
		rm -rf $DIR_UPDATE
		;;

####################################################
##   Configure ALCASAR according to alcasar.conf  ##
####################################################
	--apply|-apply)
		PTN='^\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\)/[012]\?[[:digit:]]$'
		PRIVATE_IP_MASK=`grep ^PRIVATE_IP= $CONF_FILE|cut -d"=" -f2`
		if [[ $(expr "$PRIVATE_IP_MASK" : $PTN) -eq 0 ]]
		then
			echo "Syntax error for PRIVATE_IP_MASK ($PRIVATE_IP_MASK)"
			exit 0
		fi
		PUBLIC_IP_MASK=`grep ^PUBLIC_IP= $CONF_FILE|cut -d"=" -f2`
		if [[ "$PUBLIC_IP_MASK" == "dhcp" ]]
		then
			PUBLIC_GATEWAY="dhcp"
			DHCP_DNS_servers=`cat /var/lib/dhclient/dhclient--$EXTIF.lease |grep domain-name-servers|sed -n "1 p"| rev|cut -d" " -f1|rev|tr -d ';'`
			DNS1=`echo $DHCP_DNS_servers | cut -d"," -f1`
			DNS2=`echo $DHCP_DNS_servers | cut -d"," -f2`
		else
			if [[ $(expr "$PUBLIC_IP_MASK" : $PTN) -eq 0 ]]
			then
				echo "Syntax error for PUBLIC_IP_MASK ($PUBLIC_IP_MASK)"
				exit 0
			fi
			PUBLIC_IP=`echo $PUBLIC_IP_MASK | cut -d"/" -f1`
			PUBLIC_NETMASK=`/bin/ipcalc -m $PUBLIC_IP_MASK | cut -d"=" -f2`
			PUBLIC_GATEWAY=`grep ^GW= $CONF_FILE|cut -d"=" -f2`
			PTN='^\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\)$'
			if [[ $(expr "$PUBLIC_GATEWAY" : $PTN) -eq 0 ]]
			then
				echo "Syntax error for the Gateway IP ($PUBLIC_GATEWAY)"
				exit 0
			fi
			DNS1=`grep ^DNS1= $CONF_FILE|cut -d"=" -f2`
			if [[ $(expr "$DNS1" : $PTN) -eq 0 ]]
			then
				echo "Syntax error for the IP address of the first DNS server ($DNS1)"
				exit 0
			fi
			DNS2=`grep ^DNS2= $CONF_FILE|cut -d"=" -f2`
			if [[ $(expr "$DNS2" : $PTN) -eq 0 ]]
			then
				echo "Syntax error for the IP address of the second DNS server ($DNS2)"
				exit 0
			fi
		fi
		PRIVATE_IP=`echo $PRIVATE_IP_MASK | cut -d"/" -f1`
		PRIVATE_NETMASK=`/bin/ipcalc -m $PRIVATE_IP_MASK | cut -d"=" -f2`
		private_network_calc
		INSTALL_DATE=`grep ^INSTALL_DATE= $CONF_FILE|cut -d"=" -f2`
		ORGANISME=`grep ^ORGANISM= $CONF_FILE|cut -d"=" -f2-`
		BL_SAFESEARCH=`grep ^BL_SAFESEARCH= $CONF_FILE|cut -d"=" -f2`
		WL_SAFESEARCH=`grep ^WL_SAFESEARCH= $CONF_FILE|cut -d"=" -f2`
		BL_PUREIP=`grep ^BL_PUREIP= $CONF_FILE|cut -d"=" -f2`
		DHCP_mode=`grep ^DHCP= $CONF_FILE|cut -d"=" -f2`
		if [ "$PARENT_SCRIPT" != "alcasar.sh" ] # don't launch on install stage
		then
			if [ "$DHCP_mode" = "off" ] || [ "$DHCP_mode" = "Off" ] || [ "$DHCP_mode" = "OFF" ]
			then
				$DIR_BIN/alcasar-dhcp.sh --off
			else
				$DIR_BIN/alcasar-dhcp.sh --on
			fi
# Set the local DNS (or not)
			if [ "$INT_DNS_mode" = "on" ] || [ "$INT_DNS_mode" = "On" ] || [ "$INT_DNS_mode" = "ON" ]
			then
				$DIR_BIN/alcasar-dns-local.sh --on-without-restart
			else
				$DIR_BIN/alcasar-dns-local.sh --off-without-restart
			fi
# Set the pure ip option (or not)
			if [ "$BL_PUREIP" = "off" ] || [ "$BL_PUREIP" = "Off" ] || [ "$BL_PUREIP" = "OFF" ]
			then
				bl_filter_param+="--pureip_off"
			else
				bl_filter_param+="--pureip_on"
			fi
# Set the safesearch options (or not)
			bl_filter_param=""
			if [ "$BL_SAFESEARCH" = "on" ] || [ "$BL_SAFESEARCH" = "On" ] || [ "$BL_SAFESEARCH" = "ON" ]
			then
				bl_filter_param+="--safesearch_on "
			else
				bl_filter_param+="--safesearch_off "
			fi
			$DIR_BIN/alcasar-url_filter_bl.sh $bl_filter_param
			if [ "$WL_SAFESEARCH" = "on" ] || [ "$WL_SAFESEARCH" = "On" ] || [ "$WL_SAFESEARCH" = "ON" ]
			then
				$DIR_BIN/alcasar-url_filter_wl.sh --safesearch_on
			else
				$DIR_BIN/alcasar-url_filter_wl.sh --safesearch_off
			fi
# Reload the local dns configuration
			$DIR_BIN/alcasar-dns-local.sh --reload
# Logout everybody
			$DIR_BIN/alcasar-logout.sh all
# Services stop
			echo -n "Stop services : "
			for i in ntpd e2guardian unbound unbound-whitelist unbound-blacklist unbound-blackhole chilli network httpd
			do
				/usr/bin/systemctl stop $i && echo -n "$i, "
			done
			echo
# set network configuration 
			$DIR_BIN/alcasar-network.sh --apply
		fi
# INTIF config (for bypass mode only)
		$SED "s?^IPADDR=.*?IPADDR=$PRIVATE_IP?" /etc/sysconfig/network-scripts/bypass-ifcfg-$INTIF
		$SED "s?^NETMASK=.*?NETMASK=$PRIVATE_NETMASK?" /etc/sysconfig/network-scripts/bypass-ifcfg-$INTIF
# NTP server
		$SED "/127.0.0.1/!s?^restrict.*?restrict $PRIVATE_NETWORK mask $PRIVATE_NETMASK nomodify notrap?g" /etc/ntp.conf
# host.allow
		cat <<EOF > /etc/hosts.allow
ALL: LOCAL, 127.0.0.1, localhost, $PRIVATE_IP
sshd: ALL
ntpd: $PRIVATE_NETWORK_SHORT
EOF
# Set hostname
		hostnamectl set-hostname $HOSTNAME.$DOMAIN
# /etc/hosts (retriving local hostnames)
		cp /etc/hosts /tmp/hosts
		echo "127.0.0.1	localhost" > /etc/hosts
		echo "$PRIVATE_IP	$HOSTNAME $HOSTNAME.$DOMAIN" >> /etc/hosts
		$SED "/$PRIVATE_IP/d" /tmp/hosts
		while read -r line
		do
				if ! echo $line | grep -E -q "^([0-9\.\t ]+alcasar( |$)|127\.0\.0)"
				then
					echo $line >> /etc/hosts
				fi
		done < /tmp/hosts
		rm -f /tmp/hosts
# MOTD
		$SED "s@'https://\(.\+\)/acc'@'https://$HOSTNAME.$DOMAIN/acc'@" /etc/mageia-release
# httpd
		$SED "s?^ServerName.*?ServerName $HOSTNAME.$DOMAIN?g" /etc/httpd/conf/httpd.conf
		$SED "s?^.*ErrorDocument.*?        ErrorDocument 404 https://$HOSTNAME.$DOMAIN?g" /etc/httpd/conf/webapps.d/alcasar.conf
		$SED "s?^.*AuthDigestDomain.*?        AuthDigestDomain $HOSTNAME.$DOMAIN?g" /etc/httpd/conf/webapps.d/alcasar.conf
		$SED "s?^    ServerName.*?    ServerName $HOSTNAME.$DOMAIN?g" /etc/httpd/conf/vhosts.d/00_default_vhosts.conf /etc/httpd/conf/vhosts.d/00_default_ssl_vhost.conf
		$SED "s?^Listen.*?Listen $PRIVATE_IP:80?g" /etc/httpd/conf/httpd.conf
		FIC_MOD_SSL=`find /etc/httpd/conf/ -type f -name ssl.conf`
		$SED "s?^Listen.*?Listen $PRIVATE_IP:443?g" $FIC_MOD_SSL
		$SED "/Allow from/d"  /etc/httpd/conf/webapps.d/alcasar.conf
		$SED "/Deny from all/a\ \tAllow from 127.0.0.1\n\tAllow from $PRIVATE_NETWORK_MASK" /etc/httpd/conf/webapps.d/alcasar.conf
		if [ $(grep -c "^managerIPs=" $DIR_ETC/alcasar-iptables-local.sh) -eq 1 ] ;then
			grep "^managerIPs=" $DIR_ETC/alcasar-iptables-local.sh | cut -d "'" -f2 | sed "s/,/\n/g" | while read -r managerIP
			do
	    			$SED "/Deny from all/a\ \tAllow from $managerIP" /etc/httpd/conf/webapps.d/alcasar.conf
			done
		fi
# FreeRADIUS
		$SED "s?^nas1_name:.*?nas1_name: alcasar-$ORGANISME?g" /etc/freeradius-web/naslist.conf
		$SED "s?^nas1_ip:.*?nas1_ip: $PRIVATE_IP?g" /etc/freeradius-web/naslist.conf
# CoovaChilli
		$SED "s?^uamallowed.*?uamallowed\t$HOSTNAME,$HOSTNAME.$DOMAIN?g" /etc/chilli.conf
		$SED "s?^locationname.*?locationname\t$HOSTNAME.$DOMAIN?g" /etc/chilli.conf
		$SED "s?^domain.*?domain\t\t$DOMAIN?g" /etc/chilli.conf
		[ "`grep ^HTTPS_LOGIN= $CONF_FILE | cut -d'=' -f2`" == "on" ] && chilli_login_protocol="https" || chilli_login_protocol="http"
		$SED "s?^uamserver.*?uamserver\t$chilli_login_protocol:\/\/$HOSTNAME.$DOMAIN\/intercept.php?" /etc/chilli.conf
		$SED "s?^radiusnasid.*?radiusnasid\t$HOSTNAME.$DOMAIN?g" /etc/chilli.conf
		$SED "s?^net.*?net\t\t$PRIVATE_NETWORK_MASK?g" /etc/chilli.conf
		$SED "s?^dns1.*?dns1\t\t$PRIVATE_IP?g" /etc/chilli.conf
		$SED "s?^dns2.*?dns2\t\t$PRIVATE_IP?g" /etc/chilli.conf
		$SED "s?^uamlisten.*?uamlisten\t$PRIVATE_IP?g" /etc/chilli.conf
		PRIVATE_IP_HEXA=$(printf "%02x\n" "$(echo $PRIVATE_IP | cut -d'.' -f1)")$(printf "%02x\n" "$(echo $PRIVATE_IP | cut -d'.' -f2)")$(printf "%02x\n" "$(echo $PRIVATE_IP | cut -d'.' -f3)")$(printf "%02x\n" "$(echo $PRIVATE_IP | cut -d'.' -f4)")
		$SED "s?^dhcpopt.*?dhcpopt\t\t2a04$PRIVATE_IP_HEXA?g" /etc/chilli.conf
		# modify the DHCP static ip file. Reserve the second IP address for INTIF (the first one is for tun0). Keep previous entries
		$SED "s?^$PRIVATE_MAC.*?$PRIVATE_MAC $PRIVATE_SECOND_IP?" $DIR_ETC/alcasar-ethers $DIR_ETC/alcasar-ethers-info
# unbound
		# removing unbound configuration files
		rm -f /etc/unbound/conf.d/{forward,blacklist,whitelist,blackhole}/iface.*
		rm -f /etc/unbound/conf.d/common/forward-zone.conf
		# Configuration file for the dns servers forward-zone
		cat << EOF > /etc/unbound/conf.d/common/forward-zone.conf
forward-zone:
	name: "."
	forward-addr: $DNS1
	forward-addr: $DNS2
EOF
		# Configuration file for lo of forward
		cat << EOF > /etc/unbound/conf.d/forward/iface.lo.conf
server:
	interface: 127.0.0.1@53
	access-control-view: 127.0.0.1/8 lo
view:
	name: "lo"
	local-data: "$HOSTNAME A 127.0.0.1"
	local-data: "$HOSTNAME.$DOMAIN A 127.0.0.1"
	local-data-ptr: "127.0.0.1 $HOSTNAME.$DOMAIN"
	view-first: yes
EOF
		# Configuration file for $INTIF of forward
		cat << EOF > /etc/unbound/conf.d/forward/iface.${INTIF}.conf
server:
	interface: ${PRIVATE_IP}@53
	access-control-view: $PRIVATE_NETWORK_MASK $INTIF
view:
	name: "$INTIF"
	view-first: yes
EOF
		# Configuration file for $INTIF of blacklist
		cat << EOF > /etc/unbound/conf.d/blacklist/iface.${INTIF}.conf
server:
	interface: ${PRIVATE_IP}@54
	access-control: $PRIVATE_IP_MASK allow
	access-control-tag: $PRIVATE_IP_MASK "blacklist"
	access-control-tag-action: $PRIVATE_IP_MASK "blacklist" redirect
	access-control-tag-data: $PRIVATE_IP_MASK "blacklist" "A $PRIVATE_IP"
EOF
		# Configuration file for $INTIF of whitelist
		cat << EOF > /etc/unbound/conf.d/whitelist/iface.${INTIF}.conf
server:
	interface: ${PRIVATE_IP}@55
	access-control: $PRIVATE_IP_MASK allow
	access-control-tag: $PRIVATE_IP_MASK "whitelist"
	access-control-tag-action: $PRIVATE_IP_MASK "whitelist" redirect
	access-control-tag-data: $PRIVATE_IP_MASK "whitelist" "A $PRIVATE_IP"
EOF
        # Configuration file for $INTIF of blackhole unbound
        cat << EOF > /etc/unbound/conf.d/blackhole/iface.${INTIF}.conf
server:
	interface: ${PRIVATE_IP}@56
	access-control-view: $PRIVATE_NETWORK_MASK $INTIF
view:
	name: "$INTIF"
	local-zone: "." redirect
	local-data: ". A $PRIVATE_IP"
EOF

# dhcpd
		cat <<EOF > /etc/dhcpd.conf
ddns-update-style none;
subnet $PRIVATE_NETWORK netmask $PRIVATE_NETMASK {
	option routers $PRIVATE_IP;
	option subnet-mask $PRIVATE_NETMASK;
	option domain-name-servers $PRIVATE_IP;
	range dynamic-bootp $PRIVATE_SECOND_IP $PRIVATE_LAST_IP;
	default-lease-time 21600;
	max-lease-time 43200;
}
EOF
$DIR_BIN/alcasar-dns-local.sh -hosts_to_unbound # add local name resolution to unbound (forward & blackhole)
# E2guardian
		$SED "s?^filterip.*?filterip = $PRIVATE_IP?g" /etc/e2guardian/e2guardian.conf
		$SED "s?\/\/[a-z.]*\/?\/\/$HOSTNAME.$DOMAIN\/?g" /usr/share/e2guardian/languages/french/alcasar-e2g.html
		$SED "s?\/\/[a-z.]*\/?\/\/$HOSTNAME.$DOMAIN\/?g" /usr/share/e2guardian/languages/ukenglish/alcasar-e2g.html
# Prompts
		$SED "s?^ORGANISME.*?ORGANISME=$ORGANISME?g" /etc/bashrc
# sudoers
		$SED "s?^Host_Alias.*?Host_Alias	LAN_ORG=$PRIVATE_NETWORK/$PRIVATE_NETMASK,localhost		#réseau de l'organisme?g" /etc/sudoers
# gammu-smsd
		$SED "s?^user =.*?user = $DB_USER?g" /etc/gammu_smsd_conf
		$SED "s?^password =.*?password = $DB_PASS?g" /etc/gammu_smsd_conf
# HTTPS login (Y/n)
        if [ "$HTTPS_LOGIN" = "on" ] || [ "$HTTPS_LOGIN" = "On" ] || [ "$HTTPS_LOGIN" = "ON" ]
        then
			$SED "s?^HTTPS_LOGIN=.*?HTTPS_LOGIN=on?" $CONF_FILE
			$SED "s?^HTTPS_CHILLI=.*?HTTPS_CHILLI=on?" $CONF_FILE
			$SED "s?^uamserver.*?uamserver\thttps://$HOSTNAME.$DOMAIN/intercept.php?" /etc/chilli.conf
			$SED "s?^#redirssl.*?redirssl?" /etc/chilli.conf
			$SED "s?^#uamuissl.*?uamuissl?" /etc/chilli.conf
		else
			$SED "s?^HTTPS_LOGIN=.*?HTTPS_LOGIN=off?" $CONF_FILE
			$SED "s?^HTTPS_CHILLI=.*?HTTPS_CHILLI=off?" $CONF_FILE
			$SED "s?^uamserver.*?uamserver\thttp://$HOSTNAME.$DOMAIN/intercept.php?" /etc/chilli.conf
			$SED "s?^redirssl.*?#&?" /etc/chilli.conf
			$SED "s?^uamuissl.*?#&?" /etc/chilli.conf
		fi
# Services start
		if [ "$PARENT_SCRIPT" != "alcasar.sh" ] # don't launch on install stage
		then
			/usr/bin/systemctl start network && echo -n "Start service : network" && sleep 1
			$DIR_BIN/alcasar-dhcp.sh -$DHCP_mode && echo -n ", chilli" # apply DHCP mode and start CoovaChilli
			for i in unbound unbound-blackhole ntpd
			do
				sleep 1
				/usr/bin/systemctl start $i && echo -n ", $i"
			done
			$DIR_BIN/alcasar-bl.sh -reload && echo -n ", unbound-blacklist, unbound-whitelist, e2guardian, iptables"
			/usr/bin/systemctl restart httpd && echo -n ", httpd"
		fi
# Email user registration
		$SED "s?^smtpd_banner =.*?smtpd_banner = $HOSTNAME.$DOMAIN ESMTP?g" /etc/postfix/main.cf
		$SED "s?^myhostname =.*?myhostname = $HOSTNAME.$DOMAIN?g" /etc/postfix/main.cf
		export PARENT_SCRIPT # if "alcasar.sh" then avoid some process
		$DIR_BIN/alcasar-mail-install.sh
# Start / Stop LDAP authentification
		if [ "$PARENT_SCRIPT" != "alcasar.sh" ] # don't launch on install stage
		then
			LDAP_mode=`grep ^LDAP= $CONF_FILE|cut -d"=" -f2`
			if [ $LDAP_mode = "on" ]
			then
				$DIR_BIN/alcasar-ldap.sh --on
			else
				$DIR_BIN/alcasar-ldap.sh --off
			fi
		fi
# Start / Stop Gammu-smsd (SMS)
		if [ "$PARENT_SCRIPT" != "alcasar.sh" ] # don't launch on install stage
		then
			SMS_mode=`grep ^SMS= $CONF_FILE|cut -d"=" -f2`
			if [ $SMS_mode = "on" ]
			then
				$DIR_BIN/alcasar-sms.sh --start
			fi
		fi
		echo
		;;
	*)
		echo "Argument inconnu : $1";
		echo "$usage"
		exit 1
		;;
esac
