#!/bin/sh
#
# $Id: alcasar-condown.sh 3302 2025-10-20 22:47:58Z rexy $
#
# alcasar-condown.sh
# by Rexy & Pierre RIVAULT
# This script is distributed under the Gnu General Public License (GPL)

# This script is started by coova after each logout
# Ce script est lancé par coova à chaque déconnexion d'usager

CONF_FILE="/usr/local/etc/alcasar.conf"
PASSWD_FILE="/root/ALCASAR-passwords.txt"
DB_USER=`cat $PASSWD_FILE|grep ^db_user=|cut -d'=' -f2`
DB_PASSWORD=`cat $PASSWD_FILE|grep ^db_password=|cut -d'=' -f2`

if [ -z $FRAMED_IP_ADDRESS ]; then
	exit 1
fi

# Remove the user from their IPSETs
for set_filter in av_wl av_bl av not_filtered
do
	ipset del -exist $set_filter $FRAMED_IP_ADDRESS
done
for set_filterProto in proto_0 proto_1 proto_2 proto_3
do
	ipset del -exist $set_filterProto $FRAMED_IP_ADDRESS
done


# Remove IP address from active users list
current_users_file="/tmp/current_users.txt"
[ -e $current_users_file ] && sed -i "/^$FRAMED_IP_ADDRESS:/d" $current_users_file

# Remove user_IP from load-balancing ipset
nb_gw=`grep ^WAN $CONF_FILE | wc -l`
for (( i = 0 ; i <= $nb_gw ; i++ ));do
	gw="gw$i"
	ipset test $gw $FRAMED_IP_ADDRESS 1>/dev/null 2>&1
	if [ $? -eq 0 ];then
		ipset del $gw $FRAMED_IP_ADDRESS
		break
	fi
done

#############################
## Debug : show all the coova parse variables (+ ALCASAR-Filter + ALCASAR-Protocols-Filter).
## see "/src/chilli.c" for the complete list of parse variables
#debug_file="/tmp/debug-condown.txt"
#echo "-----------------------------------------------" >> $debug_file
#echo `date` >> $debug_file
#for i in DEV NET MASK ADDR USER_NAME NAS_IP_ADDRESS SERVICE_TYPE FRAMED_IP_ADDRESS FILTER_ID STATE CLASS CUI SESSION_TIMEOUT IDLE_TIMEOUT CALLING_STATION_ID CALLED_STATION_ID NAS_ID NAS_PORT_TYPE ACCT_SESSION_ID ACCT_INTERIM_INTERVAL WISPR_LOCATION_ID WISPR_LOCATION_NAME WISPR_BANDWIDTH_MAX_UP WISPR_BANDWIDTH_MAX_DOWN COOVACHILLI_MAX_INPUT_OCTETS COOVACHILLI_MAX_OUTPUT_OCTETS COOVACHILLI_MAX_TOTAL_OCTETS INPUT_OCTETS OUTPUT_OCTETS INPUT_PACKETS OUTPUT_PACKETS SESSION_TIME IDLE_TIME LOCATION OLD_LOCATION TERMINATE_CAUSE
#do
#	echo -n "$i=" >> $debug_file
#	if [[ -v $i ]];
#	then
#		echo -n "${!i}; " >> $debug_file
#	else
#		echo -n "not defined; " >> $debug_file
#	fi
#done
#echo >> $debug_file
#echo "ALCASAR-Filter : $set_filter" >> $debug_file
#echo "ALCASAR-Protocols-Filter : $set_filterProto" >> $debug_file
## END Debug
#################################
