#!/bin/bash
# $Id: alcasar-activity_report.sh 3267 2025-04-13 22:05:45Z rexy $
#
# Create an activity report for ALCASAR every week (sunday at 5.35 pm --> see cron.d).
# We read configuration files and logs to create cool charts.
# Written by Raphaël PION, Rexy & Tom HOUDAYER

CONF_FILE='/usr/local/etc/alcasar.conf'
# files
DIR_TMP="/var/tmp"
TMP_AV="$DIR_TMP/av_count.txt"
TMP_BL="$DIR_TMP/bl_count.txt"
TMP_BL_WEEK="$DIR_TMP/bl_count_week.txt"
TMP_BL_WEEK_CAT="$DIR_TMP/bl_count_week_cat.txt"

# Model loaded to create charts
DIR_BUILD="/var/www/html/acc/manager/activity_report/"
MODEL_CHARTJS="$DIR_BUILD/models/Chart.report.js"
MODEL_TABINFO="$DIR_BUILD/models/tabinfo.html"

# Where the report will be created.
HTML_REPORT="$DIR_BUILD/alcasar-report-$(date +%F).html"

# TIME VALUE
C_TS=$(date +"%s") #current timestamp
MAX_DAY_AGO=7
SECS_AGO=$(date --date="$MAX_DAY_AGO days ago" +"%s") #timestamp ago
STEP_TS=$((C_TS-$SECS_AGO)) #timestamp between current timestamp and SECS_AGO

# PRIVATE IP OF ALCASAR
PRIVATE_IP=$(grep ^PRIVATE_IP= $CONF_FILE | cut -d'=' -f2 | cut -d'/' -f1)

# COLOR for charts
COLOR="'#ff0000','#3333cc','#009933','#993300','#1720EE','#D30229','#8D726D','#41C4E4','#8574F4','#A0BC1A','#BFDC1F','#5ADDC3','#B05744','#CD9319','#8CA39B','#D4AA1C','#A76752','#B03088','#445E87','#70424D','#D118C3','#46ABEF','#E9F197','#AEC0D4','#755C79','#94BBD7','#E2E9DC','#8B68D0','#F7EC7C','#1F16B8','#F4DA0A','#2EC17A','#E06483','#48B342','#F510CD','#9B2662','#180E98','#988FC1','#209E4E','#034240','#FDB142','#36B445','#CDD5C9','#6FA0DE','#EE2206','#204E19','#15FC93','#161ECE','#83D33B','#11A44A','#B7BF6C','#87274C','#B52C4F','#AD2805','#427E6C','#91341A','#191315','#FCB290','#13D3CD','#90F0E6','#C870C9','#AD2C14','#201D2A','#E4DB79','#90A919','#FE17FE','#09B35C','#88D950','#3440FC','#A9D42F','#E2DFAC','#DA69EC','#67430A','#43E94E','#5F7349','#22CF16','#CF038F','#0F6427','#F7AD0F','#C5E382','#DB49B6','#F760BF','#0BE701','#EF88D8','#79E6D7','#8A2D3D','#435A30','#A3C8AC','#99B118','#A929FF','#08A36D','#0A1654','#6F8283','#E1CA3E','#3E8577','#580FB6','#DB0E16','#386CBE','#FA0C43','#B713C9'"

# Values to create new htdigest user to consult statistique of ACC
DIR_KEY="/usr/local/etc/digest"
tmp_account="tmp_activityreport"
realm="ALCASAR Control Center (ACC)"
password=$(openssl rand -base64 32) #random password (length : 32)
SED="/usr/bin/sed -i "
TMP_STATS="$DIR_TMP/stats.html"
TMP_STATS_2="$DIR_TMP/stats2.html"

# if empty logs, replace charts by text.
ENABLE_BL=0
ENABLE_BL_WEEK=0
ENABLE_AV=0
if [ -e $TMP_AV ]
then
	rm $TMP_AV
fi
if [ -e $TMP_BL ]
then
	rm $TMP_BL
fi
if [ -e $TMP_BL_WEEK ]
then
	rm $TMP_BL_WEEK
fi
if [ -e $TMP_BL_WEEK_CAT ]
then
	rm $TMP_BL_WEEK_CAT
fi
if [ -e $HTML_REPORT ]
then
	rm $HTML_REPORT
fi
echo "<!doctype html>" >> $HTML_REPORT
echo "<html>" >> $HTML_REPORT
echo "<head>" >> $HTML_REPORT
echo "<meta charset=\"utf-8\">" >> $HTML_REPORT
echo "<title>ALCASAR report</title>" >> $HTML_REPORT
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../../css/bootstrap.min.css\">" >> $HTML_REPORT
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../../css/report.css\">" >> $HTML_REPORT
echo "<script src=\"../../../js/Chart.bundle.min.js\"></script>" >> $HTML_REPORT
echo "<script src=\"../../../js/jquery.min.js\"></script>" >> $HTML_REPORT
echo "</head>" >> $HTML_REPORT
echo "<body>" >> $HTML_REPORT
echo "<h1><center>ALCASAR</center></h1>" >> $HTML_REPORT
echo "<h2><center>Rapport d'activité hebdomadaire</center></h2>" >> $HTML_REPORT
echo "<h2><center>$(grep ^ORGANISM= $CONF_FILE | cut -d'=' -f2-)</center></h2>" >> $HTML_REPORT
echo "<i><p style=\"text-align: right;\">Date de création $(date +%F)</p></i>" >> $HTML_REPORT
echo "<font size=\"1\">" >> $HTML_REPORT

######################TABINFO######################
echo "Create information about system and ALCASAR"
#contain every information about ALCASAR configuration, system and last update

cat $MODEL_TABINFO | while read LINE_HTML
do
	if [ "$(echo $LINE_HTML | grep 'XXORGXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^ORGANISM= $CONF_FILE | cut -d'=' -f2-)
		echo ${LINE_HTML/XXORGXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXINSTALLXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^INSTALL_DATE= $CONF_FILE | cut -d'=' -f2)
		echo ${LINE_HTML/XXINSTALLXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXAVERSIONXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^VERSION= $CONF_FILE | cut -d'=' -f2)
		echo ${LINE_HTML/XXAVERSIONXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXIP_PUBLICXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^PUBLIC_IP= $CONF_FILE | cut -d'=' -f2)
		echo ${LINE_HTML/XXIP_PUBLICXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXIP_PRIVEXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^PRIVATE_IP= $CONF_FILE | cut -d'=' -f2)
		echo ${LINE_HTML/XXIP_PRIVEXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXGWXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^GW= $CONF_FILE | cut -d'=' -f2)
		echo ${LINE_HTML/XXGWXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXDNS1XX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^DNS1= $CONF_FILE | cut -d'=' -f2)
		echo ${LINE_HTML/XXDNS1XX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXDNS2XX' | wc -l)" -eq 1 ]
	then
		VALUE=$(grep ^DNS2= $CONF_FILE | cut -d'=' -f2)
		echo ${LINE_HTML/XXDNS2XX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXHOSTXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(hostname)
		echo ${LINE_HTML/XXHOSTXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXOS_VERSIONXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(echo "$(uname -r) [ $(uname -m) ]")
		echo ${LINE_HTML/XXOS_VERSIONXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXREBOOTXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(who -b | cut -d' ' -f12-)
		echo ${LINE_HTML/XXREBOOTXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXMAJCLAMAVXX' | wc -l)" -eq 1 ]
	then
#		VALUE=$(date -d "$(rpm -qa --queryformat "%{installtime} %{name}\n" | grep -E "clamav-db" | cut -d' ' -f1 )" "+%Y-%m-%d %H:%M:%S")
		VALUE="disabled"
		echo ${LINE_HTML/XXMAJCLAMAVXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXMAJBLXX' | wc -l)" -eq 1 ]
	then
		VALUE=$(stat -c %y /etc/e2guardian/lists/blacklists/README | cut -d' ' -f1)
		echo ${LINE_HTML/XXMAJBLXX/$VALUE} >> $HTML_REPORT

	elif [ "$(echo $LINE_HTML | grep 'XXRPMXX' | wc -l)" -eq 1 ]
	then
		#show every ALCASAR RPM updated since X day ago
		#get timestamp of X day ago. Then we get every packets which have been updated since this date.
		if [ "$(rpm -qa --queryformat '%{installtime} %{name} %{version}\n' | awk -v seuil="$SECS_AGO" '$1 > seuil' | sort -n | wc -l)" -gt 1 ]
		then
			rpm -qa --queryformat '%{installtime} %{name} %{version}\n' | awk -v seuil="$SECS_AGO" '$1 > seuil' | sort -n | while read RPM_ALCASAR
			do
				RPM_TIMESTAMP=$(echo $RPM_ALCASAR | cut -d' ' -f1)
				RPM_DATE=$(date -d "@$(echo $RPM_TIMESTAMP)" "+%Y-%m-%d %H:%M:%S")
				RPM_NAME=$(echo $RPM_ALCASAR | cut -d' ' -f2)
				RPM_VERSION=$(echo $RPM_ALCASAR | cut -d' ' -f3)

				echo "<tr>" >> $HTML_REPORT
				echo "<td>$RPM_NAME</td>" >> $HTML_REPORT
				echo "<td>$RPM_DATE</td>" >> $HTML_REPORT
				echo "<td>$RPM_VERSION</td>" >> $HTML_REPORT
				echo "</tr>" >> $HTML_REPORT
			done
		else
			echo "<tr><td colspan=\"3\">Pas de RPM mis à jour cette semaine</td></tr>" >> $HTML_REPORT
		fi
	else
		echo $LINE_HTML >> $HTML_REPORT
	fi
done

######################BL WEBSITE SINCE INSTALLATION######################
echo "Create BL website since the installation of ALCASAR"
#find data

#decompress every logs
if [ "$(ls -1 /var/log/unbound/unbound-blacklist.log.*.gz 2>/dev/null | wc -l)" -ge 1 ]
then
	gunzip -d unbound-blacklist.log.*.gz
fi

#convert logs date in timestamp and find categories of blacklisted website
tmp_log=$(mktemp)
for FILE in /var/log/unbound/unbound-blacklist.log*
do
	grep -E "info: [^ ]+ typetransparent $PRIVATE_IP" /var/log/unbound/unbound-blacklist.log > $tmp_log
	while read LOG_BL
	do
		# find the current blacklisted category
		website_bl=$(echo $LOG_BL | cut -d' ' -f4)
		website_bl=${website_bl%?} # remove the last character

		#we convert www.test.co.uk => test.co.uk to find the category of this website
		if [ "$(grep -o '\.' <<< "$website_bl" | wc -l)" -ge "2" ]
		then
			website_bl=$(echo $website_bl | cut -d'.' -f2-)
		fi
		#get BL category
		categorie_bl=$(grep -Rl "$website_bl" /usr/local/share/unbound-bl-enabled/ | cut -d'/' -f6 | head -1)
		CURRENT_TS=$(echo $LOG_BL | cut -d '[' -f2 | cut -d ']' -f1)
		echo "$CURRENT_TS:$categorie_bl:" >> $TMP_BL
	done < $tmp_log
done
rm $tmp_log

#if data exists, create this section in html document
if [ -e $TMP_BL ]
then
	ENABLE_BL=1
	#count every BL website consulted since installation (maximum 1 year)
	DATE_END=$(cat $TMP_BL | cut -d':' -f1 | sort -n | head -1 )
	for TS in $(seq $C_TS -$STEP_TS $DATE_END)
	do
		DATE_1=$TS
		DATE_2=$((TS-$STEP_TS))
		COUNT_BL_INSTALLATION=0
		for LINE in $(cat $TMP_BL)
		do
			TS_FILE=$(echo $LINE | cut -d':' -f1)

			if [ "$TS_FILE" -le "$DATE_1" ] && [ "$TS_FILE" -ge "$DATE_2" ]
			then
				COUNT_BL_INSTALLATION=$((COUNT_BL_INSTALLATION+1))
			fi
		done
		VALUE_BL_INSTALLATION_LABEL="'$(date -d @$DATE_2 "+%Y-%m-%d" )', $VALUE_BL_INSTALLATION_LABEL"
		VALUE_BL_INSTALLATION_DATA="$COUNT_BL_INSTALLATION, $VALUE_BL_INSTALLATION_DATA"
	done

	#create Antivirus section in html document
	NAME_BL_INSTALLATION='chart_bl_installation'
	CONF_BL_INSTALLATION='config_bl_installation'
	echo "<center>" >> $HTML_REPORT
	echo "<canvas id='$NAME_BL_INSTALLATION' width='450' height='450'></canvas>" >> $HTML_REPORT
	echo "</center>" >> $HTML_REPORT

	#create chart bar in html file with javascript (chartjs.com)
	echo "<script>" >> $HTML_REPORT
	cat $MODEL_CHARTJS | while read LINE_JS
	do
		#name of variable
		if [ "$(echo $LINE_JS | grep 'XXCONFXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXCONFXX/$CONF_BL_INSTALLATION} >> $HTML_REPORT
		#chart type
		elif [ "$(echo $LINE_JS | grep 'XXTYPEXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXTYPEXX/bar} >> $HTML_REPORT
		#chart title
		elif [ "$(echo $LINE_JS | grep 'XXTITLEXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXTITLEXX/"Sites bloqués au total"} >> $HTML_REPORT
		#chart data
		elif [ "$(echo $LINE_JS | grep 'XXDATAXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXDATAXX/$VALUE_BL_INSTALLATION_DATA} >> $HTML_REPORT
		#color
		elif [ "$(echo $LINE_JS | grep 'XXCOLORXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXCOLORXX/$COLOR} >> $HTML_REPORT
		#labels
		elif [ "$(echo $LINE_JS | grep 'XXLABELSXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXLABELSXX/$VALUE_BL_INSTALLATION_LABEL} >> $HTML_REPORT
		elif [ "$(echo $LINE_JS | grep 'XXLEGENDXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXLEGENDXX/false} >> $HTML_REPORT
		#display value of Y axis, only useful for chart bar
		elif [ "$(echo $LINE_JS | grep 'XXCOMMENT-BEGINXX' | wc -l)" -eq 1 ]
		then
			echo "" >> $HTML_REPORT
		#display value of Y axis, only useful for chart bar
		elif [ "$(echo $LINE_JS | grep 'XXCOMMENT-ENDXX' | wc -l)" -eq 1 ]
		then
			echo "" >> $HTML_REPORT
		elif [ "$(echo $LINE_JS | grep 'XXYLABELXX' | wc -l)" -eq 1 ]
		then
			echo "\"Nombre de site bloqué par la blacklist\"" >> $HTML_REPORT
		else
			echo $LINE_JS >> $HTML_REPORT
		fi
	done
	echo "</script>" >> $HTML_REPORT
else
	echo "<BR><h3>Aucun site bloqué par la blacklist depuis l'installation.</h3>" >> $HTML_REPORT
fi



######################Unbound BLACKLIST######################
echo "Create BL website since $MAX_DAY_AGO days"

#if data exists, create BL section in html document
if [ -e $TMP_BL ]
then
	ENABLE_BL_WEEK=1
	#find data
	#count every BL website consulted since DAYS_AGO
	DATE_1=$C_TS
	DATE_2=$((DATE_1-$STEP_TS))
	touch $TMP_BL_WEEK
	for LINE in $(cat $TMP_BL)
	do
		TS_FILE=$(echo $LINE | cut -d':' -f1)
		#select only elements between DATE_1 and DATE_2
		if [ "$TS_FILE" -le "$DATE_1" ] && [ "$TS_FILE" -ge "$DATE_2" ]
		then
			echo $LINE >> $TMP_BL_WEEK
		fi
	done

	#then we count every occurence for each category in TMP_BL_WEEK
	for CAT in $(ls /usr/local/share/unbound-bl/ -1 | cut -d'.' -f1)
	do
		echo "$CAT:$(grep -o ":$CAT:" <<< "$(cat $TMP_BL_WEEK)" | wc -l):" >> $TMP_BL_WEEK_CAT
	done

	#we sort by number of occurence and we take the top 10 BL categories
	for LINE in $(sort -t':' -k2 -rn $TMP_BL_WEEK_CAT | head -n 10)
	do
		DATA=$(echo $LINE | cut -d':' -f2)
		LABEL=$(echo $LINE | cut -d':' -f1)
		if [ $DATA -ne 0 ]
		then
			VALUE_BL_DATA="$VALUE_BL_DATA $DATA, "
			VALUE_BL_LABEL="$VALUE_BL_LABEL '$LABEL ($DATA)',"
		fi
	done

	#get other categories (sum them all)
	if [ "$(cat $TMP_BL_WEEK_CAT | cut -d':' -f2 | sort -k1 -rn | tail -n+$(($(echo $VALUE_BL_DATA | wc -w)+1)) | paste -sd+ | bc)" -gt 0 ]
	then
		VALUE_BL_DATA="$VALUE_BL_DATA $(cat $TMP_BL_WEEK_CAT | cut -d':' -f2 | sort -k1 -rn | tail -n+$(($(echo $VALUE_BL_DATA | wc -w)+1)) | paste -sd+ | bc)"
		VALUE_BL_LABEL="$VALUE_BL_LABEL 'autre ($(cat $TMP_BL_WEEK_CAT | cut -d':' -f2 | sort -k1 -rn | tail -n+$(($(echo $VALUE_BL_DATA | wc -w)+1)) | paste -sd+ | bc))'"
	fi

	#create chart pie in html file with javascript (chartjs.com)
	NAME_BL='chart_bl'
	CONF_BL='config_bl'
	echo "<center>" >> $HTML_REPORT
	echo "<canvas id='$NAME_BL' width='450' height='450' ></canvas>" >> $HTML_REPORT
	echo "</center>" >> $HTML_REPORT
	echo "<script>" >> $HTML_REPORT
	cat $MODEL_CHARTJS | while read LINE_JS
	do
		#variable name
		if [ "$(echo $LINE_JS | grep 'XXCONFXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXCONFXX/$CONF_BL} >> $HTML_REPORT
		#chart type
		elif [ "$(echo $LINE_JS | grep 'XXTYPEXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXTYPEXX/pie} >> $HTML_REPORT
		#graph title
		elif [ "$(echo $LINE_JS | grep 'XXTITLEXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXTITLEXX/"Sites bloqués cette semaine"} >> $HTML_REPORT
		#chart data
		elif [ "$(echo $LINE_JS | grep 'XXDATAXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXDATAXX/$VALUE_BL_DATA} >> $HTML_REPORT
		#color
		elif [ "$(echo $LINE_JS | grep 'XXCOLORXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXCOLORXX/$COLOR} >> $HTML_REPORT
		#labels
		elif [ "$(echo $LINE_JS | grep 'XXLABELSXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXLABELSXX/$VALUE_BL_LABEL} >> $HTML_REPORT
		#display legend, only useful for chart pie
		elif [ "$(echo $LINE_JS | grep 'XXLEGENDXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXLEGENDXX/true} >> $HTML_REPORT
		#display value of Y axis, only useful for chart bar
		elif [ "$(echo $LINE_JS | grep 'XXCOMMENT-BEGINXX' | wc -l)" -eq 1 ]
		then
			echo "/*" >> $HTML_REPORT
		#display value of Y axis, only useful for chart bar
		elif [ "$(echo $LINE_JS | grep 'XXCOMMENT-ENDXX' | wc -l)" -eq 1 ]
		then
			echo "*/" >> $HTML_REPORT
		else
			echo $LINE_JS >> $HTML_REPORT
		fi
	done
	echo "</script>" >> $HTML_REPORT
else
	echo "<BR><h3>Aucun site bloqué par la Blacklist cette semaine.</h3>" >> $HTML_REPORT
fi

###################### ALCASAR : FAIL2BAN ######################
echo "Get fail2ban log of the week"

ROWS=""
dateDaysAgo_formatted=$(date --date="$MAX_DAY_AGO days ago" +'%Y-%m-%d %H:%M:%S,%N' | rev | cut -c 7- | rev)
while read -r log ; do
	log_datas=($log)
	log_date="${log_datas[0]} ${log_datas[1]}"
	log_type=${log_datas[4]:1:-1}
	log_ip=${log_datas[6]}
	log_date_formatted=$(date -d "$log_date" +"%x %X")

	ROWS="$ROWS<tr><td>$log_date_formatted</td><td>$log_ip</td><td>$log_type</td></tr>"
done < <(grep " Ban " /var/log/fail2ban.log | sort -r | awk -v dateDaysAgo="$dateDaysAgo_formatted" '($1 " " $2) >= dateDaysAgo')

if [ -z "$ROWS" ]; then
	ROWS="<tr><td colspan=\"3\" style=\"text-align: center;\">Aucune adresse IP bloquée</td></tr>"
fi

#Create html document
echo "<BR><h3>Adresse(s) IP bloquée(s) (Fail2Ban)</h3>" >> $HTML_REPORT
echo "<table class=\"table table-striped\">" >> $HTML_REPORT
echo "<thead><tr><th>Date</th><th>Adresse IP</th><th>Règle</th></tr></thead><tbody>" >> $HTML_REPORT
echo $ROWS >> $HTML_REPORT
echo "</tbody></table>" >> $HTML_REPORT

######################VIRUS THREAT######################
echo "Create AV logs since the installation of ALCASAR"

#decompress every logs, if they exist
if [ "$(ls -1 /var/log/clamav/clamd.log.*.gz 2>/dev/null | wc -l)" -ge 1 ]
then
	gunzip -d clamd.log.*.gz
	for FILE in /var/log/clamav/clamd.log*
	do
		while read LINE_AV
		do
			if [ "`echo $LINE_AV|grep -c FOUND`" == 1 ]
			then
				Y=$(echo $LINE_AV | cut -d' ' -f5)
				M=$(echo $LINE_AV | cut -d' ' -f2)
				D=$(echo $LINE_AV | cut -d' ' -f3)
				H=$(echo $LINE_AV | cut -d' ' -f4)
				CURRENT_TS=$(date -d "$M $D $Y $H" +"%s")
				echo $CURRENT_TS >> $TMP_AV
			fi
		done < $FILE
	done
fi
if [ -e $TMP_AV ]
then
	ENABLE_AV=1
	DATE_END=$(cat $TMP_AV | sort -n | head -1)
	for TS in $(seq $C_TS -$STEP_TS $DATE_END)
	do
		DATE_1=$TS
		DATE_2=$((TS-$STEP_TS))
		COUNT_AV=0

		for TS_FILE in $(cat $TMP_AV)
		do
			if [ "$TS_FILE" -le "$DATE_1" ] && [ "$TS_FILE" -ge "$DATE_2" ]
			then
				COUNT_AV=$((COUNT_AV+1))
			fi
		done

		VALUE_AV_LABEL="'$(date -d @$DATE_2 "+%Y-%m-%d" )', $VALUE_AV_LABEL"
		VALUE_AV_DATA="$COUNT_AV, $VALUE_AV_DATA"
	done

	#create Antivirus section in html document
	NAME_AV='chart_av'
	CONF_AV='config_av'
	echo "<center>" >> $HTML_REPORT
	echo "<canvas id='$NAME_AV' width='450' height='450' ></canvas>" >> $HTML_REPORT
	echo "</center>" >> $HTML_REPORT

	#create chart bar in html file with javascript (chartjs.com)
	echo "<script>" >> $HTML_REPORT
	cat $MODEL_CHARTJS | while read LINE_JS
	do
		#name of variable
		if [ "$(echo $LINE_JS | grep 'XXCONFXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXCONFXX/$CONF_AV} >> $HTML_REPORT
		#chart type
		elif [ "$(echo $LINE_JS | grep 'XXTYPEXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXTYPEXX/bar} >> $HTML_REPORT
		#graph title
		elif [ "$(echo $LINE_JS | grep 'XXTITLEXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXTITLEXX/"Menaces bloqués par l\'antivirus"} >> $HTML_REPORT
		#chart data
		elif [ "$(echo $LINE_JS | grep 'XXDATAXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXDATAXX/$VALUE_AV_DATA} >> $HTML_REPORT
		#color
		elif [ "$(echo $LINE_JS | grep 'XXCOLORXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXCOLORXX/$COLOR} >> $HTML_REPORT
		#labels
		elif [ "$(echo $LINE_JS | grep 'XXLABELSXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXLABELSXX/$VALUE_AV_LABEL} >> $HTML_REPORT
		elif [ "$(echo $LINE_JS | grep 'XXLEGENDXX' | wc -l)" -eq 1 ]
		then
			echo ${LINE_JS/XXLEGENDXX/false} >> $HTML_REPORT
		#display value of Y axis, only useful for chart bar
		elif [ "$(echo $LINE_JS | grep 'XXCOMMENT-BEGINXX' | wc -l)" -eq 1 ]
		then
			echo "" >> $HTML_REPORT
		#display value of Y axis, only useful for chart bar
		elif [ "$(echo $LINE_JS | grep 'XXCOMMENT-ENDXX' | wc -l)" -eq 1 ]
		then
			echo "" >> $HTML_REPORT
		elif [ "$(echo $LINE_JS | grep 'XXYLABELXX' | wc -l)" -eq 1 ]
		then
			echo "\"Nombre de menaces virales bloqués par l'antivirus\"" >> $HTML_REPORT
		else
			echo $LINE_JS >> $HTML_REPORT
		fi
	done
	echo "</script>" >> $HTML_REPORT
else
	echo "<BR><h3>Aucune détection de menace virale.</h3>" >> $HTML_REPORT
fi


######################ALCASAR : DAILY USE######################
echo "Get daily use connection of the week"

echo "<BR><h3>Statistiques des connexions</h3>" >> $HTML_REPORT

#create new htdigest user to consult statistique of ACC
#if user does not exist, we create him
if [ "$(grep "$tmp_account:" $DIR_KEY/key_only_manager | wc -l)" -lt 1 ]
then
	(echo -n "$tmp_account:$realm:" && echo -n "$tmp_account:$realm:$password" | md5sum | awk '{print $1}' ) >> $DIR_KEY/key_only_manager
	(echo -n "$tmp_account:$realm:" && echo -n "$tmp_account:$realm:$password" | md5sum | awk '{print $1}' ) >> $DIR_KEY/key_manager
	(echo -n "$tmp_account:$realm:" && echo -n "$tmp_account:$realm:$password" | md5sum | awk '{print $1}' ) >> $DIR_KEY/key_all
	chown -R root:apache $DIR_KEY
	chmod 640 $DIR_KEY/key_*
fi

#get stats.php from ACC
wget -q -nv --user $tmp_account --password $password https://alcasar/acc/manager/htdocs/stats.php -O $TMP_STATS --no-check-certificate
#clean this file to include it in html report.
DELIM_1="<font color=\"darkblue\">"
DELIM_2="<\/div"
cat $TMP_STATS | sed -n "/$DELIM_1/,/$DELIM_2/p" | tail -n+2 | head -n-1 >> $TMP_STATS_2
cat $TMP_STATS_2 | sed -e 's:images/pixel.gif:../../manager/htdocs/images/pixel.gif:g' >> $HTML_REPORT

#we delete our user if he still exists
if [ "$(grep "$tmp_account:" $DIR_KEY/key_only_manager | wc -l)" -ge 1 ]
then
	$SED "/^$tmp_account:/d" $DIR_KEY/key_only_manager
	$SED "/^$tmp_account:/d" $DIR_KEY/key_manager
	$SED "/^$tmp_account:/d" $DIR_KEY/key_all
fi

###################### ALCASAR : LOG ACCESS ######################
echo "Get ACC log access of the week"

ROWS=""
while read -r access ; do
	access_datas=(${access//|/ })
	accces_date_intl=$(echo "${access_datas[0]} ${access_datas[1]}" | sed -E 's@^([0-9]{2})+/+([0-9]{2})+/+([0-9]{4})+@\3-\2-\1@') # Convert date format DD/MM/YYYY to YYYY-MM-DD
	access_date=$(date -d "$accces_date_intl" +%s)
	access_user=${access_datas[2]}
	access_ip=${access_datas[3]}
	access_agent=$(echo "$access" | cut -d'|' -f4)
	if [ $access_date -lt $SECS_AGO ]; then
		break
	fi
	access_date_formatted=$(date -d @$access_date +"%x %X")
	ROWS="$ROWS<tr><td>$access_date_formatted</td><td>$access_user</td><td>$access_ip</td><td>$access_agent</td></tr>"
done < <(cat /var/Save/security/acc_access.log | sort -r)
# TODO: Read archives if necessary
if [ -z "$ROWS" ]; then
	ROWS="<tr><td colspan=\"4\" style=\"text-align: center;\">Aucune connexion</td></tr>"
fi

# Create HTML document
echo "<BR><h3>Connexion à l'ALCASAR Control Center (ACC)</h3>" >> $HTML_REPORT
echo "<table class=\"table table-striped\">" >> $HTML_REPORT
echo "<thead><tr><th>Date</th><th>Utilisateur</th><th>Adresse IP</th><th>Agent</th></tr></thead><tbody>" >> $HTML_REPORT
echo "$ROWS" >> $HTML_REPORT
echo "</tbody></table>" >> $HTML_REPORT


###################### ALCASAR : GLOBAL TRAFFIC ######################
echo "Get Global traffic of the last 30 days"

ROWS=""
EXTIF=$(grep ^EXTIF= $CONF_FILE | cut -d'=' -f2)

while read -r entry; do
    year=$(echo "$entry" | grep -oP '(?<=<year>).*(?=</year>)')
    month=$(echo "$entry" | grep -oP '(?<=<month>).*(?=</month>)')
    day=$(echo "$entry" | grep -oP '(?<=<day>).*(?=</day>)')
    rx=$(echo "$entry" | grep -oP '(?<=<rx>).*(?=</rx>)')
    tx=$(echo "$entry" | grep -oP '(?<=<tx>).*(?=</tx>)')
    if [ -n "$year" ]; then
        date_year=$year
    fi
    if [ -n "$month" ]; then
            date_month=$month
    fi
    if [ -n "$day" ]; then
            date_day=$day
    fi
    if [ -n "$rx" ]; then
        day_rx=`echo "$rx" | numfmt --to iec`
    fi
    if [ -n "$tx" ]; then
        day_tx=`echo "$tx" | numfmt --to iec`
    fi
    if [ -n "$date_year" ] && [ -n "$date_month" ] && [ -n "$date_day" ] && [ -n "$day_rx" ] && [ -n "$day_tx" ]; then
        day_date="$date_day-$date_month-$date_year"
        rxtx=$((rx + tx))
        day_total=`echo "$rxtx" | numfmt --to iec`
        ROWS="$ROWS<tr><td>$day_date</td><td>$day_rx</td><td>$day_tx</td><td>$day_total</td></tr>"
        date_month=""
        date_day=""
        date_year=""
    fi
done < <(vnstat -i $EXTIF --days --begin $(date --date "Sunday - 6 days" +"%Y-%m-%d") --xml d | grep id= | tr -d ' '| rev | cut -c7- | rev)
if [ -z "$ROWS" ]; then
	ROWS="<tr><td colspan=\"4\" style=\"text-align: center;\">Aucun jour capturé</td></tr>"
fi

# Create html document
echo "<BR><h3>Trafic global</h3>" >> $HTML_REPORT
echo "<table class=\"table table-striped\">" >> $HTML_REPORT
echo "<thead><tr><th>Date</th><th>Entrant</th><th>Sortant</th><th>Total</th></tr></thead><tbody>" >> $HTML_REPORT
echo "$ROWS" >> $HTML_REPORT
echo "</tbody></table>" >> $HTML_REPORT

######################HTML END######################

#Execute our javascript function to print charts
echo "<script>window.onload = function() {" >> $HTML_REPORT
#BL since installation
if [ $ENABLE_BL -eq "1" ]
then
	echo "var ctx_$NAME_BL_INSTALLATION = document.getElementById('$NAME_BL_INSTALLATION').getContext('2d');" >> $HTML_REPORT
	echo "var $NAME_BL_INSTALLATION = new Chart(ctx_$NAME_BL_INSTALLATION, $CONF_BL_INSTALLATION);" >> $HTML_REPORT
fi
#BL week
if [ $ENABLE_BL_WEEK -eq "1" ]
then
	echo "var ctx_$NAME_BL = document.getElementById('$NAME_BL').getContext('2d');" >> $HTML_REPORT
	echo "var $NAME_BL = new Chart(ctx_$NAME_BL, $CONF_BL);" >> $HTML_REPORT
fi
#malware Threat
if [ $ENABLE_AV -eq "1" ]
then
	echo "var ctx_$NAME_AV = document.getElementById('$NAME_AV').getContext('2d');" >> $HTML_REPORT
	echo "var $NAME_AV = new Chart(ctx_$NAME_AV, $CONF_AV);" >> $HTML_REPORT
fi
echo "};</script>" >> $HTML_REPORT
echo "</body>" >> $HTML_REPORT
echo "</html>" >> $HTML_REPORT

#convert html document to PDF
/usr/bin/wkhtmltopdf $HTML_REPORT "$(echo $HTML_REPORT | cut -d'.' -f1).pdf"
chown apache:apache "$(echo $HTML_REPORT | cut -d'.' -f1).pdf"
chmod 644 "$(echo $HTML_REPORT | cut -d'.' -f1).pdf"
mv "$(echo $HTML_REPORT | cut -d'.' -f1).pdf" /var/Save/activity_report/

#compress every logs, if they exist
if [ "$(ls -1 /var/log/clamav/clamd.log.* 2>/dev/null | wc -l)" -ge 1 ]
then
	gzip /var/log/clamav/clamd.log.*
fi

#compress every logs
if [ "$(ls -1 /var/log/unbound/unbound-blacklist.log.* 2>/dev/null | wc -l)" -ge 1 ]
then
	gzip /var/log/unbound/unbound-blacklist.log.*
fi

#remove our files
rm -f $TMP_BL
rm -f $TMP_BL_WEEK
rm -f $TMP_BL_WEEK_CAT
rm -f $TMP_STATS
rm -f $TMP_STATS_2
rm -f $HTML_REPORT
