%define kversion 6.6.88-server-3.mga9
%define debug_package %{nil}
%define _build_id_links none
Name:		ipt-netflow
Version:	2.6
Release:	%mkrel 5
Summary:	Netflow iptables module for Linux kernel
License:	GPLv2
Packager:	Richard REY (Rexy)
Group:		System/Networking
URL:		https://github.com/aabc/ipt-netflow
BuildRequires:	iptables-devel
Source0:	%name-%version.tar.gz

%description
High performance NetFlow v5, v9, IPFIX flow data export module for Linux kernel.
Created to be useful for highly loaded linux router. It should be used as iptables target.

%prep
%setup -q -n ipt-netflow-%{version}

%build
./configure  --kdir=/usr/src/kernel-%{kversion} --disable-dkms --disable-snmp-agent
%make_build 

%install
%make_install
mkdir -p %{buildroot}/lib64/iptables
mkdir -p %{buildroot}/lib/modules/%kversion/extra
cp ~/rpmbuild/BUILD/%name-%version/libipt_NETFLOW.so %{buildroot}/lib64/iptables/
cp ~/rpmbuild/BUILD/%name-%version/libip6t_NETFLOW.so %{buildroot}/lib64/iptables/
cp ~/rpmbuild/BUILD/%name-%version/ipt_NETFLOW.ko %{buildroot}/lib/modules/%kversion/extra/
%clean
rm -rf %{buildroot}

%post
/sbin/depmod -a %kversion

%postun
/sbin/depmod -a %kversion

%files 
/lib64/iptables/libipt_NETFLOW.so
/lib64/iptables/libip6t_NETFLOW.so
/lib/modules/%kversion/extra/ipt_NETFLOW.ko
/lib/modules/%kversion/updates/ipt_NETFLOW.ko

%changelog
* Sun May 18 2025 Richard REY <Rexy>
- Version 2.6 for the kernel 6.6.88 (ALCASAR 3.7.2)
* Tue Nov 14 2023 Richard REY <Rexy>
- Version 2.6 for the kernel 5.15.126 (ALCASAR 3.6.1)
* Thu Jul 08 2021 Richard REY <Rexy>
- Version 2.6 for the kernel 5.10.46 (ALCASAR 3.5.4)
* Tue May 21 2019 Richard REY <Rexy>
- Version 2.4 for the kernel 4.14.131 (ALCASAR 3.4)
* Wed Jan 02 2019 Richard REY <Rexy>
- Version 2.3 for the kernel 4.14.89 (ALCASAR 3.3.3)
* Mon Feb 26 2018 Tom Houdayer
- Version 2.2 for the kernel 4.14.20 (ALCASAR 3.2.1)
* Mon Jul 03 2017 Richard Rey <rexy>
- Version 2.1 for the kernel 4.4.74 (alcasar 3.1.3)
* Sun May 28 2017 Richard Rey <rexy> 
- Version for the kernel 4.4.26 (alcasar 3.0)
* Sat May 14 2016 Richard Rey <rexy> 
- Version for the kernel 4.4.13
* Tue Apr 05 2016 Richard Rey <rexy> 
- Initial version of the package
