%global __requires_exclude_from %{_docdir}/

%define major 8
%define libname %mklibname %{name} %major
%define libnamedev %mklibname %{name} -d

Name:			gammu
Version:		1.42.0
Release:		%mkrel 1
Summary:		Mobile phones tools for Unix (Linux) and Win32
License:		GPLv2+
Group:			Communications/Mobile
URL:			https://www.gammu.org/
Source0:		https://dl.cihar.com/gammu/releases/%{name}-%{version}.tar.gz
Source1:		69-gammu-acl.rules
BuildRequires:		cmake
BuildRequires:		doxygen
BuildRequires:		gettext-devel
BuildRequires:		mysql-devel
BuildRequires:		pkgconfig(bash-completion)
BuildRequires:		pkgconfig(bluez)
BuildRequires:		pkgconfig(dbi)
BuildRequires:		pkgconfig(gudev-1.0)
BuildRequires:		pkgconfig(libcurl)
BuildRequires:		pkgconfig(libpq)
BuildRequires:		pkgconfig(libusb-1.0)

%description
Gammu can do such things with cellular phones as making data calls,
updating the address book, changing calendar and ToDo entries, sending and
receiving SMS messages, loading and getting ring tones and pictures (different
types of logos), synchronizing time, enabling NetMonitor, managing WAP
settings and bookmarks and much more. Functions depend on the phone model.


%package -n %libname
Summary: Mobile phones tools for Unix (Linux) and Win32 (libraries)
Group: System/Libraries
Requires: %name >= %version-%release

%description -n %libname
Gammu can do such things with cellular phones as making data calls,
updating the address book, changing calendar and ToDo entries, sending and
receiving SMS messages, loading and getting ring tones and pictures (different
types of logos), synchronizing time, enabling NetMonitor, managing WAP
settings and bookmarks and much more. Functions depend on the phone model.


%package -n %libnamedev
Summary:		Headers and pkgconfig file for Gammu development
Group:			Development/Other
Requires:		%libname = %version-%release
Provides:		libgammu-devel = %version-%release
Provides:		%name-devel = %version-%release

%description -n %libnamedev
This package contains the headers and pkgconfig file that programmers
will need to develop applications which will use libGammu.

%prep
%setup -q

%build
%cmake -DINSTALL_LIB_DIR=%{_lib}
%cmake_build

%install
%cmake_install

mkdir -p %{buildroot}%{_sysconfdir}
sed -e 's|^port =.*$|port = /dev/ttyS0|' \
    -e 's|^connection =.*$|connection = dlr3|' \
    -e 's/$//' \
    < docs/config/gammurc > %{buildroot}%{_sysconfdir}/gammurc

mkdir -p %{buildroot}%{_udevrulesdir}
install -m644 %{SOURCE1} %{buildroot}%{_udevrulesdir}/69-gammu-acl.rules

%find_lang %{name} --all-name

%files -f %name.lang
%doc ChangeLog COPYING INSTALL.* README.*
%exclude /usr/share/doc/gammu/manual
%exclude /usr/share/doc/gammu/examples/
%attr(0644,root,root) %config(noreplace) %{_sysconfdir}/gammurc
%{_udevrulesdir}/*.rules
%{_datadir}/bash-completion/completions/gammu
%{_bindir}/gammu
%{_bindir}/gammu-smsd
%{_bindir}/gammu-smsd-inject
%{_bindir}/gammu-smsd-monitor
%{_bindir}/gammu-detect
%{_bindir}/jadmaker
%{_datadir}/gammu
%{_unitdir}/gammu-smsd.service
%{_mandir}/man1/gammu-detect.*
%{_mandir}/man1/gammu-smsd-inject.*
%{_mandir}/man1/gammu-smsd-monitor.1.*
%{_mandir}/man1/gammu-smsd.*
%{_mandir}/man1/gammu.*
%{_mandir}/man1/jadmaker.*
%{_mandir}/man[57]/*

%files -n %libname
%{_libdir}/*.so.%{major}{,.*}

%files -n %libnamedev
%{_bindir}/gammu-config
%{_libdir}/*.so
%{_includedir}/gammu
%{_mandir}/man1/gammu-config.*
%{_libdir}/pkgconfig/*.pc


%changelog
* Sun Apr 03 2022 umeabot <umeabot> 1.41.0-4.mga9
+ Revision: 1841558
- Mageia 9 Mass Rebuild

* Tue Mar 08 2022 mrambo3501 <mrambo3501> 1.41.0-3.mga9
+ Revision: 1789876
- fix files list

* Mon Feb 17 2020 umeabot <umeabot> 1.41.0-2.mga8
+ Revision: 1537641
- Mageia 8 Mass Rebuild
+ wally <wally>
- build with new cmake macros

* Tue Nov 05 2019 daviddavid <daviddavid> 1.41.0-1.mga8
+ Revision: 1457788
- new version: 1.41.0

* Thu Feb 07 2019 daviddavid <daviddavid> 1.40.0-1.mga7
+ Revision: 1363910
- new version: 1.40.0

* Sun Sep 23 2018 umeabot <umeabot> 1.39.0-3.mga7
+ Revision: 1297820
- Mageia 7 Mass Rebuild

* Thu Apr 26 2018 wally <wally> 1.39.0-2.mga7
+ Revision: 1222723
- loosen lib pkg requires
- tighten devel pkg requires
- drop old obsoletes

* Thu Apr 26 2018 wally <wally> 1.39.0-1.mga7
+ Revision: 1222716
- new version 1.39.0
- new lib major 8
- python bindings are now in separate python-gammu src pkg

* Sat Dec 23 2017 wally <wally> 1.35.0-5.mga7
+ Revision: 1184224
- rebuild for new mariadb

* Thu Feb 11 2016 umeabot <umeabot> 1.35.0-4.mga6
+ Revision: 953972
- Mageia 6 Mass Rebuild

* Wed Oct 21 2015 tv <tv> 1.35.0-3.mga6
+ Revision: 893366
- fix build: exclude some doc
- fix build: exclude some doc

* Tue Jun 09 2015 vaci0 <vaci0> 1.35.0-1.mga6
+ Revision: 822958
-Update to new version 1.35.0

* Sun Jan 11 2015 vaci0 <vaci0> 1.34.0-1.mga5
+ Revision: 809905
- Update to new version 1.34.0

* Tue Nov 25 2014 cjw <cjw> 1.33.0-9.mga5
+ Revision: 799119
- rebuild against postgresql9.4

* Wed Oct 15 2014 umeabot <umeabot> 1.33.0-8.mga5
+ Revision: 746723
- Second Mageia 5 Mass Rebuild

* Sat Sep 27 2014 tv <tv> 1.33.0-7.mga5
+ Revision: 726888
- add more excludes

* Sat Sep 27 2014 tv <tv> 1.33.0-6.mga5
+ Revision: 726270
- rebuild for missing pythoneggs deps

* Thu Sep 25 2014 wally <wally> 1.33.0-5.mga5
+ Revision: 724681
- exclude %%_docdir from auto-requires
- BR gudev-1.0

* Tue Sep 16 2014 umeabot <umeabot> 1.33.0-4.mga5
+ Revision: 679406
- Mageia 5 Mass Rebuild

* Sat Jul 05 2014 tv <tv> 1.33.0-3.mga5
+ Revision: 643452
- switch to pkgconfig() style BRs

* Sat May 31 2014 pterjan <pterjan> 1.33.0-2.mga5
+ Revision: 628205
- Rebuild for new Python

* Sun Mar 02 2014 vaci0 <vaci0> 1.33.0-1.mga5
+ Revision: 598598
- Update to new version

* Fri Oct 18 2013 umeabot <umeabot> 1.32.0-5.mga4
+ Revision: 521045
- Mageia 4 Mass Rebuild

* Wed Jan 16 2013 fwang <fwang> 1.32.0-4.mga3
+ Revision: 388497
- correct udev rules dir

* Fri Jan 11 2013 umeabot <umeabot> 1.32.0-3.mga3
+ Revision: 351042
- Mass Rebuild - https://wiki.mageia.org/en/Feature:Mageia3MassRebuild

* Wed Oct 03 2012 malo <malo> 1.32.0-2.mga3
+ Revision: 302271
- update RPM group

* Tue Jul 03 2012 vaci0 <vaci0> 1.32.0-1.mga3
+ Revision: 266875
- Update to version 1.32.0

* Mon Jun 11 2012 juancho <juancho> 1.31.90-1.mga3
+ Revision: 259651
- Updated to testing version 1.31.90, and added patch to fix compilation error.

* Fri Jan 27 2012 kamil <kamil> 1.31.0-1.mga2
+ Revision: 202301
- new version 1.31.0

* Wed Jul 20 2011 fwang <fwang> 1.30.0-1.mga2
+ Revision: 126910
- new version 1.30.0

* Thu Mar 24 2011 dmorgan <dmorgan> 1.29.0-3.mga1
+ Revision: 77051
- Rebuild against new mysql

* Thu Mar 24 2011 boklm <boklm> 1.29.0-2.mga1
+ Revision: 76139
- rebuild for bug #497

* Mon Mar 07 2011 dmorgan <dmorgan> 1.29.0-1.mga1
+ Revision: 66264
- Remove mdv macros
- imported package gammu


* Wed Jan 19 2011 Funda Wang <fwang@mandriva.org> 1.29.0-1mdv2011.0
+ Revision: 631676
- new version 1.29.0

* Sat Jan 01 2011 Oden Eriksson <oeriksson@mandriva.com> 1.28.0-6mdv2011.0
+ Revision: 627236
- rebuilt against mysql-5.5.8 libs, again

* Thu Dec 30 2010 Oden Eriksson <oeriksson@mandriva.com> 1.28.0-5mdv2011.0
+ Revision: 626521
- rebuilt against mysql-5.5.8 libs

* Sun Dec 05 2010 Oden Eriksson <oeriksson@mandriva.com> 1.28.0-3mdv2011.0
+ Revision: 609658
- rebuilt against new libdbi

* Wed Nov 03 2010 Funda Wang <fwang@mandriva.org> 1.28.0-2mdv2011.0
+ Revision: 592714
- update file list

  + Michael Scherer <misc@mandriva.org>
    - rebuild for python 2.7

* Thu Jul 15 2010 Funda Wang <fwang@mandriva.org> 1.28.0-1mdv2011.0
+ Revision: 553428
- new version 1.28.0

* Thu Dec 24 2009 Frederik Himpe <fhimpe@mandriva.org> 1.27.0-1mdv2010.1
+ Revision: 481989
- update to new version 1.27.0
- Update to new version 1.26.93

* Wed Dec 16 2009 Frederic Crozat <fcrozat@mandriva.com> 1.26.92-2mdv2010.1
+ Revision: 479479
- Fix invalid udev rules (Mdv bug #56107)

* Thu Dec 03 2009 Funda Wang <fwang@mandriva.org> 1.26.92-1mdv2010.1
+ Revision: 472979
- new version 1.26.92

* Thu Nov 19 2009 Frederik Himpe <fhimpe@mandriva.org> 1.26.91-1mdv2010.1
+ Revision: 467543
- update to new version 1.26.91

* Sat Nov 07 2009 Frederik Himpe <fhimpe@mandriva.org> 1.26.90-1mdv2010.1
+ Revision: 462662
- Disable parallel make: it breaks build
- update to new version 1.26.90

* Tue Oct 27 2009 Frederic Crozat <fcrozat@mandriva.com> 1.26.1-2mdv2010.0
+ Revision: 459494
- Add udev ACL rules for ttyACM

* Wed Sep 09 2009 Frederik Himpe <fhimpe@mandriva.org> 1.26.1-1mdv2010.0
+ Revision: 435905
- Update to new version 1.26.1 (new major)

* Sat Jul 11 2009 Funda Wang <fwang@mandriva.org> 1.25.0-2mdv2010.0
+ Revision: 394733
- fix file list
- BR usb
- new version 1.25.0

* Mon May 04 2009 Funda Wang <fwang@mandriva.org> 1.24.0-1mdv2010.0
+ Revision: 371555
- New version 1.24.0

* Wed Mar 18 2009 Funda Wang <fwang@mandriva.org> 1.23.1-1mdv2009.1
+ Revision: 357109
- New version 1.23.1

* Mon Jan 19 2009 Funda Wang <fwang@mandriva.org> 1.22.91-1mdv2009.1
+ Revision: 331253
- New version 1.22.91
- add BRs

* Sun Jan 04 2009 Jérôme Soyer <saispo@mandriva.org> 1.22.1-1mdv2009.1
+ Revision: 324645
- update to new version 1.22.1

* Thu Dec 18 2008 Funda Wang <fwang@mandriva.org> 1.22.0-1mdv2009.1
+ Revision: 315680
- New version 1.22.0

* Sat Oct 11 2008 Funda Wang <fwang@mandriva.org> 1.21.0-1mdv2009.1
+ Revision: 292071
- New version 1.21.0

* Thu Aug 07 2008 Thierry Vignaud <tv@mandriva.org> 1.20.0-2mdv2009.0
+ Revision: 266832
- rebuild early 2009.0 package (before pixel changes)

  + Pixel <pixel@mandriva.com>
    - do not call ldconfig in %%post/%%postun, it is now handled by filetriggers

* Sun May 11 2008 Funda Wang <fwang@mandriva.org> 1.20.0-1mdv2009.0
+ Revision: 205441
- update to new version 1.20.0

* Tue May 06 2008 Funda Wang <fwang@mandriva.org> 1.19.91-1mdv2009.0
+ Revision: 201768
- New version 1.19.91

* Fri Apr 25 2008 Funda Wang <fwang@mandriva.org> 1.19.90-1mdv2009.0
+ Revision: 197367
- New version 1.19.90

* Wed Apr 16 2008 Funda Wang <fwang@mandriva.org> 1.19.0-1mdv2009.0
+ Revision: 194541
- New version 1.19.0

* Thu Feb 07 2008 Funda Wang <fwang@mandriva.org> 1.18.90-1mdv2008.1
+ Revision: 163359
- New version 1.18.90

* Wed Jan 30 2008 Funda Wang <fwang@mandriva.org> 1.18.0-1mdv2008.1
+ Revision: 160290
- New version 1.18.0

* Sun Jan 27 2008 Funda Wang <fwang@mandriva.org> 1.17.92-1mdv2008.1
+ Revision: 158583
- New version 1.17.92

* Sun Jan 06 2008 Funda Wang <fwang@mandriva.org> 1.17.0-1mdv2008.1
+ Revision: 145928
- New version 1.17.0

  + Olivier Blin <oblin@mandriva.com>
    - restore BuildRoot

  + Thierry Vignaud <tv@mandriva.org>
    - kill re-definition of %%buildroot on Pixel's request

* Sun Dec 16 2007 Funda Wang <fwang@mandriva.org> 1.16.0-1mdv2008.1
+ Revision: 120515
- update to new version 1.16.0

* Tue Dec 04 2007 Funda Wang <fwang@mandriva.org> 1.15.90-1mdv2008.1
+ Revision: 115295
- New version 1.15.90

* Tue Nov 20 2007 Funda Wang <fwang@mandriva.org> 1.15.0-1mdv2008.1
+ Revision: 110747
- New version 1.50.0

* Thu Nov 08 2007 Funda Wang <fwang@mandriva.org> 1.14.0-1mdv2008.1
+ Revision: 106896
- New version 1.14.0

* Sun Oct 28 2007 Funda Wang <fwang@mandriva.org> 1.13.95-1mdv2008.1
+ Revision: 102802
- New version 1.13.95

* Fri Oct 19 2007 Funda Wang <fwang@mandriva.org> 1.13.94-2mdv2008.1
+ Revision: 100168
- Obsoletes old devel package

* Wed Oct 17 2007 Funda Wang <fwang@mandriva.org> 1.13.94-1mdv2008.1
+ Revision: 99569
- New major
- Updated to svn 1628
- updated to svn release to fix build
- New version 1.13.94

* Wed Aug 22 2007 Funda Wang <fwang@mandriva.org> 1.13.0-1mdv2008.0
+ Revision: 68852
- New version 1.13.0

* Tue Aug 14 2007 Funda Wang <fwang@mandriva.org> 1.12.94-1mdv2008.0
+ Revision: 63191
- New version 1.12.94

* Tue Aug 07 2007 Funda Wang <fwang@mandriva.org> 1.12.93-2mdv2008.0
+ Revision: 59765
- renew patch from svn
- Add patch to build on 64 bit machines
- New testing version 1.12.93
- br doxygen and dot
- fix file list
- Use cmake macro
- BR cmake
- New version 1.12.0

* Tue Apr 17 2007 Erwan Velu <erwan@mandriva.org> 1.10.0-1mdv2008.0
+ Revision: 14119
- 1.10


* Tue Dec 05 2006 Nicolas Lécureuil <neoclust@mandriva.org> 1.09.00-1mdv2007.0
+ Revision: 91306
- New version 1.09.00

* Mon Nov 13 2006 Lenny Cartier <lenny@mandriva.com> 1.08.00-1mdv2007.1
+ Revision: 83580
- Update to 1.08.00
- Import gammu

* Sat Jun 17 2006 Austin Acton <austin@mandriva.org> 1.07.00-1mdv2007.0
- Rebuild

* Tue Jun 13 2006 Lenny Cartier <lenny@mandriva.com> 1.07.00-1mdv2007.0
- 1.07.00

* Thu Apr 20 2006 Lenny Cartier <lenny@mandriva.com> 1.06.00-1mdk
- 1.06.00

* Mon Mar 13 2006 Lenny Cartier <lenny@mandriva.com> 1.05.00-1mdk
- 1.05.00

* Fri Dec 02 2005 Lenny Cartier <lenny@mandriva.com> 1.03.20-1mdk
- 1.03.20

* Fri Oct 14 2005 Lenny Cartier <lenny@mandriva.com> 1.02.25-1mdk
- 1.02.25

* Tue Oct 04 2005 Lenny Cartier <lenny@mandriva.com> 1.02.20-1mdk
- 1.02.20

* Sat Oct 01 2005 Lenny Cartier <lenny@mandriva.com> 1.02.16-1mdk
- 1.02.16

* Tue Aug 23 2005 Erwan Velu <velu@seanodes.com> 1.02-1mdk
- 1.02

* Sat Jun 18 2005 Erwan Velu <velu@seanodes.com> 1.01.11-2mdk
- Fixing conflict

* Thu May 12 2005 Lenny Cartier <lenny@mandrakesoft.com> 1.01.11-1mdk
- 1.01.11

* Thu Apr 14 2005 Lenny Cartier <lenny@mandrakesoft.com> 1.01.0-1mdk
- 1.01.0

* Tue Mar 01 2005 Lenny Cartier <lenny@mandrakesoft.com> 1.00.10-1mdk
- 1.00.10

* Mon Feb 21 2005 Lenny Cartier <lenny@mandrakesoft.com> 1.00.04-1mdk
- 1.00.04

* Wed Feb 09 2005 Lenny Cartier <lenny@mandrakesoft.com> 1.00.0-1mdk
- 1.00.0

* Mon Jan 24 2005 Lenny Cartier <lenny@mandrakesoft.com> 0.99.22-1mdk
- 0.99.22

* Tue Oct 26 2004 Lenny Cartier <lenny@mandrakesoft.com> 0.99.0-1mdk
- 0.99.0

* Sat Sep 25 2004 Erwan Velu <erwan@mandrakesoft.com> 0.98.0-1mdk
- Initial mdk package

