%define _disable_ld_no_undefined 1
%define _unpackaged_files_terminate_build 0 

Summary:	CoovaChilli is an open-source software access controller for captive portal hotspots
Name:		coova-chilli
Version:	1.6
Release:	2%{?dist}
License:	GPLv3
Packager:	Richard REY (Rexy) 
Group:		System/Servers
URL:		https://coova.github.io/CoovaChilli
Source:		%{name}-%{version}.tar.gz
Patch 0:		chilli.h.patch
Patch 1:		chilli_limits.h.patch
Patch 2:		redir.c.patch
Patch 3:		Makefile.am.patch
Patch 4:		CoovaChilliLib.py.patch
BuildRequires:	gengetopt
BuildRequires:	libtool
BuildRequires:	openssl-devel
Provides:	coova-chilli = %{version}-%{release}
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

%description
Coova-Chilli is a fork of the ChilliSpot project - an open source captive
portal or wireless LAN access point controller. It supports web based login
(Universal Access Method, or UAM), standard for public HotSpots, and it
supports Wireless Protected Access (WPA), the standard for secure roamable
networks. Authentication, Authorization and Accounting (AAA) is handled by
your favorite radius server. Read more at http://coova.github.io/.

%prep
%setup -q -n %{name}-%{version}

%patch 0 -p3
%patch 1 -p0
%patch 2 -p0
%patch 3 -p0
%patch 4 -p0

cp ../../SOURCES/SHA256.c ./src/SHA256.c
cp ../../SOURCES/SHA256.h ./src/SHA256.h

%build
sh bootstrap
%configure \
	--disable-static \
	--enable-shared \
	--enable-largelimits \
	--enable-chilliredir \
	--enable-chilliscript \
	--with-poll \
	--enable-dhcpopt \
	--enable-json \
	--enable-mdns \
	--with-openssl

automake --add-missing
%make_build

%post
%_post_service chilli

%preun
%_preun_service chilli

%install
%make_install

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_sbindir}/*
%{_libdir}/*.so*
%doc AUTHORS COPYING ChangeLog INSTALL README doc/dictionary.coovachilli doc/attributes
%config %{_sysconfdir}/chilli.conf
%config %{_sysconfdir}/chilli/gui-config-default.ini
%config(noreplace) %{_sysconfdir}/chilli/defaults
%dir %{_sysconfdir}/chilli
%{_sysconfdir}/init.d/chilli
%{_sysconfdir}/chilli/wwwsh
%{_sysconfdir}/chilli/functions
%{_sysconfdir}/chilli/*.sh
%{_mandir}/man1/*.1*
%{_mandir}/man5/*.5*
%{_mandir}/man8/*.8*
%exclude %{_sysconfdir}/chilli/www/*
%exclude %{_sysconfdir}/chilli/wpad.dat
%exclude %{_includedir}/chilli*
%exclude %{_libdir}/*.la*
%exclude %{_libdir}/python/CoovaChilliLib.py*

%changelog
* Mon Jun 17 2024 Richard REY (aka Rexy) - 1.6-2.mga9
- 1.6 release for Mageia9 (master branch - last commits on Apr 1, 2023)
* Fri Oct 14 2022 Paul BAESKENS (aka StaringCat) - 1.6-1.mga8
- Add SHA256 in PAP protocol
* Sat Jul 23 2022 Richard REY (aka Rexy) - 1.6-1.mga8
- 1.6 release for Mageia8
* Wed Feb 24 2021 Richard REY (aka Rexy) - 1.6-1.mga7
- 1.6 release for Mageia7
* Fri May 22 2020 Richard REY (aka Rexy) - 1.5-1.mga7
- 1.5 release for Mageia7
* Mon May 22 2017 Tom Houdayer - 1.4-3.mga5
- Add mDNS support
* Sat May 06 2017 Tom Houdayer - 1.4-2.mga5
- Add OpenSSL support
* Mon Dec 19 2016 Rexy for ALCASAR project
- 1.4-1 release for Mageia5
* Sun Nov 13 2016 Rexy for ALCASAR project
- 1.3.2-2 release (including the code resolving IPSEC bug #255 & #301)
* Tue Oct 25 2016 Rexy for ALCASAR project
- 1.3.2-1 release
* Thu Jun 2 2016 Rexy for ALCASAR project
- 1.3.1.4 release
* Sun Apr 3 2016 Rexy for ALCASAR project
- 1.3.1.3 release
* Tue May 14 2013 Crox for ALCASAR project
- 1.3.0 release
* Mon Jun 18 2012 Rexy for ALCASAR project
- 1.2.9-1 release
* Wed Jan 18 2012 Rexy for ALCASAR project
- 1.2.9 release
* Sun Jul 11 2011 Rexy for ALCASAR project
- 1.2.8 release
* Sat Feb 12 2011 Rexy for Alcasar project
+ revision: 433
+ add _disable_ld_no_undefined 1
- 1.2.6 release
* Sat Nov 20 2010 Rexy for Alcasar project
+ revision: 394
- 1.2.5 release
* Sat Jan 2 2010 <david@coova.com>
- 1.2.0 release
* Thu Sep 30 2007 <david@coova.com>
- 1.0.8 release
* Thu Aug 20 2007 <david@coova.com>
- 1.0-coova.7 release
* Thu Jun 7 2007 <david@coova.com>
- 1.0-coova.6 release
* Wed May 16 2007  <david@coova.com>
- 1.0-coova.5 release
* Wed Feb 07 2007  <david@coova.com>
- 1.0-coova.4 release
* Wed Nov 15 2006  <david@coova.com>
- 1.0-coova.3 release
* Thu Mar 25 2004  <support@chillispot.org>
- Initial release.
