#! /bin/bash
# Unbound DNS Safe Search config entries for ALCASAR
# Create a list with : https://gist.github.com/johannrichard/a645b32c75646b1f56813b517eb6cc8b
# Modifications :
#   - remove all "IN ADDR" resolutions
#   - add "www.ecosia.org CNAME strict-safe-search.ecosia.org" (see Ecosia help center)
#   - run this script to create unbound config file (/etc/unbound/conf.d/blacklist/safe-searching & /etc/unbound/conf.d/whitelist/safe-searching
while read -r line; do
	echo -n 'local-zone: '`echo $line|cut -d" " -f2` >> safe-searching
      	echo -n '" redirect' >> safe-searching
	echo >> safe-searching
	echo -n 'local-data: '`echo $line|cut -d" " -f2` >> safe-searching
      	echo -n ' CNAME '`echo $line|cut -d" " -f4` >> safe-searching
	echo >> safe-searching
done < safe-searching-wk
