# ALCASAR CHANGELOG
## 3.8.0 (SVN revision: )
* NEWS
	* ALCASAR Federation (thx to Alexandre BOUIJOUX)
* ACC
	* phpsysinfo (last version)
	* Network : improve imput controls (@MAC & @IP)
	* LetsEncrypt : improve input control (domain & Email)
	* Users database : can delete users who have been inactive for more than a year
* CHANGES
	* Improve local DNS resolution (resolv.conf)
	* Redirect root local mails to sysadmin (thx to jay jay)
* BUGS
	* alcasar-conf.sh doesn't modify correctly entries beginning with spaces
	* Avoid duplicate entries in /etc/hosts (thx to Guillaume MARSAT)
	* Prevent nfcapd from failing to start at boot time (thx to Laurent ROUX)

## 3.7.2 (SVN revision: 3284)
* NEWS
	* kernel 6.6.88
* CHANGES
* BUGS
	* Adapt coova SQL queries to the new freeradius database schema
	* alcasar-conf.sh doesn't modify correctly "AuthDigestDomain" and "ErrorDocument" lines (thx to Guillaume Marsat)
	* alcasar-conf.sh modifies apache conf to allow external @IP to access ACC (thx to Guillaume Marsat)

## 3.7.1 (SVN revision: 3274)
* CHANGES
	* kernel 6.6.83 - letsencrypt ACME v 3.1.1
* ACC
	* Improve ordering in dataTables display (sort by @IP or #num)
	* Global traffic is displayed again in weekly reports
	* Remove activity reports older than 1 year (as the other archives)
	* Remove some log activities of nfsen-ng
* BUGS
	* Remove old safesearch method
	* Adapt all scripts with new mariadb version (binaries and conf architecture)
	* Add serverchain certificate path in httpd configuration

## 3.7.0 (SVN revision: 3258)
* NEWS
	* Mageia9 (kernel 6.6.79)
* CHANGES
	* E2guardian : new architecture
	* Radius database schema update
	* TOR @IP of node G update
	* Apache replaces lighttpd
	* Default domain is now ".lan" instead of ".localdomain" in accordance with RFC 6762
	* Improve safesearch filtering system
* ACC
	* Use nmap's MAC prefix file instead of our
	* Jquery DataTables is used more often
	* Network statistics display with NFSEN-NG
* BUGS
	* Router tests in ACC
	* Removal of a superfluous filter for user passwords
	* Dhcpd conf error (in bypass mode)
	* Week reports are now adapted with vnstat V2 (thanks to Hubert & Clément)
* SECURITY
* WEB
	* WebSVN is now in HTTPS
## 3.6.1 (SVN revision: 3180)
* NEWS
* CHANGES
	* kernel 5.15.126
	* Let's Encrypt ACME V3.0.7 - Adapt alcasar script for ECC (Elliptic Curve Cryptography) certificates
	* Master branch of ipt_NETFLOW (06/2023)
	* nfdump 1.7.3
	* intercept.php : improve interface for small devices (mobile phones)
	* Remove clamav
* ACC
	* Add organism name in menu frame to distinguish several alcasar
	* Update jquery-ui (1.13.2), phpsysinfo 3.4.3
* BUGS
	* gammu systemd unit : it should wait mysqld to start
	* Update NTP option in DHCP response in coova conf file (alcasar-conf.sh)
	* Retrieve custom firewall rules & custom filtering services when updating (Thanks to Nicolas REYNAUD)
	* Redirection to HTTPS when needed (intercept & status pages)
* SECURITY
	* Fix a CSRF+RCE vulnerability in activity.php
	* Fix two RCE vulnerabilities in email_registration_back.php & still_connected.php
* WEB
	* New infrastructure (DL380 Gen 10 + proxmox 8 + VM-Mageia 9)
	* WebSVN 2.8.0 --> 2.8.3

# 3.6.0 (SVN revision : 3108)
* NEWS
	* Mageia 8 - Kernel 5.15.82
* CHANGES
	* Add SHA256 in PAP protocol (coovachilli). Thanks to Paul BAESKENS (aka StaringCat)
	* Remove "dnsmasq" resolver used with whitelist filtering system (we now use ipset capabilities of "unbound")
	* Let's Encrypt ACME V3.0.5
	* Manage the update between versions of Mageia
* ACC
	* phpsysinfo 3.4.2 - Vnstat-frontend fork by "tomangert"
* BUGS
	* Replace deprecated php functions (php7 --> php8)
	* Access the network between ALCASAR and the Router in bypass mode
* WEB
	* WebSVN 2.7.0 --> 2.8

## 3.5.5 (SVN revision : 3071)
* NEWS
	* mail registration service : Thanks to K@M3L & T3RRY (LaPlateforme.io) and to joss_p
* CHANGES
	* Add a third RPM repository (http://ftp.free.fr)
	* Improve firewall local rules & firewall rules in bypass mode
	* Add SMTP to the list of openned ports (for filtered users)
	* Adapt user page when HTTPS is enabled with an official certificate (Thanks to Alexandre VEZIN)
* ACC
	* Avoid password preload text in password forms
	* Improve "let's encrypt" & "Internet connexion" forms
	* Add an overlay with spinner on all submit forms (Thanks to Alexandre VEZIN)
	* SSH : admin can secure it on INTIF & EXTIF : change the default port & set en "admin_from" IP (Thanks to Alexandre VEZIN)
	* Admin can allow/forbid access to the LAN located between ALCASAR and the broadband router (Thanks to Alexandre VEZIN)
* BUGS
	* Adapt "alcasar-network.sh" when ALCASAR is in DHCP mode
	* Adapt "alcasar-watchdog.sh" when ALCASAR is in multiWAN mode
* WEB
	* WebSVN 2.6.1 --> 2.7.0

## 3.5.4 (SVN revision: 2979)
* NEWS
	* Multi-WAN access with load balancing per user (Thx to Pierre RIVAULT for this great job)
* CHANGES
    * kernel 5.10.46 + ipt_NETFLOW 2.6 + Let's Encrypt ACME 2.9.0 + nfdump 1.6.23
    * Bypass mode works now also in dhcp
    * After the system has been updated (every day at 3 am), check if reboot is needed
    * phpsysinfo 3.3.4
* BUGS
	* Fix local DNS configuration when installing in dhcp mode
	* Fix a display bug for web sites in exception (Thx to Olivier C).
	* Fix local DNS configuration when changing the configuration in alcasar.conf
* WEB
	* Webserver is updated (mga8 - apache 2.4.48 - apache-svn 1.14.1)

## 3.5.3 (SVN revision: 2944)
* NEWS
	* WIFI4EU automatic integration via ACC
* CHANGES
	* Add the favicon in status page
	* Add another filter when importing the blacklist to remove line beginning with a dot
	* Improve tcpdump filter when IoT live captures option is enable
	* Adapt CA certificate to edge/chrome (add the "Subject Alt Name" - SAN)
	* Improve "alcasar-CA.sh" script : can create server certificate for every hostname (not only alcasar.localdomain)
	* kernel 5.10.30 + coova-chilli 1.6 + nfdump 1.6.22
	* Move all alcasar systemd units in "/etc/systemd" (compliant with Linux file-hierarchy)
	* ISO File is now created from a running alcasar system with updated packages.
	* ISO file can now boot on more devices (USB, EFI, VM, etc.) with several video configurations : Thanks to Pierre RIVAULT
* BUGS
	* Fix a display bug in ACC activity & stat page
	* Add the CA chain certificates in Coova in order to allow authentication with the last versions of Chrome/Edge
	* When blacklisted, display the categories even if the domain name contains a private prefix (ie mycompagny.whereby.com)
* WEB
	* websvn.alcasar.net is updated to V2.6.0

## 3.5.2 (SVN revision: 2901)
* NEWS
	* ALCASAR can now keep the user authenticated during 24h (attribute "keeping sessions alive (yes/no)")
	* Ask the "unbound" Mageia packager to add "--enabled-ipset" for the next Mageia-8. validated : https://bugs.mageia.org/show_bug.cgi?id=27803
	* HTTPS login option is now taking care during the update process
* ACC
	* Improve IoT capture system
	* Manufacturer mac addresses resolution list is now embeded in ALCASAR archive
	* Admin can add network addresses in blacklist
	* The control of the filenames imported in the blacklist is more strict
	* End of spanish translation
* CHANGES
	* Status page is now in HTTPS when interception is also in HTTPS
* BUGS
	* unbound-whitelist doesn't send DNS requests to the listen port of Dnsmasq (55)
	* Bad rights on file "/tmp/current_users.txt"
	* fix a radius message
* WEB
    * Web site is now in HTTPS

## 3.5.1 (SVN revision: 2878)
* NEWS
	* Integration of the European “WIFI4EU” system (in the exploitation doc)
	* linux-Kernel 5.7.19; ipt-NETFLOW 2.5.1; gammu 1.42
* ACC
	* Spanish translation (Thanks to Germán BOWERS)
* CHANGES
	* Improve the voucher (tickets) display with a serif font
	* Local DNS resolution simplification
	* ALCASAR E2guardian html template when intercepted (due to blacklisted-URL or malware detected)
	* Retrieve letsencrypt and gammu-smsd configuration when updating
	* The status page is now ciphered when the interception page is ciphered.
* BUGS
	* Network IP addresses can now be set as exception
	* "sudo" RPM isn't automatically loaded
	* Several fail2ban fixes & simplifications

# 3.5.0 (SVN revision: 2847)
* NEWS
	* Mageia7.1 and Linux Kernel 5.6.14
	* Remove HAVP & Tinyproxy (replaced by E2guardian & clamd)
	* All user pages are now responsive. Thanks to Clément GELINEAU
	* Add an additional BL : Malwares Command & Control servers (C&C) from "osint.bambenekconsulting.com/feeds/". Thanks to Sven RATH
	* Add IoT live capture (to detect & analyze private data leakage). Thanks to Dorian LEMOINE & Guillaume GELLUSSEAU
	* Update processes have been improved
* ACC
    * "sysinfo" is displayed with "phpsysinfo 3.3.2"
    * global flow statistics generated by "vnstat-dashboard" (instead of "vnstat-frontend")
    * Improve the process to import "official" and "Let's encrypt" certificates
* CHANGES
	* German translations have been updated. Thanks to Sven RATH
	* Improve RPMs controls at the installation stage
	* Improve BL auto-update system
* WEB
	* starbuck (ALCASAR subversion) has been updated (mageia7 + websvn 2.5.1)

# 3.4.0 (SVN revision: 2754)
* NEWS
	* Linux Kernel 4.14.131 - ipt_NETFLOW 2.4
	* Replace DNSmasq servers with Unbound servers
	* Add LDAPS (LDAP SSL) support.
	* Add a global group named "default" for all users (the "ldap" group still exists for users authenticated through LDAP/A.D.).
	* Add LDAP filter.
	* responsive captive page (thx to Aurélien DUBOIS)
* ACC
	* Add LDAP configuration assistant.
* CHANGES
	* Do not perform LDAP query for authentication of trusted authorized equipment.
	* Improve script syntax
	* LDAP server is automatically added to the DHCP static IP reservation.
* BUGS
	* Fix listening address for nfcapd (was 0.0.0.0 instead of 127.0.0.1)
	* Fix some typo
	* Fix priority of filter attributes at group creation.
	* Fix ignored filters assigned to the default group.
	* Fix group attributes in user ticket generation.
	* Fix LDAP users login without the "ldap" group created.
	* Fix bad certificates chain generation when using default certificates.
	* Fix the configuration application for LDAP.
	* Fix print info with multiple words in static IP reservation in ACC.
	* Fix IP filter in the imputability log report generator.
* SECURITY
	* Merge bad username and bad password errors at user login.

## 3.3.3 (SVN revision: 2687)
* NEWS
	* Linux Kernel 4.14.89
	* Add Qwant in safesearch option for whitelist and blacklist
	* Improve install on a server with more than 2 network card (add internal interface selector instead of choosing the first one).
	* Use a custom blacklist & whitelist description file instead of the default one
	* Updating blacklist & "TOR nodes" custom list
	* Updating the WebSVN server to V2.5-dev with Tom patches (https://github.com/websvnphp/websvn/commits/master)
	* New script to create the ISO file (mageiar) using docker. ISO file is now published on web site.
* BUGS
	* Keep custom blacklists when upgrading from dansguardian to e2guardian
	* Automatically launch database migration scripts after import user database.
	* Improve firewall rules for whitelist users (anti-bypass)

## 3.3.2 (SVN revision: 2660)
* NEWS
	* Add Bing and Youtube in safesearch option for whitelist and blacklist
	* Linux Kernel 4.14.78
* ACC
	* Allow "status page must stay open" user/group attribute to be unset in ACC.
	* Disconnect users after deleting it and members of a group at its creation and deletion.
* BUGS
	* remove "SurfMap" (an addon for NFsen) due to changes of Google Maps terms of use (while waiting for a new graphic display)
	* Fix a bug when the username is "alcasar"
	* Fix blacklist pureip option
	* Call the right script from whitelist ACC configuration page when setting safesearch option
	* Fix resolution of Internet domain names that are subdomains of the imported certificate domain.
	* Fix user deletion in its filter ipset when its filter is changed (caused an impossible connection if the old filter was the whitelist).
* CHANGES
	* Remove pureip option in whitelist ACC configuration page

## 3.3.1 (SVN revision: 2642)
* NEWS
	* Linux kernel 4.14.69
	* Introduce "Alcasar-Reconnect-Timeout" RADIUS attribute (not yet available in ACC).
	* Add original "Max-All-Session" RADIUS attribute.
	* Update acme.sh (Let's Encrypt client) to v2.7.9.
	* Don't display "CERT" menu when HTTPS isn't enable for user's network flows
	* Add counter to "CoovaChilli-Max-Total-Octets" (maximum of data exchanged) RADIUS attribute (in order to prevent quota reset on the login).
* ACC
	* Remove network check in ACC homepage.
	* Remove "Maximum of data downloaded/uploaded" filters.
* CHANGES
	* Save SMS status and number in ALCASAR configuration file (persistent to updates).
	* Launch Gammu at startup when the SMS service is enabled and check Gammu status in alcasar-daemon.
	* Print a dedicated error message for each connection error.
* BUGS
	* vnstat : bug when updating version.
	* Fix a bug in NfSen during its installation.
	* Fix a reload infinity loop in ACC auto-registration when the modem is unplugged.
	* Check that username is not empty when creating an ACC profile.
SECU
	* Use HTTPS repositories of Mageia.

# 3.3.0 (SVN revision: 2587)
* NEWS
	* Linux kernel 4.14.56, ipt_NETFLOW 2.3, gammu 1.39
	* Replace Apache with Lighttpd
	* Replace DansGuardian with E²Guardian
	* Add "Maximum of data exchanged daily/monthly" attributes.
* ACC
	* Add "nfsen", "fail2ban" and "vnstat" services to the ACC system page.
	* Add a timetable to help creation of authorized periods in a week
* CHANGES
	* Explode the "Filter-Id" RADIUS attribute into ALCASAR vendor attributes (they can now be set independently and with a good user/group priority).
	* Add "Alcasar-Expire-After" RADIUS attribute instead of replace "Max-All-Session".
	* Rename "ChilliSpot-*" RADIUS attributes to "CoovaChilli-*".
	* Check that the network interfaces are connected before updating ALCASAR.
	* local hostnames are now resolved in "/etc/hosts" (better for dnsmasq)
	* improve update process (even if the Linux Distribution is updated)
* BUGS
	* alcasar.sh : Fix exiting on wrong hardware architecture
	* Fix broken fail2ban configuration
	* Fix control of "ulogd-*" and "dnsmasq-*" services in ACC.
	* Fix imputability logs generation with a password containing spaces.
	* Fix configuration of DHCP server for the bypass mode.
* SECURITY
	* Reload Fail2Ban rules after a firewall reload (eg: after bypass state changes or Internet reconnections).

# 3.2.0 (SVN revision: 2478)
* NEWS
	* Works with Mageia6
	* Enable HTTPS support for the CoovaChilli JSON API (that allow HTTPS for status.php).
	* The disconnection of users without the status page open can be disabled by a user attribute.
	* ExFat USBKeys allowed
* ACC
	* Print parsed log of MAC address spoofed instead of raw log lines.
	* Add a regex validation when add a local DNS host or a static IP address to avoid breaking the dnsmasq service.
	* Do not show user/group header menu after deleted it.
	* Disconnect an allowed MAC address after deleted it.
	* Reconnect an allowed MAC address after disconnecting it when updating RADIUS attributes.
* CHANGES
	* Set watchdog interval to 10 minutes.
	* Set URL of BL/WL blocked page ressources to ALCASAR hostname instead of blocked domain to prevent cache issues & useless overload.
	* LDAP configuration is now saved in ALCASAR conf file
* BUGS
	* Fix the open of status.php when the user has a redirection URL attribute defined (force redirection to intercept.php after login instead of WISPr-Redirection-URL attribute value).
	* IP address of active users are properly clean from "current_users.txt".
	* Fix allowed MAC address detection in ACC activity page.
	* Fix a bug when generating 50+ user tickets at once.
	* Fix removing a WL through ACC (forgotten line undeleted in alcasar-wl-categories file) and fix a bad character written in configuration file when activate a WL through ACC.
	* Fix detection of popups blocking in Safari.
	* Get number of open session from the whole history instead of just the last 3 sessions in the status page.
	* Remove disallowed characters of login when importing users from a text file.
	* Fix ticket generation of users with accented username.
	* Fix ALCASAR configuration file parsing in scripts (comments are correctly ignored).
* SECURITY
	* Enhances passwords security generated during installation (length: 8 -> 16).

## 3.1.4
* NEWS
	* Add a link for back to the homepage when the user is disconnected in status.php.
* ACC
	* Print group attributes if user attributes are not set in ACC user status.
* CHANGES
	* Increase visibility of the status page warning about disconnection when close.
* BUGS
	* Fix ACC user/group editor where attributes were not changed.
	* Fix PHP errors in ACC user/groupe attributes editor.
	* Fix traceability log due to an omission during the migration from ulog to nflog (alcasar-iptables-local-mac-filtered & alcasar-ip-blocked).
	*  Fix all traceability NFLOG rules by specifying the nfgroup to 1 (since the default group of NFLOG is 0 instead of 1 for ULOG1).
	* Remove Fail2Ban NFLOG logs.

## 3.1.3
* NEWS
	* Add Let's Encrypt integration.
	* Change the ALCASAR CA certificate extension to .crt (to be added more easily in Firefox).
	* Allow hostname different than "alcasar".
	* Check/remove conf file of removed NIC.
	* move udev rule for huawei GSM modem in "/lib/udev" ("/etc/udev" will be deprecated)
* ACC
	* New network configuration UI (dynamic user-friendly diagram form).
	* Show/hide advanced attributes dynamically in user/group creation and edition.
	* Print parsed log of Fail2Ban instead of raw log lines.
	* New ACC menu (with JS instead of PHP reload).
	* Add option to allow unsecure login for user interception.
* BUGS
	* Display info field for DHCP static equipment
	* Fix bug where the encrypted password is printed in a random column in the ACC user editor.
* SECURITY
	* Rename Fail2Ban rule "alcasar_acc-htdigest" to "alcasar_acc" (iptables does not support long name).
	* Remove '/usr/bin/openssl' sudo privilege for 'apache' user.
	* Escape exec() parameters in ACC to prevent RCE attacks.
	* Update NfSen to 1.3.8 (Fix a security vulnerability).

## 3.1.2
* NEWS
	* An update can be fully performed via SSH
	* Linux Kernel (4.4.68)
	* Activate coova HTTPS interception (remove our DNS blackhole rules)
* ACC
	* download/upload inversion (logical traffic display)
	* internationalization & HTML improving
	* Add info field in IP static page
* BUGS
	* doesn't download unused kernel on update process
	* rollback to nfsen 1.3.7 (incompatibility with surfmap)
	* Fix importation of official certificate during the loading of ALCASAR configuration files backup.
* SECURITY
	* Fix Fail2Ban broken rules (alcasar_mod-evasive,alcasar_acc-htdigest,alcasar_change-pwd) and add SSL compatibility for alcasar_mod-evasive rule.
	* Improve ACC log

## 3.1.1
* NEWS
	* Linux Kernel (4.4.59)
	* Migratation of FPDF to wkhtmltopdf (user/vouncher tickets & user file import). (FPDF is removed)
	* Update nfsen (1.3.8)
	* Repackage wkhtmltopdf without unused wkhtmltoimage executable and wkhtmltox library (32.1 Mo -> 10.6 Mo).
	* geoip updating (surfmap)
	* Add warning message on user status page (page closed => disconnection).
	* Print allowed domains in user home (index.php).
	* Add ACC access, Global traffic and Fail2Ban bans to activity report.
	* On authentication, redirects to the status page and open the user's URL to a new tab (instead of the reverse).
	* ALCASAR update process can be fully performed via SSH (preparing via ACC)
	* Print blacklist categories of blocked domain on interception page.
* BUGS
	* The users can change their password
	* managing uamallowed domain is operational again
	* Fix broken SQL library path in autoregistration.php.
	* Fix loop redirection after connection in case of imputability logs warn.
	* Fix test if installed on a VMware
	* Fix ticket print link after user creation.
* SECURITY
	* MSEC (HIDS) is enabled by default
	* Fix vulnerabilities in the user part (1 SQL injection & 2 XSS).
	* Remove ALCASAR version visible in the user part.

# 3.1.0
* NEWS
	* The status window is now in a tab (no more popup).
	* Linux Kernel update (4.4.55) - coova-chilli updated (1.3.2) with IPSEC VPN resolve code (see #255 on coova github)
	* network protocols filtering by user
	* The user is disconnected when his "status tab" is closed (no more watchdog for that)
* ACC
	* Chinese & arab translations
	* MAC resolution (manufacturer) is displayed
	* temporarely MAC authentication can be made "on the fly"
	* some improvements when actions take long time
	* Reporting of Week statistics (in PDF)
	* the imputability logs can be displayed. All the users will be warned at their next connexion.
	* admin connexion logs (when clicking on access counter)
* BUGS
	* manual user disconnexion in ACC (french page only)
	* import BlackList file : doesn't work with domain name longer than 3 letters (ie : .info)

## 3.0.1
* BUGS
	* Fix : filter_id when importing an old users database
	* Fix : dupplicate/remove users attributes
	* Fix : passing trusted websites

# 3.0.0
* NEWS
	* Mageia 5.0 migration
	* ipt-netflow kernel module updated (V2.2) - coova-chilli updated (1.3.1.4)
	* HTTPS interception now works
	* user login name can be accentuated
	* A first BL category (malware) can be update on the fly via rsync
	* Wildcard certificate can be used
	* a blacklist custom file is added (TOR nodes)
* ACC
	* freeradius-web framework has been removed
	* all SQL PHP functions have been rewritten (thanks Clément Siccardi & Raphaël PION for this huge work)
	* the network settings can be change (lan_ip_@, GW, DNS, etc.)
	* a first page in HTML5 (statistic / security)
	* group attributes are displayed in the user edit page
	* The menu of ACC is displayed according to the profile rights
	* reoganisation of OSSI custom files (BL & WL)
* BUGS
	* The Whitelist now works fine
	* The passwords can be longer than 15 digits

## 2.9.2
* NEWS
	* importation of official certificate
	* Configuration of Dansguardian and DNSMASQ for larger sites
	* The SSL level has been improved to avoid recent vulnerabilities (exclude SSLV2 & V3)
	* The autosigned certificate has been improved (key lenght : 2048b and sha256 for fingerprint algorithm)
	* MAC auth equipments are automatically logged just after creation
* BUGS
	* MAC auth equipments in DHCP mode are logout after lease time. They can't be automatically reconnected
* ACC
	* PHP : migration of the deprecated functions --> should be continued for the V3

## 2.9.1
* BUGS
	* Problem with the resolver DNS at the time of the installation
	* Configuration with external DHCP
	* Problem with LDAP server (sradutmp is no more needed)
* NEWS
	* integration of an internal DNS in automatic configuration (alcasar-dns-local.sh)
	* "SMS autoregistration" link in the 'intercept' page (if the service is enabled)
	* It's now possible to update via ssh
* ACC
	* show user info (name & surname) in the "activity" screen (if set)

# 2.9.0
* BUGS
	* Configuration radius with PAP module (remove a warning)
	* Fix an issue when INTIF is a Gb/s card (generic-receive-offload : off)
* NEWS
	* Mageia 4.1 migration
	* Remove Squid - Add Tinyproxy
	* Add the SMS auto-registration system
	* Add whitelist filtering (domains and related IP addreses)
	* Add IP addresses of the Toulouse blacklist in the firewall targets
	* Add whitelist/blacklist/antivirus filtering by users/groups
	* Add surfmap plugin (nfsen)
	* Store user password in SHA256 instead of MD5 (Thanks to Olivier HOUSSENBAY) and use a random SALT (not same hash for two same passwords)
	* Add Network tool statistic : Vnstat
	* BL/WL/Antivirus filtering now works with MAC authentication
* ACC
	* simplify the user registration menu
	* import a file containing a list of blacklist ip addresses or DNS names (ie : CERT)
	* reboot or halt the system is now possible

## 2.8.1
* BUGS
	* a security hole has been patch (EDB-ID: 34595 - OSVDB-ID: 111026)
	* In the intercept page, fix the behaviour (loop) when the user writes "logout" as url
	* correction in "session time" radius counter (thanks to Olivier HOUSSENBAY)

# 2.8.0
* BUGS
	* The file "alcasar-services" is now sorted
	* New graphic option in grub conf file in order to fix issues with mini-itx-ATOM moterboard
* NEWS
	* Firewall-eyes and AWstat are removed from ACC
	* The user attribute "Max_total-time" is now "authorized period after the first connection"
	* Creation of a netflow probe (kernel module)
	* complete network statistics can be viewed in ACC (nfsen)
	* The porttracker nfsen module allows to view network statistics by protocols
	* The imputability files are now included in a single archive file (one per week)
	* The Alcasar name includes the domain name ('localdomain' by default). We prepare the future when we will include the domain name of company.

## 2.7.2
* BUGS
	* Modify the unit 'radiusd.service in order to wait for mysql
	* Creation of an unit 'loadbalancing.service' instead of init.d script
	* Removing the rc.local file
* NEWS
	* Add fail2ban on the following attacks : ssh, https (ACC admin page), Unix accounts
	* Creation of a security page in the ACC : fail2ban alerts, virus stopped by havp+clamav, MAC addresses bloqued by the watchdog process (usurped)

## 2.7.1
* BUGS
	* Fix multi-users voucher
	* Fix a mageia2 bug in network function
* NEWS
	* Add 2 examples of "uamalowed and uamdomain" files with several microsoft update domains
	* Show the blacklist category in "Acces denied" page
	* Watchdog : don't disconnect MAC auth equipments even if they can't be reached (arping)

# 2.7
* BUGS
	* some corrections in the connection popup
	* test if categories enabled of the BL are effectively in the BL (need after an update of the BL)
* NEWS
	* Installation with Mageia2
	* The URL filter works with the new google safesearch regex ('safe=strict' instead of 'safe=vss')
	* The safesearch for google works now with https (redirect on 'nosslsearch' proxy)
	* The WhiteList architecture is enabled
	* All the documentation has been translated in english
	* The security certificate is now signed in sha256
	* Balancing connection is now operational and dynamically checks the Internet connectivity
* CHANGES
	* HAVP doesn't scan youtube flows (too heavy load / no risk)
	* voucher can now be done in multi-users

## 2.6.1
* BUGS
	* The embedded documentation is in right version
	* fix the dhcp static address for eth1 (intif)
* ACC
	* show user information when trusted equipment are listed (better than only MAC address)
	* main page : doesn't show the date of installation in the version field (can be confused)
* NEWS
	* show the GPL

# 2.6
* BUGS
	* "username" in "userinfo" table is varchar(64) like in others tables of ALCASAR database.
	* "activity.php" : don't print "private_ip_address". Update with new "chilli_query" output
	* re-activation of COA between radius and coova (radius disconnect the users directly).
	* the "url-redirect" attribute now works fine (coovachilli V.1.2.9-1)
* CHANGES
	* all "alcasar.info" becomes "alcasar.net" in code
	* change the order of http chain (DG --> squid --> HAVP --> Internet) more réactivity and less charge of CPU
	* Dansguardian deny domains when requested via proxy http
	* The database is checked (and repair) every week
* SECURITY
	* The blacklist is now verified before activating (ANSSI need)
	* The school/parental control can now filter search engines (google, bing, yahoo, matacrowler, etc.) and Youtube
* NEWS
	* When IP addresses in the consultation network are dynamicly allocated, static ip can be reserved in the Alcasar Control Center
	* The script "alcasar-https.sh {-on|-off}" enable or disable encryption of authentication flows
	* Exceptions of authentication (@MAC) are now managed by Radius (like other users)
	* @network and @Host can be blocked by the firewall (conf file : etc/alcasar-ip-blocked). Alacasar Control Center is updated.
	* the filtering of LAN between ALCASAR and the Internet GW is no more need.
	* DHCP service is more flexible : it can be {off | half | full}
	* ACC : admin can now export the curent tracability file
	* ACC : admin can define the exception domains that will be showed in intercept page
	* A new user attribute "max-all-session" is managed (maximum time a user can be connected)
	* ACC : The english translation is more complete.
	* clears the script "alcasar-mysql.sh --expire_user" users having an expiry date than 7 days
	* user pages translations in portugese
	* voucher ticket with logo of organism
	* intercept page with exception links
	* the needed RPM for ALCASAR can be downloaded with the new script "alcasar-rpm-dowmload.sh"

# 2.5
* BUGS
	* watchdog of Daemons for service's test
	* watchdog (and script alcasar-logout.sh) doesn't logout the macallowed addresses
	* reading of alcasar.conf file parameters more securely
	* don't download RPMs twice
	* allow connexion to an LDAP server on WAN side
	* control that watchdog can't execute if already running
	* allow FTP in output
	* eth1 is no more configured. Tun0 works better (only one arp cache)
	* modoarchive is deleted (too many bugs and too hard to debug)
* CHANGES
	* new alcasar-iptables.sh script (more logically strutured)
	* update phpsysinfo page ("Internet access flag" nom show the right status)
	* Authenticate user on Mysql when LDAP server is down
	* import users via text file with or without password
	* last version of coova-chilli
* SECURITY
	* The 8080 (TCP) and 53 (UDP) ports are now hidden on Lan side
	* ANSSI code review (sql escape string in PHP)
	* remove the apache unused modules
	* the blacklist is no more update automaticly
	* postfix banner is more secure
	* anonymisation of squid (+ remove of 'x_forwarded' rule)
* NEWS
	* control eth0 config on startup (no dhcp)
	* don't download the last BL version
	* remove unused RPM before update the system
	* Improve when update is performed via SSH
	* allow/deny access to the LAN located between ALCASAR and the Internet gateway (box)
	* presentation and installation doc in english

# 2.4
* BUGS
	* some minor bugs (log rotate, intercept page, squid, ...)
	* ACC : correction of the Internet connectivity test flag
	* correction of the network filtering flag
	* ip filtering exception changes doesn't active protocols exception filter
	* remove dual log archive
	* correction in "bypass" mode
	* correction with squid cache
	* The blacklist is automaticly updated once a month
	* The distribution is automaticly updated every day

# 2.3
* BUGS
	* group properties are now written on the voucher
	* hold the state of network filter when update
* CHANGES
	* simplify official certificate import process
	* update with the last version of Coova (1.2.8)
* SECURITY
	* end of implementation of ANSSI rules for netfilter
* NEWS
	* allow exception of IP addresses (or network addresses) in the authentication process
	* ACC : group member is added in user list

# 2.2
* BUGS
	* A bug with "sudo" is bypassed
	* improve the script which display and close users open sessions
	* some minor bugs
* CHANGES
	* add a central conf file (/usr/local/etc/alcasar.conf)
	* IP parameters can be change in central conf file. Apply with the script "alcasar-conf.sh -apply"
	* 'alcasar-nf.sh' and 'alcasar-bl.sh' scripts now use the global parameters file (alcasar.conf)
	* improve the script which managed the trusted sites and urls
* SECURITY
	* close all accounting session when the system goes down or up
* NEWS
	* allow change of alcasar IP private address during install stage
	* no more question, when upgrating
	* blacklist category "ip" is added for url that contains only an ip address (no FQDN)
	* allow LDAP/AD connections both on WAN and LAN
	* Add a LDAP connectivity test
	* possibility to redirect users on a specific URL after login process
	* if activate, sshd listen both on LAN and on WAN
	* ACC : add the equipment name in the activity window when MAC authenticate

# 2.1
* mise en conformité du parefeu avec les préco ANSSI (politiques à DROP + sysctrl)
* amélioration de la fonction bastion en limitant la charge sur l'interface externe (thanks to CPN)
* amélioration de la gestion des RPM 'wget' au lieu de 'curl' et changement de repository en 'live'
* exception au filtrage réseau et DNS (double instance de dnsmasq)
* ajout d'un commentaire pour les exceptions à l'authentification
* possibilité d'imprimer un ticket de session  et simplification des champs de saisie (thank's to Geoffroy MUSITELLI)
* nouveau look graphique (thank's to Stéphane Erard)
* page de status via JSON (thank's to Stéphane Weber)
* intégration du filtrage 'safesearch' (filtrage des réponses des moteurs de recherche).
* installation à partir d'un mandriva 2010.2
* diminution des ressource système (travail d'HAVP en mémoire plutôt que sur le disque)
* distinction des fichiers de log (traçabilité - ssh - accès exterieur)
* amélioration du processus de mise à jour (prise en compte du numéro de version)
* simplification du processus de mise à jour (prise en compte mdv 2010.2)
* déplacement du répertoire 'digest' vers /usr/local/etc/
* correction horodatage des logs awstat
* inclusion d'un fichier de nommage DNS local
* inclusion d'un fichier 'alcasar-ethers' permettant la réservation d'adresses IP par Dnsmasq
* inclusion d'un fichier 'alcasar-dns-name' permettant de définir des associations @IP <--> DNS par Dnsmasq
* qq bugs mineurs (ntpd, adresse coova 1.0.0.0, etc.)

# 2.0
* mise à jour de la documentation technique
* ajout des switchs en '--' pour remplacer les '-' des scripts
* accès authentifié à la la page de garde du centre de gestion
* Prise en compte du script "alcasar-iptables-local.sh" dans le cadre du ByPass
* Prise en compte des catégories de la BL dans l'interface de gestion
* prise en compte par le watchdog de la redirection usager si panne eth0 ou panne default-gw
* Simplification de la procédure de mise à jour
* Intégration du filtrage de domaine via dnsmasq (DNS-blackhole)
* suppression de named du script d'alcasar
* Intégration des blacklists de dansguardian et formatage pour dnsmasq
* Intégration de la migration du système de la Mandriva
* Intégration de dnsmasq en lieu et place de named et dhcpd ( en mode normal) en bypass dhcpd et toujours présent ...
* Prise en charge du fichier alcasar-iptables-local.sh dans l'update

# 1.9
* Adaptation de DHCPD dans les scripts de demarrage
* Mise en place du DHCPD local en lieu et place de DHCP Chilli : "alcasar.sh"
* Ajout de la gestion des quotas sur les usagers et groupe d'usagers.
* Interdiction de créer des usagers ou groupes avec un nom vide ou contenant des espaces
* création RPM 32b et 64b d'havp. Adaptation des scripts.
* intégration havp + clamav
* remplacement de valeur DNS1 et DNS2 quand valeur= vide ; testé
* Réécriture de la procédure d'installation des RPM (téléchargement et test avant install)
* protection du menu "grub"
* Fusion menus "services" et "réseau"
* "page de garde" : simplification + Info sur le filtrage + optimisation
* "menu.php" : prise en compte version 'actuelle' et 'MAJ" dans la page de menu
* prise en compte version 'stable' et 'devel" dans la page de garde
* correction bug (adresse en 0.0.0.0 du menu activité)
* mise en place des properties svn avec $Revision  $Date
* mise en place des exceptions au filtrage (web + réseau). Correction bug utf8.
* "alcasar.sh" : modif config carte eth0 (dns local et ifcfg-eth0.default)
* bascule du développement sur subversion
* "alcasar.sh" : debug de la partie "mise à jour" + ajout de la zone reverse (localdomain.rev)
* "alcasar.sh" : correction config coova (les DNS sont pré-renseignés dans la conf par défaut). Ajout de l'entrée "alcasar" dans la zone DNS "localdomain"
* "alcasar.CA" : renommage des "OU" et préparation d'un deuxième certificat serveur pour le CN "alcasar"
* "alcasar.sh", "alcasar-conf.sh" : procedure externe pour créer l'archive des fichiers de conf
* "alcasar.sh", "alcasar-uninstall.sh", "alcasar-CA.sh", "alcasar-conf.sh" : réécriture de la procédure de mise à jour
* "alcasar-iptables.sh" : suppression DNS sur TCP (uniquement UDP)
* "alcasar-urpmi.sh" : prise en compte de la "mirrorlist" centralisée chez Mandriva
* "alcasar.sh" : suppression des daemons ifplugd associés à chaque carte réseau (mii_not_suported=yes)
* durcissement de l'entrée du nom d'organisme (pour les 2 mains gauches ;-)   )
* "service.php" : ajout du service "named"
* "alcasar-iptables.sh" : rajout des redirections et autorisations tcp domain dans parefeu
* "alcasar.sh"		 : activation du DNS bind   [install uninstall(alcasar-uninstall.sh) et update]
* "intercept.php" : intégration de la variable "userurl" dans les arguments de la demande d'authentification afin que la page demandée par l'usager soit prise en compte par le cache ARP de chilli (et donc affichée après l'authentification) ouf...  ;-)
* "intercept.php" : suppression caractères superflus ("\"). Ajout variable "urladmin" : permet de choisir la page chargée après authentification
* "alcasar.sh" : fonction 'chilli' -> creation du fichier d'exception par @mac (alcasar-macallowed)
* "menu.php", "auth.php", "filtering.php" : modification du menu
* "exception.php" : intégration php de la gestion des exceptions par @MAC + traduction
* "alcasar-iptables-filter.sh" : correction bug sur le nom du chemin du fichier ligne 30
* "alcasar-iptables.sh" : intégration Bind ( mais non activé )
* "alcasar.sh" : + intégration de Bind ( mais non actif pour le moment )
* Intégration de param_bind dans menu -install et -update
* ln et modification de /etc/trusted_network_acl.conf ( LAN autorisé à query )
* radius et update RPM : --> suite aux problèmes d'update RPM ( à affiner si suppression de certains modules radius ( rlm_, etc...)
* rajout/modification de droits msec sur /etc/raddb
* touch sur control-socket, default et inner-tunnel sous /etc/raddb/site-enabled (ln rajoutés par un update RPM de freeradius systématiquement ... et qui empêche le démarrage de radius)
* "alcasar.sh" : mise à jour de l'install ntpd ("ntpdate" étant devenu obsolète)
* "alcasar-uninstall.sh" : suppression des spécificités de la V1.7
* intercept.php : correction bug (compatibilité ie8).
* mise à jour du répertoire "conf/rpms-update" (rpm de "mindi" compatible ext4)
* "alcasar-mondo.sh" : correction proposée par Michel GAUDET
* ajout du processus "sshd" dans la page "système/services".
* "alcasar-radius" : suppression des tags config- de l'ancien plugin ldap.
* "alcasar.sh" : augmentation de la taille des fichiers en "upload" par php (pour l'import de la base usager)
* le service sshd n'est plus lancé automatiquement au démarrage (activable via l'interface de gestion)
* "alcasar-iptables-filter.sh : a voir avec richard pour les conntrack modules pour ftp ...
* "menu.php, filtering.php, activity.php" : prise en compte des @mac autorisée dans la fenêtre "activité" (+ corrections)

# 1.8
* "alcasar-bypass.sh" : amélioration du script
* création des 2 scripts d'initialisation des daemons "chilli" et "dansguardian"
* "alcasar.sh" et "alcasar-uninstall.sh" : création de la fonction "dansguardian"
* "alcasar.sh" : intégration du RPM "coova-chilli" réalisé par Mandriva.
* mise à jour des docs
* "alcasar-iptable-bypass.sh" : adaptation à la dernière version de netfilter.
* "alcasar-iptable-filter.sh" : traitement du filtrage ICMP
* "alcasar.sh" : désactivation par défaut du filtrage WEB et du filtrage réseau
* "alcasar-iptables.sh" + "alcasar-iptables-filter.sh" : optimisation des règles de filtrage.
* ajout du charset (utf-8) dans intercept.php
* adaptation de phpsysinfo : (portail.php, index.php, fr.php et en.php)
* "alcasar-CA.sh" : suppression des caractères superflus lors de la génération du certificat de l'A.C.
* "service.php" : mise en conformité graphique
* mises à jour network.php (internationnalisation et suppression des erreurs php)
* alcasar-urpmi.sh et alcasar.sh : adaptation de la procédure de mises à jour pour les architectures 64b
* mises à jour des fichiers de la partie "système" du centre de gestion (internationalisation, utf8... partie à finaliser...)
* intégration de la page activité dans "système/réseau" et adaptation du menu
* adaptation du code aux évolutions php5 (fonction "split" dépréciée, fonction "new" retourne directement une valeur, variables _get et _post interdites de visibilité globale)
* fichiers modifiés : intercept.php, uam.php, net-filter.php, bl.php, bl2.php, sauvegarde.php, 15 fichiers de phpsysinfo, to be continued ...
* "alcasar.sh" : adaptation pour le module 'ldap') :
* "alcasar.sh" : adaptation à MdV-2010, corrections : log_martians, lancement des fonctions, rpm orphelins
* tri des services, amélioration des fonctions php d'ouverture de fichiers (bl + wl)
* prise en compte d'une whitelist par protocole autorisé (création du fichier /usr/local/etc/alcasar-services)
* "alcasar.sh" : suppression de l'écoute sur le port 80. Suppression du filtrage ultrasurf. Evolution de la gestion du filtrage (alcasar-nf.sh + modules php)
* "alcasar.sh conf/logrotate.d/dansguardian" - adaptation de dansguardian dans la rotation des logs et modif du script alcasar.sh
* "alcasar.sh" : suppression du filtrage des fichiers téléchargés, mise à jour système automatique, modif page d'erreur apache "401", limitation de l'écoute d'apache sur le port 443 (eth1)
* "alcasar-unistall.sh : mise à jour
* Modification du menu de centre de gestion : ajout menu systeme(services/réseau/ldap)
* Ajout des pages de configuration des Services, Réseau et LDAP.
* "alcasar.sh" : modification des msec local (perm.local) --> prise en compte de l'interface ldap --> a confirmer
* "alcasar.sh" : adaptation des délais pour anacron
* "alcasar-iptables-filter.sh" : debug de la ligne de récupération des @IP ultrasurf
* "alcasar-iptables.sh" : adaptation des règles à la nouvelle norme d'écriture (le "!" placé avant)
* "alcasar.sh" : adaptation du module "radius" pour mandriva 2009.0 & 2009.1
* "alcasar.sh" : suppression du filtrage d'URL via les expressions régulières (REGEX) pour dansguardian
* prémices de l'interface de filtrage réseau (alcasar-nf.sh + modules php)
* "alcasar.sh" : génération de mot de passe aléatoire au sein des briques Alcasar même après une mise à jour.
* mise à jour de "mondoarchive" et "mindi" dans l'archive des RPM (alcasar-1.8-rpms.tar.gz)
* "alcasar.sh" : modif de la conf dansguardian (afin de préparer l'interfaçage graphique)
* 'alcasar-uninstall.sh" : mise à jour et désinstallation complète de mysql
* "alcasar.sh" : pour Dansguardian, on désactive le contrôle dans l'URL, on bloque les URL avec @IP, on bloque le https par le port 80
* "sauvegarde.php" : suppression de l'affichage des journaux du proxy
* ajout de 3 RPMs liés au "backportage" de "mondo-mindi"
* "alcasar.sh" : ajout des cron.d/export et clean pour une prise en compte en cas d'arrêt du serveur pendant l'exécution
* "alcasar.sh" : suppression des # dans le plugin_ldap ( ne prend pas en compte le lancement multiple ...
* "alcasar-log-export.sh, alcasar-log-clean.sh, conf/logrotate.d/dansguardian" : prise en compte des logs de dansGuardian ... dans les exports de logs et le nettoyage # a voir si on garde ?
* "alcasar.sh" : prise en compte de la tabulation avant et derrière le # dans radiusd.conf
* "alcasar-mondo.sh" : suppression du paramètre -F qui crash sur la Mandriva 2009.1
* "alcasar-bl.sh" : mise à jour des liens internes liés au téléchargement de la BL Toulouse
* "phpsysinfo" : activation de la barre de charge (load-bar) dans la page d'accueil
* correction bug : affichage des exceptions (bl.php) et sauvegarde du fichier "/etc/dansguardian/exceptioniplist" en cas de mise à jour
* modif du système de comptage des usagers en ligne de la page d'accueil (chilli_query au lieu de radwho)
* amélioration de la fonction de mise à jour
* définition aléatoire des mots de passe inter-processus (alcasar.sh)
* réécriture des règles iptables pour prévenir l'impossibilité future de filtrer sur la table NAT (alcasat-iptables.sh)
* possibilité de garder l'ancien certificat serveur lors de la mise à jour
* installation de dialupadmin + conforme (uniquement les fichiers modifiés)
* réarchitecture des pages du centre et homogénéisation graphique.
* correction javascript dans la page d'interception
* possibilité de supprimer les usagers à la suppression de leur groupe
* correction faille de conf apache (suppression de la directive "method")
* gestion des profils d'administration en 3 groupes (admin, manager, backup)
* correction de la "double redirection" lors de l'interception par coova
* suppression de la fonction "OnBlur" de intercept.php
* amélioration de la conf de squid (suite au remplacement de squidGurad par Dansguardian)
* amélioration de la rubrique "activité réseau" (affichage trié et déconnexion d'un usager (même si plusieurs sessions simultanées)
* modification des menus de l'interface
* correction d'un bug et "durcissement" de la conf de coova-chilli à l'install (alcasar.sh)
* remplacement "hotspotlogin.cgi" par "intercept.php". Traduction en 5 langues. Prise en compte des réponses Radius.
* simplification des scripts de modification du mot de passe usager (+ traduction 5 langues)
* affichage du nom d'organisme sur la page d'interception
* correction de bug dans "alcasar.sh" : appel de 'htdigest' par son chemin complet, amélioration des calculs pour les réseaux de classe A et B, procédure de mise à jour (option -update)
* correction du fichier "dhcpd.conf" (ajout de l'entrée "ddns-update-style interim")
* correction et agrégation des 2 scripts "alcasar-bypass-on / off"

# 1.7
* intégration du module de filtrage applicatif
* traitement des vpn https "ultrasurf" (contournement du filtrage d'URL)
* mise en conformité de l'interface des sites de confiances ("uamallow" et "uamdomain")
* mise à jour de la doc
* module graphique de visualisation de l'activité du réseau de consultation (équipements et usagers)
* correction bug "sauvegarde.php"
* correction bug freeradius-web/lib/sql/drivers/mysql/functions.php (merci M.G.)
* adaptation cron de chilli à notre logique (/etc.cron.d au lieu de /var/spool/cron/root)
* suppression des mails pour les cron journaliers (awstat, chilli, etc.)
* modification radius (écriture dans sradutmp et radutmp) --> récupération de la fonction "radwho"
* relooking type Alcasar de "accounting.php" et suppression d'affichage des champs "NAS*"
* recodage UTF8 alcasar.sh, alcasar-iptables, etc.
* modif alcasar-iptables (le "/etc/init.d/iptable save" est réalisé ici) et alcasar-iptables-filter (ancien alcasar-iptables-local) en vue d'intégrer le filtrage applicatif.
* agrégat uam.php + uam2.php (suppression uamallow.php et alcasar-uamallow.sh)
* sécurisation /etc/pki
* modification et intégration du fichier de conf "radiusd.conf" + conforme
	* gestion de la casse pour les noms d'usager
	* suppression des méthodes d'authentif inusitées
	* activation des compteurs SQL (module rlm_sqlcounter.so)
* remplacement "ssmtp" par "postfix" afin de préparer l'avenir ;-)  et d'éviter les erreurs de "crond"
* création et mise en ligne de l'archive des RPMs additionnels pour les installation "faible débit"
* phpsysinfo : nom de la distribution de nouveau disponible (phpsysinfo/distro.ini <-* Mandrivalinux au lieu de Mandriva)
* adaptation de admin/uam.php ( et uam2.php) pour génération web des urls et domaines de confiance
* suppression de shorewall-common et pas uniquement shorewall
- intégration dans /etc/chilli/config de alcasar-uamallowed et alcasar-uamdomain (fichiers de sites et de domaines de confiance)
- modif de alcasar-iptables.sh pour permettre l'icmp sur INTIF et pas seulement sur TUNIF
- modif alcasar-uamallowed.sh pour intégrer un fichier alcasar-uamdomain ( domaines sans restriction)
- modif "sauvegarde.php" pour ordonner la liste des sauvegardes (base, firewall, système)
- modif "hotspotlogin" pour intégrer un traitement à la fermeture du popup de déconnexion
* modif /etc/alcasar-bypass.sh en /usr/local/bin/alcasar-iptables.bypass.sh
* modif alcasar-bypass-local.sh pour intégrer des filtres applicatifs + déplacement dans alcasar-iptables.sh
* intégration coova "+ conforme" (modif du fichier de conf par défaut)
* suppression des modifs iptables effectuées par coova (/etc/chilli/up.sh)
* ajout du contrôle des flux DNS (pour éviter les tunnels DNS)
* remplacement de la page d'interception de dansguardian
* intégration du module LDAP dans /etc/raddb et alcasar.sh
* Correction bugs dans "alcasar-log-export"
* Suppression des broadcast sur EXTIF
* Suppressions des envois de mail pour cron (générait une erreur en absence de MTA)
* correction config awstat et intégration graphique
* intégration Squid "+ conforme" (modif du fichier de conf par défaut)
* suppression du snmp_finger inutile dans "/etc/freeradius-web/admin.conf"
* correction du bug mktime() de la page "stat journalière"
* modif menu pour les pages "stats journalières" et "stat usagers"
* correction bug de la page des connexions actives ("sradutmp" dans "/etc/raddb/site-available/alcasar" et @IP réelle du NAS (et non loopback))
* intégration du plugin ldap : les scripts php ne sont pas retenus (mais conservés).
* implémentation et adaptation pour authentification seule (pas de récupération des attributs Radius dans ldap )
* ajout de la commande service dans sudoers ; pourra ètre utile pour insérer l'état des services utiles (status et restart) dans phpsysinfo
* ajout des fichiers modifiés ldap.attrmap et ldap (sera modifié par le script plus tard :-) issus de freeradius-ldap
* modification du fichier d'installation alcasar.sh pour rajouter une option -ldap indépendante de l'install/update et uninstall
* correction de code php afin de supprimer les warnings dans /var/log/http/ssl_error
* correction de quelques coquilles
* intégration de la gestion des sessions simultanées
* correction bug dans la page d'info usager - rubrique "password-check" (freeradius-web/lib/sql/password_check.php)
* intégration du travail de P.Romero (générateur de mots de passe aléatoires dans htdocs/user_new.php et htdocs/user_edit.php)
* suppression des log_martian via msec -> fichier /etc/security/msec/level.local (alcasar.sh)
* ajout des RegEx de saisie d'adresse IP (alcasar.sh)
* création du script de gestion des profils "alcasar-profil.sh", adaptation d'alcasar.sh
* correction bug sauvegarde.php : répertoire "/var/Save/log/proxy" au lieu de "/var/Save/log/squid",
* correction d'un bug dans le fichier de conf d'awstat
* ajout de la possibilité de changer le plan d'addressage à l'install, correction bugs date d'installation + install via archive RPM
* intégration page uamallowed, modification du menu, lien symbolique /etc/radius/radutmp sur /etc/radius/sradutmp (pour radwho --> à revoir), vérif mdp chiffré dans mysql --> ok.
* modif archive RPMS, iptables, squid.conf (pour ce dernier, on devrait pouvoir partir du fichier de conf de base)
* suppression des paquetage avahi, mandi, shorewall, drakxtool-curses et les orphelins créés (à la fin de l'install)
* création de l'archive rpm optionnel "alcasar-rpms.tar.gz" (nécessaire quand on a pas Internet (dans le train par exemple ;-)  ))
* déplacement de /etc/chilli/defaults en /etc/chilli/defaults.old pour éviter les uamallowed insérés automatiquement par coova
* modif import-user.php, déplacement dans freeradius-web/htdocs (en import_user.php) et modif page d'appel (usager.php)
* correction des requetes SQL sur la table "usergroup" au lieu de "radusergroup" (import_user.php et portail.php). Correction du MCD.
* suppression de l'affichage du logo "coova" (/etc/chilli/config)
* suppression des log parefeu https, ssh et dhcp (les logs des daemon httpd, sshd et coova suffisent)
* suppression de la modif du fichier syslog.conf à l'install
* mise à jour de la page d'interception (hotspotlogin)
* mise à jour alcasar-uninstall, config ssh, alcasar-bypass-iptables
* affectation dynamique du role des cartes RSO (alcasar.sh)
* correction de bugs (alcasar-iptables.sh + alcasar.sh)
* généralisation de l'utilisation des variables "intif" et "extif" dans le script d'install
* prise en compte des nouvelles structure des RPM repository (alcasar-urpmi.sh)
* adaptation du script d'install en mandriva 2009
* intégration native de coova-chilli
* Suppression de l'enregistrement du mot de passe dans la table "radpostauth"
* intégration dans alcasar.sh à l'installation-update
* intégration structure ossi-bl et ossi-wl dans squidGard.conf et alcasar.sh --> reste dans script web
* intégration de coova-chilli en substitution à chillispot ;  reste à intégrer dans alcasar.sh à l'installation-update
* modif import_user.php :
* remontée de import_user.php à la racine du centre de gestion ; modification dans les différentes interfaces dont les menus
* sortie sur un fichier unique  ; reste à récupérer par le biais de l'interface
* modif chilli.conf : interval=0 (évite le relancement de chilli toute les heures)

# 1.6
* Durcissement du parefeu (fermeture de ports) et adaptation des règles à l'interface "firewalleyes"
* Simplification de la structure des fichiers de sauvegardes (/var/Save)
* Mise à jour du fichier de configuration squidGuard (intégration de tous les domaines de la BL de Toulouse)
* Séparation des RPM additionnels de l'archive du portail
* Réécriture du script de génération des certificats de l'A.C et du serveur WEB
* Automatisation de la procédure de mise à jour
* Amélioration de l'interface de gestion :
	* Meilleure intégration graphique et francisation
	* Prise en compte des créneaux horaires, de la durée des sessions et de la date d'expiration du mot de passe
	* Suppression du menu certificat (intégration dans la page d'accueil)
	* Refonte de la page de gestion des blacklists et rationalisation des scripts php associés
	* Import d'usagers (à partir d'un fichier texte ou d'une base complète) et RAZ de la base
* Déconnexion des usagers par ALCASAR (radiusd + chilli) et non plus seulement par le navigateur WEB (paramètre 'coaport')
* Modification squid.conf (compatibilité toute distrib MDV).
* Simplification du module de création de l'image système (alcasar-mondo.sh).
* Correction des bugs suivants :
	* Disparition des statistiques de consultation web après une mise à jour
	* Deconnexion d'un usager à partir de l'interface de gestion
	* possibilité de créer des groupes vides (en fait avec un usager virtuel portant le même nom que le groupe).
* Création des scripts alcasar-bl.sh (activation/désactivation/mise à jour du filtrage), alcasar-logout.sh (déconnexion des usagers) et alcasar-mysql (import usagers via txt et sql + raz de la base).

# 1.5
* prise en compte du nom de baptême du portail : ALCASAR
* intégration d'un script PHP permettant de personnaliser le logo
* intégration du contournement du bug 'MSIE' pour les pages gestion.
* Intégration de l'interface PHP d'informations système ( phpsysinfo) et ajout d'un module Alcasar (nbr.usagers, version d'installation, version de la blacklist, @IP publique).
* Réécriture des scripts d'install et de désinstall (alcasar-uninstall.sh)
	* intégration d'un test de connectivité à Internet
	* réorganisation des fonctions
	* création de l'option 'uninstall' permettant de désinstaller complétement le portail (afin de pouvoir lancer des séquences d'install/désinstall pour les tests)
	* permettre le choix du nom pour les comptes autorisés à administrer le portail
* Réécriture de la page de gestion et intégration des fonctionnalités nouvelles suivantes :
	* mise à jour de la blacklist squidGuard (globale + OSSI)
	* sauvegarde à chaud du système, sauvegarde des logs et de la base usagers
	* visu des logs du parefeu
* Modification du fichier sudoers permettant le lancement des commandes via la page de gestion
* Ajout de l'option -update pour mettre à jour le portail déjà installé (option compatible avec versions >= 1.5)
* Amélioration des règles du pare-feu (moins de Logs mais plus pertinents)
* Gestion des erreurs 404 d'apache par une redirection sur la page d'accueil
* Possibilité de changer son mot de passe via la page de connexion et la page de gestion
* Correction des bugs suivants :
	* la comptabilité utilisateur dans dialupadmin est de nouveau fonctionnelle
	* l'export chaque semaine de la base des utilisateurs est de nouveau fonctionnel
	* homogénéisation de la gestion des cron ==> tout dans /etc/cron.d/
	* déplacement de la structure d'awstat pour permettre la visu complète des pages (var/www/awstats -> /var/www/html/awstats)
* Intégration d'une interface PHP de lecture des log du parefeu ( firewallEyes )
* Implémentation du certificat gnupg pour le chiffrement éventuel des logs
* Modification mineure du script de génération à chaud d'image système (alcasar-mondo.sh)
* Modification des pages de dialupadmin ( francisation, simplification, etc.)
* Intégration dans le fichier archive des rpms supplémentaires et de la blacklist (évite leur téléchargement par internet)

# 1.4
* Réécriture du script de mise à jour de la blacklist squidGuard
* Uniformisation du script d'install
* Correction du script de désinstallation (alcasar-uninstall.sh) et de sauvegarde de la base radius (alcasar-mysql.sh)
* Mise en place d'une page WEB d'accueil pour la gestion du portail
* Suppression des cgi-bin installés par défaut

# 1.3
* Création d'une structure 'OSSI' dans la blacklist SquidGuard
* Modification de la page d'interception SquidGuard.
* Anonymisation de la structure LAN dans les trames traitées par Squid (forward_for off dans squid.conf).
* Correction de la fonction 'bypass'.
* Mise en place de la possibilité de chiffrer les logs (par gnupg).
* Correction du mot de passe dans le script d'export lorsqu'il est changé à l'install.
* Correction de la structure d'archivage et prise en compte du contenu des fichiers à sauvegarder.
* Mise en place du cron de sauvegarde des configurations.

# 1.2
* Consolidation de la fonction de désinstallation (création systématique de fichiers '.default' lors de modification)
* Configuration des services lancés au démarrage (chkconfig).
* Françisation du CGI "hotspotlogin" (codage des accents).
* Possibilité de lancer le script sans argument (-all par défaut).
* Suppression des "Logs Martians".

# 1.1
* Consolidation de la variable FIC_PARAM.
* Suppression de la déclaration des DNS dans le fichier de conf de chilli (on s'appuie sur les DNS locaux définis dans "/etc/resolv.conf").
* Modification de la page d'authentification (plus générique).
* Réorganisation de la structure de l'archive d'install.
* Modification des directives de chiffrement d'apache (SSLRequireSSL).

# 1.0
* Version initiale que l'on trouve déjà excellente ;-)
