<?php
# $Id: status.php 3165 2024-01-10 10:34:50Z rexy $
#
# status.php for ALCASAR captive portal
# by steweb57 & Rexy
# 
/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');

/****************************************************************
*			FILE reading test			*
*****************************************************************/
$conf_files = array(CONF_FILE);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Fichier $file non présent");
	}
	if (!is_readable($file)) {
		exit("Vous n'avez pas les droits de lecture sur le fichier $file");
	}
}

/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);

$page = "status";
$organisme = $conf['ORGANISM'];
$remote_ip = preg_match('#^([0-9]{1,3}\.){3}[0-9]{1,3}$#', $_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '';
$cn = '';
$connection_history = '';
$nb_connection_history = 3;
$homepage_url = (($conf['HTTPS_LOGIN'] === 'on') ? 'https' : 'http' ).'://'.$conf['HOSTNAME'].'.'.$conf['DOMAIN'].'/';
$useHTTPS = ((isset($_SERVER['HTTPS'])) && (!empty($_SERVER['HTTPS'])) && ($_SERVER['HTTPS'] !== 'off'));
$service_wifi4eu_status = ($conf['WIFI4EU'] === 'on');
$service_wifi4eu_code = $conf['WIFI4EU_CODE'];
$service_wifi4eu_server = 'https://collection.wifi4eu.ec.europa.eu/wifi4eu.min.js';

// Redirection if HTTPS needed and not used
if (($conf['HTTPS_LOGIN'] === 'on') && (!$useHTTPS)) {
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: https://'.$conf['HOSTNAME'].'.'.$conf['DOMAIN'].'/status.php');
	exit();
}

// Wait for chilli (update its tables)
sleep(1); // TODO: wait after login only?
// Retrieve user info in tab $user[]
exec("sudo /usr/sbin/chilli_query list | grep 'pass' | grep -Ew '($remote_ip)'" , $tab);
if (isset($tab[0])) {
	$user = explode(' ', $tab[0]);
}

// Time conversion 
function secondsToDuration($seconds = null) {
	if ($seconds === null) return '';
	$temp = $seconds % 3600;
	$time[2] = $temp % 60 ;			// seconds
	$time[1] = ($temp - $time[2]) / 60;	// minutes
	$time[0] = ($seconds - $temp) / 3600 ;	// hours
	return $time[0].' h '.$time[1].' m '.$time[2].' s';
}

// Choice of language
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'es') {		// Spanish
	$l_login1			= "Inicio de sesión exitoso!";
	$l_logout			= "Desconectarse";
	$l_logout_question		= "¿Seguro que desea desconectarse?";
	$l_loggedout			= "Su sesión ha finalizado";
	$l_wait				= "Por favor, espere un momento ...";
	$l_state_label			= "Estado";
	$l_session_id_label		= "Sesión ID";
	$l_max_session_time_label	= "Tiempo máximo de sesión";
	$l_max_idle_time_label		= "Tiempo de inactividad autorizado";
	$l_start_time_label		= "Tiempo de inicio";
	$l_session_time_label		= "Tiempo de conexión";
	$l_idle_time_label		= "Tiempo inactivo";
	$l_downloaded_label		= "Datos descargados";	
	$l_uploaded_label		= "Datos subidos";
	$l_original_url_label		= "URL original";
	$l_not_available		= "No disponible";	
	$l_error			= "error";
	$l_welcome			= "Bienvenido";	
	$l_conn_history			= "Últimas $nb_connection_history conexiones";
	$l_connected 			= "conectado";
	$l_a_connection			= "Tiene";
	$l_a_connection_time		= "conexiones activas en la red";
	$l_close_warning		= "Advertencia: se desconectará si cierra esta ventana";
	$l_back_homepage		= "Volver a la página de inicio";
} else if ($Language === 'zh') {	// Chinese
	$l_login1			= "验证通过";
	$l_logout			= "关闭连接";
	$l_logout_question		= "您确定需要断开连接吗？";
	$l_loggedout			= "您已登出";
	$l_wait				= "请等待 ...";
	$l_state_label			= "连接状态";
	$l_session_id_label		= "连接ID";
	$l_max_session_time_label	= "最大连接时间";
	$l_max_idle_time_label		= "最大闲置时间";
	$l_start_time_label		= "起始连接时间";
	$l_session_time_label		= "连接时间";
	$l_idle_time_label		= "闲置时间";
	$l_downloaded_label		= "数据下载";
	$l_uploaded_label		= "数据上传";
	$l_original_url_label		= "初始网址";
	$l_not_available		= "不可用";
	$l_error			= "出错";
	$l_welcome			= "欢迎";
	$l_conn_history			= "您最近的{$nb_connection_history}次连接";
	$l_connected 			= "已登录";  
	$l_a_connection			= "您已经有";
	$l_a_connection_time		= "在线时间";
	$l_close_warning		= "警告: 您将会断开连接如果您在关闭此窗口";
	$l_back_homepage		= "回到主页";
} else if ($Language === 'ar') {	// Arabic
	$l_login1			= "نجاح المصادقة";
	$l_logout			= "إغلاق الدورة";
	$l_logout_question		= "هل تريد فعلاً قطع الاتصال؟";
	$l_loggedout			= "دورتكَ مُغلَقة";
	$l_wait				= "...إنتظر بعض اللحظات";
	$l_state_label			= "وَضْع";
	$l_session_id_label		= "معرف الدورة";
	$l_max_session_time_label	= "الوقت المسموح للإتصال";
	$l_max_idle_time_label		= "الحد الأقصى لعدم التنشيط";
	$l_start_time_label		= "بداية الإتصال";
	$l_session_time_label		= "مدة الإتصال";
	$l_idle_time_label		= "انعدام التنشيط";
	$l_downloaded_label		= "تم تحميل المعطيات";
	$l_uploaded_label		= "تم إرسال المعطيات";
	$l_original_url_label		= "تم طلب URL";
	$l_not_available		= "غير متوفّر";
	$l_na				= "N/D";
	$l_error			= "خطأ";
	$l_welcome			= "مرحباً بك";
	$l_conn_history			= "($nb_connection_history) سِجِل اتصالاتك الاخيرة";
	$l_connected 			= "دورة ناشطة";  
	$l_a_connection			= "لديك";
	$l_a_connection_time		= "اتصالات ناشطة على الشبكة";
	$l_close_warning		= "تحذير: سيتم قطع الاتصال إذا قمت بإغلاق هذه النافذة";
	$l_back_homepage		= "الرجوع إلى الصفحة الرئيسية";
} else if ($Language === 'pt') {	// Portuguese
	$l_login1			= "Autenticação bem sucedida.";
	$l_logout			= "Fechando a conexão";
	$l_logout_question		= "Tem certeza de que deseja desconectar agora?";
	$l_loggedout			= "Sua conexão será fechada";
	$l_wait				= "Por favor, aguarde um momento ...";
	$l_state_label			= "Estado da conexão";
	$l_session_id_label		= "Sessão ID";
	$l_max_session_time_label	= "Restante em horas da conexão";
	$l_max_idle_time_label		= "Restante máximo liberado por dia";
	$l_start_time_label		= "Dia, mês, ano e hora da conexão";
	$l_session_time_label		= "Duração da conexão";
	$l_idle_time_label		= "Tempo de Espera";
	$l_downloaded_label		= "Recebidos";
	$l_uploaded_label		= "Enviados";
	$l_original_url_label		= "URL Original";
	$l_not_available		= "Não disponível";
	$l_error			= "Erro";
	$l_welcome			= "Bem-vindo(a)";
	$l_conn_history			= "Suas últimos conexões : $nb_connection_history";
	$l_connected 			= "Conectado"; 
	$l_a_connection			= "Conexão ativa já detectada para essa LAN";
	$l_a_connection_time		= "Tempo (s)";
	$l_close_warning		= "Aviso: você será desconectado se fechar esta janela";
	$l_back_homepage		= "Voltar à página inicial";
} else if ($Language === 'de') {	// German
	$l_login1			= "Erfolgreiche Authentifizierung";
	$l_logout			= "Beenden der Verbindung";
	$l_logout_question		= "Möchten Sie die Sitzung wirklich beenden?";
	$l_loggedout			= "Ihre Sitzung ist geschlossen";
	$l_wait				= "Bitte warten Sie einen Moment ...";
	$l_state_label			= "Status";	
	$l_session_id_label		= "Sitzungs-ID";
	$l_max_session_time_label	= "Maximale Sitzungszeit";
	$l_max_idle_time_label		= "Maximale Leerlaufzeit";
	$l_start_time_label		= "Startzeit";
	$l_session_time_label		= "Online-Zeit";
	$l_idle_time_label		= "Leerlaufzeit";
	$l_downloaded_label		= "Heruntergeladen";
	$l_uploaded_label		= "Hochgeladen";
	$l_original_url_label		= "Angefragze URL";
	$l_not_available		= "Nicht verfügbar";
	$l_error			= "Fehler";
	$l_welcome			= "Willkommen"; 
	$l_conn_history			= "Ihre letzten $nb_connection_history Verbindungen";
	$l_connected 			= "gespeichert"; 
	$l_a_connection			= "Sie haben";
	$l_a_connection_time		= "aktive Sitzungen auf dem Netzwerk";
	$l_close_warning		= "Warnung: Sie werden getrennt, wenn Sie dieses Fenster schließen";
	$l_back_homepage		= "Zurück zur Startseite";
} else if ($Language === 'nl') {	// Dutch
	$l_login1			= "Succesvolle authenticatie";
	$l_logout			= "Slotkoers verbinding";
	$l_logout_question		= "Bent u zeker dat u wilt nu los te koppelen?";
	$l_loggedout			= "Uw sessie is gesloten";
	$l_wait				= "Wacht een moment ...";
	$l_state_label			= "State";		// to translate
	$l_session_id_label		= "Session ID";	// to translate
	$l_max_session_time_label	= "Max Session Time";	// to translate
	$l_max_idle_time_label		= "Max Idle Time";		// to translate
	$l_start_time_label		= "Start Time";	// to translate
	$l_session_time_label		= "Online tijd";
	$l_idle_time_label		= "Idle Time";	// to translate
	$l_downloaded_label		= "Downloaded";	// to translate
	$l_uploaded_label		= "Uploaded";	// to translate
	$l_original_url_label		= "Original URL";	// to translate
	$l_not_available		= "Not available";	// to translate
	$l_error			= "error";		// to translate
	$l_welcome			= "Welcome";	// to translate
	$l_conn_history			= "Your last $nb_connection_history connections";	// to translate
	$l_connected 			= "logged"; // to translate 
	$l_a_connection			= "You have"; // to translate
	$l_a_connection_time		= "active connections on the network"; // to translate
	$l_close_warning		= "Waarschuwing: u zal worden afgebroken als u dit venster sluiten";
	$l_back_homepage		= "Terug naar de homepage";
} else if ($Language === 'fr') {	// French
	$l_login1			= "Authentification réussie";
	$l_logout			= "Fermeture de la session";
	$l_logout_question		= "Êtes vous sûr de vouloir vous déconnecter?";
	$l_loggedout			= "Votre session est fermée";
	$l_wait				= "Patientez un instant ....";
	$l_state_label			= "État";
	$l_session_id_label		= "Session ID";
	$l_max_session_time_label	= "Temps de connexion autorisé";
	$l_max_idle_time_label		= "Temps d'inactivité autorisé";
	$l_start_time_label		= "Début de connexion";
	$l_session_time_label		= "Durée de connexion";
	$l_idle_time_label		= "Inactivité";
	$l_downloaded_label		= "Données téléchargées";
	$l_uploaded_label		= "Données envoyées";
	$l_original_url_label		= "URL demandée";
	$l_not_available		= "Non disponible";
	$l_error			= "erreur";
	$l_welcome			= "Bienvenue";
	$l_conn_history			= "Vos $nb_connection_history dernières connexions";
	$l_connected 			= "session active";  
	$l_a_connection			= "Vous avez";
	$l_a_connection_time		= "connexions actives sur le réseau";
	$l_close_warning		= "Attention : vous serez déconnecté si vous fermez cette fenêtre";
	$l_back_homepage		= "Revenir à la page d'accueil";
} else {				// English
	$l_login1			= "Successful authentication.";
	$l_logout			= "Closing connection";
	$l_logout_question		= "Are you sure you want to disconnect now?";
	$l_loggedout			= "Your session is closed";
	$l_wait				= "Please wait a moment ...";
	$l_state_label			= "State";
	$l_session_id_label		= "Session ID";
	$l_max_session_time_label	= "Max Session Time";
	$l_max_idle_time_label		= "Max Idle Time";
	$l_start_time_label		= "Start Time";
	$l_session_time_label		= "Session Time";
	$l_idle_time_label		= "Idle Time";
	$l_downloaded_label		= "Downloaded";
	$l_uploaded_label		= "Uploaded";
	$l_original_url_label		= "Original URL";
	$l_not_available		= "Not available";
	$l_error			= "error";
	$l_welcome			= "Welcome";
	$l_conn_history			= "Your last $nb_connection_history connections";
	$l_connected 			= "logged"; 
	$l_a_connection			= "You have";
	$l_a_connection_time		= "active connections on the network";
	$l_close_warning		= "Warning: you will be disconnected if you close this window";
	$l_back_homepage		= "Back to homepage";
}

if (isset($user[5])) {
	if ((is_file('acc/manager/lib/sql/drivers/mysql/functions.php')) && (is_file('/etc/freeradius-web/config.php'))) {
		require_once('/etc/freeradius-web/config.php');
		require_once('acc/manager/lib/sql/drivers/mysql/functions.php');
		$link = @da_sql_pconnect($config);
		if ($link) {
			// Retrieve the last connections
			$sql = "SELECT UserName, AcctStartTime, AcctStopTime, acctsessiontime FROM radacct WHERE UserName='$user[5]' ORDER BY AcctStartTime DESC LIMIT 0, $nb_connection_history";
			$res = @da_sql_query($link, $config, $sql);
			if ($res) {
				$connection_history = '<ul>';
				while (($row = @da_sql_fetch_array($res,$config))) {
					$start_conn = date_create($row['acctstarttime']);
					if (empty($row['acctstoptime'])) {
						$connected = $l_connected;
					} else {
						$connected = secondsToDuration($row['acctsessiontime']);
					}
					$connection_history .= '<li>'.date_format($start_conn, 'd M Y - H:i:s').'</li>';//." - ($connected)</>";
				}
				$connection_history .= '</ul>';
			}

			// Retrieve number of open session
			$sql = "SELECT COUNT(*) AS nb_open FROM radacct WHERE username = '$user[5]' AND acctstoptime IS NULL;";
			$res = @da_sql_query($link, $config, $sql);
			if ($res) {
				$row = @da_sql_fetch_array($res, $config);
				$nb_open_session = $row['nb_open'];
			}

			// Retrieve first name & last name
			$sql = "SELECT Name FROM userinfo WHERE UserName='$user[5]'";
			$res = @da_sql_query($link, $config, $sql);
			if ($res) {
				$row = @da_sql_fetch_array($res,$config);
				$cn = (!empty($row['name'])) ? $row['name'] : $user[5];
			}
		}
	}

	$filename = '/tmp/current_users.txt';
	$user_needKeepOpen = (preg_match("/^$remote_ip:PERM/m", file_get_contents($filename)) === 0);
}

// Cleaning the cache
header('Expires: Tue, 01 Jan 2000 00:00:00 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title>ALCASAR - <?= $organisme ?></title>
		<link rel="stylesheet" href="/css/bootstrap.min.css" type="text/css">
		<link type="text/css" href="/css/status.css" rel="stylesheet">
		<link rel="icon" href="/images/favicon-48.ico" type="image/ico">
<? if ($service_wifi4eu_status): ?>
		<script type="text/javascript">
			var wifi4euTimerStart = Date.now();
			var wifi4euNetworkIdentifier = '<?= $service_wifi4eu_code ?>';
			var wifi4euLanguage = '<?= $Language ?>';
			//var selftestModus = true;
		</script>
		<script type="text/javascript" src="<?= $service_wifi4eu_server ?>"></script>
<? endif; ?>
		<script src="js/ChilliLibrary.js"></script>
		<script>
			chilliController.host = '<?= $conf['HOSTNAME'].'.'.$conf['DOMAIN'] ?>';
			chilliController.port = <?= (($useHTTPS) ? 3991 : 3990) ?>;
			chilliController.ssl  = <?= (($useHTTPS) ? 'true' : 'false') ?>;
		</script>
		<script src="js/statusControler.js"></script>
	</head>
	<body>
	<div id="Chilli" class="col-12 col-lg-12">
		<div id="chilliPage" class="row">
			<div id="loggedOutPage" class="c1 col-12 col-lg-12">
				<div id="disconnectTable" class="row logout_box">
					<div class="col-3 col-lg-3 logout_msg">
						<img height="150" src="images/logo-alcasar.png" alt="logo">
					</div>
					<div class="col-6 col-lg-6 logout_msg">
							<p class="text_auth"><?= $l_loggedout ?></p>
							<p class="text_homelink"><a href="<?= $homepage_url ?>"><?= $l_back_homepage ?></a></p>
					</div>
				</div>
			</div>
			<div id="statusPage" class="col-12 col-md-12">
				<div class="col-lg-10 offset-lg-1">
					<?php require_once(__DIR__.'/header.php'); ?>
				</div>
				
				<div class="row main_box">	
					<div class="col-12 col-md-10 offset-md-1 col-lg-8 offset-lg-2">
						<div class="row background-display">
							<div class="col-12 col-md-10 offset-sm-1 mx-auto">
								<div class="row d-block">
									<p class="welcome-user"><?= $l_welcome ?> <?= $cn ?></p>
								</div>	
								<div class="row nb_open_session">
									<?= ((isset($nb_open_session) && ($nb_open_session > 1)) ? $l_a_connection.' '.$nb_open_session.' '.$l_a_connection_time : '') ?>
								</div>
								<div class="row">
									<table class="table table-striped" id="statusTable">
										<!-- 
										<tr id="connectRow">
											<td id="statusMessageLabel" class="chilliLabel"><strong><?= $l_state_label ?></strong></td>
											<td id="statusMessage" class="chilliValue">Connected</td>
										</tr>
										<tr id="sessionIdRow">
											<td id="sessionIdLabel" class="chilliLabel"><strong><?= $l_session_id_label ?></strong></td>
											<td id="sessionId" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
										-->
										<tr id="sessionTimeoutRow" class="table-border">
											<td id="sessionTimeoutLabel" class="chilliLabel"><?= $l_max_session_time_label ?>: </td>
											<td id="sessionTimeout" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
										<tr id="idleTimeoutRow">
											<td id="idleTimeoutLabel" class="chilliLabel"><?= $l_max_idle_time_label ?>: </td>
											<td id="idleTimeout" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
										<tr id="startTimeRow">
											<td id="startTimeLabel" class="chilliLabel"><?= $l_start_time_label ?>: </td>
											<td id="startTime" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
										<tr id="sessionTimeRow">
											<td id="sessionTimeLabel" class="chilliLabel"><?= $l_session_time_label ?>: </td>
											<td id="sessionTime" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
										<tr id="idleTimeRow">
											<td id="idleTimeLabel" class="chilliLabel"><?= $l_idle_time_label ?>: </td>
											<td id="idleTime" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
										<tr id="inputOctetsRow">
											<td id="inputOctetsLabel" class="chilliLabel"><?= $l_downloaded_label ?>: </td>
											<td id="inputOctets" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
										<tr id="outputOctetsRow">
											<td id="outputOctetsLabel" class="chilliLabel"><?= $l_uploaded_label ?>: </td>
											<td id="outputOctets" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
			<!-- 
										<tr id="originalURLRow">
											<td id="originalURLLabel" class="chilliLabel"><?= $l_original_url_label ?></td>
											<td id="originalURL" class="chilliValue"><?= $l_not_available ?></td>
										</tr>
			 -->
										<?php if (isset($user_needKeepOpen) && ($user_needKeepOpen === true)): ?>
											<tr>
												<td colspan="2" id="close-warning">(<?= $l_close_warning ?>)</td>
											</tr>
										<?php endif; ?>
									</table>
								</div>
								<button onclick="return logoutWithConfirmation('<?= $l_logout_question ?>');" class="button btn btn-danger btn-md"><?= $l_logout ?></button>
							</div>
						</div>
					</div>
					<div class="d-sm-none d-lg-block col-lg-2 history mx-auto">
						<div class="row">
							<div class="d-none d-sm-block col-lg-11 offset-lg-1 log-box">
								<div class="row log-titre">	
									<div class="col-lg-12">
									<?= $l_conn_history ?>
									</div>
								</div>
								<div class="row log-info">
									<?= $connection_history ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-3 d-sm-none d-md-none d-lg-none">	
						<img class="img-fluid image-resize-bottom" src="images/logo-alcasar.png" alt="logo">
					</div>
					<div class="col-6 col-md-10 offset-sm-1 col-lg-8 offset-lg-2 d-lg-none history_bottom">
						<div class="log-titre-petit">	
							<?= $l_conn_history ?>
						</div>
						<div class="log-info-petit">
							<?= $connection_history ?>
						</div>
					</div>
				</div>
			</div>
			<div id="waitPage" class="col-12 col-md-12">
				<div class="row waiting_box">
					<div class="col-3 col-md-3 waiting_msg">
						<img height="150" src="images/logo-alcasar.png" alt="logo">
					</div>
					<div class="col-6 col-md-6 waiting_msg">
						<p class="text_auth"><img src="images/wait.gif" width="16" height="16" class="wait" alt="<?= $l_wait ?>"><?= $l_wait ?></p>
					</div>
				</div>
			</div>
			<div id="errorPage" class="col-12 col-md-12">
				<div class="row error_box">
					<div class="col-3 col-md-3 error_msg">
						<img height="150" src="images/logo-alcasar.png" alt="logo">
					</div>
					<div class="col-6 col-md-6 error_msg">
						<p id="errorMessage"><?= $l_error ?></p>
					</div>
				</div>
			</div>
		</div>
	</div>
	</body>
</html>
