let radiusDays = ['Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa', 'Su'];

function scheduleToRadius(serialized) {
    let radiusPeriod = [];
    for(let day in serialized) {
        if(radiusDays[day].length > 0) {
            for(let period of serialized[day]) {
                radiusPeriod.push(
                    radiusDays[day] + (period[0] + "-" + period[1]).replace(/:/g, '')
                );
            }
        }
    }

    return radiusPeriod.join(',');
}

function addPeriodToArray(array, day, hours) {
    array[radiusDays.indexOf(day)].push([
        hours[0].substr(0,2) + ':' + hours[0].substr(2,4),
        hours[1].substr(0,2) + ':' + hours[1].substr(2,4)
    ]);
}

function radiusToSchedule(radiusAttr) {
    let res = [[], [], [], [], [], [], []];

    if(radiusAttr.length === 0) {
        return res;
    }

    radiusAttr = radiusAttr.split(',');


    for(let period of radiusAttr) {
        hours = /[0-9]{4}-[0-9]{4}$/.exec(period);

        if(hours === null) {
            hours = "0000-2400";
        } else {
            hours = hours[0]
        }

        hours = hours.split('-');


        days = /^[a-zA-Z]{2,3}(?:-[a-zA-Z]{2})?/.exec(period);

        if(days === null) {
            continue;
        } else {
            days = days[0].split('-');
            if(days.length > 1) {
                dBegin = radiusDays.indexOf(days[0]);
                dEnd = radiusDays.indexOf(days[1]);

                if(dBegin === -1 || dEnd === -1 || dBegin > dEnd) {
                    continue;
                }

                days = radiusDays.slice(dBegin, dEnd + 1);
            }
        }

        if(hours.length !== 2) continue;

        if(days[0] === 'Wk') {
            for (let i = 0; i < 5; ++i) {
                addPeriodToArray(res, radiusDays[i], hours);
            }
        } else if(days[0] === 'Any' || days[0] == 'Al') {
            for (day of radiusDays) {
                addPeriodToArray(res, day, hours);
            }
        } else {
            for(day of days) {
                addPeriodToArray(res, day, hours);
            }
        }
    }

    return res;
}

(function ($) {
    let schedule = $("#login-time-schedule");
    
    $("#login-time-dialog").dialog({
        autoOpen: false,
        height: $(window).height() > 650 ? 650 : $(window).height(),
        width: $(window).width() > 700 ? 700 : $(window).width(),
        modal: true
    });

    $("#login-time-calendar").click((e) => {
        e.preventDefault();

        let scheduleArray = radiusToSchedule($("#Login-Time").val());

        schedule.data('artsy.dayScheduleSelector').deserialize(scheduleArray);
        
        $("#login-time-dialog").dialog("open");
    });

    schedule.dayScheduleSelector({
        interval: 60,
        startTime: '00:00',
        endTime: '24:00',
        stringDays: ['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche']
    });
    schedule.on('selected.artsy.dayScheduleSelector', function (e, selected) {
        let days = schedule.data('artsy.dayScheduleSelector').serialize();
        $("#Login-Time").val(scheduleToRadius(days));
    });
})($);