<?php
function da_sql_limit($limit,$point,$config)
{
	switch($point){
		case 0:
			return '';
		case 1:
			return '';
//modif by MG for Alcasar
		case 2:
			return "LIMIT $limit";
		case 3:
			return "LIMIT $limit";
	}
}

function da_sql_host_connect($server,$config)
{
	if ($config['sql_use_http_credentials'] == 'yes'){
		global $HTTP_SERVER_VARS;
		$SQL_user = $HTTP_SERVER_VARS["REMOTE_USER"];
		$SQL_passwd = $HTTP_SERVER_VARS["PHP_AUTH_PW"];
	}
	else{
		$SQL_user = $config['sql_username'];
		$SQL_passwd = $config['sql_password'];
	}

	if ($config['sql_connect_timeout'] != 0)
		ini_set('mysql.connect_timeout',$config['sql_connect_timeout']);
	if ($config['sql_debug'] == 'true')
		print "<b>DEBUG(SQL,MYSQL DRIVER): Connect: User=$SQL_user,Password=$SQL_passwd </b><br>\n";
	return mysqli_connect("$server:$config[sql_port]",$SQL_user,$SQL_passwd,$config['sql_database']);
}

function da_sql_connect($config)
{
	if (isset($config['sql_use_http_credentials']) && $config['sql_use_http_credentials'] == 'yes'){
		global $HTTP_SERVER_VARS;
		$SQL_user = $HTTP_SERVER_VARS["REMOTE_USER"];
		$SQL_passwd = $HTTP_SERVER_VARS["PHP_AUTH_PW"];
	}
	else{
		$SQL_user = $config['sql_username'];
		$SQL_passwd = $config['sql_password'];
	}

	if ($config['sql_connect_timeout'] != 0)
		ini_set('mysql.connect_timeout',$config['sql_connect_timeout']);
	if ($config['sql_debug'] == 'true')
		print "<b>DEBUG(SQL,MYSQL DRIVER): Connect: User=$SQL_user,Password=$SQL_passwd </b><br>\n";
	return mysqli_connect("$config[sql_server]:$config[sql_port]",$SQL_user,$SQL_passwd,$config['sql_database']);
}

function da_sql_pconnect($config)
{
	if (isset($config['sql_use_http_credentials']) && $config['sql_use_http_credentials'] == 'yes'){
		global $HTTP_SERVER_VARS;
		$SQL_user = $HTTP_SERVER_VARS["REMOTE_USER"];
		$SQL_passwd = $HTTP_SERVER_VARS["PHP_AUTH_PW"];
	}
	else{
		$SQL_user = $config['sql_username'];
		$SQL_passwd = $config['sql_password'];
	}
	if ($config['sql_connect_timeout'] != 0)
		ini_set('mysql.connect_timeout',$config['sql_connect_timeout']);
	if ($config['sql_debug'] == 'true')
		print "<b>DEBUG(SQL,MYSQL DRIVER): Connect: User=$SQL_user,Password=$SQL_passwd </b><br>\n";
	return mysqli_connect($config['sql_server'],$SQL_user,$SQL_passwd,$config['sql_database'],$config['sql_port']);
}

function da_sql_close($link,$config)
{
	return mysqli_close($link);
}

function da_sql_escape_string($link, $string)
{
	return mysqli_real_escape_string($link, $string);
}

function da_sql_query($link,$config,$query)
{
	if ($config['sql_debug'] == 'true')
		print "<b>DEBUG(SQL,MYSQL DRIVER): Query: <i>$query</i></b><br>\n";
	return mysqli_query($link,$query);
}

function da_sql_num_rows($result,$config)
{
	if ($config['sql_debug'] == 'true')
		print "<b>DEBUG(SQL,MYSQL DRIVER): Query Result: Num rows:: " . mysqli_num_rows($result) . "</b><br>\n";
	return mysqli_num_rows($result);
}

function da_sql_fetch_array($result,$config)
{
	while($fetch=mysqli_fetch_array($result,MYSQLI_ASSOC)){
		$row = @array_change_key_case($fetch,CASE_LOWER);
		if ($config['sql_debug'] == 'true'){
			print "<b>DEBUG(SQL,MYSQL DRIVER): Query Result: <pre>";
			print_r($row);
			print "</b></pre>\n";
		}
		return $row;
	}
}

function da_sql_affected_rows($link,$result,$config)
{
	if ($config['sql_debug'] == 'true')
		print "<b>DEBUG(SQL,MYSQL DRIVER): Query Result: Affected rows:: " . mysqli_affected_rows($result) . "</b><br>\n";
	return mysqli_affected_rows($link);
}

function da_sql_list_fields($table,$link,$config)
{
	return da_sql_query($link, $config, "SHOW COLUMNS FROM $table");
}


function da_sql_field_name($fields,$num,$config)
{
	return mysqli_fetch_field_direct($fields,$num);
}

function da_sql_error($link,$config)
{
	return mysqli_error($link);
}
?>
