<?php
# $Id: stats.php 3105 2023-01-04 15:01:47Z rexy $

require('/etc/freeradius-web/config.php');
require('../lib/functions.php');
require('../lib/sql/nas_list.php');
require_once('../lib/xlat.php');
?>
<!DOCTYPE html>
<html>
<head>
<?php
# Choice of language
$Language = 'en';
if(isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])){
	$Langue		= explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language	= strtolower(substr(chop($Langue[0]),0,2)); }
if($Language == 'fr'){
	$l_Pagename		= "Usage quotidien";
	$l_title		= "Analyse journalière";
	$l_uploads		= "Données sortantes";
	$l_downloads		= "Données entrantes";
	$l_from			= "Du";
	$l_to			= "au";
	$l_user			= "utilisateur";
	$l_onserver		= "sur le serveur";
	$l_fields_to_display	= "Champs à afficher";
	$l_number_of_sessions	= "Nombre de sessions";
	$l_total_usage_time     = "Temps d'usage total";
	$l_date			= "date";
	$l_daily_summary	= "Récapitulatif journalier";
	$l_refresh		= "Rafraîchir";
	$l_stat_for_all		= "Statistique pour <b><font color=\"darkblue\">tous</font></b> les utilisateurs";
	$l_stat_for_user	= "Statistique pour l'utilisateur :";
	$l_maximum		= "Maximum";
	$l_average		= "Moyenne";
	$l_summary		= "Récapitulatif";
} else if($Language == 'es') {
	$l_Pagename		= "Uso diario";
	$l_title		= "SAnálisis diario";
	$l_uploads		= "Datos de salida";
	$l_downloads		= "Datos entrantes";
	$l_from			= "Del";
	$l_to			= "al";
	$l_user			= "usuario";
	$l_onserver		= "en el servidor";
	$l_fields_to_display	= "Campos a mostrar";
	$l_number_of_sessions	= "Número de sesiones";
        $l_total_usage_time     = "Tiempo total de uso";
	$l_date			= "Fecha";
	$l_daily_summary	= "Resumen diaro";
	$l_refresh		= "Actualizar";
	$l_stat_for_all		= "Estadísticas para <b><font color=\"darkblue\">todos</font></b> los usuarios";
	$l_stat_for_user	= "Etadísticas para el usuario :";
	$l_maximum		= "Máximo";
	$l_average		= "Promedio";
	$l_summary		= "Résumen";
} else {
	$l_Pagename		= "Daily use";
	$l_title		= "Daily analysis";
	$l_uploads		= "Uploads";
	$l_downloads		= "Downloads";
	$l_from			= "From";
	$l_to			= "to";
	$l_user			= "user";
	$l_onserver		= "on the server";
	$l_fields_to_display	= "Fields to display";
	$l_number_of_sessions	= "Number of sesions";
	$l_total_usage_time	= "Total usage time";
	$l_date			= "date";
	$l_daily_summary	= "Daily summary";
	$l_refresh		= "Refresh";
	$l_stat_for_all		= "Statistic for <b><font color=\"darkblue\">all</font></b> users";
	$l_stat_for_user	= "Statistic for user :";
	$l_maximum		= "Maximum";
	$l_average		= "Average";
	$l_summary		= "Summary";
}
if (is_file("../lib/sql/drivers/$config[sql_type]/functions.php"))
	include_once("../lib/sql/drivers/$config[sql_type]/functions.php");
else{
	echo <<<EOM
<title>$l_title</title>
<meta http-equiv="Content-Type" content="text/html; charset=$config[general_charset]">
<link rel="stylesheet" href="/css/acc.css">
</head>
<body>
<center><b>Could not include SQL library functions. Aborting</b></center>
</body>
</html>
EOM;
	exit();
}
?>
<title><?= $l_title ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=<?= $config['general_charset'] ?>">
<link rel="stylesheet" href="/css/acc.css" type="text/css">
</head>
<body>
<?php
$stats_num = array();
$date = strftime('%A, %e %B %Y, %T %Z');
$now = time();
if (!isset($before))
{
	$before = date($config['sql_date_format'], $now + 86400);
}
if (!isset($after))
{
	$after = date($config['sql_date_format'], $now - 604800 );
}
$after_time = strtotime($after);
$before_time = strtotime($before);
$days[0] = $after;
$counter = $after_time + 86400;
$i = 1;
while($counter < $before_time){
	$days[$i++] = date($config['sql_date_format'],$counter);	
	$counter += 86400;
}
$days[$i] = $before;
$num_days = $i;

$column1 = (isset($column1)) ? "$column1" : 'sessions';
$column[1] = "$column1";
$selected1["$column1"] = 'selected';

$column2 = (isset($column2)) ? "$column2" : 'usage';
$column[2] = "$column2";
$selected2["$column2"] = 'selected';

$column3 = (isset($column3)) ? "$column3" : 'download';
$column[3] = "$column3";
$selected3["$column3"] = 'selected';

$message['sessions'] = $l_number_of_sessions;
$message['usage'] = $l_total_usage_time;
$message['upload'] = $l_uploads;
$message['download'] = $l_downloads;

if ($config['general_stats_use_totacct'] == 'yes'){
	$sql_val['sessions'] = 'connnum';
	$sql_val['usage'] = 'conntotduration';
	$sql_val['upload'] = 'outputoctets'; # invert with 'inputoctets' in order to display it more logically
	$sql_val['download'] = 'inputoctets';
}
else{
	$sql_val['usage'] = 'acctsessiontime';
	$sql_val['upload'] = 'acctinputoctets';
	$sql_val['download'] = 'acctoutputoctets';
}
$fun['sessions'] = 'nothing';
$fun['usage'] = 'time2strclock';
$fun['upload'] = 'bytes2str';
$fun['download'] = 'bytes2str';
$sql_val['user'] = (!isset($login) || $login == '' ) ? "WHERE username LIKE '%'" : "WHERE username = '$login'";
for ($j = 1; $j <= 3; $j++){
	$tmp = "{$sql_val[$column[$j]]}";
	$res[$j] = (!isset($tmp)) ? "COUNT(radacctid) AS res_$j" : "sum($tmp) AS res_$j";
}
$i = 1;
$servers['all'] = 'all';
foreach ($nas_list as $nas){
	$name = $nas['name'];
	if ($nas['ip'] == '')
		continue;
	$servers[$name] = $nas['ip'];
	$i++;
}
ksort($servers);
if(isset($server))
{
	if ($server != 'all' && $server != ''){
		$server = da_sql_escape_string($link,$server);
		$s = "AND nasipaddress = '$server'";
	}
}
$sql_extra_query = '';
if (isset($config['sql_accounting_extra_query']))
{
	$sql_extra_query = xlat($config['sql_accounting_extra_query'],$login,$config);
}
else
{
	$sql_extra_query = "";
}

$link = @da_sql_pconnect($config);
if ($link)
{
	$data['sum'] = array();
	$data['sum'][1] = "";
	$data['sum'][2] = "";
	$data['sum'][3] = "";

	$stats_num[1] = "";
	$stats_num[2] = "";
	$stats_num[3] = "";

	for ($i = $num_days;$i > -1; $i--){
		$day = "$days[$i]";
		if ($config['general_stats_use_totacct'] == 'yes')
			$search = @da_sql_query($link,$config,
			"SELECT $res[1],$res[2],$res[3] FROM $config[sql_total_accounting_table]
			$sql_val[user] AND acctdate = '$day' $s $sql_extra_query;");
		else
			$search = @da_sql_query($link,$config,
			"SELECT $res[1],$res[2],$res[3] FROM $config[sql_accounting_table]
			$sql_val[user] AND acctstoptime >= '$day 00:00:00' 
			AND acctstoptime <= '$day 23:59:59' $s $sql_extra_query;");
		if ($search){
			$row = @da_sql_fetch_array($search,$config);
			$data[$day][1] = $row['res_1'];
			$data_tmp = (int)$data['sum'][1] ;
			$data['sum'][1] = $data_tmp + $row['res_1'];
			$stats_num[1] = ($data[$day][1]) ? (int)$stats_num[1] + 1 : $stats_num[1];
			$data[$day][2] = $row['res_2'];
			$data_tmp = (int)$data['sum'][2];
			$data['sum'][2] = $data_tmp + $row['res_2'];
			$stats_num[2] = ($data[$day][2]) ? (int)$stats_num[2] + 1 : $stats_num[2];
			$data[$day][3] = $row['res_3'];
			$data_tmp = (int)$data['sum'][3];
			$data['sum'][3] = $data_tmp + $row['res_3'];
			$stats_num[3] = ($data[$day][3]) ? (int)$stats_num[3] + 1 : $stats_num[3];
		}
		else
			echo "<b>Database query failed: " . da_sql_error($link,$config) . "</b><br>\n";
	}
}
else
	echo "<b>Could not connect to SQL database</b><br>\n";

$stats_num[1] = ($stats_num[1]) ? $stats_num[1] : 1;
$stats_num[2] = ($stats_num[2]) ? $stats_num[2] : 1;
$stats_num[3] = ($stats_num[3]) ? $stats_num[3] : 1;

$data['avg'][1] = ceil($data['sum'][1] / $stats_num[1]);
$data['avg'][2] = ceil($data['sum'][2] / $stats_num[2]);
$data['avg'][3] = ceil($data['sum'][3] / $stats_num[3]);

$data['avg'][1] = $fun[$column[1]]($data['avg'][1]);
$data['avg'][2] = $fun[$column[2]]($data['avg'][2]);
$data['avg'][3] = $fun[$column[3]]($data['avg'][3]);

$data['sum'][1] = $fun[$column[1]]($data['sum'][1]);
$data['sum'][2] = $fun[$column[2]]($data['sum'][2]);
$data['sum'][3] = $fun[$column[3]]($data['sum'][3]);

$max[1] = 0;
$max[2] = 0;
$max[3] = 0;

for ($i = 0; $i <= $num_days; $i++){
	$day = "$days[$i]";
	$max[1] = ($max[1] > $data[$day][1] ) ? $max[1] : $data[$day][1];
	$max[2] = ($max[2] > $data[$day][2] ) ? $max[2] : $data[$day][2];
	$max[3] = ($max[3] > $data[$day][3] ) ? $max[3] : $data[$day][3];

}
for ($i = 0; $i <= $num_days; $i++){
	$day = "$days[$i]";
	for ($j = 1; $j <= 3; $j++){
		$tmp = $data[$day][$j];
		if (!$max[$j])
			$p = $w = $c = 0;
		else{
			$p = floor(100 * ($tmp / $max[$j]));
			$w = floor(70 * ($tmp / $max[$j]));
			$c = hexdec('f0e9e2') - (258 * $p);
			$c = dechex($c);
		}
		if (!$w)
			$w++;
		$perc[$day][$j] = $p . "%";
		$width[$day][$j] = $w;
		$color[$day][$j] = $c;
	}

	$data[$day][1] = $fun[$column[1]]($data[$day][1]);
	$data[$day][2] = $fun[$column[2]]($data[$day][2]);
	$data[$day][3] = $fun[$column[3]]($data[$day][3]);
}

$data['max'][1] = $fun[$column[1]]($max[1]);
$data['max'][2] = $fun[$column[2]]($max[2]);
$data['max'][3] = $fun[$column[3]]($max[3]);

require('../html/stats.html.php');
?>
