<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>ALCASAR Report</title>
	<link rel="stylesheet" href="/css/bootstrap.min.css">
	<link rel="stylesheet" href="/css/acc.css">
	<script src="/js/jquery.min.js"></script>
	<script src="/js/bootstrap.min.js"></script>
</head>
<body>
<?php
# Cette page permet de générer les journaux d'imputabilité dans une archive avec mot de passe.
# Lors de la création de cette archive, tous les utilisateurs d'alcasar seront prévenus lors de leur prochaine connexion par un message d'alerte.

# Choice of language
if(isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
{
	$Langue = explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]),0,2));
}
if($Language == 'fr')
{
	$l_title = "Journaux d'imputabilité";
	$l_info = "Génération des journaux d'imputabilité";
	$l_log_info = "Vous allez générer un document réservé aux autorités dans le cadre d'une requête judiciaire ou administrative. Tout les utilisateurs seront avertis de la génération de ce document.";
	$l_password = "Entrez votre mot de passe afin de protéger l'archive contenant le document généré";
	$l_submit = "Continuer";
	$l_date1="Commençant le ...";
	$l_date2="Terminant le ...";
	$l_hours="à ...";
	$l_options_info = "Que désirez vous?";
	$l_options_1="Tous les journaux";
	$l_options_2="Selectionnez un intervale ...";
	$l_options_3="Selectionnez depuis une date ...";
	$l_create="Les utilisateurs ont été prévenus de cette action et l'archive a bien été crée, retenez bien votre mot de passe car il sera impossible de vous le redonner";
	$l_load="Chargement...";
	$l_download="Télécharger l'archive";
	$l_error="Vous devez remplir les informations du formulaire!";
	$l_demandeur="Nom du demandeur :";
	$l_commentary="Raison :";
	$l_info_form="Information du demandeur :";
	$l_logtab="Dernières entrées :";
	$l_empty_log="Les journaux sont vides";
} else if($Language == 'es') {
	$l_title = "Registros de responsabilidad";
	$l_info = "Generación de registros de Imputabilidades";
	$l_log_info = "Está iniciando el proceso para generar un documento reservado para una investigación judicial o administrativa. Todos los usuarios serán advertidos.";
	$l_password = "Ingrese una contraseña para proteger el archivo que contiene el documento.";
	$l_submit = "Continuar";
	$l_date1="Desde el...";
	$l_date2="Hasta...";
	$l_hours=" a las...";
	$l_options_info = "¿Qué desea?";
	$l_options_1="Todos los registros";
	$l_options_2="Seleccione un rango...";
	$l_options_3="Seleccione desde una fecha específica...";
	$l_create="¡Los usuarios han sido advertidos y su archivo ha sido creado! ¡No olvide la contraseña!";
	$l_load="Cargando...";
	$l_download="Descargar archivo";
	$l_error="¡¡Es necesario que complete los criterios en el formulario!!";
	$l_demandeur="Nombre del solicitante:";
	$l_commentary="Motivo:";
	$l_info_form="Informacion del usuario";
	$l_logtab="Ultimas entradas:";
	$l_empty_log="Sin datos en los registros";
} else {
	$l_title = "Imputabilities logs";
	$l_info = "Imputabilities logs generation";
	$l_log_info = "You are in progress to generate a document reserved for a judicial or administrative investigation. All users will be warned.";
	$l_password = "Enter your password to protect the archive which contains the document.";
	$l_submit = "Proceed";
	$l_date1="Start at ...";
	$l_date2="End at ...";
	$l_hours="at ...";
	$l_options_info = "What do you want?";
	$l_options_1="All logs";
	$l_options_2="Select a range ...";
	$l_options_3="Select from a specific date ...";
	$l_create="Users have been warned and your archive has been created! Don't forget your password!";
	$l_load="Loading...";
	$l_download="Download archive";
	$l_error="You need to submit form informations!!";
	$l_demandeur="Applicant name :";
	$l_commentary="Reason :";
	$l_info_form="User Information";
	$l_logtab="Last entries :";
	$l_empty_log="Logs are empty";
}
$filename='/var/www/html/acc/backup/log_info.txt';
if(isset($_POST['submit']))
{
	$password=$_POST['password'];
	$demandeur=$_POST['demandeur'];
	$raison=$_POST['comment'];
# si le mot de passe est vide ou si il contient des espaces
	if($password != "" && $demandeur != "" && $raison != "")
	{
# Génération de log
		$text=date("Y-m-d H:i:s")."|||".$demandeur."|||".$raison."|||".$_SERVER['REMOTE_ADDR'];
# supprimer les nouvelles lignes
		$text = str_replace("\n", ' ', $text);
		$text = str_replace("\r", ' ', $text);
		file_put_contents($filename, $text.PHP_EOL, FILE_APPEND);
# Création des journaux dans une archive avec mot de passe.
		$filename_logs="imputabilities_logs.zip";
		switch($_POST['submit'])
		{
			case 'query_all':
				exec("sudo alcasar-generate_log.sh ".escapeshellarg($password));
				break;
			case 'query_range':
				$date1_selected= $_POST['start-year'].'-'.$_POST['start-month'].'-'.$_POST['start-day'].' '.$_POST['start-hour'].':'.$_POST['start-min'].':'.$_POST['start-sec'];
				$date2_selected= $_POST['stop-year'].'-'.$_POST['stop-month'].'-'.$_POST['stop-day'].' '.$_POST['stop-hour'].':'.$_POST['stop-min'].':'.$_POST['stop-sec'];
				exec("sudo alcasar-generate_log.sh ".escapeshellarg($password)." ".escapeshellarg($date1_selected)." ".escapeshellarg($date2_selected));
				break;
			case 'query_simple':
				$date1_selected= $_POST['start-year'].'-'.$_POST['start-month'].'-'.$_POST['start-day'].' '.$_POST['start-hour'].':'.$_POST['start-min'].':'.$_POST['start-sec'];
				exec("sudo alcasar-generate_log.sh ".escapeshellarg($password)." ".escapeshellarg($date1_selected));
				break;
		}
# Interface permettant de télécharger les journaux d'imputabilité
		echo "<h3>$l_create</h3>";
		echo "<a href=\"$filename_logs\" class=\"btn btn-info btn-lg\">";
		echo "	<span class=\"glyphicon glyphicon-download-alt\"></span> $l_download";
		echo "</a>";
	}
	else
	{
		echo "$l_error";	
	}
}
else
{
# Interface permettant de configurer la génération des journaux d'imputabilité.
	echo "<div class=\"panel\">\n";
	echo "<div class=\"panel-header\">$l_title</div>";
	echo "<div class=\"panel-row\">";
	echo "	<div style=\"margin-top:16px;margin-left:15px;\">";
	echo "		<div>";
	echo "				<fieldset>";
	echo "					<h3>$l_info</h3>";
	echo "					<p>$l_log_info</p>";
	echo "				</fieldset>";
	echo "<h4> $l_options_info  </h4>";
	echo "<div class=\"radio\">";
	echo "<label><input type=\"radio\" name=\"optradio\" onclick=\"radio_interact1()\"  style=\"margin-top: -1px;\" checked> $l_options_1 </label>";
	echo "</div>";
	echo "<div class=\"radio\">";
	echo "<label><input type=\"radio\" name=\"optradio\" onclick=\"radio_interact2()\" style=\"margin-top: -1px;\" > $l_options_2 </label>";
	echo "</div>";
	echo "<div class=\"radio\">";
	echo "<label><input type=\"radio\" name=\"optradio\" onclick=\"radio_interact3()\" style=\"margin-top: -1px;\"> $l_options_3 </label>";
	echo "</div>";
	echo "<form name=\"form_log\" method=\"post\" action=\"log_generation.php\" role=\"form\">";
	echo "<p> $l_password </p><input name=\"password\" type=\"password\" size=\"25\">";
	echo "<h2>$l_info_form</h2>";
	echo "<p>$l_demandeur</p><textarea name='demandeur' style=\"height:25px;\"></textarea>";
	echo "<p>$l_commentary</p><textarea name='comment'></textarea>";
	echo "<p id=\"query_option\"></br></br><button type=\"submit\" onClick=\"this.classList.add('disabled');\" class=\"btn btn-primary\" name=\"submit\" value=\"query_all\"> $l_submit </button></p>";	
}
echo "<br><div style=\"height:1px;background:#717171;border-bottom:1px solid #313030:\"></div>";
echo "<h2>$l_logtab</h2>";
if(file_exists($filename)){
	echo "<div class=\"container\">";     
	echo "<table class=\"table table-striped\">";
	echo "<thead>";
	echo "<tr>";
	echo "<th>Date</th>";
	echo "<th>User</th>";
	echo "<th>Reason</th>";
	echo "<th>IP address</th>";
	echo "</tr>";
	echo "</thead>";
	echo "<tbody>";
	$fichier = fopen($filename, "r");
	$content = file($filename);
	$content = array_reverse($content);
	foreach ($content as $line){
		$infos=explode("|||", $line);
		echo "<tr>";
		echo "<td>$infos[0]</td>";
		echo "<td>$infos[1]</td>";
		echo "<td>$infos[2]</td>";
		echo "<td>$infos[3]</td>";
		echo "</tr>";
	}
	echo "</tbody>";
	echo "</table>";
	echo "</div>";
}
else
{
	echo "<p>$l_empty_log</p>";
}

#javascript permettant de generer les dropdown des dates. Il faut s'assurer que les données envoyées soient au bon format afin d'etre traité dans alcasar-generation_logs.sh

echo "<script>";

echo "function radio_interact1() {";
echo "document.getElementById(\"query_option\").innerHTML = '";
echo "</br></br><button type=\"submit\" class=\"btn btn-primary\" name=\"submit\" value=\"query_all\"> $l_submit</button>";
echo "';}";

echo "function radio_interact2() {";
echo "    document.getElementById(\"query_option\").innerHTML = '";

echo "$l_date1 <select name=\"start-year\">";
$year = date('Y');
$years = $year-50;
for ($i = $year; $i >= $years; $i--) {
    $sel = ($i == $year) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo "-<select name=\"start-month\">";
$month = date('m');
for ($i = 1; $i <= 12; $i++) {
    $sel = ($i == $month) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}

echo "</select>";
echo "-<select name=\"start-day\">";
$day = date('d');
for ($i = 1; $i <= 31; $i++) {
    $sel = ($i == $day) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}

echo "</select>";
echo "$l_hours <select name=\"start-hour\">";
$hour = date('G');
for ($i = 0; $i <= 23; $i++) {
    $sel = ($i == $hour) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo ":<select name=\"start-min\">";
$min = date('i');
for ($i = 0; $i <= 59; $i++) {
    $sel = ($i == $min) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo ":<select name=\"start-sec\">";
$sec = date('s');
for ($i = 0; $i <= 59; $i++) {
    $sel = ($i == $sec) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo "</br>";

echo "$l_date2 <select name=\"stop-year\">";
$year = date('Y');
$years = $year-50;
for ($i = $year; $i >= $years; $i--) {
    $sel = ($i == $year) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo "-<select name=\"stop-month\">";
$month = date('m')+1;
for ($i = 1; $i <= 12; $i++) {
    $sel = ($i == $month) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}

echo "</select>";
echo "-<select name=\"stop-day\">";
$day = date('d');
for ($i = 1; $i <= 31; $i++) {
    $sel = ($i == $day) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}

echo "</select>";
echo "$l_hours <select name=\"stop-hour\">";
$hour = date('G');
for ($i = 0; $i <= 23; $i++) {
    $sel = ($i == $hour) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo ":<select name=\"stop-min\">";
$min = date('i');
for ($i = 0; $i <= 59; $i++) {
    $sel = ($i == $min) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo ":<select name=\"stop-sec\">";
$sec = date('s');
for ($i = 0; $i <= 59; $i++) {
    $sel = ($i == $sec) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo "</br></br><button type=\"submit\" class=\"btn btn-primary\" name=\"submit\" value=\"query_range\"> $l_submit</button>";
echo "';}";



echo "function radio_interact3() {";
echo "    document.getElementById(\"query_option\").innerHTML = '";

echo "$l_date1 <select name=\"start-year\">";
$year = date('Y');
$years = $year-50;
for ($i = $year; $i >= $years; $i--) {
    $sel = ($i == $year) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo "-<select name=\"start-month\">";
$month = date('m');
for ($i = 1; $i <= 12; $i++) {
    $sel = ($i == $month) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}

echo "</select>";
echo "-<select name=\"start-day\">";
$day = date('d');
for ($i = 1; $i <= 31; $i++) {
    $sel = ($i == $day) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}

echo "</select>";
echo "$l_hours <select name=\"start-hour\">";
$hour = date('G');
for ($i = 0; $i <= 23; $i++) {
    $sel = ($i == $hour) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo ":<select name=\"start-min\">";
$min = date('i');
for ($i = 0; $i <= 59; $i++) {
    $sel = ($i == $min) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo ":<select name=\"start-sec\">";
$sec = date('s');
for ($i = 0; $i <= 59; $i++) {
    $sel = ($i == $sec) ? ' selected="selected"' : '';
    $i = str_pad($i, 2, '0', STR_PAD_LEFT);
    echo "<option value=\"$i\"$sel>$i</option>";
}
echo "</select>";
echo "</br></br><button type=\"submit\" class=\"btn btn-primary\" name=\"submit\" value=\"query_simple\"> $l_submit</button>";
echo "';}";
echo "</script>";

echo "</form>";
echo "</div>";
echo "</div>";
echo "</div>";
?>
</div>
</body>
</html>
