<?php
# $Id: ldap.php 3238 2024-12-02 22:38:59Z rexy $

/* written by steweb57, Rexy & Tom HOUDAYER */
/****************************************************************
*			GLOBAL FILE PATHS			*
*****************************************************************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');

/****************************************************************
*			FILE reading test			*
*****************************************************************/
$conf_files = array(CONF_FILE);
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Fichier $file non présent");
	}
	if (!is_readable($file)) {
		exit("Vous n'avez pas les droits de lecture sur le fichier $file");
	}
}

/****************************************************************
*			Read CONF_FILE				*
*****************************************************************/
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}
fclose($file_conf);

/****************************************************************
*			Choice of language			*
*****************************************************************/
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue	  = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'fr') {
	$l_ldap_update			= "Mise à jour des paramètres LDAP effectuée";
	$l_ldap_title			= "Authentification externe : LDAP";
	$l_ldap_legend			= "Authentification LDAP";
	$l_ldap_auth_enable_label	= "Éditer la configuration LDAP:";
	$l_ldap_YES			= "OUI";
	$l_ldap_NO			= "NON";
	$l_ldap_server_label		= "Serveur LDAP:";
	$l_ldap_server_text		= "Adresse IP du serveur";
	$l_ldap_base_dn_label		= "DN de la base:";
	$l_ldap_base_dn_text		= "Le DN (Distinguished Name) définit où se situent les informations des utilisateurs dans l'annuaire.<br> - Exemple LDAP: 'o=mycompany, c=FR'.<br> - Exemple AD 'cn=Users,dc=server_name,dc=lan'";
	$l_ldap_uid_label		= "Identifiant d'utilisateur (UID):";
	$l_ldap_uid_text		= "Clé utilisée pour rechercher un identifiant de connexion.<br> - Exemple LDAP: 'uid', 'sn', etc.<br> - Pour A.D. mettre 'sAMAccountName'.";
	$l_ldap_base_filter_label	= "Filtre de recherche des utilisateurs (optionnel):";
	$l_ldap_base_filter_text	= "Vous pouvez limiter les objets recherchés avec des filtres additionnels.<br> Exemple 'objectClass=posixGroup' ajouterait le filtre '(&amp;(uid=username)(objectClass=posixGroup))'";
	$l_ldap_user_label		= "CN de l'utilisateur exploité par ALCASAR:";
	$l_ldap_user_text		= "CN=Common Name. Laissez vide pour utiliser un accès invité (ou anonyme). Obligatoire sur un AD.<br> - Exemple LDAP : 'uid=username,ou=my_lan,o=mycompany,c=FR'.<br> - Exemple AD : 'username' ou 'cn=username,cn=Users,dc=server_name,dc=lan'";
	$l_ldap_password_label		= "Mot de passe:";
	$l_ldap_password_text		= "Laissez vide pour un accès invité (ou anonyme). Obligatoire sur un AD.";
	$l_ldap_ssl_label		= "Connexion chiffrée";
	$l_ldap_ssl_text		= "Utiliser une connexion chiffré avec SSL (LDAPS)";
	$l_ldap_cert_required_label	= "Vérifier le certificat SSL";
	$l_ldap_cert_required_text	= "Vérifier que le serveur LDAP utilise un certificat connu";
	$l_ldap_cert_label		= "Certificat SSL (CA)";
	$l_ldap_cert_text		= "Certificat de l'authorité de certification signant celui du serveur LDAP";
	$l_ad_dns_domain_label		= "Nom de domaine interne";
	$l_ad_dns_domain_text		= "Nom de domaine qui sera redirigé vers le serveur DNS de l'annuaire LDAP (vide pour désactivé)";
	$l_ldap_cert_status_cur		= "Certificat actuel : ";
	$l_ldap_cert_status_no		= "Aucun certificat installé";
	$l_ldap_submit			= "Enregistrer";
	$l_ldap_test_service_failed	= "Service LDAP injoignable sur ce serveur (vérifiez l'@IP).";
	$l_ldap_test_service_ok		= "Un port 389 (636 avec SSL) est actif sur ce serveur";
	$l_ldap_test_connection_failed	= "Connexion LDAP impossible (vérifiez le service LDAP sur ce serveur)";
	$l_ldap_test_connection_ok	= "Une connexion LDAP a été établie";
	$l_ldap_test_bind_failed	= "Echec d'authentification (vérifiez l'utilisateur et le mot de passe)";
	$l_ldap_test_bind_ok		= "L'authentification a réussie";
	$l_ldap_test_dn_failed		= "Le DN de la base semble incorrect (vérifiez le)";
	$l_ldap_test_dn_ok		= "Le DN de la base semble correct";
	$l_ldap_error			= "erreur LDAP";
	$l_ldap_entries			= "entrées dans la base";
	$l_ldap_cert_cn_diff_dn		= "Le CommonName du certificat (§cert_domainName§) est différent du nom de domaine du serveur";
	$l_check			= "Vérifier cette configuration";
	$l_checkingConf			= "Vérification de cette configuration...";
} else if ($Language === 'es') {
	$l_ldap_update			= "Configuración de LDAP actualizada";
	$l_ldap_title			= "Autenticación externa : LDAP";
	$l_ldap_legend			= "LDAP autenticación";
	$l_ldap_auth_enable_label	= "Editar la configuración LDAP:";
	$l_ldap_YES			= "SI";
	$l_ldap_NO			= "NO";
	$l_ldap_server_label		= "Servidor LDAP:";
	$l_ldap_server_text		= "Dirección IP del servidor LDAP.";
	$l_ldap_base_dn_label		= "DN de la base:";
	$l_ldap_base_dn_text		= "El DN (Distinguished Name) se utiliza para ubicar la información de los usuarios en el directorio.<br> e.g. LDAP : 'o=MiEmpresa,c=AR'.<br> e.g. AD : 'cn=Users,dc=nombre_servidor,dc=lan'";
	$l_ldap_uid_label		= "Identificador de usuario (UID):";
	$l_ldap_uid_text		= "Clave utilizada para buscar una identidad de inicio de sesión determinada.<br>Ej. 'uid', 'sn', etc.. Para AD usar 'sAMAccountName'.";
	$l_ldap_base_filter_label	= "Filtro de búsqueda de usuario (opcional):";
	$l_ldap_base_filter_text	= "Puede limitar aún más los objetos buscados con filtros adicionales.<br> Por ejemplo'objectClass=posixGroup' daría como resultado el uso de '(&amp;(uid=username)(objectClass=posixGroup))'";
	$l_ldap_user_label		= "CN del usuario operador ALCASAR:";
	$l_ldap_user_text		= "CN=Common Name. Déjelo en blanco para enlace anónimo. Obligatorio para AD.<br> Ej. LDAP :'uid=Usuario,ou=mi_Red,o=miEmpresa,c=AR'.<br> Ej. AD : 'username' or 'cn=username,cn=Users,dc=server_name,dc=lan'";
	$l_ldap_password_label		= "Contraseña:";
	$l_ldap_password_text		= "Déjelo en blanco para usar un enlace anónimo. Obligatorio para AD.";
	$l_ldap_ssl_label		= "Conexión segura";
	$l_ldap_ssl_text		= "Use una conexión encriptada con SSL (LDAPS)";
	$l_ldap_cert_required_label	= "Comprueba el certificado SSL";
	$l_ldap_cert_required_text	= "Verifique que el servidor LDAP use un certificado confiable";
	$l_ldap_cert_label		= "Certificado (CA) SSL";
	$l_ldap_cert_text		= "Certificado de la autoridad de certificación que firmó el certificado del servidor LDAP";
	$l_ad_dns_domain_label		= "Nombre de dominio interno";
	$l_ad_dns_domain_text		= "Nombre de dominio que se reenviará al servidor DNS del directorio LDAP (vacío para desactivar)";
	$l_ldap_cert_status_cur		= "Certificado actual:";
	$l_ldap_cert_status_no		= "Ningún certificado importado";
	$l_ldap_submit			= "Guardar";
	$l_ldap_test_service_failed	= "El servicio LDAP no es accesible en ese servidor (verifique la IP)";
	$l_ldap_test_service_ok		= "El puerto 389 (636 con SSL) está abierto en este servidor";
	$l_ldap_test_connection_failed	= "La conexión LDAP falló (verifique el servicio LDAP en este servidor)";
	$l_ldap_test_connection_ok	= "Se establece una conexión LDAP";
	$l_ldap_test_bind_failed	= "La autenticación LDAP falló (verifique el usuario LDAP y la contraseña)";
	$l_ldap_test_bind_ok		= "Autenticación exitosa";
	$l_ldap_test_dn_failed		= "DN de la base parece ser erróneo (verifíquelo)";
	$l_ldap_test_dn_ok		= "DN de la base parece estar bien";
	$l_ldap_error			= "error LDAP";
	$l_ldap_entries			= "entradas en la base";
	$l_ldap_cert_cn_diff_dn		= "El CommonName del certificado (§cert_domainName§) es diferente del nombre de dominio del servidor";
	$l_check			= "Verifique éste paramétro";
	$l_checkingConf			= "Verificando ésta configuración...";
} else {
	$l_ldap_update			= "LDAP settings updated";
	$l_ldap_title			= "External authentication : LDAP";
	$l_ldap_legend			= "LDAP authentication";
	$l_ldap_auth_enable_label	= "Edit the LDAP configuration :";
	$l_ldap_YES			= "YES";
	$l_ldap_NO			= "NO";
	$l_ldap_server_label		= "LDAP server :";
	$l_ldap_server_text		= "IP address of the LDAP server.";
	$l_ldap_base_dn_label		= "DN of the base:";
	$l_ldap_base_dn_text		= "The DN (Distinguished Name) is used to locate the users information in the directory.<br> e.g. LDAP : 'o=MyCompany,c=US'.<br> e.g. AD : 'cn=Users,dc=server_name,dc=lan'";
	$l_ldap_uid_label		= "User IDentifier (UID):";
	$l_ldap_uid_text		= "Key used to search for a given login identity.<br>e.g. 'uid', 'sn', etc.. For AD use 'sAMAccountName'.";
	$l_ldap_base_filter_label	= "User search filter (optional):";
	$l_ldap_base_filter_text	= "You can further limit the searched objects with additional filters.<br> For example 'objectClass=posixGroup' would result in the use of '(&amp;(uid=username)(objectClass=posixGroup))'";
	$l_ldap_user_label		= "CN of the user operated by ALCASAR:";
	$l_ldap_user_text		= "CN=Common Name. Leave blank to use anonymous binding. Mandatory for AD.<br> e.g. LDAP :'uid=Username,ou=my_lan,o=mycompany,c=US'.<br> e.g. AD : 'username' or 'cn=username,cn=Users,dc=server_name,dc=lan'";
	$l_ldap_password_label		= "Password:";
	$l_ldap_password_text		= "Leave blank to use anonymous binding. Mandatory for AD.";
	$l_ldap_ssl_label		= "Secure connection";
	$l_ldap_ssl_text		= "Use an encrypted connection with SSL (LDAPS)";
	$l_ldap_cert_required_label	= "Check the SSL certificate";
	$l_ldap_cert_required_text	= "Verify that the LDAP server uses a trusted certificate";
	$l_ldap_cert_label		= "SSL certificate (CA)";
	$l_ldap_cert_text		= "Certificate of the certification authority that signed the LDAP server certificate";
	$l_ad_dns_domain_label		= "Internal domain name";
	$l_ad_dns_domain_text		= "Domain name that will be forwarded to the DNS server of the LDAP directory (empty for disabled)";
	$l_ldap_cert_status_cur		= "Current certificate:";
	$l_ldap_cert_status_no		= "No certificate imported";
	$l_ldap_submit			= "Save";
	$l_ldap_test_service_failed	= "LDAP service is not reachable on that server (check IP)";
	$l_ldap_test_service_ok		= "A port 389 (636 with SSL) is open on this server";
	$l_ldap_test_connection_failed	= "LDAP connexion failed (check the LDAP service on this server)";
	$l_ldap_test_connection_ok	= "A LDAP connexion is established";
	$l_ldap_test_bind_failed	= "LDAP authentication failed (check the LDAP user and password)";
	$l_ldap_test_bind_ok		= "Successful authentication";
	$l_ldap_test_dn_failed		= "DN of the base seems to be wrong (check it)";
	$l_ldap_test_dn_ok		= "DN of the base seems to be ok";
	$l_ldap_error			= "LDAP error";
	$l_ldap_entries			= "entries in the base";
	$l_ldap_cert_cn_diff_dn		= "Certificate CommonName (§cert_domainName§) is different from the server domain name";
	$l_check			= "Check this config";
	$l_checkingConf			= "Checking this configuration...";
}

// AJAX LDAP assitant
if (isset($_GET['assistant'])) {
	$response = [
		'values' => []
	];
	if (!isset($_POST['ldap_server'])) exit();
	$ldap_server = $_POST['ldap_server'];

	// Check port 389 & 636
	if (!$sock = @fsockopen($ldap_server, 389, $num, $error, 2)) {
		$ldap_port_389 = false;
		$ldap_srv_389  = false;
	} else {
		$ldap_port_389 = true;
		fclose($sock);
	}
	if (!$sock = @fsockopen($ldap_server, 636, $num, $error, 2)) {
		$ldap_port_636 = false;
		$ldap_srv_636  = false;
		$ldap_ssl      = false;
	} else {
		$ldap_port_636 = true;
		$ldap_ssl      = true;
		fclose($sock);
	}

	if (!$ldap_port_389 && !$ldap_port_636) {
		$response['result'] = -2;

		header('Content-Type: application/json');
		echo json_encode($response);
		exit();
	}

	// Check LDAP service
	if ($ldap_port_636) {
	// Set LDAP SSL options
		ldap_set_option(null, LDAP_OPT_X_TLS_REQUIRE_CERT, LDAP_OPT_X_TLS_NEVER);
		$ldapconn = @ldap_connect('ldaps://'.$ldap_server);
		if (!$ldapconn) {
			$ldap_srv_636 = false;
		} else {
			ldap_set_option($ldapconn, LDAP_OPT_TIMELIMIT, 2);

			// Bind anonymous
			$ldap_srv_636 = true;
			if (!@ldap_bind($ldapconn)) {
				ldap_set_option($ldapconn, LDAP_OPT_PROTOCOL_VERSION, 3);
				if (!@ldap_bind($ldapconn)) {
					$ldap_srv_636 = false;
				}
			}
		}

		if ($ldap_srv_636) {
			$ldap_data    = @ldap_read($ldapconn, '', 'objectClass=*', ['dnsHostName','rootDomainNamingContext','supportedCapabilities']);
			$ldap_rootDSE = @ldap_get_entries($ldapconn, $ldap_data);

			try {
				$response['values']['isAD'] = in_array('1.2.840.113556.1.4.800', $ldap_rootDSE[0]['supportedcapabilities']);
			} catch (Exception $e) {
				$response['values']['isAD'] = false;
			}

			if ($response['values']['isAD']) {
				try {
					$response['values']['ldap_base_dn'] = $ldap_rootDSE[0]['rootdomainnamingcontext'][0];

					if ($response['values']['ldap_base_dn']) {
						$response['values']['int_dns_domain'] = str_replace('DC=', '', str_replace(',DC=', '.', $response['values']['ldap_base_dn']));
					}

					$response['values']['ldap_base_dn'] = 'CN=Users,'.$response['values']['ldap_base_dn'];
				} catch (Exception $e) { }

				try {
					$response['values']['ldap_server_domain'] = $ldap_rootDSE[0]['dnshostname'][0];
				} catch (Exception $e) { }
			}
		}
	}
	$response['values']['ldap_srv_636'] = $ldap_srv_636;

	if (!$ldap_srv_636) {
		$ldapconn = @ldap_connect('ldap://'.$ldap_server);
		if (!$ldapconn) {
			$ldap_srv_389 = false;
		} else {
			ldap_set_option($ldapconn, LDAP_OPT_TIMELIMIT, 2);

			// Bind anonymous
			$ldap_srv_389 = true;
			if (!@ldap_bind($ldapconn)) {
				ldap_set_option($ldapconn, LDAP_OPT_PROTOCOL_VERSION, 3);
				if (!@ldap_bind($ldapconn)) {
					$ldap_srv_389 = false;
				}
			}
		}

		if ($ldap_srv_389) {
			$ldap_data    = @ldap_read($ldapconn, '', 'objectClass=*', ['dnsHostName','rootDomainNamingContext','supportedCapabilities']);
			$ldap_rootDSE = @ldap_get_entries($ldapconn, $ldap_data);

			try {
				$response['values']['isAD'] = in_array('1.2.840.113556.1.4.800', $ldap_rootDSE[0]['supportedcapabilities']);
			} catch (Exception $e) {
				$response['values']['isAD'] = false;
			}

			if ($response['values']['isAD']) {
				try {
					$response['values']['ldap_base_dn'] = $ldap_rootDSE[0]['rootdomainnamingcontext'][0];

					if ($response['values']['ldap_base_dn']) {
						$response['values']['int_dns_domain'] = str_replace('DC=', '', str_replace(',DC=', '.', $response['values']['ldap_base_dn']));
					}

					$response['values']['ldap_base_dn'] = 'CN=Users,'.$response['values']['ldap_base_dn'];
				} catch (Exception $e) { }

				try {
					$response['values']['ldap_server_domain'] = $ldap_rootDSE[0]['dnshostname'][0];
				} catch (Exception $e) { }
			}
		}
		$response['values']['ldap_srv_389'] = $ldap_srv_389;
	}

	if (!$ldap_srv_636 && !$ldap_srv_389) {
		$response['result'] = -1;

		header('Content-Type: application/json');
		echo json_encode($response);
		exit();
	}

	$response['result'] = 0;
	header('Content-Type: application/json');
	echo json_encode($response);
	exit();
}

function ldap_checkServerConfig($f_ldap_server, $f_ldap_identity, $f_ldap_password, $f_ldap_basedn, $f_ldap_base_filter, $f_ldap_uid, $f_ldap_ssl, $f_ldap_cert, $f_ldap_cert_required) {
	// Socket to the LDAP port of the server
	if (!$sock = @fsockopen($f_ldap_server, (($f_ldap_ssl) ? 636 : 389), $num, $error, 2)) {
		// no network connection
		return -2;
	}
	fclose($sock);

	// Set LDAP SSL options
	if ($f_ldap_ssl) {
		if ($f_ldap_cert_required) {
			if ($f_ldap_cert) {
				ldap_set_option(null, LDAP_OPT_X_TLS_CACERTFILE, $f_ldap_cert);
			}
			ldap_set_option(null, LDAP_OPT_X_TLS_REQUIRE_CERT, LDAP_OPT_X_TLS_DEMAND);

		} else {
			ldap_set_option(null, LDAP_OPT_X_TLS_REQUIRE_CERT, LDAP_OPT_X_TLS_NEVER);
		}
	}

	// if ok, Test LDAP connection
	$ldapconn = @ldap_connect((($f_ldap_ssl)?'ldaps':'ldap').'://'.$f_ldap_server);
	if (!$ldapconn) {
		// LDAP connection failed
		return -1;
	}

	ldap_set_option($ldapconn, LDAP_OPT_TIMELIMIT, 2);

	// if ok, test a ldap-bind with the user used by ALCASAR
	$ldapbind = @ldap_bind($ldapconn, $f_ldap_identity, $f_ldap_password);
	if (!$ldapbind) {
		// Test LDAP Version 3
		ldap_set_option($ldapconn, LDAP_OPT_PROTOCOL_VERSION, 3);
		$ldapbind = @ldap_bind($ldapconn, $f_ldap_identity, $f_ldap_password);
		if (!$ldapbind) {
			// LDAP Bind failed
			return 0;
		}
	}

	// if ok, try to query the directory of users
	$filter = ((!empty($f_ldap_base_filter)) ? $f_ldap_base_filter : '&');
	$query = "(&($f_ldap_uid=*)($filter))";
	$ldap_result = @ldap_search($ldapconn, $f_ldap_basedn, $query);
	if ($ldap_result) {
		$ldap_users_count = ldap_count_entries($ldapconn, $ldap_result);
		return ($ldap_users_count + 2);
	} else {
		return 1;
	}
	ldap_unbind($ldapconn);
}

$messages = '';
$LDAPS_CERT_LOC = '/etc/raddb/certs/alcasar-ldaps.crt';

if (isset($_POST['auth_enable'])) {
	if ($_POST['auth_enable'] === '1') {
		// TODO : need to translate messages
		$varErrors = [];
		if (isset($_POST['ldap_server']))        $ldap_server        = $_POST['ldap_server'];        else array_push($varErrors, 'Variable error "ldap_server"');
		if (isset($_POST['ldap_base_dn']))       $ldap_base_dn       = $_POST['ldap_base_dn'];       else array_push($varErrors, 'Variable error "ldap_base_dn"');
		if (isset($_POST['ldap_uid']))           $ldap_uid           = $_POST['ldap_uid'];           else array_push($varErrors, 'Variable error "ldap_uid"');
		if (isset($_POST['ldap_base_filter']))   $ldap_base_filter   = $_POST['ldap_base_filter'];   else array_push($varErrors, 'Variable error "ldap_base_filter"');
		if (isset($_POST['ldap_user']))          $ldap_user          = $_POST['ldap_user'];          else array_push($varErrors, 'Variable error "ldap_user"');
		if (isset($_POST['ldap_password']))      $ldap_password      = $_POST['ldap_password'];      else array_push($varErrors, 'Variable error "ldap_password"');
		if (isset($_POST['ldap_ssl']))           $ldap_ssl           = $_POST['ldap_ssl'];           //else array_push($varErrors, 'Variable error "ldap_ssl"');
		if (isset($_FILES['ldap_cert']))         $ldap_cert          = $_FILES['ldap_cert'];         //else array_push($varErrors, 'Variable error "ldap_cert"');
		if (isset($_POST['ldap_cert_required'])) $ldap_cert_required = $_POST['ldap_cert_required']; //else array_push($varErrors, 'Variable error "ldap_cert_required"');

		if (isset($ldap_cert) && ($ldap_cert['error'] === UPLOAD_ERR_OK)) {
			if ($ldap_cert_required === 'on') {
				$certificateInfos = openssl_x509_parse(file_get_contents($ldap_cert['tmp_name']));
				if (preg_match_all('@/[a-zA-Z]+=([^/]+)@', $certificateInfos['name'], $matches)) {
					$cert_domainName = implode('.', array_reverse($matches[1]));
					if ($cert_domainName !== $ldap_server) {
						array_push($varErrors, str_replace("§cert_domainName§", $cert_domainName, $l_ldap_cert_cn_diff_dn));
					}
				}
			}
		}

		if (!empty($varErrors)) { 
			foreach ($varErrors as $error) {
				$messages .= '<span style="font-weight: bold; color: red;">'.$error.'</span><br>';
			}
		} else {
			exec('sed -i '.escapeshellarg("s/^LDAP_SERVER=.*/LDAP_SERVER=$ldap_server/g").' '.CONF_FILE);
			exec('sed -i '.escapeshellarg("s/^LDAP_BASE=.*/LDAP_BASE=$ldap_base_dn/g").' '.CONF_FILE);
			exec('sed -i '.escapeshellarg("s/^LDAP_UID=.*/LDAP_UID=$ldap_uid/g").' '.CONF_FILE);
			exec('sed -i '.escapeshellarg("s/^LDAP_FILTER=.*/LDAP_FILTER=$ldap_base_filter/g").' '.CONF_FILE);
			exec('sed -i '.escapeshellarg("s/^LDAP_USER=.*/LDAP_USER=$ldap_user/g").' '.CONF_FILE);
			exec('sed -i '.escapeshellarg("s/^LDAP_PASSWORD=.*/LDAP_PASSWORD=$ldap_password/g").' '.CONF_FILE);
			exec('sed -i '.escapeshellarg("s/^LDAP_SSL=.*/LDAP_SSL=$ldap_ssl/g").' '.CONF_FILE);
			if (isset($ldap_cert_required)) {
				exec('sed -i '.escapeshellarg("s/^LDAP_CERT_REQUIRED=.*/LDAP_CERT_REQUIRED=$ldap_cert_required/g").' '.CONF_FILE);
			}
			exec('sed -i \'s/^LDAP=.*/LDAP=on/g\' '.CONF_FILE);
			if (isset($ldap_cert) && ($ldap_cert['error'] === UPLOAD_ERR_OK)) {
				exec('sudo /usr/local/bin/alcasar-ldap.sh --import-cert '.escapeshellarg($ldap_cert['tmp_name']));
			}
			exec('sudo /usr/local/bin/alcasar-ldap.sh --on');
			$messages .= '<span style="font-weight: bold; color: green;">'.$l_ldap_update.'</span><br>';

			if ((isset($_POST['ad_dns_domain'])) && ($_POST['ad_dns_domain'] !== $conf['INT_DNS_DOMAIN'])) {
				if (filter_var($ldap_server, FILTER_VALIDATE_IP) !== false) {
					$ldap_server_ip = $ldap_server;
				} else {
					$ldap_server_ip = gethostbyname($ldap_server);
				}
				if (filter_var($ldap_server_ip, FILTER_VALIDATE_IP) !== false) {
					file_put_contents(CONF_FILE, str_replace('INT_DNS_IP='.$conf['INT_DNS_IP'],         'INT_DNS_IP='.$ldap_server_ip,             file_get_contents(CONF_FILE)));
					file_put_contents(CONF_FILE, str_replace('INT_DNS_DOMAIN='.$conf['INT_DNS_DOMAIN'], 'INT_DNS_DOMAIN='.$_POST['ad_dns_domain'], file_get_contents(CONF_FILE)));
					if (!empty($_POST['ad_dns_domain'])) {
						exec('sudo /usr/local/bin/alcasar-dns-local.sh --on');
					} else {
						exec('sudo /usr/local/bin/alcasar-dns-local.sh --off');
					}
				}
			}
		}
	} else {
		exec('sed -i "s/^LDAP=.*/LDAP=off/g" '.CONF_FILE);
		exec('sudo /usr/local/bin/alcasar-ldap.sh --off');
		$messages .= '<span style="font-weight: bold; color: green;">'.$l_ldap_update.'</span><br>';

		if ((isset($_POST['ad_dns_domain'])) && (empty($_POST['ad_dns_domain']))) {
			exec('sudo /usr/local/bin/alcasar-dns-local.sh --off');
		}
	}

	// Reload configuration
	$file_conf = fopen(CONF_FILE, 'r');
	if (!$file_conf) {
		exit('Error opening the file '.CONF_FILE);
	}
	while (!feof($file_conf)) {
		$buffer = fgets($file_conf, 4096);
		if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
			$tmp = explode('=', $buffer, 2);
			$conf[trim($tmp[0])] = trim($tmp[1]);
		}
	}
	fclose($file_conf);
}

// LDAP configuration params
$ldap_status        = ($conf['LDAP'] === 'on');
$ldap_server        = $conf['LDAP_SERVER'];
$ldap_user          = $conf['LDAP_USER'];
$ldap_password      = $conf['LDAP_PASSWORD'];
$ldap_base_dn       = $conf['LDAP_BASE'];
$ldap_uid	    = $conf['LDAP_UID'];
$ldap_base_filter   = $conf['LDAP_FILTER'];
$ldap_ssl           = ($conf['LDAP_SSL'] === 'on');
$ldap_cert_required = ($conf['LDAP_CERT_REQUIRED'] === 'on');

$ldap_cert_subject = null;
if (file_exists($LDAPS_CERT_LOC)) {
	$certificateInfos = openssl_x509_parse(file_get_contents($LDAPS_CERT_LOC));
	if (preg_match_all('@/[a-zA-Z]+=([^/]+)@', $certificateInfos['name'], $matches)) {
		$ldap_cert_subject = implode('.', array_reverse($matches[1]));
	}
}

// AJAX LDAP configuration checker
if (isset($_GET['conf_check'])) {
	$response = [
		'enable' => $ldap_status
	];
	if ($ldap_status || ($_SERVER['REQUEST_METHOD'] === 'POST')) {
		$varErrors = [];
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			// TODO : need to translate messages
			if (isset($_POST['ldap_server']))        $ldap_server        = $_POST['ldap_server'];                   else array_push($varErrors, 'Variable error "ldap_server"');
			if (isset($_POST['ldap_base_dn']))       $ldap_base_dn       = $_POST['ldap_base_dn'];                  else array_push($varErrors, 'Variable error "ldap_base_dn"');
			if (isset($_POST['ldap_uid']))           $ldap_uid           = $_POST['ldap_uid'];                      else array_push($varErrors, 'Variable error "ldap_uid"');
			if (isset($_POST['ldap_base_filter']))   $ldap_base_filter   = $_POST['ldap_base_filter'];              else array_push($varErrors, 'Variable error "ldap_base_filter"');
			if (isset($_POST['ldap_user']))          $ldap_user          = $_POST['ldap_user'];                     else array_push($varErrors, 'Variable error "ldap_user"');
			if (isset($_POST['ldap_password']))      $ldap_password      = $_POST['ldap_password'];                 else array_push($varErrors, 'Variable error "ldap_password"');
			if (isset($_POST['ldap_ssl']))           $ldap_ssl           = ($_POST['ldap_ssl'] === 'on');           //else array_push($varErrors, 'Variable error "ldap_ssl"');
			if (isset($_FILES['ldap_cert']))         $ldap_cert          = $_FILES['ldap_cert'];                    //else array_push($varErrors, 'Variable error "ldap_cert"');
			if (isset($_POST['ldap_cert_required'])) $ldap_cert_required = ($_POST['ldap_cert_required'] === 'on'); //else array_push($varErrors, 'Variable error "ldap_cert_required"');
		}

		if (($ldap_cert_required) && isset($ldap_cert) && ($ldap_cert['error'] === UPLOAD_ERR_OK)) {
			$ldap_cert_tmpFilename = $ldap_cert['tmp_name'];
		} else {
			$ldap_cert_tmpFilename = null;
		}

		if (!empty($varErrors)) {
			$response['errors'] = $varErrors;
		} else {
			$result = ldap_checkServerConfig($ldap_server, $ldap_user, $ldap_password, $ldap_base_dn, $ldap_base_filter, $ldap_uid, $ldap_ssl, $ldap_cert_tmpFilename, $ldap_cert_required);

			if (($result === 0) && ($ldap_ssl && $ldap_cert_required && ((isset($ldap_cert) && ($ldap_cert['error'] === UPLOAD_ERR_OK)) || (file_exists($LDAPS_CERT_LOC))))) {
				if (filter_var($ldap_server, FILTER_VALIDATE_IP) !== false) {
					if (isset($ldap_cert) && ($ldap_cert['error'] === UPLOAD_ERR_OK)) {
						$certificateInfos = openssl_x509_parse(file_get_contents($ldap_cert['tmp_name']));
					} else {
						$certificateInfos = openssl_x509_parse(file_get_contents($LDAPS_CERT_LOC));
					}
					if (preg_match_all('@/[a-zA-Z]+=([^/]+)@', $certificateInfos['name'], $matches)) {
						$cert_domainName = implode('.', array_reverse($matches[1]));
						if ($cert_domainName !== $ldap_server) {
							$response['warnings'][] = str_replace("§cert_domainName§", $cert_domainName, $l_ldap_cert_cn_diff_dn);
						}
					}
					$res = ldap_checkServerConfig($cert_domainName, $ldap_user, $ldap_password, $ldap_base_dn, $ldap_base_filter, $ldap_uid, $ldap_ssl, $ldap_cert_tmpFilename, $ldap_cert_required);
					if ($res > 1) {
						$result = $res;
					}
					$result = max($result, $res);
				}
			}

			$response['result'] = $result;
		}
	}

	header('Content-Type: application/json');
	echo json_encode($response);
	exit();
}

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title><?= $l_ldap_title ?></title>
	<link type="text/css" href="/css/acc.css" rel="stylesheet">
	<link type="text/css" href="/css/ldap.css" rel="stylesheet">
	<script>
	function onLdapStatusChange() {
		var listToDisables = ['ldap_server', 'ldap_dn', 'ldap_uid', 'ldap_base_filter', 'ldap_user', 'ldap_password', 'ldap_ssl', 'ldap_cert_required', 'ldap_cert'];
		var formSubmit = document.querySelector('form input[type="submit"]');
		var btn_checkConf = document.getElementById('btn-checkconf');
		var isChecked = false;

		if (document.getElementById('auth_enable').value === '1') {
			for (var i=0; i<listToDisables.length; i++) {
				document.getElementById(listToDisables[i]).style.backgroundColor = null;
				document.getElementById(listToDisables[i]).disabled = false;
			}
			if (document.getElementById('ldap_ssl').value === 'off') {
				document.getElementById('ldap_cert_required').style.backgroundColor = '#c0c0c0';
				document.getElementById('ldap_cert_required').disabled = true;
				document.getElementById('ldap_cert').style.backgroundColor = '#c0c0c0';
				document.getElementById('ldap_cert').disabled = true;
			}
			else if (document.getElementById('ldap_cert_required').value === 'off') {
				document.getElementById('ldap_cert').style.backgroundColor = '#c0c0c0';
				document.getElementById('ldap_cert').disabled = true;
			}
			formSubmit.style.display = 'none';
			btn_checkConf.style.display = null;
		} else {
			for (var i=0; i<listToDisables.length; i++) {
				document.getElementById(listToDisables[i]).style.backgroundColor = '#c0c0c0';
				document.getElementById(listToDisables[i]).disabled = true;
			}
			formSubmit.style.display = null;
			btn_checkConf.style.display = 'none';
		}
	}

	function checkConfig() {
		var messagesElem = document.querySelector('fieldset > legend > div');
		var formSubmit   = document.querySelector('form input[type="submit"]');
		var btn_checkConf = document.getElementById('btn-checkconf');
		var form = document.getElementById('form-config_ldap');
		var post_data = new FormData(form);
		post_data.delete('auth_enable');

		messagesElem.innerHTML = '<?= $l_checkingConf ?>';

		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (this.readyState == 4) {
				if (this.status == 200) {
					var data = JSON.parse(this.responseText);

					var messages = '';

					if (typeof data.result !== 'undefined') {
						if (data.result === -2) {
							messages += "<span style=\"color: red\"><?= $l_ldap_test_service_failed ?></span>";
						} else {
							messages += "<span style=\"color: green\"><?= $l_ldap_test_service_ok ?></span>";
							if (data.result === -1) {
								messages += "<br><span style=\"color: red\"><?= $l_ldap_test_connection_failed ?></span>";
							} else {
								messages += "<br><span style=\"color: green\"><?= $l_ldap_test_connection_ok ?></span>";
								if (data.result === 0) {
									messages += "<br><span style=\"color: red\"><?= $l_ldap_test_bind_failed ?></span>";
								} else {
									messages += "<br><span style=\"color: green\"><?= $l_ldap_test_bind_ok ?></span>";
									if (data.result === 1) {
										messages += "<br><span style=\"color: red\"><?= $l_ldap_test_dn_failed ?></span>";
									} else {
										messages += "<br><span style=\"color: green\"><?= $l_ldap_test_dn_ok ?> (" + (data.result - 2) + " <?= $l_ldap_entries?>)</span>";
									}
								}
							}
						}
					}

					if (data.result > 1) {
						formSubmit.style.display = null;
						btn_checkConf.style.display = 'none';
					} else {
						formSubmit.style.display = 'none';
						btn_checkConf.style.display = null;
					}

					if (typeof data.errors !== 'undefined') {
						messages = '<span style=\"color: red\">' + data.errors.join('</span><br><span style=\"color: red\">') + '</span><br>';
					}
					if (typeof data.warnings !== 'undefined') {
						messages += '<br><span style=\"color: orange\">' + data.warnings.join('</span><br><span style=\"color: orange\">') + '</span><br>';
					}

					messagesElem.innerHTML = messages;
				} else {
					messagesElem.innerHTML = 'server error';
				}
			}
		};
		xhr.open('POST', 'ldap.php?conf_check', true);
		xhr.send(post_data);
	}

	function launchAssistant() {
		var messagesElem = document.querySelector('fieldset > legend > div');
		var dom_ldap_server        = document.getElementById('ldap_server');
		var dom_ldap_ssl           = document.getElementById('ldap_ssl');
		var dom_ldap_cert_required = document.getElementById('ldap_cert_required');
		var dom_ldap_dn            = document.getElementById('ldap_dn');
		var dom_ldap_uid           = document.getElementById('ldap_uid');
		var dom_ad_dns_domain      = document.getElementById('ad_dns_domain');
		post_data = 'ldap_server='+dom_ldap_server.value;

		messagesElem.innerHTML = '';

		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (this.readyState == 4) {
				if (this.status == 200) {
					var data = JSON.parse(this.responseText);
					var messages = '';

					if (typeof data.result !== 'undefined') {
						if (data.result === -2) {
							messages += "<span style=\"color: red\"><?= $l_ldap_test_service_failed ?></span>";
						} else if (data.result === -1) {
							messages += "<br><span style=\"color: red\"><?= $l_ldap_test_connection_failed ?></span>";
						} else if (data.result === 0) {
							if ((typeof data.values.int_dns_domain !== 'undefined') && (dom_ad_dns_domain.value === '')) {
								dom_ad_dns_domain.value = data.values.int_dns_domain
							}
							if ((typeof data.values.ldap_base_dn !== 'undefined') && (dom_ldap_dn.value === '')) {
								dom_ldap_dn.value = data.values.ldap_base_dn
							}
							if (dom_ldap_uid.value === '') {
								if (data.values.isAD === true) {
									dom_ldap_uid.value = 'sAMAccountName';
								} else {
									dom_ldap_uid.value = 'uid';
								}
							}
							if (data.values.ldap_srv_636 === true) {
								dom_ldap_ssl.value = 'on'
								if ((typeof data.values.ldap_server_domain !== 'undefined') && (dom_ldap_cert_required.value === 'on')) {
									dom_ldap_server.value = data.values.ldap_server_domain
								}
							} else {
								if (dom_ldap_ssl.value === 'on') {
									dom_ldap_ssl.value = 'off';
								}
							}
							onLdapStatusChange();
						}
					}

					messagesElem.innerHTML = messages;
				} else {
					messagesElem.innerHTML = 'server error';
				}
			}
		};
		xhr.open('POST', 'ldap.php?assistant', true);
		xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xhr.send(post_data);
	}
	</script>
</head>
<body onLoad="onLdapStatusChange();">
	<div class="panel">
		<div class="panel-header"><?= $l_ldap_legend ?></div>
		<div class="panel-body">
			<form id="form-config_ldap" name="config_ldap" method="POST" action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" enctype="multipart/form-data">
				<fieldset>
					<legend>
						<br>
						<div style="text-align: center">
							<?php if ($messages): ?>
								<?= $messages ?>
							<?php endif; ?>
						</div>
					</legend>
					<dl>
						<dt>
							<label for="auth_enable"><?= $l_ldap_auth_enable_label ?></label>
						</dt>
						<dd>
							<select id="auth_enable" name="auth_enable" onchange="onLdapStatusChange();">
								<option value="1"<?= ($ldap_status)  ? ' selected="selected"' : '' ?>><?= $l_ldap_YES ?></option>
								<option value="0"<?= (!$ldap_status) ? ' selected="selected"' : '' ?>><?= $l_ldap_NO ?></option>
							</select>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_server"><?= $l_ldap_server_label ?></label><br>
							<?= $l_ldap_server_text ?>
						</dt>
						<dd>
							<input type="text" id="ldap_server" size="40" name="ldap_server" value="<?= htmlspecialchars($ldap_server) ?>" oninput="onLdapStatusChange();"> <button onclick="launchAssistant(); return false;"><?= 'Assistant' ?></button>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_ssl"><?= $l_ldap_ssl_label ?></label><br>
							<?= $l_ldap_ssl_text ?><br>
						</dt>
						<dd>
							<select id="ldap_ssl" name="ldap_ssl" onchange="onLdapStatusChange();">
								<option value="on"<?= ($ldap_ssl)  ? ' selected="selected"' : '' ?>><?= $l_ldap_YES ?></option>
								<option value="off"<?= (!$ldap_ssl) ? ' selected="selected"' : '' ?>><?= $l_ldap_NO ?></option>
							</select>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_cert_required"><?= $l_ldap_cert_required_label ?></label><br>
							<?= $l_ldap_cert_required_text ?><br>
						</dt>
						<dd>
							<select id="ldap_cert_required" name="ldap_cert_required" onchange="onLdapStatusChange();">
								<option value="on"<?= ($ldap_cert_required)  ? ' selected="selected"' : '' ?>><?= $l_ldap_YES ?></option>
								<option value="off"<?= (!$ldap_cert_required) ? ' selected="selected"' : '' ?>><?= $l_ldap_NO ?></option>
							</select>
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_cert"><?= $l_ldap_cert_label ?></label><br>
							<?= $l_ldap_cert_text ?><br>
							<?= (($ldap_cert_subject) ? "$l_ldap_cert_status_cur $ldap_cert_subject" : $l_ldap_cert_status_no ) ?>
						</dt>
						<dd>
							<input type="file" id="ldap_cert" name="ldap_cert" oninput="onLdapStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_user"><?= $l_ldap_user_label ?></label><br>
							<?= $l_ldap_user_text ?>
						</dt>
						<dd>
							<input type="text" id="ldap_user" size="40" name="ldap_user" value="<?= htmlspecialchars($ldap_user) ?>" oninput="onLdapStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_password"><?= $l_ldap_password_label ?></label><br>
							<?= $l_ldap_password_text ?>
						</dt>
						<dd>
							<input type="password" id="ldap_password" size="40" name="ldap_password" value="<?= htmlspecialchars($ldap_password) ?>" oninput="onLdapStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_dn"><?= $l_ldap_base_dn_label ?></label><br>
							<?= $l_ldap_base_dn_text ?>
						</dt>
						<dd>
							<input type="text" id="ldap_dn" size="40" name="ldap_base_dn" value="<?= htmlspecialchars($ldap_base_dn) ?>" oninput="onLdapStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_uid"><?= $l_ldap_uid_label ?></label><br>
							<?= $l_ldap_uid_text ?>
						</dt>
						<dd>
							<input type="text" id="ldap_uid" size="40" name="ldap_uid" value="<?= htmlspecialchars($ldap_uid) ?>" oninput="onLdapStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ldap_base_filter"><?= $l_ldap_base_filter_label ?></label><br>
							<?= $l_ldap_base_filter_text ?>
						</dt>
						<dd>
							<input type="text" id="ldap_base_filter" size="40" name="ldap_base_filter" value="<?= htmlspecialchars($ldap_base_filter) ?>" oninput="onLdapStatusChange();">
						</dd>
					</dl>
					<dl>
						<dt>
							<label for="ad_dns_domain"><?= $l_ad_dns_domain_label ?></label><br>
							<?= $l_ad_dns_domain_text ?>
						</dt>
						<dd>
							<input type="text" id="ad_dns_domain" size="40" name="ad_dns_domain" value="<?= htmlspecialchars($conf['INT_DNS_DOMAIN']) ?>" oninput="onLdapStatusChange();">
						</dd>
					</dl>
					<p>
						<button id="btn-checkconf" onclick="checkConfig(); return false;"><?= $l_check ?></button>
						<input id="submit" type="submit" value="<?= $l_ldap_submit ?>" name="submit">
					</p>
				</fieldset>
			</form>
		</div>
	</div>
</body>
</html>
