#!/bin/bash

# Id: $Id: alcasar-url_filter_wl.sh 3263 2025-03-25 23:14:18Z rexy $

# alcasar-url_filter.sh
# by REXY
# This script is distributed under the Gnu General Public License (GPL)

# Active / désactive : safesearch des moteurs de recherche
# Enable / disable : search engines safesearch

CONF_FILE="/usr/local/etc/alcasar.conf"
IP_WL="/usr/local/share/iptables-wl-enabled/ossi-ip-safesearch"
SED="/bin/sed -i"
safesearch="Off"
usage="Usage: alcasar-url_filter_wl.sh { -safesearch_on or -safesearch_off }"

nb_args=$#
if [ $nb_args -le 0 ]
then
	echo "$usage"
	exit 1
fi

while [ $nb_args -ge 1 ]
do
	arg=${!nb_args}
	case $arg in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	# Safe search activation
	-safesearch_on | --safesearch_on)
		safesearch="On"
		;;
	# Safe search desactivation
	-safesearch_off | --safesearch_off)
		safesearch="Off"
		;;
	*)
		echo "Argument inconnu : $arg";
		echo "$usage"
		exit 1
		;;
	esac
nb_args=$(expr $nb_args - 1)
done

if [ $safesearch == "On" ]
then
	[ -e $IP_WL ] && rm -f $IP_WL
	# Before we wrote a special Unbound file with redirection. Ex. for google safesearching
	# google_safe_server=`host -ta forcesafesearch.google.com | grep "address" | cut -d" " -f4`	# retrieve google forcesafesearch ip
	# echo "server:" > $UNBOUND_BL_DOMAIN_FILTER_CONF
	# for domain in "google.com. google.ad. google.ae. google.com.af. google.com.ag. google.com etc."
	# do
	#	echo -e "\tlocal-zone: \"$domain\" redirect" >> $UNBOUND_BL_DOMAIN_FILTER_CONF
	#	echo -e "\tlocal-data: \"$domain A $google_safe_server\"" >> $UNBOUND_BL_DOMAIN_FILTER_CONF
	# done
	#
	# If enable again, add/remove "safe-searching" file in /etc/unbound/conf.d/whitelist (in this file, CNAME is used instead of REDIRECT)
	$SED 's/^WL_SAFESEARCH=.*/WL_SAFESEARCH=on/g' $CONF_FILE
else
	[ -e $IP_WL ] && rm -f $IP_WL
	$SED 's/^WL_SAFESEARCH=.*/WL_SAFESEARCH=off/g' $CONF_FILE
fi
systemctl restart unbound-whitelist
