#!/bin/bash

# Id: $Id: alcasar-url_filter_bl.sh 3263 2025-03-25 23:14:18Z rexy $

# alcasar-url_filter.sh
# by REXY
# This script is distributed under the Gnu General Public License (GPL)

# Active / désactive : safesearch des moteurs de recherche
# Enable / disable : search engines safesearch
# Active / désactive : le filtrage des url contenant une adresse ip à la place d'un nom de domaine
# Enable / disable : filter of urls containing ip address instead of domain name

CONF_FILE="/usr/local/etc/alcasar.conf"
DIR_DG_GROUP1="/etc/e2guardian/lists/group1"
SED="/bin/sed -i"
safesearch="Off"
pureip="Off"
usage="Usage: alcasar-url_filter_bl.sh { -safesearch_on or -safesearch_off } & { -pureip_on or -pureip_off }"

nb_args=$#
if [ $nb_args -lt 1 ]
then
	echo "$usage"
	exit 1
fi

while [ $nb_args -ge 1 ]
do
	arg=${!nb_args}
	case $arg in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	# Safe search activation
	-safesearch_on | --safesearch_on)
		safesearch="On"
		;;
	# Safe search deactivation
	-safesearch_off | --safesearch_off)
		safesearch="Off"
		;;
	# pure_ip activation
	-pureip_on | --pureip_on)
		pureip="On"
		;;
	# pureip deactivation
	-pureip_off | --pureip_off)
		pureip="Off"
		;;
	*)
		echo "Argument inconnu :$arg";
		echo "$usage"
		exit 1
		;;
	esac
nb_args=$(expr $nb_args - 1)
done

if [ "$safesearch" == "On" ]
then
	$SED "s?^#\"?\"?g" $DIR_DG_GROUP1/urlregexplist # uncomment rules lines
	# Before we wrote a special Unbound file with redirection. Ex. for google safesearching
	# google_safe_server=`host -ta forcesafesearch.google.com | grep "address" | cut -d" " -f4`	# retrieve google forcesafesearch ip
	# echo "server:" > $UNBOUND_BL_DOMAIN_FILTER_CONF
	# for domain in "google.com. google.ad. google.ae. google.com.af. google.com.ag. google.com etc."
	# do
	#	echo -e "\tlocal-zone: \"$domain\" redirect" >> $UNBOUND_BL_DOMAIN_FILTER_CONF
	#	echo -e "\tlocal-data: \"$domain A $google_safe_server\"" >> $UNBOUND_BL_DOMAIN_FILTER_CONF
	# done
	#
	# If enable again, add/remove "safe-searching" file in /etc/unbound/conf.d/blacklist (in this file, CNAME is used instead of REDIRECT)
	$SED 's/^BL_SAFESEARCH=.*/BL_SAFESEARCH=on/g' $CONF_FILE
elif [ "$safesearch" == "Off" ]
then
	$SED "s?^[^#]?#&?g" $DIR_DG_GROUP1/urlregexplist # comment rules lines

	$SED 's/^BL_SAFESEARCH=.*/BL_SAFESEARCH=off/g' $CONF_FILE
fi

if [ "$pureip" == "On" ]
then
	$SED "s/^\#\*ip$/*ip/g" $DIR_DG_GROUP1/bannedsitelist
	$SED "s/^\#\*ips$/*ips/g" $DIR_DG_GROUP1/bannedsitelist

	$SED 's/^BL_PUREIP=.*/BL_PUREIP=on/g' $CONF_FILE
elif [ "$pureip" == "Off" ]
then
	$SED "s/^\*ip$/#*ip/g" $DIR_DG_GROUP1/bannedsitelist
	$SED "s/^\*ips$/#*ips/g" $DIR_DG_GROUP1/bannedsitelist

	$SED 's/^BL_PUREIP=.*/BL_PUREIP=off/g' $CONF_FILE
fi
systemctl restart e2guardian
systemctl restart unbound-blacklist
