
#!/bin/bash

# alcasar-ssh.sh
# by Alexandre Vezin

# enable/disable SSH on external card
# activation/désactivation de SSH sur la carte réseau externe

SED="/bin/sed -i"
CAT="/bin/cat"
GREP="/bin/grep"
SYSTEMCTL="/bin/systemctl"
ALCASAR_CONF="/usr/local/etc/alcasar.conf"
SSH_CONF="/etc/ssh/sshd_config"

usage="Usage: alcasar-ssh.sh {--off | -off} | {--on | -on} [-p port] [-i allowed ip] {-l lan} | {-w wan}" # | {--all | -all} à add pour off all?

nb_args=$#
args=$1
if [ $nb_args -eq 0 ]
then
	echo "$usage"
	exit 1
fi

while getopts ":p:i:wl" portarg; do
    case "${portarg}" in
        p)
            SSH_PORT=${OPTARG}
			NUM_REGEX='^[0-9]+$'
			if ! [[ $SSH_PORT =~ $NUM_REGEX ]];
			then
				echo "The port $SSH_PORT is invalid"
				exit 1
			fi
			if [ $SSH_PORT -lt 0 ] || [ $SSH_PORT -gt 65535 ]
			then
				echo "The port $SSH_PORT is invalid"
				exit 1
			fi
            ;;
		i)
			IP_FROM=${OPTARG}
			ipcalc -c $IP_FROM
			if [ $? -ne 0 ]
			then
				exit 1;
			fi
			;;
		w)
			NETWORK="wan"
			;;
		l)
			NETWORK="lan"
			;;
    esac
done

case $args in
	-\? | -h* | --h*)
		echo "$usage"
		exit 0
		;;
	--off | -off)
		NETWORK=${NETWORK:="none"}
		if [ $NETWORK == "wan" ]
		then
			# Editing Alcasar configuration - Deleting the port
        	$SED "s/^SSH_WAN=.*/SSH_WAN=0/g" $ALCASAR_CONF
			# Editing SSH configuration - Deleting any port other than 22
			$SED "/^.*Port\s[0-9]*/{/\s22$/!d}" $SSH_CONF
			# Applying iptables
			/usr/local/bin/alcasar-iptables.sh
		elif [ $NETWORK == "lan" ] 
		then
			# Editing Alcasar configuration
			$SED "s/^SSH_LAN=.*/SSH_LAN=0/g" $ALCASAR_CONF
			# Applying iptables
			/usr/local/bin/alcasar-iptables.sh
		else
			echo "$usage"
			exit 0
		fi
		$SYSTEMCTL restart sshd
		exit 0
		;;
	--on | -on)
		NETWORK=${NETWORK:="none"}
		if [ $NETWORK == "wan" ]
		then
			# Getting LAN IP
			LAN_IP=`$GREP "^SSH_ADMIN_FROM=" $ALCASAR_CONF |cut -d"=" -f2|cut -d"/" -f1`
			# Setting accepted IP in Alcasar configuration
			IP_FROM=${IP_FROM:="0.0.0.0"}
			$SED "s ^SSH_ADMIN_FROM=.* SSH_ADMIN_FROM=$LAN_IP/$IP_FROM g" $ALCASAR_CONF
			# Setting SSH port in Alcasar configuration
    		SSH_PORT=${SSH_PORT:=22}
			$SED "s/^SSH_WAN=.*/SSH_WAN=$SSH_PORT/g" $ALCASAR_CONF
			LAN_PORT=`$GREP "^SSH_LAN=" $ALCASAR_CONF | cut -d"=" -f2`
			LAN_PORT=${LAN_PORT:=0}
			# Checking if there is already a port other than the LAN port set
			if [ `grep -E "^.*Port\s[0-9]*" /etc/ssh/sshd_config| grep -vEc "\s$LAN_PORT$"` -gt 0 ]
			then
				if [ $SSH_PORT -ne $LAN_PORT ]
				then
					# Editing SSH configuration - Changing any port other than the LAN port
					$SED "/\s$LAN_PORT$/! s/^.*Port\s[0-9]*/Port $SSH_PORT/" $SSH_CONF
				else
					# Editing SSH configuration - Deleting any port other than the LAN port
					$SED "/^.*Port\s[0-9]*/{/\s$LAN_PORT$/!d}" $SSH_CONF
				fi
			else
				if [ $SSH_PORT -ne $LAN_PORT ]
				then
					# Adding the new SSH port in the config
					echo "Port $SSH_PORT" >> $SSH_CONF
				fi
			fi
			# Applying iptables
			/usr/local/bin/alcasar-iptables.sh
		elif [ $NETWORK == "lan" ]
		then
			# Getting WAN IP
			WAN_IP=`$GREP "^SSH_ADMIN_FROM=" $ALCASAR_CONF |cut -d"=" -f2|cut -d"/" -f2`
			# Setting accepted IP in Alcasar configuration
			IP_FROM=${IP_FROM:="0.0.0.0"}
			$SED "s ^SSH_ADMIN_FROM=.* SSH_ADMIN_FROM=$IP_FROM/$WAN_IP g" $ALCASAR_CONF
			# Editing Alcasar configuration
			$SED "s/^SSH_LAN=.*/SSH_LAN=$SSH_PORT/g" $ALCASAR_CONF
			# Setting SSH port in Alcasar configuration
    		SSH_PORT=${SSH_PORT:=22}
			$SED "s/^SSH_LAN=.*/SSH_LAN=$SSH_PORT/g" $ALCASAR_CONF
			WAN_PORT=`$GREP "^SSH_WAN=" $ALCASAR_CONF | cut -d"=" -f2`
			WAN_PORT=${WAN_PORT:=0}
			# Checking if there is already a port other than the WAN port set
			if [ `grep -E "^.*Port\s[0-9]*" /etc/ssh/sshd_config| grep -vEc "\s$WAN_PORT$"` -gt 0 ]
			then
				if [ $SSH_PORT -ne $WAN_PORT ]
				then
					# Editing SSH configuration - Changing any port other than the WAN port
					$SED "/\s$WAN_PORT$/! s/^.*Port\s[0-9]*/Port $SSH_PORT/" $SSH_CONF
				else
					# Editing SSH configuration - Deleting any port other than the WAN port
					$SED "/^.*Port\s[0-9]*/{/\s$WAN_PORT$/!d}" $SSH_CONF
				fi
			else
				if [ $SSH_PORT -ne $WAN_PORT ]
				then
					# Adding the new SSH port in the config
					echo "Port $SSH_PORT" >> $SSH_CONF
				fi
			fi
			# Applying iptables
			/usr/local/bin/alcasar-iptables.sh
		else
			echo "$usage"
			exit 0
		fi		
		$SYSTEMCTL restart sshd
        exit 0
        ;;
	*)
		echo "Argument inconnu : $1"
		echo "$usage"
		exit 1
		;;
esac
