#!/bin/bash
# $Id: alcasar-rpm-download.sh 3293 2025-07-16 22:50:45Z rexy $

# alcasar-rpm-download.sh
# by Franck BOUIJOUX and Richard REY
# This script is distributed under the Gnu General Public License (GPL)

# récupération des RPM nécessaires dans un fichier tarball
# retrieve needed RPM in a tarball file

VERSION="9"
ARCH="x86_64"
# The kernel version we compile netflow for
KERNEL="kernel-server-6.6.88-3.mga9"
# ****** Alcasar needed RPMS - paquetages nécessaires au fonctionnement d'Alcasar ******
# (old) perl-Socket6 : needed by nfsen
# "fonts-dejavu-common" & "fonts-ttf-dejavu" : fonts needed by wkhtmltopdf
# "lsscsi" & nvme-cli" : needed by phpsysinfo
# "socat" : avoid a warning when run the install script of letsencrypt ("acme.sh")
# "sudo" : needed after a reinstallation (to be investigated)
# "clamav" + "clamav-db" : needed because of a lack of mutual dependance
# "postfix" + "cyrus-sasl" + "lib64sasl2-plug-plain" : email registration method
PACKAGES="vim-enhanced freeradius freeradius-mysql freeradius-ldap apache apache-mod_ssl apache-mod_php php-gd php-ldap php-mysqli php-mbstring php-sockets php-curl php-pdo_sqlite php-dom php-filter php-intl php-rrd php-cli unbound e2guardian postfix mariadb ntpsec bind-utils openssh-server rng-utils rsync fail2ban gnupg2 ulogd ipset usb_modeswitch vnstat dos2unix p7zip msec kernel-userspace-headers kernel-firmware kernel-firmware-nonfree dhcp-server tcpdump fonts-dejavu-common fonts-ttf-dejavu lsscsi nvme-cli sudo socat postfix cyrus-sasl lib64sasl2-plug-plain iftop"

rpm_repository_sync ()
{
cat <<EOF > /etc/urpmi/urpmi.cfg
{
downloader: wget
}
EOF
urpmi.addmedia core --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/core/release
urpmi.addmedia core-updates --update --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/core/updates
urpmi.addmedia nonfree --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/nonfree/release
urpmi.addmedia nonfree-updates --update --probe-synthesis --mirrorlist ${!MIRRORLIST} /media/nonfree/updates
}

rpm_error ()
{
echo
echo "Relancez l'installation ultérieurement."
echo "Si vous rencontrez à nouveau ce problème, modifier les variables MIRRORLIST[1&2] du fichier 'scripts/alcasar-rpm.sh'"
echo "Try an other install later."
echo "If this problem occurs again, change the MIRRORLIST[1&2] variables in the file 'scripts/alcasar-rpm.sh'"
}

# extract the current architecture (i586 ou X64)
fic=`cat /etc/product.id`
old="$IFS"
IFS=","
set $fic
for i in $*
do
	if [ "`echo $i|grep arch|cut -d'=' -f1`" == "arch" ]
	then
		ARCH=`echo $i|cut -d"=" -f2`
	fi
done
IFS="$old"
# We prefer wget than curl
wget_exist=`rpm -qa|grep wget|wc -l`
if [ "$wget_exist" -eq "0" ]
then
	urpmi --no-verify-rpm --auto ../rpms/$ARCH/wget*.rpm
fi
# Set the RPM repository
MIRROR_NBR=2
#                       For french ALCASARistes
MIRRORLIST1="http://www.mirrorservice.org/sites/mageia.org/pub/mageia/distrib/$VERSION/$ARCH"
#                       For International install
MIRRORLIST2="http://mirrors.mageia.org/api/mageia.$VERSION.$ARCH.list"
try_nb="0"; nb_repository="0"
while [ "$nb_repository" != "4" ]
do
	try_nb=`expr $try_nb + 1`
	MIRRORLIST="MIRRORLIST$try_nb"
	rpm_repository_sync
	nb_repository=`cat /etc/urpmi/urpmi.cfg|grep mirrorlist|wc -l`
	if [ "$nb_repository" != "4" ]
	then
		echo "Une erreur a été détectée lors de la synchronisation avec le dépot N°$try_nb."
		echo "An error occurs when synchronising the repositories N°$try_nb"
		if [ $(expr $try_nb) -eq $MIRROR_NBR ]
		then
			rpm_error
			exit 1
		fi
		echo "Voulez-vous tenter une synchronisation avec un autre dépôt (O/n)?"
		echo "Do you want to try a synchronisation with an other repository (Y/n)?"
		response=0
		PTN='^[oOnNyY]?$'
		until [[ "$response" =~ $PTN ]]
		do
			read response
		done
		if [ "$response" = "n" ] || [ "$response" = "N" ]
		then
			exit 1
		fi
	fi
done
# delete unused RPMs
echo "Cleaning the system : "
for rm_rpm in shorewall dhcp-server cyrus-sasl distcache-server avahi mandi radeontool mondo mindi
do
	/usr/sbin/urpme --auto $rm_rpm --auto-orphans 2>/dev/null
	echo -n "."
done
urpmi --clean
# download RPM in cache
echo "Récupération des paquetages de mise à jour. Veuillez patienter ..."
echo "Updated RPM download. Please wait ..."
echo "Il est temps d'aller prendre un café :-) "
echo "You should now take a Beer ;-) "
urpmi --auto --auto-update --quiet --test --retry 2
if [ "$?" != "0" ]
then
	echo
	echo "Une erreur a été détectée lors de la récupération des paquetages."
	echo "An error occurs when downloading RPMS"
	rpm_error
	exit 1
fi
# update with cached RPM
urpmi --auto --auto-update --noclean
if [ "$?" != "0" ]
then
	echo
	echo "Une erreur a été détectée lors de la mise à jour des paquetages."
	echo "An error occurs when updating packages"
	rpm_error
	exit 1
fi

# Download of ALCASAR specifics RPM in cache (and test)
echo "Récupération des paquetages complémentaires. Veuillez patienter ..."
echo "Download of complementary packages. Please wait ..."
urpmi --auto $KERNEL --quiet --test --retry 2
urpmi --auto $PACKAGES --quiet --test --retry 2
if [ "$?" != "0" ]
then
	echo
	echo "Une erreur a été détectée lors de la récupération des paquetages complémentaires."
	echo "An error occurs when downloading complementary packages"
	rpm_error
	exit 1
fi
echo "archive creation. Please wait..."
cd /var/cache/urpmi
tar -czf rpms-$ARCH.tar.gz rpms/
# Clean the RPM cache
urpmi --clean
mv rpms-$ARCH.tar.gz /root/
cd
echo "Your RPM archive file is /root/rpms-$ARCH.tar.gz"
exit 0
