#!/bin/bash
#
# $Id: alcasar-migration-3.3.1_dbRadiusAttrs.sh 2664 2018-11-19 17:35:12Z tom.houdayer $
#
# alcasar-migration_db-3.3.1.sh
# by Tom HOUDAYER
#
# This script is distributed under the Gnu General Public License (GPL)
#
# Migrate user database to ALCASAR 3.3.1
# Changes:
# - Move "CoovaChilli-Max-Total-Octets" RADIUS attribute from radreply to radcheck
# - Delete "CoovaChilli-Max-Input-Octets" and "CoovaChilli-Max-Output-Octets" RADIUS attributes

PASSWD_FILE="/root/ALCASAR-passwords.txt"
DB_PASS=$(grep ^db_root= $PASSWD_FILE | cut -d'=' -f2-)

DRY_RUN=false

if [ $# -eq 1 ] && [ "$1" == "--simulation" ]; then
	DRY_RUN=true
fi

db_query () {
	if $DRY_RUN && [[ ! "$1" =~ ^'SELECT ' ]]; then
		echo "[SQL] request: \"$1\""
	else
		mariadb -u root -p"$DB_PASS" -D radius -e "$1" -Bs
		[ $? -ne 0 ] && echo "[SQL] ERROR (\"$1\")"
	fi
}

for step in $(seq 1 2); do
	if [ $step -eq 1 ]; then
		tableNameCheck='radcheck'
		tableNameReply='radreply'
		loginName='username'
	else
		tableNameCheck='radgroupcheck'
		tableNameReply='radgroupreply'
		loginName='groupname'
	fi

	# Move "CoovaChilli-Max-Total-Octets" RADIUS attribute from radreply to radcheck
	db_res=$(db_query "SELECT $loginName, value FROM $tableNameReply WHERE attribute = 'CoovaChilli-Max-Total-Octets';")
	if [ -n "$db_res" ]; then
		echo "$(echo "$db_res" | wc -l) \"CoovaChilli-Max-Total-Octets\" found in table \"$tableNameReply\"."
		while read -r line; do
			login=$(echo "$line" | cut -f1)
			value=$(echo "$line" | cut -f2)
			echo " $login..."

			db_query "INSERT INTO $tableNameCheck ($loginName, attribute, value, op) VALUES ('$login','CoovaChilli-Max-Total-Octets','$value', ':=');"

		done <<< "$db_res"
		db_query "DELETE FROM $tableNameReply WHERE attribute = 'CoovaChilli-Max-Total-Octets';"
	fi

	# Delete "CoovaChilli-Max-Input-Octets" and "CoovaChilli-Max-Output-Octets" RADIUS attributes
	db_query "DELETE FROM $tableNameReply WHERE attribute = 'CoovaChilli-Max-Input-Octets';"
	db_query "DELETE FROM $tableNameReply WHERE attribute = 'CoovaChilli-Max-Output-Octets';"
done
