#!/bin/sh
# $Id: alcasar-CA.sh 3252 2025-02-21 18:40:30Z rexy $

# alcasar-CA.sh
# by Franck BOUIJOUX (3abtux), Pascal LEVANT and Richard REY (Rexy)
# This script is distributed under the Gnu General Public License (GPL)
#
# Some ideas from "nessus-mkcert" script written by Renaud Deraison <deraison@cvs.nessus.org>
# and Michel Arboi <arboi@alussinan.org>
#
DIR_TMP=${TMPDIR-/tmp}/alcasar-mkcert.$$
DIR_PKI=/etc/pki
DIR_CERT=$DIR_PKI/tls
DIR_WEB=/var/www/html
CACERT=$DIR_PKI/CA/alcasar-ca.crt
CAKEY=$DIR_PKI/CA/private/alcasar-ca.key
SRVREQ=$DIR_CERT/alcasar.req
SRVKEY=$DIR_CERT/private/alcasar.key
SRVCERT=$DIR_CERT/certs/alcasar.crt
SRVPEM=$DIR_CERT/private/alcasar.pem
SRVCHAIN=$DIR_CERT/certs/server-chain.pem
CONF_FILE="/usr/local/etc/alcasar.conf"
hostname=`grep ^HOSTNAME= $CONF_FILE|cut -d"=" -f2`
domain=`grep ^DOMAIN= $CONF_FILE|cut -d"=" -f2`
domain=${domain:=lan}
fqdn_hostname="$hostname.$domain"
# The value for organizationalUnitName must be 64 chars or less;
#   thus, hostname must be 36 chars or less. If it's too big,
#   try removing domain (merci REXY ;-) ).
hostname_len=`echo $fqdn_hostname| wc -c`
if [ $hostname_len -gt 36 ];
then
	fqdn_hostname=$hostname
fi
private_ip=`grep ^PRIVATE_IP= $CONF_FILE|cut -d"=" -f2|cut -d"/" -f1`

CACERT_LIFETIME="1460"
SRVCERT_LIFETIME="1460"
COUNTRY="FR"
PROVINCE="none"
LOCATION="Paris"
ORGANIZATION="ALCASAR-Team"

mkdir $DIR_TMP || exit 1
[ -d $DIR_PKI/CA/private ] || mkdir -p $DIR_PKI/CA/private ; chown -R root:root $DIR_PKI/CA ; chmod -R 750 $DIR_PKI/CA
# dynamic conf file for openssl
cat <<EOF >$DIR_TMP/ssl.conf
RANDFILE		= $HOME/.rnd

[ca]
default_ca = AlcasarCA

[AlcasarCA]
dir		= $DIR_TMP		# Where everything is kept
certs		= \$dir			# Where the issued certs are kept
crl_dir		= \$dir			# Where the issued crl are kept
database	= \$dir/index.txt	# database index file.
new_certs_dir	= \$dir			# default place for new certs.
certificate	= $CACERT	 	# The CA certificate
serial		= \$dir/serial 		# The current serial number
crl		= \$dir/crl.pem 	# The current CRL
private_key	= $CAKEY		# The private key
x509_extensions	= usr_cert		# The extentions to add to the cert
crl_extensions	= crl_ext
default_days	= 365			# how long to certify for
default_crl_days= 30			# how long before next CRL
default_md	= sha256		# which message digest to use.
preserve	= no			# keep passed DN ordering
policy		= policy_anything

[policy_anything]
countryName             = optional
stateOrProvinceName     = optional
localityName            = optional
organizationName        = optional
organizationalUnitName  = optional
commonName              = supplied
emailAddress            = optional

[req]
default_bits		= 2048
distinguished_name	= req_distinguished_name
# attributes		= req_attributes
x509_extensions		= v3_ca		# The extentions to add to the self signed cert

[ v3_ca ]
subjectKeyIdentifier	= hash
authorityKeyIdentifier	= keyid:always,issuer:always
basicConstraints	= critical,CA:true
keyUsage		= cRLSign, keyCertSign
nsCertType		= sslCA

[req_distinguished_name]
countryName			= Country Name (2 letter code)
countryName_default		= FR
countryName_min			= 2
countryName_max			= 2
stateOrProvinceName		= State or Province Name (full name)
stateOrProvinceName_default	= Some-State
localityName			= Locality Name (eg, city)
localityName_default		= Lyon
0.organizationName		= Organization Name (eg, company)
0.organizationName_default	= your organization name
organizationalUnitName		= Organizational Unit Name (eg, section)
commonName			= Common Name (eg, your name or your server\'s hostname)
commonName_max			= 255
emailAddress			= Email Address
emailAddress_max		= 255

[usr_cert]
nsCertType			= server
subjectKeyIdentifier		= hash
authorityKeyIdentifier		= keyid,issuer
basicConstraints		= CA:FALSE
keyUsage			= digitalSignature, nonRepudiation, keyEncipherment, dataEncipherment
issuerAltName			= issuer:copy
subjectAltName			= @alt_names

[alt_names]
DNS.1				= $fqdn_hostname
IP.1				= $private_ip
EOF

CAMAIL=
SRVMAIL=
echo `date +%s` > $DIR_TMP/serial
touch $DIR_TMP/index.txt

# CA key
rm -f $CAKEY
echo "*********CAKEY*********" > $DIR_TMP/openssl-log
openssl genrsa -out $CAKEY 2048 2>> $DIR_TMP/openssl-log

# CA certificate
rm -f $CACERT
echo >> $DIR_TMP/openssl-log
echo "*********CACERT*********" >> $DIR_TMP/openssl-log
echo "$COUNTRY
$PROVINCE
$LOCATION
$ORGANIZATION
Certification Authority for $fqdn_hostname
$fqdn_hostname-local-CA
$CAMAIL" | 
openssl req -config $DIR_TMP/ssl.conf -new -x509 -sha256 -days $CACERT_LIFETIME -key $CAKEY -out $CACERT 2>> $DIR_TMP/openssl-log

# Server key
rm -f $SRVKEY	
echo >> $DIR_TMP/openssl-log
echo "*********SRVKEY*********" >> $DIR_TMP/openssl-log
openssl genrsa -out $SRVKEY 2048 2>> $DIR_TMP/openssl-log

# Server certificate "request"
echo >> $DIR_TMP/openssl-log
echo "*********SRVRQST*********" >> $DIR_TMP/openssl-log
echo "$COUNTRY
$PROVINCE
$LOCATION
$ORGANIZATION
Server certificate for $fqdn_hostname
$fqdn_hostname
$SRVMAIL" | 
openssl req -config $DIR_TMP/ssl.conf -new -key $SRVKEY -out $SRVREQ 2>> $DIR_TMP/openssl-log

# Sign the server certificate "request" to create server certificate
rm -f $SRVCERT
echo >> $DIR_TMP/openssl-log
echo "*********SRVCERT*********" >> $DIR_TMP/openssl-log
openssl ca -config $DIR_TMP/ssl.conf -name AlcasarCA -batch -days $SRVCERT_LIFETIME -in $SRVREQ -out $SRVCERT 2>> $DIR_TMP/openssl-log
rm -f $SRVREQ

(cat $SRVKEY; echo; cat $SRVCERT) > $SRVPEM
cp -f $CACERT $SRVCHAIN

# Limit rights
chown -R root:root $SRVKEY $CAKEY
chmod -R 0600 $SRVKEY $CAKEY

# Link CAcerts in ALCASAR Control Center
if [ -s "$CACERT" -a -s "$CAKEY" -a -s "$SRVCERT" -a -s "$SRVKEY" ];
	then
	[ -d $DIR_WEB/certs ] || mkdir -p $DIR_WEB/certs
	rm -f $DIR_WEB/certs/*
	ln -s $CACERT $DIR_WEB/certs/certificat_alcasar_ca.crt
	rm -rf $DIR_TMP
	exit 0
else
	echo "An error occured when generating security certificates (see : $DIR_TMP/openssl-log)" 
	exit 1
fi
