Summary:	HTTP anti-virus proxy filter
Name:		havp
Version:	0.93
Release:	1%{?dist}
License:	GPLv2
Group:		Security
URL:		https://sourceforge.net/projects/havp/
Source:		%{name}-%{version}.tar.gz
Patch1:		havp-init.diff
Packager:	Richard REY (Rexy)
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires:	clamav-devel

%description
HAVP (HTTP AntiVirus proxy) is a proxy with an anti-virus filter.
It does not cache or filter content. At the moment the complete
traffic is scanned. The reason for this is the chance of malicious
code in nearly every filetype e.g. HTML (JavaScript) or Jpeg.

I aim to stop especially dialer or browser exploits. But writing
a http Anti Virus Proxy is a real dilemma! Huge downloads are
a problem for virus scanning proxies. A Client should not receive
data which is unchecked by the virus scanner, but big downloads
should not timeout.

%prep
%setup
%patch1 -p0
%build
%configure
%make

%install
rm -rf %{buildroot}
install -d %{buildroot}%{_initrddir}
cp /etc/init.d/havp %{buildroot}%{_initrddir}/havp
install -d %{buildroot}%{_localstatedir}/run/havp/
install -d %{buildroot}%{_localstatedir}/log/havp/
%makeinstall

%pre
if ! /usr/bin/id havp &>/dev/null; then
	/usr/sbin/useradd -r -d %{_localstatedir}/log/havp -s /bin/sh -c "havp" havp || \
		%logmsg "Unexpected error adding user \"havp\". Aborting installation."
fi

%post
/usr/bin/systemctl -q enable havp.service

%preun
if [ $1 -eq 0 ]; then
	/usr/bin/systemctl stop havp.service
	/usr/bin/systemctl -q disable havp.service
fi

%postun
if [ $1 -eq 0 ]; then
	/usr/sbin/userdel havp || %logmsg "User \"havp\" could not be deleted."
fi

%files
%defattr(-, root, root, 0755)
%doc ChangeLog COPYING INSTALL update-conf
%config %{_sysconfdir}/havp/
%config %{_initrddir}/havp
%{_sbindir}/havp

%defattr(-, havp, havp, 0755)
%{_localstatedir}/log/havp/
%{_localstatedir}/run/havp/

%changelog
* Sat Nov 23 2019 Rexy for ALCASAR project
- Rebuild 0.93 for MGA7

* Sun Apr 3 2016 Rexy for ALCASAR project
- Rebuild 0.92a.1 for Mga5

* Thu Jul 07 2014 jb <jeanbaptiste.couprit@gmail.com> - 0.92-1.1
- Created .spec file to build rpms for Mageia4 (x86_64 & i586).
- Created two rpms : havp-0.92a-1-1.mga4.x86_64.rpm & havp-0.92a-1-1.mga4.i586.rpm with Libclamav patch (OpenSSL)

* Tue Apr 30 2013 Crox <ptitois@gmail.com> - 0.92-1.1
- Created .spec file to build rpms for Mageia2 (x86_64 & i586).

* Sun Nov 21 2010 Rexy <richard@rexy.fr> - 0.92-1
- Updated to release 0.92a.

* Sun May  9 2010 Rexy <richard@irexy.fr> - 0.91-1
- Updated to release 0.91.

* Tue Apr  7 2009 Dries Verachtert <dries@ulyssis.org> - 0.90-1
- Updated to release 0.90.

* Wed Aug 13 2008 Dries Verachtert <dries@ulyssis.org> - 0.89-1
- Updated to release 0.89.

* Sun Apr 20 2008 Dries Verachtert <dries@ulyssis.org> - 0.88-1
- Updated to release 0.88.

* Mon Jul 23 2007 Dries Verachtert <dries@ulyssis.org> - 0.86-1
- Updated to release 0.86.

* Tue Aug 22 2006 Dag Wieers <dag@wieers.com> - 0.7.9-1
- Cosmetic changes.

* Wed May 31 2006 Bernard 'Tux' Lheureux <tux at portalinux dot org> 0.7.9-2
- Corrected the specfile to make it installable on CentOS 4.x
- Created and applied some patches to make it chkconfig compatible
- Created and applied a patch to make config reflect the correct location of the files

* Tue May 30 2006 Jim Perrin <jperrin at gmail dot com> 0.7.9-1
- Initial build for CentOS,
- Specfile generation... still some work to do...

