#!/bin/bash

#######################################
## Update script for Tor entry point ##
##      By Sylvain Harand & Rexy     ##
##                                   ##
#######################################

# Note: The dan.me site only allow to fetch one every 15 minutes by IP adresses.
# Trying to fetch more may result in a definitive ban.

# File paths
input_file='TorNodesTmp.txt'
output_file_IPV4='TorNodesIPV4.txt'
output_file_IPV6='TorNodesIPV6.txt'

# Récupération de la liste des noeuds TOR et stockage dans le fichier temporaire depuis le site dan.me
curl https://www.dan.me.uk/tornodes > $input_file

# extraction des données situées entre les balises spécifiques
tor_nodes=$(sed -n '/<!-- __BEGIN_TOR_NODE_LIST__ \/\/-->/, /<!-- __END_TOR_NODE_LIST__ \/\/-->/p' "$input_file" | sed '1d;$d')

# RAZ des fichiers de sortie
> "$output_file_IPV4"
> "$output_file_IPV6"

# IPV4 Ptn
PTN='^\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\).\([01]\?[[:digit:]][[:digit:]]\?\|2[0-4][[:digit:]]\|25[0-5]\)$'

# Pour chaque ligne de la variable temporaire
echo "$tor_nodes" | while IFS= read -r line; do
    # Suppression des balises HTML
    clean_line=$(echo "$line" | sed -e 's/<br>//g')
    # Extraction du 5e champ pour vérifier s'il contient "G" (Tag pour noeud de Garde (entrée)
    fifth_field=$(echo "$clean_line" | cut -d '|' -f 5)
     if [[ "$fifth_field" == *"G"* ]]; then
        # Extraction de l'@IP (1er champ)
        ip_address=$(echo "$clean_line" | cut -d '|' -f 1)
        # Aihuillage en fonction du type @IP
        if [[ $(expr "$ip_address" : "$PTN") -gt 0 ]]
            then echo "$ip_address" >> "$output_file_IPV4"
            else echo "$ip_address" >> "$output_file_IPV6"
        fi
        echo -n "#"
    fi
done
echo
echo -n "Removing duplicate IPV4 entries - Please wait..."
uniq "$output_file_IPV4" > "$input_file"; cat "$input_file" > "$output_file_IPV4"
echo "Nb_IP_V4 = `wc -l $output_file_IPV4`"
echo -n "Removing duplicate IPV6 entries - Please wait..."
uniq "$output_file_IPV6" > "$input_file"; cat "$input_file" > "$output_file_IPV6"
echo "Nb_IP_V6 = `wc -l $output_file_IPV6`"
rm "$input_file"
